/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVOutputConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestOrderedPartitionedKVOutputConfig {
    @Test
    public void testNullParams() {
        try {
            OrderedPartitionedKVOutputConfig.newBuilder(null, (String)"VALUE", (String)"PARTITIONER", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            OrderedPartitionedKVOutputConfig.newBuilder((String)"KEY", null, (String)"PARTITIONER", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            OrderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", null, null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test
    public void testSetters() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setInt("tez.runtime.ifile.readahead.bytes", 1111);
        fromConf.set("fs.shouldExist", "fs");
        HashMap<String, String> additionalConf = new HashMap<String, String>();
        additionalConf.put("test.key.2", "key2");
        additionalConf.put("io.shouldExist", "io");
        additionalConf.put("tez.runtime.internal.sorter.class", "TestInternalSorter");
        OrderedPartitionedKVOutputConfig.Builder builder = OrderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER", null).setKeyComparatorClass("KEY_COMPARATOR", null).setCompression(true, "CustomCodec", null).setSortBufferSize(2048).setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("file.shouldExist", "file").setAdditionalConfiguration("tez.runtime.ifile.readahead", String.valueOf(false)).setAdditionalConfiguration(additionalConf).setFromConfiguration(fromConf);
        OrderedPartitionedKVOutputConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuilt = new OrderedPartitionedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((long)2048L, (long)conf.getInt("tez.runtime.io.sort.mb", 0));
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"PARTITIONER", (Object)conf.get("tez.runtime.partitioner.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.compress", false));
        Assert.assertEquals((Object)"KEY_COMPARATOR", (Object)conf.get("tez.runtime.key.comparator.class"));
        Assert.assertEquals((Object)false, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((long)1111L, (long)conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000));
        Assert.assertEquals((Object)"TestInternalSorter", (Object)conf.get("tez.runtime.internal.sorter.class", ""));
        Assert.assertEquals((Object)"io", (Object)conf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)conf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)conf.get("fs.shouldExist"));
        Assert.assertNull((Object)conf.get("test.conf.key.1"));
        Assert.assertNull((Object)conf.get("test.key.1"));
        Assert.assertNull((Object)conf.get("test.key.2"));
    }

    @Test
    public void testDefaultConfigsUsed() {
        OrderedPartitionedKVOutputConfig.Builder builder = OrderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER", null);
        OrderedPartitionedKVOutputConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuilt = new OrderedPartitionedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)true, (Object)conf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"KEY", (Object)conf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)conf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"PARTITIONER", (Object)conf.get("tez.runtime.partitioner.class", ""));
    }

    @Test
    public void testPartitionerConfigs() {
        HashMap partitionerConf = Maps.newHashMap();
        partitionerConf.put("partitioner.test.key", "PARTITIONERKEY");
        partitionerConf.put("tez.runtime.compress.codec", "InvalidKeyOverride");
        OrderedPartitionedKVOutputConfig.Builder builder = OrderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER", (Map)partitionerConf);
        OrderedPartitionedKVOutputConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuilt = new OrderedPartitionedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"PARTITIONERKEY", (Object)conf.get("partitioner.test.key"));
    }

    @Test
    public void testCombinerConfigs() {
        HashMap combinerConf = Maps.newHashMap();
        combinerConf.put("combiner.test.key", "COMBINERKEY");
        combinerConf.put("tez.runtime.compress.codec", "InvalidKeyOverride");
        OrderedPartitionedKVOutputConfig.Builder builder = OrderedPartitionedKVOutputConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER", null).setCombiner("COMBINER", (Map)combinerConf);
        OrderedPartitionedKVOutputConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuilt = new OrderedPartitionedKVOutputConfig();
        rebuilt.fromUserPayload(configuration.toUserPayload());
        Configuration conf = rebuilt.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)conf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)"COMBINERKEY", (Object)conf.get("combiner.test.key"));
    }
}

