/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.conf;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.library.conf.OrderedGroupedKVInputConfig;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVEdgeConfig;
import org.apache.tez.runtime.library.conf.OrderedPartitionedKVOutputConfig;
import org.junit.Assert;
import org.junit.Test;

public class TestOrderedPartitionedKVEdgeConfig {
    @Test
    public void testNullParams() {
        try {
            OrderedPartitionedKVEdgeConfig.newBuilder(null, (String)"VALUE", (String)"PARTITIONER");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            OrderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", null, (String)"PARTITIONER");
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
        try {
            OrderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", null);
            Assert.fail((String)"Expecting a null parameter list to fail");
        }
        catch (NullPointerException npe) {
            Assert.assertTrue((boolean)npe.getMessage().contains("cannot be null"));
        }
    }

    @Test
    public void testDefaultConfigsUsed() {
        OrderedPartitionedKVEdgeConfig.Builder builder = OrderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER");
        OrderedPartitionedKVEdgeConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuiltOutput = new OrderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        OrderedGroupedKVInputConfig rebuiltInput = new OrderedGroupedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Assert.assertEquals((Object)true, (Object)outputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)outputConf.get("tez.runtime.compress.codec", ""));
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)true, (Object)inputConf.getBoolean("tez.runtime.ifile.readahead", true));
        Assert.assertEquals((Object)"TestCodec", (Object)inputConf.get("tez.runtime.compress.codec", ""));
    }

    @Test
    public void testSpecificIOConfs() {
        OrderedPartitionedKVEdgeConfig.Builder builder = OrderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER");
        OrderedPartitionedKVEdgeConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuiltOutput = new OrderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        OrderedGroupedKVInputConfig rebuiltInput = new OrderedGroupedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)outputConf.get("tez.runtime.compress.codec", "DEFAULT"));
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)"TestCodec", (Object)inputConf.get("tez.runtime.compress.codec", "DEFAULT"));
    }

    @Test
    public void tetCommonConf() {
        Configuration fromConf = new Configuration(false);
        fromConf.set("test.conf.key.1", "confkey1");
        fromConf.setInt("tez.runtime.io.sort.factor", 3);
        fromConf.setFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.11f);
        fromConf.setInt("tez.runtime.io.sort.mb", 123);
        fromConf.set("io.shouldExist", "io");
        HashMap<String, String> additionalConfs = new HashMap<String, String>();
        additionalConfs.put("test.key.2", "key2");
        additionalConfs.put("tez.runtime.ifile.readahead.bytes", "1111");
        additionalConfs.put("tez.runtime.shuffle.memory.limit.percent", "0.22f");
        additionalConfs.put("tez.runtime.internal.sorter.class", "CustomSorter");
        additionalConfs.put("file.shouldExist", "file");
        OrderedPartitionedKVEdgeConfig.Builder builder = OrderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER").setAdditionalConfiguration("fs.shouldExist", "fs").setAdditionalConfiguration("test.key.1", "key1").setAdditionalConfiguration("io.file.buffer.size", "2222").setAdditionalConfiguration("tez.runtime.shuffle.merge.percent", "0.33f").setAdditionalConfiguration("tez.runtime.index.cache.memory.limit.bytes", "3333").setAdditionalConfiguration(additionalConfs).setFromConfiguration(fromConf);
        OrderedPartitionedKVEdgeConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuiltOutput = new OrderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        OrderedGroupedKVInputConfig rebuiltInput = new OrderedGroupedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((long)3L, (long)outputConf.getInt("tez.runtime.io.sort.factor", 0));
        Assert.assertEquals((long)1111L, (long)outputConf.getInt("tez.runtime.ifile.readahead.bytes", 0));
        Assert.assertEquals((long)2222L, (long)outputConf.getInt("io.file.buffer.size", 0));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.fetch.buffer.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.memory.limit.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.merge.percent"));
        Assert.assertEquals((long)123L, (long)outputConf.getInt("tez.runtime.io.sort.mb", 0));
        Assert.assertEquals((Object)"CustomSorter", (Object)outputConf.get("tez.runtime.internal.sorter.class"));
        Assert.assertEquals((long)3333L, (long)outputConf.getInt("tez.runtime.index.cache.memory.limit.bytes", 0));
        Assert.assertEquals((Object)"io", (Object)outputConf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)outputConf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)outputConf.get("fs.shouldExist"));
        Assert.assertEquals((long)3L, (long)inputConf.getInt("tez.runtime.io.sort.factor", 0));
        Assert.assertEquals((long)1111L, (long)inputConf.getInt("tez.runtime.ifile.readahead.bytes", 0));
        Assert.assertEquals((long)2222L, (long)inputConf.getInt("io.file.buffer.size", 0));
        Assert.assertEquals((float)0.11f, (float)inputConf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.22f, (float)inputConf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.33f, (float)inputConf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.001f);
        Assert.assertNull((Object)inputConf.get("tez.runtime.io.sort.mb"));
        Assert.assertNull((Object)inputConf.get("tez.runtime.internal.sorter.class"));
        Assert.assertNull((Object)inputConf.get("tez.runtime.index.cache.memory.limit.bytes"));
        Assert.assertEquals((Object)"io", (Object)inputConf.get("io.shouldExist"));
        Assert.assertEquals((Object)"file", (Object)inputConf.get("file.shouldExist"));
        Assert.assertEquals((Object)"fs", (Object)inputConf.get("fs.shouldExist"));
    }

    @Test
    public void testSetters() {
        HashMap comparatorConf = Maps.newHashMap();
        comparatorConf.put("comparator.test.key", "comparatorValue");
        OrderedPartitionedKVEdgeConfig.Builder builder = ((OrderedPartitionedKVEdgeConfig.Builder)((OrderedPartitionedKVEdgeConfig.Builder)OrderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER").setKeyComparatorClass("KEY_COMPARATOR", (Map)comparatorConf).configureOutput().setSortBufferSize(1111).setSorterNumThreads(2).done()).configureInput().setMaxSingleMemorySegmentFraction(0.11f).setMergeFraction(0.22f).setPostMergeBufferFraction(0.33f).setShuffleBufferFraction(0.44f).done()).setCompression(true, "CustomCodec", null);
        OrderedPartitionedKVEdgeConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuiltOutput = new OrderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        OrderedGroupedKVInputConfig rebuiltInput = new OrderedGroupedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)"KEY", (Object)outputConf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)outputConf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"PARTITIONER", (Object)outputConf.get("tez.runtime.partitioner.class", ""));
        Assert.assertEquals((long)1111L, (long)outputConf.getInt("tez.runtime.io.sort.mb", 0));
        Assert.assertEquals((Object)"CustomCodec", (Object)outputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)outputConf.getBoolean("tez.runtime.compress", false));
        Assert.assertEquals((Object)"KEY_COMPARATOR", (Object)outputConf.get("tez.runtime.key.comparator.class"));
        Assert.assertEquals((Object)"comparatorValue", (Object)outputConf.get("comparator.test.key"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.memory.limit.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.merge.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.task.input.post-merge.buffer.percent"));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.fetch.buffer.percent"));
        Assert.assertEquals((Object)"KEY_COMPARATOR", (Object)inputConf.get("tez.runtime.key.comparator.class"));
        Assert.assertEquals((Object)"comparatorValue", (Object)inputConf.get("comparator.test.key"));
        Assert.assertEquals((Object)"KEY", (Object)inputConf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)inputConf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)inputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)inputConf.getBoolean("tez.runtime.compress", false));
        Assert.assertEquals((float)0.11f, (float)inputConf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.22f, (float)inputConf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.33f, (float)inputConf.getFloat("tez.runtime.task.input.post-merge.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertEquals((float)0.44f, (float)inputConf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.001f);
        Assert.assertNull((Object)inputConf.get("tez.runtime.io.sort.mb"));
    }

    @Test
    public void testSerialization() {
        OrderedPartitionedKVEdgeConfig.Builder builder = OrderedPartitionedKVEdgeConfig.newBuilder((String)"KEY", (String)"VALUE", (String)"PARTITIONER").setCompression(true, "CustomCodec", null).setKeySerializationClass("serClass1", "SomeComparator1", null).setValueSerializationClass("serClass2", null);
        OrderedPartitionedKVEdgeConfig configuration = builder.build();
        OrderedPartitionedKVOutputConfig rebuiltOutput = new OrderedPartitionedKVOutputConfig();
        rebuiltOutput.fromUserPayload(configuration.getOutputPayload());
        OrderedGroupedKVInputConfig rebuiltInput = new OrderedGroupedKVInputConfig();
        rebuiltInput.fromUserPayload(configuration.getInputPayload());
        Configuration outputConf = rebuiltOutput.conf;
        Configuration inputConf = rebuiltInput.conf;
        Assert.assertEquals((Object)"KEY", (Object)outputConf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)outputConf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"PARTITIONER", (Object)outputConf.get("tez.runtime.partitioner.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)outputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)outputConf.getBoolean("tez.runtime.compress", false));
        Assert.assertNull((Object)outputConf.get("tez.runtime.shuffle.fetch.buffer.percent"));
        Assert.assertEquals((Object)"SomeComparator1", (Object)outputConf.get("tez.runtime.key.comparator.class"));
        Assert.assertTrue((boolean)outputConf.get("io.serializations").trim().startsWith("serClass2,serClass1"));
        Assert.assertEquals((Object)"SomeComparator1", (Object)inputConf.get("tez.runtime.key.comparator.class"));
        Assert.assertTrue((boolean)inputConf.get("io.serializations").trim().startsWith("serClass2,serClass1"));
        Assert.assertEquals((Object)"KEY", (Object)inputConf.get("tez.runtime.key.class", ""));
        Assert.assertEquals((Object)"VALUE", (Object)inputConf.get("tez.runtime.value.class", ""));
        Assert.assertEquals((Object)"CustomCodec", (Object)inputConf.get("tez.runtime.compress.codec", ""));
        Assert.assertEquals((Object)true, (Object)inputConf.getBoolean("tez.runtime.compress", false));
    }
}

