/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.LinkedList;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapHost;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleInputEventHandlerOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleScheduler;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestShuffleInputEventHandler {
    private static final String HOST = "localhost";
    private static final int PORT = 8080;
    private static final String PATH_COMPONENT = "attempt";
    private ShuffleInputEventHandlerOrderedGrouped handler;
    private ShuffleScheduler scheduler;

    private InputContext createTezInputContext() {
        ApplicationId applicationId = ApplicationId.newInstance((long)1L, (int)1);
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)applicationId).when((Object)inputContext)).getApplicationId();
        return inputContext;
    }

    private Event createDataMovementEvent(int srcIndex, int targetIndex, ByteString emptyPartitionByteString, boolean allPartitionsEmpty) {
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder builder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        if (!allPartitionsEmpty) {
            builder.setHost(HOST);
            builder.setPort(8080);
            builder.setPathComponent(PATH_COMPONENT);
        }
        builder.setRunDuration(10);
        if (emptyPartitionByteString != null) {
            builder.setEmptyPartitions(emptyPartitionByteString);
        }
        return DataMovementEvent.create((int)srcIndex, (int)targetIndex, (int)0, (ByteBuffer)builder.build().toByteString().asReadOnlyByteBuffer());
    }

    @Before
    public void setup() throws Exception {
        InputContext inputContext = this.createTezInputContext();
        this.scheduler = (ShuffleScheduler)Mockito.mock(ShuffleScheduler.class);
        this.handler = new ShuffleInputEventHandlerOrderedGrouped(inputContext, this.scheduler, false);
    }

    @Test
    public void basicTest() throws IOException {
        LinkedList<Event> events = new LinkedList<Event>();
        int srcIdx = 0;
        int targetIdx = 1;
        Event dme = this.createDataMovementEvent(srcIdx, targetIdx, null, false);
        events.add(dme);
        this.handler.handleEvents(events);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(targetIdx, 0, PATH_COMPONENT);
        String baseUri = this.handler.getBaseURI(HOST, 8080, srcIdx).toString();
        int partitionId = srcIdx;
        ((ShuffleScheduler)Mockito.verify((Object)this.scheduler)).addKnownMapOutput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), Matchers.eq((int)partitionId), (String)Matchers.eq((Object)baseUri), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier));
    }

    @Test
    public void testFailedEvent() throws IOException {
        LinkedList<InputFailedEvent> events = new LinkedList<InputFailedEvent>();
        int targetIdx = 1;
        InputFailedEvent failedEvent = InputFailedEvent.create((int)targetIdx, (int)0);
        events.add(failedEvent);
        this.handler.handleEvents(events);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(targetIdx, 0);
        ((ShuffleScheduler)Mockito.verify((Object)this.scheduler)).obsoleteInput((InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier));
    }

    @Test
    public void testAllPartitionsEmpty() throws IOException {
        LinkedList<Event> events = new LinkedList<Event>();
        int srcIdx = 0;
        int targetIdx = 1;
        Event dme = this.createDataMovementEvent(srcIdx, targetIdx, this.createEmptyPartitionByteString(srcIdx), true);
        events.add(dme);
        this.handler.handleEvents(events);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(targetIdx, 0);
        ((ShuffleScheduler)Mockito.verify((Object)this.scheduler)).copySucceeded((InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier), (MapHost)Matchers.any(MapHost.class), Matchers.eq((long)0L), Matchers.eq((long)0L), Matchers.eq((long)0L), (MapOutput)Matchers.any(MapOutput.class));
    }

    @Test
    public void testCurrentPartitionEmpty() throws IOException {
        LinkedList<Event> events = new LinkedList<Event>();
        int srcIdx = 0;
        int targetIdx = 1;
        Event dme = this.createDataMovementEvent(srcIdx, targetIdx, this.createEmptyPartitionByteString(srcIdx), false);
        events.add(dme);
        this.handler.handleEvents(events);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(targetIdx, 0);
        ((ShuffleScheduler)Mockito.verify((Object)this.scheduler)).copySucceeded((InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier), (MapHost)Matchers.any(MapHost.class), Matchers.eq((long)0L), Matchers.eq((long)0L), Matchers.eq((long)0L), (MapOutput)Matchers.any(MapOutput.class));
    }

    @Test
    public void testOtherPartitionEmpty() throws IOException {
        LinkedList<Event> events = new LinkedList<Event>();
        int srcIdx = 0;
        int taskIndex = 1;
        Event dme = this.createDataMovementEvent(srcIdx, taskIndex, this.createEmptyPartitionByteString(100), false);
        events.add(dme);
        this.handler.handleEvents(events);
        String baseUri = this.handler.getBaseURI(HOST, 8080, srcIdx).toString();
        int partitionId = srcIdx;
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(taskIndex, 0, PATH_COMPONENT);
        ((ShuffleScheduler)Mockito.verify((Object)this.scheduler)).addKnownMapOutput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), Matchers.eq((int)partitionId), (String)Matchers.eq((Object)baseUri), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier));
    }

    private ByteString createEmptyPartitionByteString(int ... emptyPartitions) throws IOException {
        BitSet bitSet = new BitSet();
        for (int i : emptyPartitions) {
            bitSet.set(i);
        }
        return TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)bitSet));
    }
}

