/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.IOException;
import java.util.LinkedList;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.FileChunk;
import org.apache.hadoop.io.IntWritable;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMergeManager {
    private static final Log LOG = LogFactory.getLog(TestMergeManager.class);
    private static Configuration defaultConf = new TezConfiguration();
    private static FileSystem localFs = null;
    private static Path workDir = null;

    @Before
    @After
    public void cleanup() throws IOException {
        localFs.delete(workDir, true);
    }

    @Test(timeout=10000L)
    public void testLocalDiskMergeMultipleTasks() throws IOException {
        TezConfiguration conf = new TezConfiguration(defaultConf);
        conf.setBoolean("tez.runtime.compress", false);
        conf.set("tez.runtime.key.class", IntWritable.class.getName());
        conf.set("tez.runtime.value.class", IntWritable.class.getName());
        Path localDir = new Path(workDir, "local");
        Path srcDir = new Path(workDir, "srcData");
        localFs.mkdirs(localDir);
        localFs.mkdirs(srcDir);
        conf.setStrings("tez.runtime.framework.local.dirs", new String[]{localDir.toString()});
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        InputContext t0inputContext = this.createMockInputContext(UUID.randomUUID().toString());
        InputContext t1inputContext = this.createMockInputContext(UUID.randomUUID().toString());
        ExceptionReporter t0exceptionReporter = (ExceptionReporter)Mockito.mock(ExceptionReporter.class);
        ExceptionReporter t1exceptionReporter = (ExceptionReporter)Mockito.mock(ExceptionReporter.class);
        MergeManager t0mergeManagerReal = new MergeManager((Configuration)conf, (FileSystem)localFs, localDirAllocator, t0inputContext, null, null, null, null, t0exceptionReporter, 2000000L, null, false, -1);
        MergeManager t0mergeManager = (MergeManager)Mockito.spy((Object)t0mergeManagerReal);
        MergeManager t1mergeManagerReal = new MergeManager((Configuration)conf, (FileSystem)localFs, localDirAllocator, t1inputContext, null, null, null, null, t1exceptionReporter, 2000000L, null, false, -1);
        MergeManager t1mergeManager = (MergeManager)Mockito.spy((Object)t1mergeManagerReal);
        SrcFileInfo src1Info = this.createFile((Configuration)conf, (FileSystem)localFs, new Path(srcDir, "attemptsrc1.out"), 2, 3, 0);
        SrcFileInfo src2Info = this.createFile((Configuration)conf, (FileSystem)localFs, new Path(srcDir, "attemptsrc2.out"), 2, 3, 6);
        InputAttemptIdentifier t0Identifier0 = new InputAttemptIdentifier(0, 0, src1Info.path.getName());
        InputAttemptIdentifier t0Identifier1 = new InputAttemptIdentifier(1, 0, src2Info.path.getName());
        InputAttemptIdentifier t1Identifier0 = new InputAttemptIdentifier(0, 0, src1Info.path.getName());
        InputAttemptIdentifier t1Identifier1 = new InputAttemptIdentifier(1, 0, src2Info.path.getName());
        MapOutput t0MapOutput0 = TestMergeManager.getMapOutputForDirectDiskFetch(t0Identifier0, src1Info.path, src1Info.indexedRecords[0], t0mergeManager);
        MapOutput t0MapOutput1 = TestMergeManager.getMapOutputForDirectDiskFetch(t0Identifier1, src2Info.path, src2Info.indexedRecords[0], t0mergeManager);
        MapOutput t1MapOutput0 = TestMergeManager.getMapOutputForDirectDiskFetch(t1Identifier0, src1Info.path, src1Info.indexedRecords[1], t1mergeManager);
        MapOutput t1MapOutput1 = TestMergeManager.getMapOutputForDirectDiskFetch(t1Identifier1, src2Info.path, src2Info.indexedRecords[1], t1mergeManager);
        t0MapOutput0.commit();
        t0MapOutput1.commit();
        ((MergeManager)Mockito.verify((Object)t0mergeManager)).closeOnDiskFile(t0MapOutput0.getOutputPath());
        ((MergeManager)Mockito.verify((Object)t0mergeManager)).closeOnDiskFile(t0MapOutput1.getOutputPath());
        LinkedList t0MergeFiles = new LinkedList();
        t0MergeFiles.addAll(t0mergeManager.onDiskMapOutputs);
        t0mergeManager.onDiskMapOutputs.clear();
        t0mergeManager.onDiskMerger.merge(t0MergeFiles);
        Assert.assertEquals((long)1L, (long)t0mergeManager.onDiskMapOutputs.size());
        t1MapOutput0.commit();
        t1MapOutput1.commit();
        ((MergeManager)Mockito.verify((Object)t1mergeManager)).closeOnDiskFile(t1MapOutput0.getOutputPath());
        ((MergeManager)Mockito.verify((Object)t1mergeManager)).closeOnDiskFile(t1MapOutput1.getOutputPath());
        LinkedList t1MergeFiles = new LinkedList();
        t1MergeFiles.addAll(t1mergeManager.onDiskMapOutputs);
        t1mergeManager.onDiskMapOutputs.clear();
        t1mergeManager.onDiskMerger.merge(t1MergeFiles);
        Assert.assertEquals((long)1L, (long)t1mergeManager.onDiskMapOutputs.size());
        Assert.assertNotEquals((Object)((FileChunk)t0mergeManager.onDiskMapOutputs.iterator().next()).getPath(), (Object)((FileChunk)t1mergeManager.onDiskMapOutputs.iterator().next()).getPath());
        Assert.assertTrue((boolean)((FileChunk)t0mergeManager.onDiskMapOutputs.iterator().next()).getPath().toString().contains(t0inputContext.getUniqueIdentifier()));
        Assert.assertTrue((boolean)((FileChunk)t1mergeManager.onDiskMapOutputs.iterator().next()).getPath().toString().contains(t1inputContext.getUniqueIdentifier()));
    }

    private InputContext createMockInputContext(String uniqueId) {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)new TezCounters()).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)0xC800000L).when((Object)inputContext)).getTotalMemoryAvailableToTask();
        ((InputContext)Mockito.doReturn((Object)"srcVertexName").when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)uniqueId).when((Object)inputContext)).getUniqueIdentifier();
        return inputContext;
    }

    private SrcFileInfo createFile(Configuration conf, FileSystem fs, Path path, int numPartitions, int numKeysPerPartition, int startKey) throws IOException {
        FSDataOutputStream outStream = fs.create(path);
        int currentKey = startKey;
        SrcFileInfo srcFileInfo = new SrcFileInfo();
        SrcFileInfo.access$102(srcFileInfo, new TezIndexRecord[numPartitions]);
        srcFileInfo.path = path;
        for (int i = 0; i < numPartitions; ++i) {
            long pos = outStream.getPos();
            IFile.Writer writer = new IFile.Writer(conf, outStream, IntWritable.class, IntWritable.class, null, null, null);
            for (int j = 0; j < numKeysPerPartition; ++j) {
                writer.append((Object)new IntWritable(currentKey), (Object)new IntWritable(currentKey));
                ++currentKey;
            }
            writer.close();
            ((SrcFileInfo)srcFileInfo).indexedRecords[i] = new TezIndexRecord(pos, writer.getRawLength(), writer.getCompressedLength());
        }
        outStream.close();
        return srcFileInfo;
    }

    private static MapOutput getMapOutputForDirectDiskFetch(InputAttemptIdentifier srcAttemptId, Path filename, TezIndexRecord indexRecord, MergeManager merger) throws IOException {
        return MapOutput.createLocalDiskMapOutput((InputAttemptIdentifier)srcAttemptId, (MergeManager)merger, (Path)filename, (long)indexRecord.getStartOffset(), (long)indexRecord.getPartLength(), (boolean)true);
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestMergeManager.class.getSimpleName());
            workDir = localFs.makeQualified(workDir);
            localFs.mkdirs(workDir);
            LOG.info((Object)("Using workDir: " + workDir));
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }

    private class SrcFileInfo {
        private Path path;
        private TezIndexRecord[] indexedRecords;

        private SrcFileInfo() {
        }

        static /* synthetic */ TezIndexRecord[] access$102(SrcFileInfo x0, TezIndexRecord[] x1) {
            x0.indexedRecords = x1;
            return x1;
        }
    }
}

