/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.LinkedList;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputAllocator;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleInputEventHandlerImpl;
import org.apache.tez.runtime.library.common.shuffle.impl.ShuffleManager;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestShuffleInputEventHandlerImpl {
    private static final String HOST = "localhost";
    private static final int PORT = 8080;
    private static final String PATH_COMPONENT = "attempttmp";

    @Test
    public void testSimple() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex = 1;
        Event dme = this.createDataMovementEvent(0, taskIndex, null);
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(taskIndex, 0, PATH_COMPONENT);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier), Matchers.eq((int)0));
    }

    @Test
    public void testCurrentPartitionEmpty() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex = 1;
        Event dme = this.createDataMovementEvent(0, taskIndex, this.createEmptyPartitionByteString(0));
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(taskIndex, 0);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addCompletedInputWithNoData((InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier));
    }

    @Test
    public void testOtherPartitionEmpty() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex = 1;
        Event dme = this.createDataMovementEvent(0, taskIndex, this.createEmptyPartitionByteString(1));
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier = new InputAttemptIdentifier(taskIndex, 0, PATH_COMPONENT);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier), Matchers.eq((int)0));
    }

    @Test
    public void testMultipleEvents1() throws IOException {
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ShuffleManager shuffleManager = (ShuffleManager)Mockito.mock(ShuffleManager.class);
        FetchedInputAllocator inputAllocator = (FetchedInputAllocator)Mockito.mock(FetchedInputAllocator.class);
        ShuffleInputEventHandlerImpl handler = new ShuffleInputEventHandlerImpl(inputContext, shuffleManager, inputAllocator, null, false, 0);
        int taskIndex1 = 1;
        Event dme1 = this.createDataMovementEvent(0, taskIndex1, this.createEmptyPartitionByteString(0));
        int taskIndex2 = 2;
        Event dme2 = this.createDataMovementEvent(0, taskIndex2, null);
        LinkedList<Event> eventList = new LinkedList<Event>();
        eventList.add(dme1);
        eventList.add(dme2);
        handler.handleEvents(eventList);
        InputAttemptIdentifier expectedIdentifier1 = new InputAttemptIdentifier(taskIndex1, 0);
        InputAttemptIdentifier expectedIdentifier2 = new InputAttemptIdentifier(taskIndex2, 0, PATH_COMPONENT);
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addCompletedInputWithNoData((InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier1));
        ((ShuffleManager)Mockito.verify((Object)shuffleManager)).addKnownInput((String)Matchers.eq((Object)HOST), Matchers.eq((int)8080), (InputAttemptIdentifier)Matchers.eq((Object)expectedIdentifier2), Matchers.eq((int)0));
    }

    private Event createDataMovementEvent(int srcIndex, int targetIndex, ByteString emptyPartitionByteString) {
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder builder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        builder.setHost(HOST);
        builder.setPort(8080);
        builder.setPathComponent(PATH_COMPONENT);
        if (emptyPartitionByteString != null) {
            builder.setEmptyPartitions(emptyPartitionByteString);
        }
        DataMovementEvent dme = DataMovementEvent.create((int)srcIndex, (int)targetIndex, (int)0, (ByteBuffer)builder.build().toByteString().asReadOnlyByteBuffer());
        return dme;
    }

    private ByteString createEmptyPartitionByteString(int ... emptyPartitions) throws IOException {
        BitSet bitSet = new BitSet();
        for (int i : emptyPartitions) {
            bitSet.set(i);
        }
        ByteString emptyPartitionsBytesString = TezCommonUtils.compressByteArrayToByteString((byte[])TezUtilsInternal.toByteArray((BitSet)bitSet));
        return emptyPartitionsBytesString;
    }
}

