/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.comparator;

import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.tez.runtime.library.common.comparator.TezBytesComparator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestProxyComparator {
    private static final Log LOG = LogFactory.getLog(TestProxyComparator.class);
    static final String[] keys = new String[]{"", "A", "B", "AA", "BB", "BA", "CB", "AAA", "BBBB", "CCCCC", "\u00e6AAAA", "\u00f7", "A\u00f7", "\u00f7AAAAAAAAA", "\u00f7\u00f7", "\u00f7\u00f7\u00e6\u00e6A", "\u00f7\u00f7\u00e6\u00e6A"};

    private static final void set(BytesWritable bw, String s) {
        byte[] b = s.getBytes(Charset.forName("utf-8"));
        bw.set(b, 0, b.length);
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void cleanup() throws Exception {
    }

    @Test
    public void testProxyComparator() {
        TezBytesComparator comparator = new TezBytesComparator();
        BytesWritable lhs = new BytesWritable();
        BytesWritable rhs = new BytesWritable();
        for (String l : keys) {
            for (String r : keys) {
                TestProxyComparator.set(lhs, l);
                TestProxyComparator.set(rhs, r);
                int lproxy = comparator.getProxy((Object)lhs);
                int rproxy = comparator.getProxy((Object)rhs);
                if (lproxy < rproxy) {
                    Assert.assertTrue((String)String.format("(%s) %d < (%s) %d", l, lproxy, r, rproxy), (comparator.compare((Object)lhs, (Object)rhs) < 0 ? 1 : 0) != 0);
                }
                if (lproxy <= rproxy) continue;
                Assert.assertTrue((String)String.format("(%s) %d > (%s) %d", l, lproxy, r, rproxy), (comparator.compare((Object)lhs, (Object)rhs) > 0 ? 1 : 0) != 0);
            }
        }
    }
}

