/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.tez.common.counters.GenericCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.ValuesIterator;
import org.apache.tez.runtime.library.common.comparator.TezBytesComparator;
import org.apache.tez.runtime.library.common.serializer.TezBytesWritableSerialization;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryReader;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.InMemoryWriter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MergeManager;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.TezMerger;
import org.apache.tez.runtime.library.common.sort.impl.TezRawKeyValueIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestValuesIterator {
    private static final Log LOG = LogFactory.getLog(TestValuesIterator.class);
    static final String TEZ_BYTES_SERIALIZATION = TezBytesWritableSerialization.class.getName();
    Configuration conf;
    FileSystem fs;
    static final Random rnd = new Random();
    final Class keyClass;
    final Class valClass;
    final RawComparator comparator;
    final RawComparator correctComparator;
    final boolean expectedTestResult;
    int mergeFactor;
    final TreeMultimap<Writable, Writable> sortedDataMap;
    TezRawKeyValueIterator rawKeyValueIterator;
    Path baseDir;
    Path tmpDir;
    Path[] streamPaths;

    public TestValuesIterator(String serializationClassName, Class key, Class val, TestWithComparator comparator, TestWithComparator correctComparator, boolean testResult) throws IOException {
        this.keyClass = key;
        this.valClass = val;
        this.comparator = this.getComparator(comparator);
        this.correctComparator = correctComparator == null ? this.comparator : this.getComparator(correctComparator);
        this.expectedTestResult = testResult;
        this.sortedDataMap = TreeMultimap.create((Comparator)this.correctComparator, (Comparator)Ordering.natural());
        this.setupConf(serializationClassName);
    }

    private void setupConf(String serializationClassName) throws IOException {
        this.mergeFactor = Math.max(2, rnd.nextInt(100));
        this.conf = new Configuration();
        this.conf.setInt("tez.runtime.io.sort.factor", this.mergeFactor);
        if (serializationClassName != null) {
            this.conf.set("io.serializations", serializationClassName + "," + this.conf.get("io.serializations"));
        }
        this.baseDir = new Path(".", this.getClass().getName());
        String localDirs = this.baseDir.toString();
        this.conf.setStrings("tez.runtime.framework.local.dirs", new String[]{localDirs});
        this.fs = FileSystem.getLocal((Configuration)this.conf);
    }

    @Before
    public void setup() throws Exception {
        this.fs.mkdirs(this.baseDir);
        this.tmpDir = new Path(this.baseDir, "tmp");
    }

    @After
    public void cleanup() throws Exception {
        this.fs.delete(this.baseDir, true);
        this.sortedDataMap.clear();
    }

    @Test(timeout=20000L)
    public void testIteratorWithInMemoryReader() throws IOException {
        ValuesIterator iterator = this.createIterator(true);
        this.testIterator(iterator);
    }

    @Test(timeout=20000L)
    public void testIteratorWithIFileReader() throws IOException {
        ValuesIterator iterator = this.createIterator(false);
        this.testIterator(iterator);
    }

    private void testIterator(ValuesIterator valuesIterator) throws IOException {
        Iterator oriKeySet = this.sortedDataMap.keySet().iterator();
        boolean result = true;
        block0: while (valuesIterator.moveToNext()) {
            Writable key = (Writable)valuesIterator.getKey();
            Assert.assertTrue((boolean)oriKeySet.hasNext());
            Writable ori = (Writable)oriKeySet.next();
            if (!key.equals(ori)) {
                result = false;
                break;
            }
            for (Object val : valuesIterator.getValues()) {
                if (this.sortedDataMap.get((Object)key).contains(val)) continue;
                result = false;
                continue block0;
            }
        }
        if (this.expectedTestResult) {
            Assert.assertTrue((boolean)result);
        } else {
            Assert.assertFalse((boolean)result);
        }
    }

    private ValuesIterator createIterator(boolean inMemory) throws IOException {
        if (!inMemory) {
            this.streamPaths = this.createFiles();
            this.rawKeyValueIterator = TezMerger.merge((Configuration)this.conf, (FileSystem)this.fs, (Class)this.keyClass, (Class)this.valClass, null, (boolean)false, (int)-1, (int)1024, (Path[])this.streamPaths, (boolean)false, (int)this.mergeFactor, (Path)this.tmpDir, (RawComparator)this.comparator, (Progressable)new ProgressReporter(), null, null, null, null);
        } else {
            List<TezMerger.Segment> segments = this.createInMemStreams();
            this.rawKeyValueIterator = TezMerger.merge((Configuration)this.conf, (FileSystem)this.fs, (Class)this.keyClass, (Class)this.valClass, segments, (int)this.mergeFactor, (Path)this.tmpDir, (RawComparator)this.comparator, (Progressable)new ProgressReporter(), (TezCounter)new GenericCounter("readsCounter", "y"), (TezCounter)new GenericCounter("writesCounter", "y1"), (TezCounter)new GenericCounter("bytesReadCounter", "y2"), (Progress)new Progress());
        }
        return new ValuesIterator(this.rawKeyValueIterator, this.comparator, this.keyClass, this.valClass, this.conf, (TezCounter)new GenericCounter("inputKeyCounter", "y3"), (TezCounter)new GenericCounter("inputValueCounter", "y4"));
    }

    @Parameterized.Parameters(name="test[{0}, {1}, {2}, {3} {4} {5} {6}]")
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{null, Text.class, Text.class, TestWithComparator.TEXT, null, true});
        parameters.add(new Object[]{null, LongWritable.class, Text.class, TestWithComparator.LONG, null, true});
        parameters.add(new Object[]{null, IntWritable.class, Text.class, TestWithComparator.INT, null, true});
        parameters.add(new Object[]{null, BytesWritable.class, BytesWritable.class, TestWithComparator.BYTES, null, true});
        parameters.add(new Object[]{TEZ_BYTES_SERIALIZATION, BytesWritable.class, BytesWritable.class, TestWithComparator.TEZ_BYTES, null, true});
        parameters.add(new Object[]{TEZ_BYTES_SERIALIZATION, BytesWritable.class, LongWritable.class, TestWithComparator.TEZ_BYTES, null, true});
        parameters.add(new Object[]{TEZ_BYTES_SERIALIZATION, CustomKey.class, LongWritable.class, TestWithComparator.TEZ_BYTES, null, true});
        parameters.add(new Object[]{TEZ_BYTES_SERIALIZATION, BytesWritable.class, BytesWritable.class, TestWithComparator.BYTES, TestWithComparator.TEZ_BYTES, false});
        parameters.add(new Object[]{TEZ_BYTES_SERIALIZATION, CustomKey.class, LongWritable.class, TestWithComparator.CUSTOM, TestWithComparator.TEZ_BYTES, false});
        return parameters;
    }

    private RawComparator getComparator(TestWithComparator comparator) {
        switch (comparator) {
            case LONG: {
                return new LongWritable.Comparator();
            }
            case INT: {
                return new IntWritable.Comparator();
            }
            case BYTES: {
                return new BytesWritable.Comparator();
            }
            case TEZ_BYTES: {
                return new TezBytesComparator();
            }
            case TEXT: {
                return new Text.Comparator();
            }
            case CUSTOM: {
                return new CustomKey.Comparator();
            }
        }
        return null;
    }

    private Path[] createFiles() throws IOException {
        int numberOfStreams = Math.max(2, rnd.nextInt(10));
        LOG.info((Object)("No of streams : " + numberOfStreams));
        Path[] paths = new Path[numberOfStreams];
        for (int i = 0; i < numberOfStreams; ++i) {
            paths[i] = new Path(this.baseDir, "ifile_" + i + ".out");
            IFile.Writer writer = new IFile.Writer(this.conf, this.fs, paths[i], this.keyClass, this.valClass, null, null, null);
            Map<Writable, Writable> data = this.createData();
            for (Map.Entry<Writable, Writable> entry : data.entrySet()) {
                writer.append((Object)entry.getKey(), (Object)entry.getValue());
            }
            LOG.info((Object)("Wrote " + data.size() + " in " + paths[i]));
            data.clear();
            writer.close();
        }
        return paths;
    }

    public List<TezMerger.Segment> createInMemStreams() throws IOException {
        int numberOfStreams = Math.max(2, rnd.nextInt(5));
        LOG.info((Object)("No of streams : " + numberOfStreams));
        SerializationFactory serializationFactory = new SerializationFactory(this.conf);
        Serializer keySerializer = serializationFactory.getSerializer(this.keyClass);
        Serializer valueSerializer = serializationFactory.getSerializer(this.valClass);
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        InputContext context = this.createTezInputContext();
        MergeManager mergeManager = new MergeManager(this.conf, this.fs, localDirAllocator, context, null, null, null, null, null, 0xA00000L, null, false, -1);
        DataOutputBuffer keyBuf = new DataOutputBuffer();
        DataOutputBuffer valBuf = new DataOutputBuffer();
        DataInputBuffer keyIn = new DataInputBuffer();
        DataInputBuffer valIn = new DataInputBuffer();
        keySerializer.open((OutputStream)keyBuf);
        valueSerializer.open((OutputStream)valBuf);
        LinkedList<TezMerger.Segment> segments = new LinkedList<TezMerger.Segment>();
        for (int i = 0; i < numberOfStreams; ++i) {
            BoundedByteArrayOutputStream bout = new BoundedByteArrayOutputStream(0x100000);
            InMemoryWriter writer = new InMemoryWriter(bout);
            Map<Writable, Writable> data = this.createData();
            for (Map.Entry<Writable, Writable> entry : data.entrySet()) {
                keySerializer.serialize((Object)entry.getKey());
                valueSerializer.serialize((Object)entry.getValue());
                keyIn.reset(keyBuf.getData(), 0, keyBuf.getLength());
                valIn.reset(valBuf.getData(), 0, valBuf.getLength());
                writer.append(keyIn, valIn);
                keyBuf.reset();
                valBuf.reset();
                keyIn.reset();
                valIn.reset();
            }
            InMemoryReader reader = new InMemoryReader(mergeManager, null, bout.getBuffer(), 0, bout.getBuffer().length);
            segments.add(new TezMerger.Segment((IFile.Reader)reader, true));
            data.clear();
            writer.close();
        }
        return segments;
    }

    private InputContext createTezInputContext() {
        TezCounters counters = new TezCounters();
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)0x6400000L).when((Object)inputContext)).getTotalMemoryAvailableToTask();
        ((InputContext)Mockito.doReturn((Object)counters).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getInputIndex();
        ((InputContext)Mockito.doReturn((Object)"srcVertex").when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskVertexIndex();
        ((InputContext)Mockito.doReturn((Object)UserPayload.create((ByteBuffer)ByteBuffer.wrap(new byte[1024]))).when((Object)inputContext)).getUserPayload();
        return inputContext;
    }

    private Map<Writable, Writable> createData() {
        TreeMap<Writable, Writable> map = new TreeMap<Writable, Writable>((Comparator<Writable>)this.comparator);
        for (int j = 0; j < Math.max(10, rnd.nextInt(50)); ++j) {
            Writable key = this.createData(this.keyClass);
            Writable value = this.createData(this.valClass);
            map.put(key, value);
            this.sortedDataMap.put((Object)key, (Object)value);
        }
        return map;
    }

    private Writable createData(Class c) {
        if (c.getName().equalsIgnoreCase(BytesWritable.class.getName())) {
            return new BytesWritable(new BigInteger(256, rnd).toString().getBytes());
        }
        if (c.getName().equalsIgnoreCase(IntWritable.class.getName())) {
            return new IntWritable(rnd.nextInt());
        }
        if (c.getName().equalsIgnoreCase(LongWritable.class.getName())) {
            return new LongWritable(rnd.nextLong());
        }
        if (c.getName().equalsIgnoreCase(CustomKey.class.getName())) {
            String rndStr = new BigInteger(256, rnd).toString() + "_" + new BigInteger(256, rnd).toString();
            return new CustomKey(rndStr.getBytes(), rndStr.hashCode());
        }
        if (c.getName().equalsIgnoreCase(Text.class.getName())) {
            String rndStr = new BigInteger(256, rnd).toString() + "_" + new BigInteger(256, rnd).toString();
            return new Text(rndStr);
        }
        throw new IllegalArgumentException("Illegal argument : " + c.getName());
    }

    public static class CustomKey
    extends BytesWritable {
        private static final int LENGTH_BYTES = 4;
        private int hashCode;

        public CustomKey() {
        }

        public CustomKey(byte[] data, int hashCode) {
            super(data);
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        static {
            WritableComparator.define(CustomKey.class, (WritableComparator)new Comparator());
        }

        public static class Comparator
        extends WritableComparator {
            public Comparator() {
                super(CustomKey.class);
            }

            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
                return Comparator.compareBytes((byte[])b1, (int)(s1 + 4), (int)(l1 - 4), (byte[])b2, (int)(s2 + 4), (int)(l2 - 4));
            }
        }
    }

    private static class ProgressReporter
    implements Progressable {
        private ProgressReporter() {
        }

        public void progress() {
        }
    }

    static enum TestWithComparator {
        LONG,
        INT,
        BYTES,
        TEZ_BYTES,
        TEXT,
        CUSTOM;

    }
}

