/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.resources;

import com.google.common.base.Joiner;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.OutputContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.common.resources.MemoryDistributor;
import org.apache.tez.runtime.common.resources.TestMemoryDistributor;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.OrderedPartitionedKVOutput;
import org.apache.tez.runtime.library.resources.WeightedScalingMemoryDistributor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestWeightedScalingMemoryDistributor
extends TestMemoryDistributor {
    public void setup() {
        this.conf.setBoolean("tez.task.scale.memory.enabled", true);
        this.conf.set("tez.task.scale.memory.allocator.class", WeightedScalingMemoryDistributor.class.getName());
        this.conf.setDouble("tez.task.scale.memory.reserve-fraction", 0.3);
        this.conf.setDouble("tez.task.scale.memory.additional-reservation.fraction.per-io", 0.0);
    }

    @Test(timeout=5000L)
    public void testSimpleWeightedScaling() {
        Configuration conf = new Configuration(this.conf);
        conf.setStrings("tez.task.scale.memory.ratios", WeightedScalingMemoryDistributor.generateWeightStrings((int)0, (int)1, (int)2, (int)3, (int)1, (int)1));
        System.err.println(Joiner.on((String)",").join((Iterable)conf.getStringCollection("tez.task.scale.memory.ratios")));
        MemoryDistributor dist = new MemoryDistributor(2, 2, conf);
        dist.setJvmMemory(10000L);
        MemoryUpdateCallbackForTest e1Callback = new MemoryUpdateCallbackForTest();
        InputContext e1InputContext1 = this.createTestInputContext();
        InputDescriptor e1InDesc1 = this.createTestInputDescriptor(OrderedGroupedKVInput.class);
        dist.requestMemory(10000L, (MemoryUpdateCallback)e1Callback, (TaskContext)e1InputContext1, (EntityDescriptor)e1InDesc1);
        MemoryUpdateCallbackForTest e2Callback = new MemoryUpdateCallbackForTest();
        InputContext e2InputContext2 = this.createTestInputContext();
        InputDescriptor e2InDesc2 = this.createTestInputDescriptor(UnorderedKVInput.class);
        dist.requestMemory(10000L, (MemoryUpdateCallback)e2Callback, (TaskContext)e2InputContext2, (EntityDescriptor)e2InDesc2);
        MemoryUpdateCallbackForTest e3Callback = new MemoryUpdateCallbackForTest();
        OutputContext e3OutputContext1 = this.createTestOutputContext();
        OutputDescriptor e3OutDesc1 = this.createTestOutputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e3Callback, (TaskContext)e3OutputContext1, (EntityDescriptor)e3OutDesc1);
        MemoryUpdateCallbackForTest e4Callback = new MemoryUpdateCallbackForTest();
        OutputContext e4OutputContext2 = this.createTestOutputContext();
        OutputDescriptor e4OutDesc2 = this.createTestOutputDescriptor(OrderedPartitionedKVOutput.class);
        dist.requestMemory(10000L, (MemoryUpdateCallback)e4Callback, (TaskContext)e4OutputContext2, (EntityDescriptor)e4OutDesc2);
        dist.makeInitialAllocations();
        Assert.assertEquals((long)3000L, (long)e1Callback.assigned);
        Assert.assertEquals((long)1000L, (long)e2Callback.assigned);
        Assert.assertEquals((long)1000L, (long)e3Callback.assigned);
        Assert.assertEquals((long)2000L, (long)e4Callback.assigned);
    }

    @Test(timeout=5000L)
    public void testAdditionalReserveFractionWeightedScaling() {
        Configuration conf = new Configuration(this.conf);
        conf.setStrings("tez.task.scale.memory.ratios", WeightedScalingMemoryDistributor.generateWeightStrings((int)0, (int)2, (int)3, (int)6, (int)1, (int)1));
        conf.setDouble("tez.task.scale.memory.additional-reservation.fraction.per-io", 0.025);
        conf.setDouble("tez.task.scale.memory.additional-reservation.fraction.max", 0.2);
        MemoryDistributor dist = new MemoryDistributor(2, 2, conf);
        dist.setJvmMemory(10000L);
        MemoryUpdateCallbackForTest e1Callback = new MemoryUpdateCallbackForTest();
        InputContext e1InputContext1 = this.createTestInputContext();
        InputDescriptor e1InDesc1 = this.createTestInputDescriptor(OrderedGroupedKVInput.class);
        dist.requestMemory(10000L, (MemoryUpdateCallback)e1Callback, (TaskContext)e1InputContext1, (EntityDescriptor)e1InDesc1);
        MemoryUpdateCallbackForTest e2Callback = new MemoryUpdateCallbackForTest();
        InputContext e2InputContext2 = this.createTestInputContext();
        InputDescriptor e2InDesc2 = this.createTestInputDescriptor(UnorderedKVInput.class);
        dist.requestMemory(10000L, (MemoryUpdateCallback)e2Callback, (TaskContext)e2InputContext2, (EntityDescriptor)e2InDesc2);
        MemoryUpdateCallbackForTest e3Callback = new MemoryUpdateCallbackForTest();
        OutputContext e3OutputContext1 = this.createTestOutputContext();
        OutputDescriptor e3OutDesc1 = this.createTestOutputDescriptor();
        dist.requestMemory(10000L, (MemoryUpdateCallback)e3Callback, (TaskContext)e3OutputContext1, (EntityDescriptor)e3OutDesc1);
        MemoryUpdateCallbackForTest e4Callback = new MemoryUpdateCallbackForTest();
        OutputContext e4OutputContext2 = this.createTestOutputContext();
        OutputDescriptor e4OutDesc2 = this.createTestOutputDescriptor(OrderedPartitionedKVOutput.class);
        dist.requestMemory(10000L, (MemoryUpdateCallback)e4Callback, (TaskContext)e4OutputContext2, (EntityDescriptor)e4OutDesc2);
        dist.makeInitialAllocations();
        Assert.assertEquals((long)3000L, (long)e1Callback.assigned);
        Assert.assertEquals((long)1000L, (long)e2Callback.assigned);
        Assert.assertEquals((long)500L, (long)e3Callback.assigned);
        Assert.assertEquals((long)1500L, (long)e4Callback.assigned);
    }

    private InputDescriptor createTestInputDescriptor(Class<? extends LogicalInput> inputClazz) {
        InputDescriptor desc = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        ((InputDescriptor)Mockito.doReturn((Object)inputClazz.getName()).when((Object)desc)).getClassName();
        return desc;
    }

    private OutputDescriptor createTestOutputDescriptor(Class<? extends LogicalOutput> outputClazz) {
        OutputDescriptor desc = (OutputDescriptor)Mockito.mock(OutputDescriptor.class);
        ((OutputDescriptor)Mockito.doReturn((Object)outputClazz.getName()).when((Object)desc)).getClassName();
        return desc;
    }

    private static class MemoryUpdateCallbackForTest
    extends MemoryUpdateCallback {
        long assigned = -1000L;

        private MemoryUpdateCallbackForTest() {
        }

        public void memoryAssigned(long assignedSize) {
            this.assigned = assignedSize;
        }
    }
}

