/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.library.vertexmanager.InputReadyVertexManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestInputReadyVertexManager {
    @Captor
    ArgumentCaptor<List<VertexManagerPluginContext.TaskWithLocationHint>> requestCaptor;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test(timeout=5000L)
    public void testBasicScatterGather() {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)2);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)3);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        HashMap initialCompletions = Maps.newHashMap();
        initialCompletions.put(mockSrcVertexId1, Collections.singletonList(0));
        InputReadyVertexManager manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        manager.onVertexStarted((Map)initialCompletions);
        manager.onSourceTaskCompleted(mockSrcVertexId1, Integer.valueOf(1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleVertexTasks(Mockito.anyList());
        manager.onSourceTaskCompleted(mockSrcVertexId1, Integer.valueOf(2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleVertexTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)2L, (long)((List)this.requestCaptor.getValue()).size());
    }

    @Test(timeout=5000L)
    public void testBasicOneToOne() {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)3);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        HashMap initialCompletions = Maps.newHashMap();
        initialCompletions.put(mockSrcVertexId1, Collections.singletonList(0));
        InputReadyVertexManager manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        manager.onVertexStarted((Map)initialCompletions);
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleVertexTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex().intValue());
        Assert.assertEquals((Object)mockSrcVertexId1, (Object)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(mockSrcVertexId1, Integer.valueOf(1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleVertexTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex().intValue());
        Assert.assertEquals((Object)mockSrcVertexId1, (Object)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(mockSrcVertexId1, Integer.valueOf(2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).scheduleVertexTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex().intValue());
        Assert.assertEquals((Object)mockSrcVertexId1, (Object)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
    }

    @Test(timeout=5000L)
    public void testComplex() {
        HashMap<String, EdgeProperty> mockInputVertices = new HashMap<String, EdgeProperty>();
        String mockSrcVertexId1 = "Vertex1";
        EdgeProperty eProp1 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockSrcVertexId2 = "Vertex2";
        EdgeProperty eProp2 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockSrcVertexId3 = "Vertex3";
        EdgeProperty eProp3 = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.ONE_TO_ONE, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)OutputDescriptor.create((String)"out"), (InputDescriptor)InputDescriptor.create((String)"in"));
        String mockManagedVertexId = "Vertex";
        Container mockContainer2 = (Container)Mockito.mock(Container.class);
        ContainerId mockCId2 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer2.getId()).thenReturn((Object)mockCId2);
        Container mockContainer3 = (Container)Mockito.mock(Container.class);
        ContainerId mockCId3 = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)mockContainer3.getId()).thenReturn((Object)mockCId3);
        VertexManagerPluginContext mockContext = (VertexManagerPluginContext)Mockito.mock(VertexManagerPluginContext.class);
        Mockito.when((Object)mockContext.getInputVertexEdgeProperties()).thenReturn(mockInputVertices);
        Mockito.when((Object)mockContext.getVertexName()).thenReturn((Object)mockManagedVertexId);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId1)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId2)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId3)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getTaskContainer(mockSrcVertexId2, Integer.valueOf(0))).thenReturn((Object)mockContainer2);
        Mockito.when((Object)mockContext.getTaskContainer(mockSrcVertexId2, Integer.valueOf(1))).thenReturn((Object)mockContainer2);
        Mockito.when((Object)mockContext.getTaskContainer(mockSrcVertexId2, Integer.valueOf(2))).thenReturn((Object)mockContainer2);
        Mockito.when((Object)mockContext.getTaskContainer(mockSrcVertexId3, Integer.valueOf(0))).thenReturn((Object)mockContainer3);
        Mockito.when((Object)mockContext.getTaskContainer(mockSrcVertexId3, Integer.valueOf(1))).thenReturn((Object)mockContainer3);
        Mockito.when((Object)mockContext.getTaskContainer(mockSrcVertexId3, Integer.valueOf(2))).thenReturn((Object)mockContainer3);
        mockInputVertices.put(mockSrcVertexId1, eProp1);
        mockInputVertices.put(mockSrcVertexId2, eProp2);
        mockInputVertices.put(mockSrcVertexId3, eProp3);
        HashMap initialCompletions = Maps.newHashMap();
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)4);
        InputReadyVertexManager manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        try {
            manager.onVertexStarted((Map)initialCompletions);
            Assert.assertTrue((String)"Should have exception", (boolean)false);
        }
        catch (TezUncheckedException e) {
            e.getMessage().contains("Managed task number must equal 1-1 source");
        }
        Mockito.when((Object)mockContext.getVertexNumTasks(mockManagedVertexId)).thenReturn((Object)3);
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId3)).thenReturn((Object)4);
        manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        try {
            manager.onVertexStarted((Map)initialCompletions);
            Assert.assertTrue((String)"Should have exception", (boolean)false);
        }
        catch (TezUncheckedException e) {
            e.getMessage().contains("1-1 source vertices must have identical concurrency");
        }
        initialCompletions.put(mockSrcVertexId1, Collections.singletonList(0));
        initialCompletions.put(mockSrcVertexId2, Collections.singletonList(0));
        Mockito.when((Object)mockContext.getVertexNumTasks(mockSrcVertexId3)).thenReturn((Object)3);
        manager = new InputReadyVertexManager(mockContext);
        manager.initialize();
        manager.onVertexStarted((Map)initialCompletions);
        manager.onSourceTaskCompleted(mockSrcVertexId3, Integer.valueOf(0));
        manager.onSourceTaskCompleted(mockSrcVertexId1, Integer.valueOf(1));
        manager.onSourceTaskCompleted(mockSrcVertexId1, Integer.valueOf(1));
        manager.onSourceTaskCompleted(mockSrcVertexId2, Integer.valueOf(1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)0))).scheduleVertexTasks(Mockito.anyList());
        manager.onSourceTaskCompleted(mockSrcVertexId1, Integer.valueOf(2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).scheduleVertexTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex().intValue());
        Assert.assertEquals((Object)mockSrcVertexId3, (Object)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)0L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(mockSrcVertexId3, Integer.valueOf(1));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleVertexTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex().intValue());
        Assert.assertEquals((Object)mockSrcVertexId3, (Object)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)1L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(mockSrcVertexId3, Integer.valueOf(2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)2))).scheduleVertexTasks(Mockito.anyList());
        manager.onSourceTaskCompleted(mockSrcVertexId2, Integer.valueOf(2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).scheduleVertexTasks((List)this.requestCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.requestCaptor.getValue()).size());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskIndex().intValue());
        Assert.assertEquals((Object)mockSrcVertexId2, (Object)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getVertexName());
        Assert.assertEquals((long)2L, (long)((VertexManagerPluginContext.TaskWithLocationHint)((List)this.requestCaptor.getValue()).get(0)).getTaskLocationHint().getAffinitizedTask().getTaskIndex());
        manager.onSourceTaskCompleted(mockSrcVertexId3, Integer.valueOf(2));
        ((VertexManagerPluginContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)3))).scheduleVertexTasks(Mockito.anyList());
    }
}

