/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.input;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.readers.ShuffledUnorderedKVReader;
import org.apache.tez.runtime.library.shuffle.common.ShuffleEventHandler;
import org.apache.tez.runtime.library.shuffle.common.impl.ShuffleInputEventHandlerImpl;
import org.apache.tez.runtime.library.shuffle.common.impl.ShuffleManager;
import org.apache.tez.runtime.library.shuffle.common.impl.SimpleFetchedInputAllocator;

public class ShuffledUnorderedKVInput
implements LogicalInput {
    private static final Log LOG = LogFactory.getLog(ShuffledUnorderedKVInput.class);
    private Configuration conf;
    private int numInputs = -1;
    private TezInputContext inputContext;
    private ShuffleManager shuffleManager;
    private final BlockingQueue<Event> pendingEvents = new LinkedBlockingQueue<Event>();
    private long firstEventReceivedTime = -1L;
    private MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private ShuffledUnorderedKVReader kvReader;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private TezCounter inputRecordCounter;
    private SimpleFetchedInputAllocator inputManager;
    private ShuffleEventHandler inputEventHandler;

    public synchronized List<Event> initialize(TezInputContext inputContext) throws Exception {
        Preconditions.checkArgument((this.numInputs != -1 ? 1 : 0) != 0, (Object)"Number of Inputs has not been set");
        this.inputContext = inputContext;
        this.conf = TezUtils.createConfFromUserPayload((byte[])inputContext.getUserPayload());
        if (this.numInputs == 0) {
            inputContext.requestInitialMemory(0L, null);
            this.isStarted.set(true);
            inputContext.inputIsReady();
            LOG.info((Object)("input fetch not required since there are 0 physical inputs for input vertex: " + inputContext.getSourceVertexName()));
            return Collections.emptyList();
        }
        long initalMemReq = this.getInitialMemoryReq();
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        this.inputContext.requestInitialMemory(initalMemReq, (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.conf.setStrings("tez.runtime.local.dirs", inputContext.getWorkDirs());
        this.inputRecordCounter = inputContext.getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
        return Collections.emptyList();
    }

    public synchronized void start() throws IOException {
        if (!this.isStarted.get()) {
            CompressionCodec codec;
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            if (ConfigUtils.isIntermediateInputCompressed(this.conf)) {
                Class<? extends CompressionCodec> codecClass = ConfigUtils.getIntermediateInputCompressorClass(this.conf, DefaultCodec.class);
                codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.conf);
            } else {
                codec = null;
            }
            boolean ifileReadAhead = this.conf.getBoolean("tez.runtime.ifile.readahead", true);
            int ifileReadAheadLength = 0;
            int ifileBufferSize = 0;
            if (ifileReadAhead) {
                ifileReadAheadLength = this.conf.getInt("tez.runtime.ifile.readahead.bytes", 0x400000);
            }
            ifileBufferSize = this.conf.getInt("io.file.buffer.size", -1);
            this.inputManager = new SimpleFetchedInputAllocator(this.inputContext.getUniqueIdentifier(), this.conf, this.inputContext.getTotalMemoryAvailableToTask(), this.memoryUpdateCallbackHandler.getMemoryAssigned());
            this.shuffleManager = new ShuffleManager(this.inputContext, this.conf, this.numInputs, ifileBufferSize, ifileReadAhead, ifileReadAheadLength, codec, this.inputManager);
            this.inputEventHandler = new ShuffleInputEventHandlerImpl(this.inputContext, this.shuffleManager, this.inputManager, codec, ifileReadAhead, ifileReadAheadLength);
            this.shuffleManager.run();
            this.kvReader = this.createReader(this.inputRecordCounter, codec, ifileBufferSize, ifileReadAhead, ifileReadAheadLength);
            LinkedList<Event> pending = new LinkedList<Event>();
            this.pendingEvents.drainTo(pending);
            if (pending.size() > 0) {
                LOG.info((Object)("NoAutoStart delay in processing first event: " + (System.currentTimeMillis() - this.firstEventReceivedTime)));
                this.inputEventHandler.handleEvents(pending);
            }
            this.isStarted.set(true);
        }
    }

    public synchronized KeyValueReader getReader() throws Exception {
        Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Must start input before invoking this method");
        if (this.numInputs == 0) {
            return new KeyValueReader(){

                @Override
                public boolean next() throws IOException {
                    return false;
                }

                @Override
                public Object getCurrentKey() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }

                @Override
                public Object getCurrentValue() throws IOException {
                    throw new RuntimeException("No data available in Input");
                }
            };
        }
        return this.kvReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws IOException {
        ShuffledUnorderedKVInput shuffledUnorderedKVInput = this;
        synchronized (shuffledUnorderedKVInput) {
            if (this.numInputs == 0) {
                throw new RuntimeException("No input events expected as numInputs is 0");
            }
            if (!this.isStarted.get()) {
                if (this.firstEventReceivedTime == -1L) {
                    this.firstEventReceivedTime = System.currentTimeMillis();
                }
                this.pendingEvents.addAll(inputEvents);
                return;
            }
        }
        this.inputEventHandler.handleEvents(inputEvents);
    }

    public synchronized List<Event> close() throws Exception {
        if (this.shuffleManager != null) {
            this.shuffleManager.shutdown();
        }
        return null;
    }

    public synchronized void setNumPhysicalInputs(int numInputs) {
        this.numInputs = numInputs;
    }

    private long getInitialMemoryReq() {
        return SimpleFetchedInputAllocator.getInitialMemoryReq(this.conf, this.inputContext.getTotalMemoryAvailableToTask());
    }

    private ShuffledUnorderedKVReader createReader(TezCounter inputRecordCounter, CompressionCodec codec, int ifileBufferSize, boolean ifileReadAheadEnabled, int ifileReadAheadLength) throws IOException {
        return new ShuffledUnorderedKVReader(this.shuffleManager, this.conf, codec, ifileReadAheadEnabled, ifileReadAheadLength, ifileBufferSize, inputRecordCounter);
    }
}

