/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.yarn.util.AuxiliaryServiceHelper;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.impl.TezOutputContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.output.OnFileUnorderedKVOutput;
import org.apache.tez.runtime.library.shuffle.common.ShuffleUtils;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;
import org.apache.tez.runtime.library.testutils.KVDataGen;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestOnFileUnorderedKVOutput {
    private static final Log LOG = LogFactory.getLog(TestOnFileUnorderedKVOutput.class);
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private static Path workDir = null;

    @Before
    @After
    public void cleanup() throws Exception {
        localFs.delete(workDir, true);
    }

    @Test
    public void testGeneratedDataMovementEvent() throws Exception {
        OnFileUnorderedKVOutputForTest kvOutput = new OnFileUnorderedKVOutputForTest();
        Configuration conf = new Configuration();
        conf.set("tez.runtime.intermediate-output.key.class", Text.class.getName());
        conf.set("tez.runtime.intermediate-output.value.class", IntWritable.class.getName());
        conf.setStrings("tez.runtime.local.dirs", new String[]{workDir.toString()});
        int appAttemptNumber = 1;
        TezUmbilical tezUmbilical = null;
        String dagName = "currentDAG";
        String taskVertexName = "currentVertex";
        String destinationVertexName = "destinationVertex";
        TezDAGID dagID = TezDAGID.getInstance((String)"2000", (int)1, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)1);
        TezCounters counters = new TezCounters();
        byte[] userPayload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        RuntimeTask runtimeTask = (RuntimeTask)Mockito.mock(RuntimeTask.class);
        int shufflePort = 2112;
        HashMap auxEnv = new HashMap();
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(shufflePort);
        bb.position(0);
        AuxiliaryServiceHelper.setServiceDataIntoEnv((String)ShuffleUtils.SHUFFLE_HANDLER_SERVICE_ID, (ByteBuffer)bb, auxEnv);
        TezOutputContextImpl outputContext = new TezOutputContextImpl(conf, appAttemptNumber, tezUmbilical, dagName, taskVertexName, destinationVertexName, taskAttemptID, counters, 0, userPayload, runtimeTask, null, auxEnv, new MemoryDistributor(1, 1, conf), (OutputDescriptor)Mockito.mock(OutputDescriptor.class));
        List events = null;
        events = kvOutput.initialize((TezOutputContext)outputContext);
        Assert.assertTrue((events != null && events.size() == 0 ? 1 : 0) != 0);
        KeyValueWriter kvWriter = kvOutput.getWriter();
        List<KVDataGen.KVPair> data = KVDataGen.generateTestData(true);
        for (KVDataGen.KVPair kvp : data) {
            kvWriter.write((Object)kvp.getKey(), (Object)kvp.getvalue());
        }
        events = kvOutput.close();
        Assert.assertTrue((events != null && events.size() == 1 ? 1 : 0) != 0);
        DataMovementEvent dmEvent = (DataMovementEvent)events.get(0);
        Assert.assertEquals((String)"Invalid source index", (long)0L, (long)dmEvent.getSourceIndex());
        ShuffleUserPayloads.DataMovementEventPayloadProto shufflePayload = ShuffleUserPayloads.DataMovementEventPayloadProto.parseFrom((byte[])dmEvent.getUserPayload());
        Assert.assertFalse((boolean)shufflePayload.hasEmptyPartitions());
        Assert.assertEquals((Object)outputContext.getUniqueIdentifier(), (Object)shufflePayload.getPathComponent());
        Assert.assertEquals((long)shufflePort, (long)shufflePayload.getPort());
        Assert.assertEquals((Object)"host", (Object)shufflePayload.getHost());
    }

    static {
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), TestOnFileUnorderedKVOutput.class.getName()).makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
            LOG.info((Object)("Using workDir: " + workDir));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class OnFileUnorderedKVOutputForTest
    extends OnFileUnorderedKVOutput {
        private OnFileUnorderedKVOutputForTest() {
        }

        String getHost() {
            return "host";
        }
    }
}

