/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.runtime.common.resources.InitialMemoryAllocator;
import org.apache.tez.runtime.common.resources.InitialMemoryRequestContext;

public class ScalingAllocator
implements InitialMemoryAllocator {
    private static final Log LOG = LogFactory.getLog(ScalingAllocator.class);
    @VisibleForTesting
    static final double DEFAULT_RESERVE_FRACTION = 0.3;
    private Configuration conf;

    public Iterable<Long> assignMemory(long availableForAllocation, int numTotalInputs, int numTotalOutputs, Iterable<InitialMemoryRequestContext> requests) {
        int numRequests = 0;
        long totalRequested = 0L;
        for (InitialMemoryRequestContext context : requests) {
            totalRequested += context.getRequestedSize();
            ++numRequests;
        }
        double reserveFraction = this.conf.getDouble("tez.task.scale.memory.reserve-fraction", 0.3);
        Preconditions.checkState((reserveFraction >= 0.0 && reserveFraction <= 1.0 ? 1 : 0) != 0);
        availableForAllocation = (long)((double)availableForAllocation - reserveFraction * (double)availableForAllocation);
        long totalJvmMem = Runtime.getRuntime().maxMemory();
        double ratio = (double)totalRequested / (double)totalJvmMem;
        LOG.info((Object)("Scaling Requests. TotalRequested: " + totalRequested + ", TotalJVMHeap: " + totalJvmMem + ", TotalAvailable: " + availableForAllocation + ", TotalRequested/TotalJVMHeap:" + new DecimalFormat("0.00").format(ratio)));
        if (totalRequested < availableForAllocation || totalRequested == 0L) {
            return Lists.newArrayList((Iterable)Iterables.transform(requests, (Function)new Function<InitialMemoryRequestContext, Long>(){

                public Long apply(InitialMemoryRequestContext requestContext) {
                    return requestContext.getRequestedSize();
                }
            }));
        }
        ArrayList allocations = Lists.newArrayListWithCapacity((int)numRequests);
        for (InitialMemoryRequestContext request : requests) {
            long requestedSize = request.getRequestedSize();
            if (requestedSize == 0L) {
                allocations.add(0L);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"Scaling requested: 0 to allocated: 0");
                continue;
            }
            long allocated = (long)((double)requestedSize / (double)totalRequested * (double)availableForAllocation);
            allocations.add(allocated);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Scaling requested: " + requestedSize + " to allocated: " + allocated));
        }
        return allocations;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

