/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.tez.common.ProtoConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.events.TaskAttemptCompletedEvent;
import org.apache.tez.runtime.api.events.TaskAttemptFailedEvent;
import org.apache.tez.runtime.api.events.TaskStatusUpdateEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.EventType;
import org.apache.tez.runtime.internals.api.events.SystemEventProtos;

public class TezEvent
implements Writable {
    private EventType eventType;
    private Event event;
    private EventMetaData sourceInfo;
    private EventMetaData destinationInfo;

    public TezEvent() {
    }

    public TezEvent(Event event, EventMetaData sourceInfo) {
        this.event = event;
        this.setSourceInfo(sourceInfo);
        if (event instanceof DataMovementEvent) {
            this.eventType = EventType.DATA_MOVEMENT_EVENT;
        } else if (event instanceof CompositeDataMovementEvent) {
            this.eventType = EventType.COMPOSITE_DATA_MOVEMENT_EVENT;
        } else if (event instanceof VertexManagerEvent) {
            this.eventType = EventType.VERTEX_MANAGER_EVENT;
        } else if (event instanceof InputReadErrorEvent) {
            this.eventType = EventType.INPUT_READ_ERROR_EVENT;
        } else if (event instanceof TaskAttemptFailedEvent) {
            this.eventType = EventType.TASK_ATTEMPT_FAILED_EVENT;
        } else if (event instanceof TaskAttemptCompletedEvent) {
            this.eventType = EventType.TASK_ATTEMPT_COMPLETED_EVENT;
        } else if (event instanceof InputFailedEvent) {
            this.eventType = EventType.INPUT_FAILED_EVENT;
        } else if (event instanceof TaskStatusUpdateEvent) {
            this.eventType = EventType.TASK_STATUS_UPDATE_EVENT;
        } else if (event instanceof RootInputDataInformationEvent) {
            this.eventType = EventType.ROOT_INPUT_DATA_INFORMATION_EVENT;
        } else {
            throw new TezUncheckedException("Unknown event, event=" + event.getClass().getName());
        }
    }

    public Event getEvent() {
        return this.event;
    }

    public EventMetaData getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(EventMetaData sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public EventMetaData getDestinationInfo() {
        return this.destinationInfo;
    }

    public void setDestinationInfo(EventMetaData destinationInfo) {
        this.destinationInfo = destinationInfo;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    private void serializeEvent(DataOutput out) throws IOException {
        if (this.event == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.eventType.ordinal());
        if (this.eventType.equals((Object)EventType.TASK_STATUS_UPDATE_EVENT)) {
            TaskStatusUpdateEvent sEvt = (TaskStatusUpdateEvent)this.event;
            sEvt.write(out);
        } else {
            byte[] eventBytes = null;
            switch (this.eventType) {
                case DATA_MOVEMENT_EVENT: {
                    eventBytes = ProtoConverters.convertDataMovementEventToProto((DataMovementEvent)this.event).toByteArray();
                    break;
                }
                case COMPOSITE_DATA_MOVEMENT_EVENT: {
                    eventBytes = ProtoConverters.convertCompositeDataMovementEventToProto((CompositeDataMovementEvent)this.event).toByteArray();
                    break;
                }
                case VERTEX_MANAGER_EVENT: {
                    VertexManagerEvent vmEvt = (VertexManagerEvent)this.event;
                    EventProtos.VertexManagerEventProto.Builder vmBuilder = EventProtos.VertexManagerEventProto.newBuilder();
                    vmBuilder.setTargetVertexName(vmEvt.getTargetVertexName());
                    if (vmEvt.getUserPayload() != null) {
                        vmBuilder.setUserPayload(ByteString.copyFrom((byte[])vmEvt.getUserPayload()));
                    }
                    eventBytes = vmBuilder.build().toByteArray();
                    break;
                }
                case INPUT_READ_ERROR_EVENT: {
                    InputReadErrorEvent ideEvt = (InputReadErrorEvent)this.event;
                    eventBytes = EventProtos.InputReadErrorEventProto.newBuilder().setIndex(ideEvt.getIndex()).setDiagnostics(ideEvt.getDiagnostics()).setVersion(ideEvt.getVersion()).build().toByteArray();
                    break;
                }
                case TASK_ATTEMPT_FAILED_EVENT: {
                    TaskAttemptFailedEvent tfEvt = (TaskAttemptFailedEvent)this.event;
                    eventBytes = SystemEventProtos.TaskAttemptFailedEventProto.newBuilder().setDiagnostics(tfEvt.getDiagnostics()).build().toByteArray();
                    break;
                }
                case TASK_ATTEMPT_COMPLETED_EVENT: {
                    eventBytes = SystemEventProtos.TaskAttemptCompletedEventProto.newBuilder().build().toByteArray();
                    break;
                }
                case INPUT_FAILED_EVENT: {
                    InputFailedEvent ifEvt = (InputFailedEvent)this.event;
                    eventBytes = EventProtos.InputFailedEventProto.newBuilder().setSourceIndex(ifEvt.getSourceIndex()).setTargetIndex(ifEvt.getTargetIndex()).setVersion(ifEvt.getVersion()).build().toByteArray();
                    break;
                }
                case ROOT_INPUT_DATA_INFORMATION_EVENT: {
                    eventBytes = ProtoConverters.convertRootInputDataInformationEventToProto((RootInputDataInformationEvent)this.event).toByteArray();
                    break;
                }
                default: {
                    throw new TezUncheckedException("Unknown TezEvent, type=" + (Object)((Object)this.eventType));
                }
            }
            out.writeInt(eventBytes.length);
            out.write(eventBytes);
        }
    }

    private void deserializeEvent(DataInput in) throws IOException {
        if (!in.readBoolean()) {
            this.event = null;
            return;
        }
        this.eventType = EventType.values()[in.readInt()];
        if (this.eventType.equals((Object)EventType.TASK_STATUS_UPDATE_EVENT)) {
            this.event = new TaskStatusUpdateEvent();
            ((TaskStatusUpdateEvent)this.event).readFields(in);
        } else {
            int eventBytesLen = in.readInt();
            byte[] eventBytes = new byte[eventBytesLen];
            in.readFully(eventBytes);
            switch (this.eventType) {
                case DATA_MOVEMENT_EVENT: {
                    EventProtos.DataMovementEventProto dmProto = EventProtos.DataMovementEventProto.parseFrom((byte[])eventBytes);
                    this.event = ProtoConverters.convertDataMovementEventFromProto(dmProto);
                    break;
                }
                case COMPOSITE_DATA_MOVEMENT_EVENT: {
                    EventProtos.CompositeEventProto cProto = EventProtos.CompositeEventProto.parseFrom((byte[])eventBytes);
                    this.event = ProtoConverters.convertCompositeDataMovementEventFromProto(cProto);
                    break;
                }
                case VERTEX_MANAGER_EVENT: {
                    EventProtos.VertexManagerEventProto vmProto = EventProtos.VertexManagerEventProto.parseFrom((byte[])eventBytes);
                    this.event = new VertexManagerEvent(vmProto.getTargetVertexName(), vmProto.getUserPayload() != null ? vmProto.getUserPayload().toByteArray() : null);
                    break;
                }
                case INPUT_READ_ERROR_EVENT: {
                    EventProtos.InputReadErrorEventProto ideProto = EventProtos.InputReadErrorEventProto.parseFrom((byte[])eventBytes);
                    this.event = new InputReadErrorEvent(ideProto.getDiagnostics(), ideProto.getIndex(), ideProto.getVersion());
                    break;
                }
                case TASK_ATTEMPT_FAILED_EVENT: {
                    SystemEventProtos.TaskAttemptFailedEventProto tfProto = SystemEventProtos.TaskAttemptFailedEventProto.parseFrom(eventBytes);
                    this.event = new TaskAttemptFailedEvent(tfProto.getDiagnostics());
                    break;
                }
                case TASK_ATTEMPT_COMPLETED_EVENT: {
                    this.event = new TaskAttemptCompletedEvent();
                    break;
                }
                case INPUT_FAILED_EVENT: {
                    EventProtos.InputFailedEventProto ifProto = EventProtos.InputFailedEventProto.parseFrom((byte[])eventBytes);
                    this.event = new InputFailedEvent(ifProto.getSourceIndex(), ifProto.getTargetIndex(), ifProto.getVersion());
                    break;
                }
                case ROOT_INPUT_DATA_INFORMATION_EVENT: {
                    EventProtos.RootInputDataInformationEventProto difProto = EventProtos.RootInputDataInformationEventProto.parseFrom((byte[])eventBytes);
                    this.event = ProtoConverters.convertRootInputDataInformationEventFromProto(difProto);
                    break;
                }
                default: {
                    throw new TezUncheckedException("Unexpected TezEvent, type=" + (Object)((Object)this.eventType));
                }
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        this.serializeEvent(out);
        if (this.sourceInfo != null) {
            out.writeBoolean(true);
            this.sourceInfo.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.destinationInfo != null) {
            out.writeBoolean(true);
            this.destinationInfo.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.deserializeEvent(in);
        if (in.readBoolean()) {
            this.sourceInfo = new EventMetaData();
            this.sourceInfo.readFields(in);
        }
        if (in.readBoolean()) {
            this.destinationInfo = new EventMetaData();
            this.destinationInfo.readFields(in);
        }
    }
}

