/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.common.RuntimeUtils;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.RuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.LogicalIOProcessor;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.MergedLogicalInput;
import org.apache.tez.runtime.api.Output;
import org.apache.tez.runtime.api.Processor;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.TezProcessorContext;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.GroupInputSpec;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezInputContextImpl;
import org.apache.tez.runtime.api.impl.TezOutputContextImpl;
import org.apache.tez.runtime.api.impl.TezProcessorContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;

@InterfaceAudience.Private
public class LogicalIOProcessorRuntimeTask
extends RuntimeTask {
    private static final Log LOG = LogFactory.getLog(LogicalIOProcessorRuntimeTask.class);
    private final List<InputSpec> inputSpecs;
    private final ConcurrentHashMap<String, LogicalInput> inputsMap;
    private final ConcurrentHashMap<String, TezInputContext> inputContextMap;
    private final List<OutputSpec> outputSpecs;
    private final ConcurrentHashMap<String, LogicalOutput> outputsMap;
    private final ConcurrentHashMap<String, TezOutputContext> outputContextMap;
    private final List<GroupInputSpec> groupInputSpecs;
    private ConcurrentHashMap<String, MergedLogicalInput> groupInputsMap;
    private final ProcessorDescriptor processorDescriptor;
    private final LogicalIOProcessor processor;
    private TezProcessorContext processorContext;
    private final MemoryDistributor initialMemoryDistributor;
    private final LinkedHashMap<String, LogicalInput> runInputMap;
    private final LinkedHashMap<String, LogicalOutput> runOutputMap;
    private final Map<String, ByteBuffer> serviceConsumerMetadata;
    private final ExecutorService initializerExecutor;
    private final CompletionService<Void> initializerCompletionService;
    private final Multimap<String, String> startedInputsMap;
    private LinkedBlockingQueue<TezEvent> eventsToBeProcessed;
    private Thread eventRouterThread = null;
    private final int appAttemptNumber;
    private final InputReadyTracker inputReadyTracker;

    public LogicalIOProcessorRuntimeTask(TaskSpec taskSpec, int appAttemptNumber, Configuration tezConf, TezUmbilical tezUmbilical, Map<String, ByteBuffer> serviceConsumerMetadata, Multimap<String, String> startedInputsMap) throws IOException {
        super(taskSpec, tezConf, tezUmbilical);
        LOG.info((Object)("Initializing LogicalIOProcessorRuntimeTask with TaskSpec: " + taskSpec));
        int numInputs = taskSpec.getInputs().size();
        int numOutputs = taskSpec.getOutputs().size();
        this.inputSpecs = taskSpec.getInputs();
        this.inputsMap = new ConcurrentHashMap(numInputs);
        this.inputContextMap = new ConcurrentHashMap(numInputs);
        this.outputSpecs = taskSpec.getOutputs();
        this.outputsMap = new ConcurrentHashMap(numOutputs);
        this.outputContextMap = new ConcurrentHashMap(numOutputs);
        this.runInputMap = new LinkedHashMap();
        this.runOutputMap = new LinkedHashMap();
        this.processorDescriptor = taskSpec.getProcessorDescriptor();
        this.processor = this.createProcessor(this.processorDescriptor);
        this.serviceConsumerMetadata = serviceConsumerMetadata;
        this.eventsToBeProcessed = new LinkedBlockingQueue();
        this.state = RuntimeTask.State.NEW;
        this.appAttemptNumber = appAttemptNumber;
        int numInitializers = numInputs + numOutputs;
        numInitializers = numInitializers == 0 ? 1 : numInitializers;
        this.initializerExecutor = Executors.newFixedThreadPool(numInitializers, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Initializer %d").build());
        this.initializerCompletionService = new ExecutorCompletionService<Void>(this.initializerExecutor);
        this.groupInputSpecs = taskSpec.getGroupInputs();
        this.initialMemoryDistributor = new MemoryDistributor(numInputs, numOutputs, tezConf);
        this.startedInputsMap = startedInputsMap;
        this.inputReadyTracker = new InputReadyTracker();
    }

    public void initialize() throws Exception {
        int completedTasks;
        LOG.info((Object)"Initializing LogicalProcessorIORuntimeTask");
        Preconditions.checkState((this.state == RuntimeTask.State.NEW ? 1 : 0) != 0, (Object)"Already initialized");
        this.state = RuntimeTask.State.INITED;
        int numTasks = 0;
        int inputIndex = 0;
        for (InputSpec inputSpec : this.taskSpec.getInputs()) {
            this.initializerCompletionService.submit(new InitializeInputCallable(inputSpec, inputIndex++));
            ++numTasks;
        }
        int outputIndex = 0;
        for (OutputSpec outputSpec : this.taskSpec.getOutputs()) {
            this.initializerCompletionService.submit(new InitializeOutputCallable(outputSpec, outputIndex++));
            ++numTasks;
        }
        this.initializeLogicalIOProcessor();
        for (completedTasks = 0; completedTasks < numTasks; ++completedTasks) {
            LOG.info((Object)("Waiting for " + (numTasks - completedTasks) + " initializers to finish"));
            Future<Void> future = this.initializerCompletionService.take();
            try {
                future.get();
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new Exception(e);
            }
        }
        LOG.info((Object)"All initializers finished");
        this.initializeGroupInputs();
        this.inputReadyTracker.setGroupedInputs(this.groupInputsMap == null ? null : this.groupInputsMap.values());
        HashSet groupInputs = Sets.newHashSet();
        if (this.groupInputSpecs != null && !this.groupInputSpecs.isEmpty()) {
            for (GroupInputSpec groupInputSpec : this.groupInputSpecs) {
                this.runInputMap.put(groupInputSpec.getGroupName(), (LogicalInput)this.groupInputsMap.get(groupInputSpec.getGroupName()));
                groupInputs.addAll(groupInputSpec.getGroupVertices());
            }
        }
        this.initialMemoryDistributor.makeInitialAllocations();
        LOG.info((Object)"Starting Inputs/Outputs");
        int numAutoStarts = 0;
        for (InputSpec inputSpec : this.inputSpecs) {
            if (groupInputs.contains(inputSpec.getSourceVertexName())) {
                LOG.info((Object)("Ignoring " + inputSpec.getSourceVertexName() + " for start, since it will be controlled via it's Group"));
                continue;
            }
            if (this.inputAlreadyStarted(this.taskSpec.getVertexName(), inputSpec.getSourceVertexName())) continue;
            this.startedInputsMap.put((Object)this.taskSpec.getVertexName(), (Object)inputSpec.getSourceVertexName());
            ++numAutoStarts;
            this.initializerCompletionService.submit(new StartInputCallable(this.inputsMap.get(inputSpec.getSourceVertexName()), inputSpec.getSourceVertexName()));
            LOG.info((Object)("Input: " + inputSpec.getSourceVertexName() + " being auto started by the framework. Subsequent instances will not be auto-started"));
        }
        if (this.groupInputSpecs != null) {
            for (GroupInputSpec group : this.groupInputSpecs) {
                if (this.inputAlreadyStarted(this.taskSpec.getVertexName(), group.getGroupName())) continue;
                ++numAutoStarts;
                this.initializerCompletionService.submit(new StartInputCallable((LogicalInput)this.groupInputsMap.get(group.getGroupName()), group.getGroupName()));
                LOG.info((Object)("InputGroup: " + group.getGroupName() + " being auto started by the framework. Subsequent instance will not be auto-started"));
            }
        }
        this.initializerExecutor.shutdown();
        LOG.info((Object)("Num IOs determined for AutoStart: " + numAutoStarts));
        for (completedTasks = 0; completedTasks < numAutoStarts; ++completedTasks) {
            LOG.info((Object)("Waiting for " + (numAutoStarts - completedTasks) + " IOs to start"));
            Future<Void> future = this.initializerCompletionService.take();
            try {
                future.get();
                continue;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new Exception(e);
            }
        }
        LOG.info((Object)"AutoStartComplete");
        for (InputSpec inputSpec : this.inputSpecs) {
            if (groupInputs.contains(inputSpec.getSourceVertexName())) continue;
            LogicalInput input = this.inputsMap.get(inputSpec.getSourceVertexName());
            this.runInputMap.put(inputSpec.getSourceVertexName(), input);
        }
        for (OutputSpec outputSpec : this.outputSpecs) {
            LogicalOutput output = this.outputsMap.get(outputSpec.getDestinationVertexName());
            String outputName = outputSpec.getDestinationVertexName();
            this.runOutputMap.put(outputName, output);
        }
        this.startRouterThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        RuntimeTask.State state = this.state;
        synchronized (state) {
            Preconditions.checkState((this.state == RuntimeTask.State.INITED ? 1 : 0) != 0, (Object)("Can only run while in INITED state. Current: " + (Object)((Object)this.state)));
            this.state = RuntimeTask.State.RUNNING;
        }
        LogicalIOProcessor lioProcessor = this.processor;
        lioProcessor.run(this.runInputMap, this.runOutputMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        try {
            Preconditions.checkState((this.state == RuntimeTask.State.RUNNING ? 1 : 0) != 0, (Object)("Can only run while in RUNNING state. Current: " + (Object)((Object)this.state)));
            this.state = RuntimeTask.State.CLOSED;
            this.processor.close();
            for (InputSpec inputSpec : this.inputSpecs) {
                String srcVertexName = inputSpec.getSourceVertexName();
                List closeInputEvents = this.inputsMap.get(srcVertexName).close();
                this.sendTaskGeneratedEvents(closeInputEvents, EventMetaData.EventProducerConsumerType.INPUT, this.taskSpec.getVertexName(), srcVertexName, this.taskSpec.getTaskAttemptID());
            }
            for (OutputSpec outputSpec : this.outputSpecs) {
                String destVertexName = outputSpec.getDestinationVertexName();
                List closeOutputEvents = this.outputsMap.get(destVertexName).close();
                this.sendTaskGeneratedEvents(closeOutputEvents, EventMetaData.EventProducerConsumerType.OUTPUT, this.taskSpec.getVertexName(), destVertexName, this.taskSpec.getTaskAttemptID());
            }
        }
        finally {
            this.setTaskDone();
            if (this.eventRouterThread != null) {
                this.eventRouterThread.interrupt();
            }
        }
    }

    private boolean inputAlreadyStarted(String vertexName, String edgeVertexName) {
        return this.startedInputsMap.containsKey((Object)vertexName) && this.startedInputsMap.get((Object)vertexName).contains(edgeVertexName);
    }

    private void initializeGroupInputs() {
        if (this.groupInputSpecs != null && !this.groupInputSpecs.isEmpty()) {
            this.groupInputsMap = new ConcurrentHashMap(this.groupInputSpecs.size());
            for (GroupInputSpec groupInputSpec : this.groupInputSpecs) {
                LOG.info((Object)("Initializing GroupInput using GroupInputSpec: " + groupInputSpec));
                MergedLogicalInput groupInput = (MergedLogicalInput)this.createInputFromDescriptor(groupInputSpec.getMergedInputDescriptor());
                ArrayList inputs = Lists.newArrayListWithCapacity((int)groupInputSpec.getGroupVertices().size());
                for (String groupVertex : groupInputSpec.getGroupVertices()) {
                    inputs.add(this.inputsMap.get(groupVertex));
                }
                groupInput.initialize((List)inputs);
                this.groupInputsMap.put(groupInputSpec.getGroupName(), groupInput);
            }
        }
    }

    private void initializeLogicalIOProcessor() throws Exception {
        TezProcessorContext processorContext;
        LOG.info((Object)("Initializing processor, processorClassName=" + this.processorDescriptor.getClassName()));
        this.processorContext = processorContext = this.createProcessorContext();
        this.processor.initialize(processorContext);
        LOG.info((Object)("Initialized processor, processorClassName=" + this.processorDescriptor.getClassName()));
    }

    private TezInputContext createInputContext(Input input, InputSpec inputSpec, int inputIndex) {
        TezInputContextImpl inputContext = new TezInputContextImpl(this.tezConf, this.appAttemptNumber, this.tezUmbilical, this.taskSpec.getDAGName(), this.taskSpec.getVertexName(), inputSpec.getSourceVertexName(), this.taskSpec.getTaskAttemptID(), this.tezCounters, inputIndex, inputSpec.getInputDescriptor().getUserPayload() == null ? this.taskSpec.getProcessorDescriptor().getUserPayload() : inputSpec.getInputDescriptor().getUserPayload(), this, this.serviceConsumerMetadata, System.getenv(), this.initialMemoryDistributor, inputSpec.getInputDescriptor(), input, this.inputReadyTracker);
        return inputContext;
    }

    private TezOutputContext createOutputContext(OutputSpec outputSpec, int outputIndex) {
        TezOutputContextImpl outputContext = new TezOutputContextImpl(this.tezConf, this.appAttemptNumber, this.tezUmbilical, this.taskSpec.getDAGName(), this.taskSpec.getVertexName(), outputSpec.getDestinationVertexName(), this.taskSpec.getTaskAttemptID(), this.tezCounters, outputIndex, outputSpec.getOutputDescriptor().getUserPayload() == null ? this.taskSpec.getProcessorDescriptor().getUserPayload() : outputSpec.getOutputDescriptor().getUserPayload(), this, this.serviceConsumerMetadata, System.getenv(), this.initialMemoryDistributor, outputSpec.getOutputDescriptor());
        return outputContext;
    }

    private TezProcessorContext createProcessorContext() {
        TezProcessorContextImpl processorContext = new TezProcessorContextImpl(this.tezConf, this.appAttemptNumber, this.tezUmbilical, this.taskSpec.getDAGName(), this.taskSpec.getVertexName(), this.taskSpec.getTaskAttemptID(), this.tezCounters, this.processorDescriptor.getUserPayload(), this, this.serviceConsumerMetadata, System.getenv(), this.initialMemoryDistributor, this.processorDescriptor, this.inputReadyTracker);
        return processorContext;
    }

    private LogicalInput createInput(InputSpec inputSpec) {
        LOG.info((Object)"Creating Input");
        return this.createInputFromDescriptor(inputSpec.getInputDescriptor());
    }

    private LogicalInput createInputFromDescriptor(InputDescriptor inputDesc) {
        Input input = (Input)RuntimeUtils.createClazzInstance((String)inputDesc.getClassName());
        if (!(input instanceof LogicalInput)) {
            throw new TezUncheckedException(inputDesc.getClass().getName() + " is not a sub-type of LogicalInput." + " Only LogicalInput sub-types supported by LogicalIOProcessor.");
        }
        return (LogicalInput)input;
    }

    private LogicalOutput createOutput(OutputSpec outputSpec) {
        LOG.info((Object)"Creating Output");
        Output output = (Output)RuntimeUtils.createClazzInstance((String)outputSpec.getOutputDescriptor().getClassName());
        if (!(output instanceof LogicalOutput)) {
            throw new TezUncheckedException(output.getClass().getName() + " is not a sub-type of LogicalOutput." + " Only LogicalOutput sub-types supported by LogicalIOProcessor.");
        }
        return (LogicalOutput)output;
    }

    private LogicalIOProcessor createProcessor(ProcessorDescriptor processorDescriptor) {
        Processor processor = (Processor)RuntimeUtils.createClazzInstance((String)processorDescriptor.getClassName());
        if (!(processor instanceof LogicalIOProcessor)) {
            throw new TezUncheckedException(processor.getClass().getName() + " is not a sub-type of LogicalIOProcessor." + " Only LogicalIOProcessor sub-types supported by LogicalIOProcessorRuntimeTask.");
        }
        return (LogicalIOProcessor)processor;
    }

    private void sendTaskGeneratedEvents(List<Event> events, EventMetaData.EventProducerConsumerType generator, String taskVertexName, String edgeVertexName, TezTaskAttemptID taskAttemptID) {
        if (events == null || events.isEmpty()) {
            return;
        }
        EventMetaData eventMetaData = new EventMetaData(generator, taskVertexName, edgeVertexName, taskAttemptID);
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event event : events) {
            TezEvent te = new TezEvent(event, eventMetaData);
            tezEvents.add(te);
        }
        if (LOG.isDebugEnabled()) {
            for (TezEvent tezEvent : tezEvents) {
                LOG.debug((Object)("Generated event info, eventMetaData=" + eventMetaData.toString() + ", eventType=" + (Object)((Object)tezEvent.getEventType())));
            }
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    private boolean handleEvent(TezEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling TezEvent in task, taskAttemptId=" + this.taskSpec.getTaskAttemptID() + ", eventType=" + (Object)((Object)e.getEventType()) + ", eventSourceInfo=" + e.getSourceInfo() + ", eventDestinationInfo=" + e.getDestinationInfo()));
        }
        try {
            switch (e.getDestinationInfo().getEventGenerator()) {
                case INPUT: {
                    LogicalInput input = this.inputsMap.get(e.getDestinationInfo().getEdgeVertexName());
                    if (input != null) {
                        input.handleEvents(Collections.singletonList(e.getEvent()));
                        break;
                    }
                    throw new TezUncheckedException("Unhandled event for invalid target: " + e);
                }
                case OUTPUT: {
                    LogicalOutput output = this.outputsMap.get(e.getDestinationInfo().getEdgeVertexName());
                    if (output != null) {
                        output.handleEvents(Collections.singletonList(e.getEvent()));
                        break;
                    }
                    throw new TezUncheckedException("Unhandled event for invalid target: " + e);
                }
                case PROCESSOR: {
                    this.processor.handleEvents(Collections.singletonList(e.getEvent()));
                    break;
                }
                case SYSTEM: {
                    LOG.warn((Object)("Trying to send a System event in a Task: " + e));
                }
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)"Failed to handle event", t);
            this.setFatalError(t, "Failed to handle event");
            EventMetaData sourceInfo = new EventMetaData(e.getDestinationInfo().getEventGenerator(), this.taskSpec.getVertexName(), e.getDestinationInfo().getEdgeVertexName(), this.getTaskAttemptID());
            this.tezUmbilical.signalFatalError(this.getTaskAttemptID(), StringUtils.stringifyException((Throwable)t), sourceInfo);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void handleEvents(Collection<TezEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        this.eventCounter.addAndGet(events.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received events to be processed by task, taskAttemptId=" + this.taskSpec.getTaskAttemptID() + ", eventCount=" + events.size() + ", newEventCounter=" + this.eventCounter.get()));
        }
        this.eventsToBeProcessed.addAll(events);
    }

    private void startRouterThread() {
        this.eventRouterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!LogicalIOProcessorRuntimeTask.this.isTaskDone() && !Thread.currentThread().isInterrupted()) {
                    try {
                        TezEvent e = (TezEvent)LogicalIOProcessorRuntimeTask.this.eventsToBeProcessed.take();
                        if (e == null || LogicalIOProcessorRuntimeTask.this.handleEvent(e)) continue;
                        LOG.warn((Object)("Stopping Event Router thread as failed to handle event: " + e));
                        return;
                    }
                    catch (InterruptedException e) {
                        if (!LogicalIOProcessorRuntimeTask.this.isTaskDone()) {
                            LOG.warn((Object)"Event Router thread interrupted. Returning.");
                        }
                        return;
                    }
                }
            }
        });
        this.eventRouterThread.setName("TezTaskEventRouter[" + this.taskSpec.getTaskAttemptID().toString() + "]");
        this.eventRouterThread.start();
    }

    public synchronized void cleanup() {
        LOG.info((Object)("Final Counters : " + this.tezCounters.toShortString()));
        this.setTaskDone();
        if (this.eventRouterThread != null) {
            this.eventRouterThread.interrupt();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public Collection<TezInputContext> getInputContexts() {
        return this.inputContextMap.values();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public Collection<TezOutputContext> getOutputContexts() {
        return this.outputContextMap.values();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public TezProcessorContext getProcessorContext() {
        return this.processorContext;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public LogicalIOProcessor getProcessor() {
        return this.processor;
    }

    private class InitializeOutputCallable
    implements Callable<Void> {
        private final OutputSpec outputSpec;
        private final int outputIndex;

        public InitializeOutputCallable(OutputSpec outputSpec, int outputIndex) {
            this.outputSpec = outputSpec;
            this.outputIndex = outputIndex;
        }

        @Override
        public Void call() throws Exception {
            LOG.info((Object)("Initializing Output using OutputSpec: " + this.outputSpec));
            String edgeName = this.outputSpec.getDestinationVertexName();
            LogicalOutput output = LogicalIOProcessorRuntimeTask.this.createOutput(this.outputSpec);
            TezOutputContext outputContext = LogicalIOProcessorRuntimeTask.this.createOutputContext(this.outputSpec, this.outputIndex);
            LogicalIOProcessorRuntimeTask.this.outputsMap.put(edgeName, output);
            LogicalIOProcessorRuntimeTask.this.outputContextMap.put(edgeName, outputContext);
            if (output instanceof LogicalOutput) {
                output.setNumPhysicalOutputs(this.outputSpec.getPhysicalEdgeCount());
            }
            LOG.info((Object)("Initializing Output with dest edge: " + edgeName));
            List events = output.initialize(outputContext);
            LogicalIOProcessorRuntimeTask.this.sendTaskGeneratedEvents(events, EventMetaData.EventProducerConsumerType.OUTPUT, outputContext.getTaskVertexName(), outputContext.getDestinationVertexName(), LogicalIOProcessorRuntimeTask.this.taskSpec.getTaskAttemptID());
            LOG.info((Object)("Initialized Output with dest edge: " + edgeName));
            return null;
        }
    }

    private class StartInputCallable
    implements Callable<Void> {
        private final LogicalInput input;
        private final String srcVertexName;

        public StartInputCallable(LogicalInput input, String srcVertexName) {
            this.input = input;
            this.srcVertexName = srcVertexName;
        }

        @Override
        public Void call() throws Exception {
            LOG.info((Object)("Starting Input with src edge: " + this.srcVertexName));
            this.input.start();
            LOG.info((Object)("Started Input with src edge: " + this.srcVertexName));
            return null;
        }
    }

    private class InitializeInputCallable
    implements Callable<Void> {
        private final InputSpec inputSpec;
        private final int inputIndex;

        public InitializeInputCallable(InputSpec inputSpec, int inputIndex) {
            this.inputSpec = inputSpec;
            this.inputIndex = inputIndex;
        }

        @Override
        public Void call() throws Exception {
            LOG.info((Object)("Initializing Input using InputSpec: " + this.inputSpec));
            String edgeName = this.inputSpec.getSourceVertexName();
            LogicalInput input = LogicalIOProcessorRuntimeTask.this.createInput(this.inputSpec);
            TezInputContext inputContext = LogicalIOProcessorRuntimeTask.this.createInputContext((Input)input, this.inputSpec, this.inputIndex);
            LogicalIOProcessorRuntimeTask.this.inputsMap.put(edgeName, input);
            LogicalIOProcessorRuntimeTask.this.inputContextMap.put(edgeName, inputContext);
            if (input instanceof LogicalInput) {
                input.setNumPhysicalInputs(this.inputSpec.getPhysicalEdgeCount());
            }
            LOG.info((Object)("Initializing Input with src edge: " + edgeName));
            List events = input.initialize(inputContext);
            LogicalIOProcessorRuntimeTask.this.sendTaskGeneratedEvents(events, EventMetaData.EventProducerConsumerType.INPUT, inputContext.getTaskVertexName(), inputContext.getSourceVertexName(), LogicalIOProcessorRuntimeTask.this.taskSpec.getTaskAttemptID());
            LOG.info((Object)("Initialized Input with src edge: " + edgeName));
            return null;
        }
    }
}

