/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;

public class ProtoConverters {
    public static EventProtos.DataMovementEventProto convertDataMovementEventToProto(DataMovementEvent event) {
        EventProtos.DataMovementEventProto.Builder builder = EventProtos.DataMovementEventProto.newBuilder();
        builder.setSourceIndex(event.getSourceIndex()).setTargetIndex(event.getTargetIndex()).setVersion(event.getVersion());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((byte[])event.getUserPayload()));
        }
        return builder.build();
    }

    public static DataMovementEvent convertDataMovementEventFromProto(EventProtos.DataMovementEventProto proto) {
        return new DataMovementEvent(proto.getSourceIndex(), proto.getTargetIndex(), proto.getVersion(), proto.getUserPayload() != null ? proto.getUserPayload().toByteArray() : null);
    }

    public static EventProtos.CompositeEventProto convertCompositeDataMovementEventToProto(CompositeDataMovementEvent event) {
        EventProtos.CompositeEventProto.Builder builder = EventProtos.CompositeEventProto.newBuilder();
        builder.setStartIndex(event.getSourceIndexStart());
        builder.setEndIndex(event.getSourceIndexEnd());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((byte[])event.getUserPayload()));
        }
        return builder.build();
    }

    public static CompositeDataMovementEvent convertCompositeDataMovementEventFromProto(EventProtos.CompositeEventProto proto) {
        return new CompositeDataMovementEvent(proto.getStartIndex(), proto.getEndIndex(), proto.hasUserPayload() ? proto.getUserPayload().toByteArray() : null);
    }

    public static EventProtos.RootInputDataInformationEventProto convertRootInputDataInformationEventToProto(RootInputDataInformationEvent event) {
        EventProtos.RootInputDataInformationEventProto.Builder builder = EventProtos.RootInputDataInformationEventProto.newBuilder();
        builder.setSourceIndex(event.getSourceIndex());
        builder.setTargetIndex(event.getTargetIndex());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((byte[])event.getUserPayload()));
        }
        return builder.build();
    }

    public static RootInputDataInformationEvent convertRootInputDataInformationEventFromProto(EventProtos.RootInputDataInformationEventProto proto) {
        RootInputDataInformationEvent diEvent = new RootInputDataInformationEvent(proto.getSourceIndex(), proto.getUserPayload() != null ? proto.getUserPayload().toByteArray() : null);
        diEvent.setTargetIndex(proto.getTargetIndex());
        return diEvent;
    }
}

