/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.junit.Assert;
import org.junit.Test;

public class TestDeprecatedKeys {
    @Test
    public void verifyReduceKeyTranslation() {
        JobConf jobConf = new JobConf();
        jobConf.setFloat("mapreduce.reduce.shuffle.input.buffer.percent", 0.4f);
        jobConf.setLong("mapreduce.reduce.memory.totalbytes", 20000L);
        jobConf.setInt("mapreduce.task.io.sort.factor", 2000);
        jobConf.setFloat("mapreduce.reduce.shuffle.memory.limit.percent", 0.55f);
        jobConf.setFloat("mapreduce.reduce.merge.memtomem.threshold", 0.6f);
        jobConf.setFloat("mapreduce.reduce.shuffle.merge.percent", 0.22f);
        jobConf.setBoolean("mapreduce.reduce.merge.memtomem.enabled", true);
        jobConf.setFloat("mapreduce.reduce.input.buffer.percent", 0.33f);
        MRHelpers.translateMRConfToTez((Configuration)jobConf);
        Assert.assertEquals((float)0.4f, (float)jobConf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.01f);
        Assert.assertEquals((long)20000L, (long)jobConf.getLong("tez.runtime.task.memory", 0L));
        Assert.assertEquals((long)2000L, (long)jobConf.getInt("tez.runtime.io.sort.factor", 0));
        Assert.assertEquals((float)0.55f, (float)jobConf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.6f, (float)jobConf.getFloat("tez.runtime.shuffle.memory-to-memory.segments", 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.22f, (float)jobConf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.01f);
        Assert.assertEquals((Object)true, (Object)jobConf.getBoolean("tez.runtime.shuffle.memory-to-memory.enable", false));
        Assert.assertEquals((float)0.33f, (float)jobConf.getFloat("tez.runtime.task.input.post-merge.buffer.percent", 0.0f), (float)0.01f);
    }

    @Test
    public void verifyTezOverridenKeys() {
        JobConf jobConf = new JobConf();
        jobConf.setInt("mapreduce.task.io.sort.factor", 2000);
        jobConf.setInt("mapreduce.task.io.sort.mb", 100);
        jobConf.setInt("mapreduce.job.counters.max", 100);
        jobConf.setInt("tez.runtime.io.sort.factor", 1000);
        jobConf.setInt("tez.runtime.io.sort.mb", 200);
        jobConf.setBoolean("tez.runtime.ifile.readahead", true);
        jobConf.setInt("tez.runtime.ifile.readahead.bytes", 20);
        jobConf.setFloat("tez.runtime.sort.spill.percent", 0.2f);
        jobConf.setInt("tez.runtime.index.cache.memory.limit.bytes", 10);
        jobConf.setInt("tez.runtime.combine.min.spills", 20);
        jobConf.setInt("tez.runtime.task.memory", 10);
        jobConf.setInt("tez.runtime.shuffle.parallel.copies", 10);
        jobConf.setInt("tez.runtime.shuffle.fetch.failures.limit", 10);
        jobConf.setBoolean("tez.runtime.shuffle.notify.readerror", true);
        jobConf.setInt("tez.runtime.shuffle.connect.timeout", 10);
        jobConf.setInt("tez.runtime.shuffle.read.timeout", 10);
        jobConf.setBoolean("tez.runtime.shuffle.ssl.enable", true);
        jobConf.setFloat("tez.runtime.shuffle.fetch.buffer.percent", 10.0f);
        jobConf.setFloat("tez.runtime.shuffle.memory.limit.percent", 10.0f);
        jobConf.setFloat("tez.runtime.shuffle.merge.percent", 10.0f);
        jobConf.setInt("tez.runtime.shuffle.memory-to-memory.segments", 10);
        jobConf.setBoolean("tez.runtime.shuffle.memory-to-memory.enable", true);
        jobConf.setFloat("tez.runtime.task.input.post-merge.buffer.percent", 10.0f);
        jobConf.set("tez.runtime.internal.sorter.class", "DefaultSorter");
        jobConf.set("tez.runtime.group.comparator.class", "groupComparator");
        jobConf.set("tez.runtime.key.secondary.comparator.class", "SecondaryComparator");
        jobConf.setBoolean("mapreduce.map.output.compress", false);
        jobConf.setBoolean("tez.runtime.compress", true);
        MRHelpers.translateMRConfToTez((Configuration)jobConf);
        Assert.assertEquals((long)1000L, (long)jobConf.getInt("tez.runtime.io.sort.factor", 0));
        Assert.assertEquals((long)200L, (long)jobConf.getInt("tez.runtime.io.sort.mb", 100));
        Assert.assertEquals((Object)true, (Object)jobConf.getBoolean("tez.runtime.ifile.readahead", false));
        Assert.assertEquals((long)20L, (long)jobConf.getInt("tez.runtime.ifile.readahead.bytes", 0));
        Assert.assertEquals((long)10L, (long)jobConf.getInt("tez.runtime.index.cache.memory.limit.bytes", 0));
        Assert.assertEquals((long)20L, (long)jobConf.getInt("tez.runtime.combine.min.spills", 0));
        Assert.assertEquals((long)10L, (long)jobConf.getInt("tez.runtime.task.memory", 0));
        Assert.assertEquals((long)10L, (long)jobConf.getInt("tez.runtime.shuffle.parallel.copies", 0));
        Assert.assertEquals((long)10L, (long)jobConf.getInt("tez.runtime.shuffle.fetch.failures.limit", 0));
        Assert.assertEquals((Object)true, (Object)jobConf.getBoolean("tez.runtime.shuffle.notify.readerror", false));
        Assert.assertEquals((long)10L, (long)jobConf.getInt("tez.runtime.shuffle.connect.timeout", 0));
        Assert.assertEquals((long)10L, (long)jobConf.getInt("tez.runtime.shuffle.read.timeout", 0));
        Assert.assertEquals((Object)true, (Object)jobConf.getBoolean("tez.runtime.shuffle.ssl.enable", false));
        Assert.assertEquals((float)10.0f, (float)jobConf.getFloat("tez.runtime.shuffle.fetch.buffer.percent", 0.0f), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)jobConf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)jobConf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.0f);
        Assert.assertEquals((long)10L, (long)jobConf.getInt("tez.runtime.shuffle.memory-to-memory.segments", 0));
        Assert.assertEquals((Object)true, (Object)jobConf.getBoolean("tez.runtime.shuffle.memory-to-memory.enable", false));
        Assert.assertEquals((float)10.0f, (float)jobConf.getFloat("tez.runtime.task.input.post-merge.buffer.percent", 0.0f), (float)0.0f);
        Assert.assertEquals((Object)"DefaultSorter", (Object)jobConf.get("tez.runtime.internal.sorter.class", ""));
        Assert.assertEquals((Object)"groupComparator", (Object)jobConf.get("tez.runtime.group.comparator.class", ""));
        Assert.assertEquals((Object)"SecondaryComparator", (Object)jobConf.get("tez.runtime.key.secondary.comparator.class", ""));
        Assert.assertEquals((Object)"DefaultSorter", (Object)jobConf.get("tez.runtime.internal.sorter.class", ""));
        Assert.assertTrue((boolean)jobConf.getBoolean("tez.runtime.compress", false));
        Assert.assertNull((Object)jobConf.get("mapreduce.ifile.readahead"));
        Assert.assertNull((Object)jobConf.get("mapreduce.ifile.readahead.bytes"));
        Assert.assertNull((Object)jobConf.get("mapreduce.task.merge.progress.records"));
        Assert.assertNull((Object)jobConf.get("mapreduce.task.io.sort.factor"));
        Assert.assertNull((Object)jobConf.get("mapreduce.task.io.sort.mb"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.read.timeout"));
        Assert.assertNull((Object)jobConf.get("mapreduce.task.index.cache.limit.bytes"));
        Assert.assertNull((Object)jobConf.get("mapreduce.map.combine.minspills"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.memory.totalbytes"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.parallelcopies"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.maxfetchfailures"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.notify.readerror"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.connect.timeout"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.read.timeout"));
        Assert.assertNull((Object)jobConf.get("mapreduce.shuffle.ssl.enabled"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.input.buffer.percent"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.shuffle.memory.limit.percent"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.merge.memtomem.threshold"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.merge.memtomem.enabled"));
        Assert.assertNull((Object)jobConf.get("mapreduce.reduce.input.buffer.percent"));
        Assert.assertNull((Object)jobConf.get("mapreduce.job.output.group.comparator.class"));
        Assert.assertNull((Object)jobConf.get("mapreduce.job.output.group.comparator.class"));
        Assert.assertNull((Object)jobConf.get("map.sort.class"));
    }
}

