/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigTranslationMRToTez {
    @Test
    public void testComplexKeys() {
        JobConf confVertex1 = new JobConf();
        confVertex1.set("mapreduce.map.output.key.class", IntWritable.class.getName());
        confVertex1.unset("mapreduce.job.output.key.comparator.class");
        confVertex1.unset("mapreduce.job.output.group.comparator.class");
        MRHelpers.translateMRConfToTez((Configuration)confVertex1);
        Assert.assertEquals((Object)IntWritable.Comparator.class.getName(), (Object)ConfigUtils.getIntermediateOutputKeyComparator((Configuration)confVertex1).getClass().getName());
        Assert.assertEquals((Object)IntWritable.Comparator.class.getName(), (Object)ConfigUtils.getIntermediateInputKeyComparator((Configuration)confVertex1).getClass().getName());
    }

    @Test
    public void testMRToTezKeyTranslation() {
        JobConf confVertex1 = new JobConf();
        confVertex1.set("mapreduce.map.output.key.class", IntWritable.class.getName());
        confVertex1.set("mapreduce.map.output.value.class", LongWritable.class.getName());
        confVertex1.setBoolean("mapreduce.map.output.compress", true);
        MRHelpers.translateMRConfToTez((Configuration)confVertex1);
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputKeyClass((Configuration)confVertex1).getName());
        Assert.assertEquals((Object)LongWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputValueClass((Configuration)confVertex1).getName());
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputKeyClass((Configuration)confVertex1).getName());
        Assert.assertEquals((Object)LongWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputValueClass((Configuration)confVertex1).getName());
        Assert.assertTrue((boolean)ConfigUtils.shouldCompressIntermediateOutput((Configuration)confVertex1));
        Assert.assertTrue((boolean)ConfigUtils.isIntermediateInputCompressed((Configuration)confVertex1));
    }
}

