/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReaderTez;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DiskChecker;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.mapreduce.TezTestUtils;
import org.apache.tez.mapreduce.processor.map.MapProcessor;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;

public class MapUtils {
    private static final Log LOG = LogFactory.getLog(MapUtils.class);
    private static final FsPermission JOB_FILE_PERMISSION = FsPermission.createImmutable((short)420);

    public static void configureLocalDirs(Configuration conf, String localDir) throws IOException {
        String[] localSysDirs = new String[]{localDir};
        conf.setStrings("tez.runtime.framework.local.dirs", localSysDirs);
        conf.set("tez.mr.framework.task-local-resource.dir", localDir);
        LOG.info((Object)("tez.runtime.framework.local.dirs for child: " + conf.get("tez.runtime.framework.local.dirs")));
        LOG.info((Object)("tez.mr.framework.task-local-resource.dir for child: " + conf.get("tez.mr.framework.task-local-resource.dir")));
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        Path workDir = null;
        try {
            workDir = lDirAlloc.getLocalPathToRead("work", conf);
        }
        catch (DiskChecker.DiskErrorException e) {
            // empty catch block
        }
        if (workDir == null) {
            workDir = lDirAlloc.getLocalPathForWrite("work", conf);
            FileSystem lfs = FileSystem.getLocal((Configuration)conf).getRaw();
            boolean madeDir = false;
            try {
                madeDir = lfs.mkdirs(workDir);
            }
            catch (FileAlreadyExistsException e) {
                madeDir = true;
                workDir = lDirAlloc.getLocalPathToRead("work", conf);
            }
            if (!madeDir) {
                throw new IOException("Mkdirs failed to create " + workDir.toString());
            }
        }
        conf.set("tez.mr.framework.job.local.dir", workDir.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputSplit createInputSplit(FileSystem fs, Path workDir, JobConf job, Path file) throws IOException {
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        LOG.info((Object)("Generating data at path: " + file));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)job, (Path)file, LongWritable.class, Text.class);
        try {
            Random r = new Random(System.currentTimeMillis());
            LongWritable key = new LongWritable();
            Text value = new Text();
            for (int i = 10; i > 0; --i) {
                key.set((long)r.nextInt(1000));
                value.set(Integer.toString(i));
                writer.append((Writable)key, (Writable)value);
                LOG.info((Object)("<k, v> : <" + key.get() + ", " + value + ">"));
            }
        }
        finally {
            writer.close();
        }
        SequenceFileInputFormat format = new SequenceFileInputFormat();
        InputSplit[] splits = format.getSplits(job, 1);
        System.err.println("#split = " + splits.length + " ; " + "#locs = " + splits[0].getLocations().length + "; " + "loc = " + splits[0].getLocations()[0] + "; " + "off = " + splits[0].getLength() + "; " + "file = " + ((FileSplit)splits[0]).getPath());
        return splits[0];
    }

    private static void writeSplitFiles(FileSystem fs, JobConf conf, InputSplit split) throws IOException {
        Path jobSplitFile = new Path(conf.get("tez.mr.framework.task-local-resource.dir", "/tmp"), "job.split");
        LOG.info((Object)("Writing split to: " + jobSplitFile));
        FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)jobSplitFile, (FsPermission)new FsPermission(JOB_FILE_PERMISSION));
        long offset = out.getPos();
        Text.writeString((DataOutput)out, (String)split.getClass().getName());
        split.write((DataOutput)out);
        out.close();
        String[] locations = split.getLocations();
        JobSplit.SplitMetaInfo info = null;
        info = new JobSplit.SplitMetaInfo(locations, offset, split.getLength());
        Path jobSplitMetaInfoFile = new Path(conf.get("tez.mr.framework.task-local-resource.dir"), "job.splitmetainfo");
        FSDataOutputStream outMeta = FileSystem.create((FileSystem)fs, (Path)jobSplitMetaInfoFile, (FsPermission)new FsPermission(JOB_FILE_PERMISSION));
        outMeta.write(SplitMetaInfoReaderTez.META_SPLIT_FILE_HEADER);
        WritableUtils.writeVInt((DataOutput)outMeta, (int)1);
        WritableUtils.writeVInt((DataOutput)outMeta, (int)1);
        info.write((DataOutput)outMeta);
        outMeta.close();
    }

    public static void generateInputSplit(FileSystem fs, Path workDir, JobConf jobConf, Path mapInput) throws IOException {
        jobConf.setInputFormat(SequenceFileInputFormat.class);
        InputSplit split = MapUtils.createInputSplit(fs, workDir, jobConf, mapInput);
        MapUtils.writeSplitFiles(fs, jobConf, split);
    }

    public static LogicalIOProcessorRuntimeTask createLogicalTask(FileSystem fs, Path workDir, JobConf jobConf, int mapId, Path mapInput, TezUmbilical umbilical, String dagName, String vertexName, List<InputSpec> inputSpecs, List<OutputSpec> outputSpecs) throws Exception {
        jobConf.setInputFormat(SequenceFileInputFormat.class);
        ProcessorDescriptor mapProcessorDesc = (ProcessorDescriptor)ProcessorDescriptor.create((String)MapProcessor.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)jobConf));
        Token shuffleToken = new Token();
        TaskSpec taskSpec = new TaskSpec(TezTestUtils.getMockTaskAttemptId(0, 0, mapId, 0), dagName, vertexName, -1, mapProcessorDesc, inputSpecs, outputSpecs, null);
        HashMap<String, ByteBuffer> serviceConsumerMetadata = new HashMap<String, ByteBuffer>();
        serviceConsumerMetadata.put(ShuffleUtils.SHUFFLE_HANDLER_SERVICE_ID, ShuffleUtils.convertJobTokenToBytes((Token)shuffleToken));
        LogicalIOProcessorRuntimeTask task = new LogicalIOProcessorRuntimeTask(taskSpec, 0, (Configuration)jobConf, new String[]{workDir.toString()}, umbilical, serviceConsumerMetadata, (Multimap)HashMultimap.create(), null);
        return task;
    }
}

