/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.input.MultiMRInput;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMultiMRInput {
    private static final Log LOG = LogFactory.getLog(TestMultiMRInput.class);
    private static final JobConf defaultConf = new JobConf();
    private static final String testTmpDir;
    private static final Path TEST_ROOT_DIR;
    private static FileSystem localFs;

    @Before
    public void setup() throws IOException {
        LOG.info((Object)("Setup. Using test dir: " + TEST_ROOT_DIR));
        localFs.delete(TEST_ROOT_DIR, true);
        localFs.mkdirs(TEST_ROOT_DIR);
    }

    @Test(timeout=5000L)
    public void testSingleSplit() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testSingleSplit");
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        MRRuntimeProtos.MRInputUserPayloadProto.Builder builder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        builder.setGroupingEnabled(false);
        builder.setConfigurationBytes(TezUtils.createByteStringFromConf((Configuration)jobConf));
        byte[] payload = builder.build().toByteArray();
        InputContext inputContext = this.createTezInputContext(payload);
        MultiMRInput input = new MultiMRInput(inputContext, 1);
        input.initialize();
        ArrayList<InputDataInformationEvent> eventList = new ArrayList<InputDataInformationEvent>();
        String file1 = "file1";
        LinkedHashMap<LongWritable, Text> data1 = TestMultiMRInput.createInputData(localFs, workDir, jobConf, file1, 0L, 10L);
        SequenceFileInputFormat format = new SequenceFileInputFormat();
        InputSplit[] splits = format.getSplits(jobConf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        MRRuntimeProtos.MRSplitProto splitProto = MRInputHelpers.createSplitProto((InputSplit)splits[0]);
        InputDataInformationEvent event = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        eventList.clear();
        eventList.add(event);
        input.handleEvents(eventList);
        int readerCount = 0;
        for (KeyValueReader reader : input.getKeyValueReaders()) {
            ++readerCount;
            while (reader.next()) {
                if (data1.size() == 0) {
                    Assert.fail((String)"Found more records than expected");
                }
                Object key = reader.getCurrentKey();
                Object val = reader.getCurrentValue();
                Assert.assertEquals((Object)val, data1.remove(key));
            }
        }
        Assert.assertEquals((long)1L, (long)readerCount);
    }

    @Test(timeout=5000L)
    public void testMultipleSplits() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testMultipleSplits");
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        MRRuntimeProtos.MRInputUserPayloadProto.Builder builder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        builder.setGroupingEnabled(false);
        builder.setConfigurationBytes(TezUtils.createByteStringFromConf((Configuration)jobConf));
        byte[] payload = builder.build().toByteArray();
        InputContext inputContext = this.createTezInputContext(payload);
        MultiMRInput input = new MultiMRInput(inputContext, 2);
        input.initialize();
        ArrayList<InputDataInformationEvent> eventList = new ArrayList<InputDataInformationEvent>();
        LinkedHashMap<LongWritable, Text> data = new LinkedHashMap<LongWritable, Text>();
        String file1 = "file1";
        LinkedHashMap<LongWritable, Text> data1 = TestMultiMRInput.createInputData(localFs, workDir, jobConf, file1, 0L, 10L);
        String file2 = "file2";
        LinkedHashMap<LongWritable, Text> data2 = TestMultiMRInput.createInputData(localFs, workDir, jobConf, file2, 10L, 20L);
        data.putAll(data1);
        data.putAll(data2);
        SequenceFileInputFormat format = new SequenceFileInputFormat();
        InputSplit[] splits = format.getSplits(jobConf, 2);
        Assert.assertEquals((long)2L, (long)splits.length);
        MRRuntimeProtos.MRSplitProto splitProto1 = MRInputHelpers.createSplitProto((InputSplit)splits[0]);
        InputDataInformationEvent event1 = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto1.toByteString().asReadOnlyByteBuffer());
        MRRuntimeProtos.MRSplitProto splitProto2 = MRInputHelpers.createSplitProto((InputSplit)splits[1]);
        InputDataInformationEvent event2 = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto2.toByteString().asReadOnlyByteBuffer());
        eventList.clear();
        eventList.add(event1);
        eventList.add(event2);
        input.handleEvents(eventList);
        int readerCount = 0;
        for (KeyValueReader reader : input.getKeyValueReaders()) {
            ++readerCount;
            while (reader.next()) {
                if (data.size() == 0) {
                    Assert.fail((String)"Found more records than expected");
                }
                Object key = reader.getCurrentKey();
                Object val = reader.getCurrentValue();
                Assert.assertEquals((Object)val, data.remove(key));
            }
        }
        Assert.assertEquals((long)2L, (long)readerCount);
    }

    @Test(timeout=5000L)
    public void testExtraEvents() throws Exception {
        Path workDir = new Path(TEST_ROOT_DIR, "testExtraEvents");
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        jobConf.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{workDir});
        MRRuntimeProtos.MRInputUserPayloadProto.Builder builder = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        builder.setGroupingEnabled(false);
        builder.setConfigurationBytes(TezUtils.createByteStringFromConf((Configuration)jobConf));
        byte[] payload = builder.build().toByteArray();
        InputContext inputContext = this.createTezInputContext(payload);
        MultiMRInput input = new MultiMRInput(inputContext, 1);
        input.initialize();
        ArrayList<InputDataInformationEvent> eventList = new ArrayList<InputDataInformationEvent>();
        String file1 = "file1";
        TestMultiMRInput.createInputData(localFs, workDir, jobConf, file1, 0L, 10L);
        SequenceFileInputFormat format = new SequenceFileInputFormat();
        InputSplit[] splits = format.getSplits(jobConf, 1);
        Assert.assertEquals((long)1L, (long)splits.length);
        MRRuntimeProtos.MRSplitProto splitProto = MRInputHelpers.createSplitProto((InputSplit)splits[0]);
        InputDataInformationEvent event1 = InputDataInformationEvent.createWithSerializedPayload((int)0, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        InputDataInformationEvent event2 = InputDataInformationEvent.createWithSerializedPayload((int)1, (ByteBuffer)splitProto.toByteString().asReadOnlyByteBuffer());
        eventList.clear();
        eventList.add(event1);
        eventList.add(event2);
        try {
            input.handleEvents(eventList);
            Assert.fail((String)"Expecting Exception due to too many events");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unexpected event. All physical sources already initialized"));
        }
    }

    private InputContext createTezInputContext(byte[] payload) {
        ApplicationId applicationId = ApplicationId.newInstance((long)10000L, (int)1);
        TezCounters counters = new TezCounters();
        InputContext inputContext = (InputContext)Mockito.mock(InputContext.class);
        ((InputContext)Mockito.doReturn((Object)applicationId).when((Object)inputContext)).getApplicationId();
        ((InputContext)Mockito.doReturn((Object)counters).when((Object)inputContext)).getCounters();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getDAGAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)"dagName").when((Object)inputContext)).getDAGName();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getInputIndex();
        ((InputContext)Mockito.doReturn((Object)"srcVertexName").when((Object)inputContext)).getSourceVertexName();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskAttemptNumber();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskIndex();
        ((InputContext)Mockito.doReturn((Object)1).when((Object)inputContext)).getTaskVertexIndex();
        ((InputContext)Mockito.doReturn((Object)"taskVertexName").when((Object)inputContext)).getTaskVertexName();
        ((InputContext)Mockito.doReturn((Object)UserPayload.create((ByteBuffer)ByteBuffer.wrap(payload))).when((Object)inputContext)).getUserPayload();
        return inputContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashMap<LongWritable, Text> createInputData(FileSystem fs, Path workDir, JobConf job, String filename, long startKey, long numKeys) throws IOException {
        LinkedHashMap<LongWritable, Text> data = new LinkedHashMap<LongWritable, Text>();
        Path file = new Path(workDir, filename);
        LOG.info((Object)("Generating data at path: " + file));
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)job, (Path)file, LongWritable.class, Text.class);
        try {
            Random r = new Random(System.currentTimeMillis());
            LongWritable key = new LongWritable();
            Text value = new Text();
            for (long i = startKey; i < numKeys; ++i) {
                key.set(i);
                value.set(Integer.toString(r.nextInt(10000)));
                data.put(new LongWritable(key.get()), new Text(value.toString()));
                writer.append((Writable)key, (Writable)value);
                LOG.info((Object)("<k, v> : <" + key.get() + ", " + value + ">"));
            }
        }
        finally {
            writer.close();
        }
        return data;
    }

    static {
        defaultConf.set("fs.defaultFS", "file:///");
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            testTmpDir = System.getProperty("test.build.data", "/tmp");
            TEST_ROOT_DIR = new Path(testTmpDir, TestMultiMRInput.class.getSimpleName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

