/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.localshuffle.LocalShuffle;
import org.apache.tez.runtime.library.input.OrderedGroupedInputLegacy;

public class LocalMergedInput
extends OrderedGroupedInputLegacy {
    public LocalMergedInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public List<Event> initialize() throws IOException {
        this.getContext().requestInitialMemory(0L, null);
        this.getContext().inputIsReady();
        this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        if (this.getNumPhysicalInputs() == 0) {
            return Collections.emptyList();
        }
        LocalShuffle localShuffle = new LocalShuffle(this.getContext(), this.conf, this.getNumPhysicalInputs());
        this.rawIter = localShuffle.run();
        this.createValuesIterator();
        return Collections.emptyList();
    }

    public void start() throws IOException {
    }

    public List<Event> close() throws IOException {
        if (this.getNumPhysicalInputs() != 0) {
            this.rawIter.close();
        }
        return Collections.emptyList();
    }
}

