/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.junit.Assert;
import org.junit.Test;

public class TestMRHelpers {
    private Configuration createConfForJavaOptsTest() {
        Configuration conf = new Configuration(false);
        conf.set("mapreduce.admin.map.child.java.opts", "fooMapAdminOpts");
        conf.set("mapreduce.map.java.opts", "fooMapJavaOpts");
        conf.set("mapreduce.map.log.level", "FATAL");
        conf.set("mapreduce.admin.reduce.child.java.opts", "fooReduceAdminOpts");
        conf.set("mapreduce.reduce.java.opts", "fooReduceJavaOpts");
        conf.set("mapreduce.reduce.log.level", "TRACE");
        return conf;
    }

    @Test
    public void testMapJavaOptions() {
        Configuration conf = this.createConfForJavaOptsTest();
        String opts = MRHelpers.getJavaOptsForMRMapper((Configuration)conf);
        Assert.assertTrue((boolean)opts.contains("fooMapAdminOpts"));
        Assert.assertTrue((boolean)opts.contains(" fooMapJavaOpts "));
        Assert.assertFalse((boolean)opts.contains("fooReduceAdminOpts "));
        Assert.assertFalse((boolean)opts.contains(" fooReduceJavaOpts "));
        Assert.assertTrue((opts.indexOf("fooMapAdminOpts") < opts.indexOf("fooMapJavaOpts") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)opts.contains(" -Dtez.root.logger=FATAL"));
        Assert.assertFalse((boolean)opts.contains(" -Dtez.root.logger=TRACE"));
    }

    @Test
    public void testReduceJavaOptions() {
        Configuration conf = this.createConfForJavaOptsTest();
        String opts = MRHelpers.getJavaOptsForMRReducer((Configuration)conf);
        Assert.assertFalse((boolean)opts.contains("fooMapAdminOpts"));
        Assert.assertFalse((boolean)opts.contains(" fooMapJavaOpts "));
        Assert.assertTrue((boolean)opts.contains("fooReduceAdminOpts"));
        Assert.assertTrue((boolean)opts.contains(" fooReduceJavaOpts "));
        Assert.assertTrue((opts.indexOf("fooReduceAdminOpts") < opts.indexOf("fooReduceJavaOpts") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)opts.contains(" -Dtez.root.logger=FATAL"));
        Assert.assertTrue((boolean)opts.contains(" -Dtez.root.logger=TRACE"));
    }

    @Test
    public void testContainerResourceConstruction() {
        JobConf conf = new JobConf(new Configuration());
        Resource mapResource = MRHelpers.getResourceForMRMapper((Configuration)conf);
        Resource reduceResource = MRHelpers.getResourceForMRReducer((Configuration)conf);
        Assert.assertEquals((long)1L, (long)mapResource.getVirtualCores());
        Assert.assertEquals((long)1024L, (long)mapResource.getMemory());
        Assert.assertEquals((long)1L, (long)reduceResource.getVirtualCores());
        Assert.assertEquals((long)1024L, (long)reduceResource.getMemory());
        conf.setInt("mapreduce.map.cpu.vcores", 2);
        conf.setInt("mapreduce.map.memory.mb", 123);
        conf.setInt("mapreduce.reduce.cpu.vcores", 20);
        conf.setInt("mapreduce.reduce.memory.mb", 1234);
        mapResource = MRHelpers.getResourceForMRMapper((Configuration)conf);
        reduceResource = MRHelpers.getResourceForMRReducer((Configuration)conf);
        Assert.assertEquals((long)2L, (long)mapResource.getVirtualCores());
        Assert.assertEquals((long)123L, (long)mapResource.getMemory());
        Assert.assertEquals((long)20L, (long)reduceResource.getVirtualCores());
        Assert.assertEquals((long)1234L, (long)reduceResource.getMemory());
    }

    private Configuration setupConfigForMREnvTest() {
        JobConf conf = new JobConf(new Configuration());
        conf.set("mapreduce.map.env", "foo=map1,bar=map2");
        conf.set("mapreduce.reduce.env", "foo=red1,bar=red2");
        conf.set("mapreduce.map.log.level", "TRACE");
        conf.set("mapreduce.reduce.log.level", "FATAL");
        String mapredAdminUserEnv = Shell.WINDOWS ? "PATH=%PATH%" + File.pathSeparator + "%TEZ_ADMIN_ENV%\\bin" : "LD_LIBRARY_PATH=$TEZ_ADMIN_ENV_TEST/lib/native";
        conf.set("mapreduce.admin.user.env", mapredAdminUserEnv);
        return conf;
    }

    private void testCommonEnvSettingsForMRTasks(Map<String, String> env) {
        Assert.assertTrue((boolean)env.containsKey("foo"));
        Assert.assertTrue((boolean)env.containsKey("bar"));
        Assert.assertTrue((boolean)env.containsKey(ApplicationConstants.Environment.LD_LIBRARY_PATH.name()));
        Assert.assertTrue((boolean)env.containsKey(ApplicationConstants.Environment.SHELL.name()));
        Assert.assertTrue((boolean)env.containsKey("HADOOP_ROOT_LOGGER"));
        if (!Shell.WINDOWS) {
            Assert.assertEquals((Object)"$PWD:$TEZ_ADMIN_ENV_TEST/lib/native", (Object)env.get(ApplicationConstants.Environment.LD_LIBRARY_PATH.name()));
        } else {
            Assert.assertTrue((boolean)env.get(ApplicationConstants.Environment.PATH.name()).contains(";%TEZ_ADMIN_ENV%\\bin"));
        }
    }

    @Test
    public void testMREnvSetupForMap() {
        Configuration conf = this.setupConfigForMREnvTest();
        HashMap<String, String> env = new HashMap<String, String>();
        MRHelpers.updateEnvBasedOnMRTaskEnv((Configuration)conf, env, (boolean)true);
        this.testCommonEnvSettingsForMRTasks(env);
        Assert.assertEquals((Object)"map1", env.get("foo"));
        Assert.assertEquals((Object)"map2", env.get("bar"));
    }

    @Test
    public void testMREnvSetupForReduce() {
        Configuration conf = this.setupConfigForMREnvTest();
        HashMap<String, String> env = new HashMap<String, String>();
        MRHelpers.updateEnvBasedOnMRTaskEnv((Configuration)conf, env, (boolean)false);
        this.testCommonEnvSettingsForMRTasks(env);
        Assert.assertEquals((Object)"red1", env.get("foo"));
        Assert.assertEquals((Object)"red2", env.get("bar"));
    }

    @Test
    public void testMRAMJavaOpts() {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.admin-command-opts", " -Dadminfoobar   ");
        conf.set("yarn.app.mapreduce.am.command-opts", "  -Duserfoo  ");
        String opts = MRHelpers.getJavaOptsForMRAM((Configuration)conf);
        Assert.assertEquals((Object)"-Dadminfoobar -Duserfoo", (Object)opts);
    }

    @Test
    public void testMRAMEnvironmentSetup() {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.admin.user.env", "foo=bar,admin1=foo1");
        conf.set("yarn.app.mapreduce.am.env", "foo=bar2,user=foo2");
        HashMap env = new HashMap();
        MRHelpers.updateEnvBasedOnMRAMEnv((Configuration)conf, env);
        Assert.assertEquals((Object)"foo1", env.get("admin1"));
        Assert.assertEquals((Object)"foo2", env.get("user"));
        Assert.assertEquals((Object)("bar" + File.pathSeparator + "bar2"), env.get("foo"));
    }
}

