/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.processor.map;

import java.io.DataInput;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.mapreduce.TestUmbilical;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfToTezTranslator;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfigUtil;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.mapreduce.processor.MapUtils;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.TezInputContext;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.task.local.output.TezLocalTaskOutputFiles;
import org.apache.tez.runtime.library.common.task.local.output.TezTaskOutput;
import org.apache.tez.runtime.library.output.LocalOnFileSorterOutput;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMapProcessor {
    private static final Log LOG = LogFactory.getLog(TestMapProcessor.class);
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir = null;

    public void setUpJobConf(JobConf job) {
        job.set("tez.runtime.local.dirs", workDir.toString());
        job.set("mapreduce.cluster.local.dir", workDir.toString());
        job.setClass("tez.runtime.task.local.output.manager", TezLocalTaskOutputFiles.class, TezTaskOutput.class);
        job.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        job.setNumReduceTasks(1);
    }

    @Before
    @After
    public void cleanup() throws Exception {
        localFs.delete(workDir, true);
    }

    @Test
    public void testMapProcessor() throws Exception {
        String dagName = "mrdag0";
        String vertexName = MultiStageMRConfigUtil.getInitialMapVertexName();
        JobConf jobConf = new JobConf((Configuration)defaultConf);
        this.setUpJobConf(jobConf);
        Configuration conf = MultiStageMRConfToTezTranslator.convertMRToLinearTez((Configuration)jobConf);
        conf.setInt("mapreduce.job.application.attempt.id", 0);
        Configuration stageConf = MultiStageMRConfigUtil.getConfForVertex((Configuration)conf, (String)vertexName);
        JobConf job = new JobConf(stageConf);
        job.setBoolean("mapreduce.tez.splits.via.events", false);
        job.set("tez.runtime.task-local-resource.dir", new Path(workDir, "localized-resources").toUri().toString());
        Path mapInput = new Path(workDir, "map0");
        MapUtils.generateInputSplit(localFs, workDir, job, mapInput);
        InputSpec mapInputSpec = new InputSpec("NullSrcVertex", new InputDescriptor(MRInputLegacy.class.getName()).setUserPayload(MRHelpers.createMRInputPayload((Configuration)job, null)), 0);
        OutputSpec mapOutputSpec = new OutputSpec("NullDestVertex", new OutputDescriptor(LocalOnFileSorterOutput.class.getName()), 1);
        LogicalIOProcessorRuntimeTask task = MapUtils.createLogicalTask(localFs, workDir, job, 0, new Path(workDir, "map0"), new TestUmbilical(), dagName, vertexName, Collections.singletonList(mapInputSpec), Collections.singletonList(mapOutputSpec));
        task.initialize();
        task.run();
        task.close();
        TezInputContext inputContext = (TezInputContext)task.getInputContexts().iterator().next();
        TezLocalTaskOutputFiles mapOutputs = new TezLocalTaskOutputFiles((Configuration)jobConf, inputContext.getUniqueIdentifier());
        Path mapOutputFile = mapOutputs.getInputFile(new InputAttemptIdentifier(0, 0));
        LOG.info((Object)("mapOutputFile = " + mapOutputFile));
        IFile.Reader reader = new IFile.Reader(localFs, mapOutputFile, null, null, null, false, 0, -1);
        LongWritable key = new LongWritable();
        Text value = new Text();
        DataInputBuffer keyBuf = new DataInputBuffer();
        DataInputBuffer valueBuf = new DataInputBuffer();
        long prev = Long.MIN_VALUE;
        while (reader.nextRawKey(keyBuf)) {
            reader.nextRawValue(valueBuf);
            key.readFields((DataInput)keyBuf);
            value.readFields((DataInput)valueBuf);
            if (prev != Long.MIN_VALUE) {
                assert (prev <= key.get());
                prev = key.get();
            }
            LOG.info((Object)("key = " + key.get() + "; value = " + value));
        }
        reader.close();
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestMapProcessor").makeQualified(localFs);
            LOG.info((Object)("Using workDir: " + workDir));
            MapUtils.configureLocalDirs((Configuration)defaultConf, workDir.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }
}

