/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.mapreduce.hadoop.InputSplitInfo;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMRHelpers {
    protected static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static Path testFilePath;
    private static Path oldSplitsDir;
    private static Path newSplitsDir;
    private static String TEST_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        YarnConfiguration testConf = new YarnConfiguration(dfsCluster.getFileSystem().getConf());
        File testConfFile = new File(TEST_ROOT_DIR, "test.xml");
        try {
            testConfFile.createNewFile();
            testConf.writeXml((OutputStream)new FileOutputStream(testConfFile));
            testConfFile.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        remoteFs.mkdirs(new Path("/tmp/input/"));
        remoteFs.mkdirs(new Path("/tmp/splitsDirNew/"));
        remoteFs.mkdirs(new Path("/tmp/splitsDirOld/"));
        testFilePath = remoteFs.makeQualified(new Path("/tmp/input/test.xml"));
        remoteFs.copyFromLocalFile(new Path(testConfFile.getAbsolutePath()), testFilePath);
        FileStatus fsStatus = remoteFs.getFileStatus(testFilePath);
        Assert.assertTrue((fsStatus.getLen() > 0L ? 1 : 0) != 0);
        oldSplitsDir = remoteFs.makeQualified(new Path("/tmp/splitsDirOld/"));
        newSplitsDir = remoteFs.makeQualified(new Path("/tmp/splitsDirNew/"));
    }

    private void verifyLocationHints(Path inputSplitsDir, List<VertexLocationHint.TaskLocationHint> actual) throws Exception {
        JobID jobId = new JobID("dummy", 1);
        JobSplit.TaskSplitMetaInfo[] splitsInfo = SplitMetaInfoReader.readSplitMetaInfo((JobID)jobId, (FileSystem)remoteFs, (Configuration)conf, (Path)inputSplitsDir);
        int splitsCount = splitsInfo.length;
        ArrayList<VertexLocationHint.TaskLocationHint> locationHints = new ArrayList<VertexLocationHint.TaskLocationHint>(splitsCount);
        for (int i = 0; i < splitsCount; ++i) {
            locationHints.add(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList(splitsInfo[i].getLocations())), null));
        }
        Assert.assertEquals(locationHints, actual);
    }

    private InputSplitInfo generateNewSplits(Path inputSplitsDir) throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.setUseNewMapper(true);
        jobConf.setClass("mapreduce.job.inputformat.class", org.apache.hadoop.mapreduce.lib.input.TextInputFormat.class, InputFormat.class);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", testFilePath.toString());
        return MRHelpers.generateInputSplits((Configuration)jobConf, (Path)inputSplitsDir);
    }

    @Test
    public void testNewSplitsGen() throws Exception {
        InputSplitInfo info = this.generateNewSplits(newSplitsDir);
        Assert.assertEquals((Object)new Path(newSplitsDir, "job.split"), (Object)info.getSplitsFile());
        Assert.assertEquals((Object)new Path(newSplitsDir, "job.splitmetainfo"), (Object)info.getSplitsMetaInfoFile());
        RemoteIterator files = remoteFs.listFiles(newSplitsDir, false);
        boolean foundSplitsFile = false;
        boolean foundMetaFile = false;
        int totalFilesFound = 0;
        while (files.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)files.next();
            String fName = status.getPath().getName();
            ++totalFilesFound;
            if (fName.equals("job.split")) {
                foundSplitsFile = true;
            } else if (fName.equals("job.splitmetainfo")) {
                foundMetaFile = true;
            } else {
                Assert.fail((String)("Found invalid file in splits dir, filename=" + fName));
            }
            Assert.assertTrue((status.getLen() > 0L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)totalFilesFound);
        Assert.assertTrue((boolean)foundSplitsFile);
        Assert.assertTrue((boolean)foundMetaFile);
        this.verifyLocationHints(newSplitsDir, info.getTaskLocationHints());
    }

    private InputSplitInfo generateOldSplits(Path inputSplitsDir) throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.setUseNewMapper(false);
        jobConf.setInputFormat(TextInputFormat.class);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", testFilePath.toString());
        return MRHelpers.generateInputSplits((Configuration)jobConf, (Path)inputSplitsDir);
    }

    @Test
    public void testOldSplitsGen() throws Exception {
        InputSplitInfo info = this.generateOldSplits(oldSplitsDir);
        Assert.assertEquals((Object)new Path(oldSplitsDir, "job.split"), (Object)info.getSplitsFile());
        Assert.assertEquals((Object)new Path(oldSplitsDir, "job.splitmetainfo"), (Object)info.getSplitsMetaInfoFile());
        RemoteIterator files = remoteFs.listFiles(oldSplitsDir, false);
        boolean foundSplitsFile = false;
        boolean foundMetaFile = false;
        int totalFilesFound = 0;
        while (files.hasNext()) {
            LocatedFileStatus status = (LocatedFileStatus)files.next();
            String fName = status.getPath().getName();
            ++totalFilesFound;
            if (fName.equals("job.split")) {
                foundSplitsFile = true;
            } else if (fName.equals("job.splitmetainfo")) {
                foundMetaFile = true;
            } else {
                Assert.fail((String)("Found invalid file in splits dir, filename=" + fName));
            }
            Assert.assertTrue((status.getLen() > 0L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)totalFilesFound);
        Assert.assertTrue((boolean)foundSplitsFile);
        Assert.assertTrue((boolean)foundMetaFile);
        this.verifyLocationHints(oldSplitsDir, info.getTaskLocationHints());
    }

    @Test
    public void testInputSplitLocalResourceCreation() throws Exception {
        InputSplitInfo inputSplitInfo = this.generateOldSplits(oldSplitsDir);
        HashMap localResources = new HashMap();
        localResources.put("job.split", null);
        try {
            MRHelpers.updateLocalResourcesForInputSplits((FileSystem)remoteFs, (InputSplitInfo)inputSplitInfo, localResources);
            Assert.fail((String)"Expected failure for job.split override in local resources map");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        localResources.clear();
        MRHelpers.updateLocalResourcesForInputSplits((FileSystem)remoteFs, (InputSplitInfo)inputSplitInfo, localResources);
        Assert.assertEquals((long)2L, (long)localResources.size());
        Assert.assertTrue((boolean)localResources.containsKey("job.split"));
        Assert.assertTrue((boolean)localResources.containsKey("job.splitmetainfo"));
    }

    private Configuration createConfForJavaOptsTest() {
        Configuration conf = new Configuration(false);
        conf.set("mapreduce.admin.map.child.java.opts", "fooMapAdminOpts");
        conf.set("mapreduce.map.java.opts", "fooMapJavaOpts");
        conf.set("mapreduce.map.log.level", "FATAL");
        conf.set("mapreduce.admin.reduce.child.java.opts", "fooReduceAdminOpts");
        conf.set("mapreduce.reduce.java.opts", "fooReduceJavaOpts");
        conf.set("mapreduce.reduce.log.level", "TRACE");
        return conf;
    }

    @Test
    public void testMapJavaOptions() {
        Configuration conf = this.createConfForJavaOptsTest();
        String opts = MRHelpers.getMapJavaOpts((Configuration)conf);
        Assert.assertTrue((boolean)opts.contains("fooMapAdminOpts"));
        Assert.assertTrue((boolean)opts.contains(" fooMapJavaOpts "));
        Assert.assertFalse((boolean)opts.contains("fooReduceAdminOpts "));
        Assert.assertFalse((boolean)opts.contains(" fooReduceJavaOpts "));
        Assert.assertTrue((opts.indexOf("fooMapAdminOpts") < opts.indexOf("fooMapJavaOpts") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)opts.contains(" -Dtez.root.logger=FATAL"));
        Assert.assertFalse((boolean)opts.contains(" -Dtez.root.logger=TRACE"));
    }

    @Test
    public void testReduceJavaOptions() {
        Configuration conf = this.createConfForJavaOptsTest();
        String opts = MRHelpers.getReduceJavaOpts((Configuration)conf);
        Assert.assertFalse((boolean)opts.contains("fooMapAdminOpts"));
        Assert.assertFalse((boolean)opts.contains(" fooMapJavaOpts "));
        Assert.assertTrue((boolean)opts.contains("fooReduceAdminOpts"));
        Assert.assertTrue((boolean)opts.contains(" fooReduceJavaOpts "));
        Assert.assertTrue((opts.indexOf("fooReduceAdminOpts") < opts.indexOf("fooReduceJavaOpts") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)opts.contains(" -Dtez.root.logger=FATAL"));
        Assert.assertTrue((boolean)opts.contains(" -Dtez.root.logger=TRACE"));
    }

    @Test
    public void testContainerResourceConstruction() {
        JobConf conf = new JobConf(new Configuration());
        Resource mapResource = MRHelpers.getMapResource((Configuration)conf);
        Resource reduceResource = MRHelpers.getReduceResource((Configuration)conf);
        Assert.assertEquals((long)1L, (long)mapResource.getVirtualCores());
        Assert.assertEquals((long)1024L, (long)mapResource.getMemory());
        Assert.assertEquals((long)1L, (long)reduceResource.getVirtualCores());
        Assert.assertEquals((long)1024L, (long)reduceResource.getMemory());
        conf.setInt("mapreduce.map.cpu.vcores", 2);
        conf.setInt("mapreduce.map.memory.mb", 123);
        conf.setInt("mapreduce.reduce.cpu.vcores", 20);
        conf.setInt("mapreduce.reduce.memory.mb", 1234);
        mapResource = MRHelpers.getMapResource((Configuration)conf);
        reduceResource = MRHelpers.getReduceResource((Configuration)conf);
        Assert.assertEquals((long)2L, (long)mapResource.getVirtualCores());
        Assert.assertEquals((long)123L, (long)mapResource.getMemory());
        Assert.assertEquals((long)20L, (long)reduceResource.getVirtualCores());
        Assert.assertEquals((long)1234L, (long)reduceResource.getMemory());
    }

    private Configuration setupConfigForMREnvTest() {
        JobConf conf = new JobConf(new Configuration());
        conf.set("mapreduce.map.env", "foo=map1,bar=map2");
        conf.set("mapreduce.reduce.env", "foo=red1,bar=red2");
        conf.set("mapreduce.map.log.level", "TRACE");
        conf.set("mapreduce.reduce.log.level", "FATAL");
        return conf;
    }

    private void testCommonEnvSettingsForMRTasks(Map<String, String> env) {
        Assert.assertTrue((boolean)env.containsKey("foo"));
        Assert.assertTrue((boolean)env.containsKey("bar"));
        Assert.assertTrue((boolean)env.containsKey(ApplicationConstants.Environment.LD_LIBRARY_PATH.name()));
        Assert.assertTrue((boolean)env.containsKey(ApplicationConstants.Environment.SHELL.name()));
        Assert.assertTrue((boolean)env.containsKey("HADOOP_ROOT_LOGGER"));
    }

    @Test
    public void testMREnvSetupForMap() {
        Configuration conf = this.setupConfigForMREnvTest();
        HashMap<String, String> env = new HashMap<String, String>();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)conf, env, (boolean)true);
        this.testCommonEnvSettingsForMRTasks(env);
        Assert.assertEquals((Object)"map1", env.get("foo"));
        Assert.assertEquals((Object)"map2", env.get("bar"));
    }

    @Test
    public void testMREnvSetupForReduce() {
        Configuration conf = this.setupConfigForMREnvTest();
        HashMap<String, String> env = new HashMap<String, String>();
        MRHelpers.updateEnvironmentForMRTasks((Configuration)conf, env, (boolean)false);
        this.testCommonEnvSettingsForMRTasks(env);
        Assert.assertEquals((Object)"red1", env.get("foo"));
        Assert.assertEquals((Object)"red2", env.get("bar"));
    }

    @Test
    public void testGetBaseMRConf() {
        Configuration conf = MRHelpers.getBaseMRConfiguration();
        Assert.assertNotNull((Object)conf);
        conf = MRHelpers.getBaseMRConfiguration((Configuration)new YarnConfiguration());
        Assert.assertNotNull((Object)conf);
    }

    @Test
    public void testMRAMJavaOpts() {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.admin-command-opts", " -Dadminfoobar   ");
        conf.set("yarn.app.mapreduce.am.command-opts", "  -Duserfoo  ");
        String opts = MRHelpers.getMRAMJavaOpts((Configuration)conf);
        Assert.assertEquals((Object)"-Dadminfoobar -Duserfoo", (Object)opts);
    }

    public void testMRAMEnvironmentSetup() {
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.admin.user.env", "foo=bar,admin1=foo1");
        conf.set("yarn.app.mapreduce.am.env", "foo=bar2,user=foo2");
        HashMap env = new HashMap();
        MRHelpers.updateEnvironmentForMRAM((Configuration)conf, env);
        Assert.assertEquals((Object)"foo1", env.get("admin1"));
        Assert.assertEquals((Object)"foo2", env.get("user"));
        Assert.assertEquals((Object)"bar2", env.get("foo"));
    }

    static {
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestMRHelpers.class.getName() + "-tmpDir";
    }
}

