/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfToTezTranslator;
import org.junit.Assert;
import org.junit.Test;

public class TestDeprecatedKeys {
    @Test
    public void verifyReduceKeyTranslation() {
        JobConf jobConf = new JobConf();
        jobConf.setFloat("mapreduce.reduce.shuffle.input.buffer.percent", 0.4f);
        jobConf.setLong("mapreduce.reduce.memory.totalbytes", 20000L);
        jobConf.setInt("mapreduce.task.io.sort.factor", 2000);
        jobConf.setFloat("mapreduce.reduce.shuffle.memory.limit.percent", 0.55f);
        jobConf.setFloat("mapreduce.reduce.merge.memtomem.threshold", 0.6f);
        jobConf.setFloat("mapreduce.reduce.shuffle.merge.percent", 0.22f);
        jobConf.setBoolean("mapreduce.reduce.merge.memtomem.enabled", true);
        jobConf.setFloat("mapreduce.reduce.input.buffer.percent", 0.33f);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)jobConf, null);
        Assert.assertEquals((float)0.4f, (float)jobConf.getFloat("tez.runtime.shuffle.input.buffer.percent", 0.0f), (float)0.01f);
        Assert.assertEquals((long)20000L, (long)jobConf.getLong("tez.runtime.task.memory", 0L));
        Assert.assertEquals((long)2000L, (long)jobConf.getInt("tez.runtime.io.sort.factor", 0));
        Assert.assertEquals((float)0.55f, (float)jobConf.getFloat("tez.runtime.shuffle.memory.limit.percent", 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.6f, (float)jobConf.getFloat("tez.runtime.shuffle.memory-to-memory.segments", 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.22f, (float)jobConf.getFloat("tez.runtime.shuffle.merge.percent", 0.0f), (float)0.01f);
        Assert.assertEquals((Object)true, (Object)jobConf.getBoolean("tez.runtime.shuffle.memory-to-memory.enable", false));
        Assert.assertEquals((float)0.33f, (float)jobConf.getFloat("tez.runtime.task.input.buffer.percent", 0.0f), (float)0.01f);
    }
}

