/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfToTezTranslator;
import org.apache.tez.runtime.library.common.ConfigUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigTranslationMRToTez {
    @Test
    public void testComplexKeys() {
        JobConf confVertex1 = new JobConf();
        JobConf confVertex2 = new JobConf();
        confVertex1.set("mapreduce.map.output.key.class", IntWritable.class.getName());
        confVertex2.set("mapreduce.map.output.key.class", ByteWritable.class.getName());
        confVertex1.unset("mapreduce.job.output.key.comparator.class");
        confVertex1.unset("mapreduce.job.output.group.comparator.class");
        confVertex2.unset("mapreduce.job.output.key.comparator.class");
        confVertex2.unset("mapreduce.job.output.group.comparator.class");
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)confVertex1, null);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)confVertex2, (Configuration)confVertex1);
        Assert.assertEquals((Object)IntWritable.Comparator.class.getName(), (Object)ConfigUtils.getIntermediateOutputKeyComparator((Configuration)confVertex1).getClass().getName());
        Assert.assertEquals((Object)IntWritable.Comparator.class.getName(), (Object)ConfigUtils.getIntermediateInputKeyComparator((Configuration)confVertex2).getClass().getName());
    }

    @Test
    public void testMultiStageConversion() {
        JobConf confVertex1 = new JobConf();
        confVertex1.set("mapreduce.map.output.key.class", IntWritable.class.getName());
        confVertex1.set("mapreduce.map.output.value.class", IntWritable.class.getName());
        confVertex1.setBoolean("mapreduce.map.output.compress", true);
        JobConf confVertex2 = new JobConf();
        confVertex2.set("mapreduce.map.output.key.class", LongWritable.class.getName());
        confVertex2.set("mapreduce.map.output.value.class", LongWritable.class.getName());
        confVertex2.setBoolean("mapreduce.map.output.compress", false);
        JobConf confVertex3 = new JobConf();
        confVertex3.set("mapreduce.map.output.key.class", ByteWritable.class.getName());
        confVertex3.set("mapreduce.map.output.value.class", ByteWritable.class.getName());
        confVertex3.setBoolean("mapreduce.map.output.compress", true);
        JobConf confVertex4 = new JobConf();
        confVertex4.set("mapreduce.map.output.key.class", Text.class.getName());
        confVertex4.set("mapreduce.map.output.value.class", Text.class.getName());
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)confVertex1, null);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)confVertex2, (Configuration)confVertex1);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)confVertex3, (Configuration)confVertex2);
        MultiStageMRConfToTezTranslator.translateVertexConfToTez((Configuration)confVertex4, (Configuration)confVertex3);
        Assert.assertFalse((boolean)ConfigUtils.isIntermediateInputCompressed((Configuration)confVertex1));
        Assert.assertNull((Object)ConfigUtils.getIntermediateInputKeyClass((Configuration)confVertex1));
        Assert.assertNull((Object)ConfigUtils.getIntermediateInputValueClass((Configuration)confVertex1));
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputKeyClass((Configuration)confVertex1).getName());
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputValueClass((Configuration)confVertex1).getName());
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputKeyClass((Configuration)confVertex2).getName());
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputValueClass((Configuration)confVertex2).getName());
        Assert.assertTrue((boolean)ConfigUtils.shouldCompressIntermediateOutput((Configuration)confVertex1));
        Assert.assertTrue((boolean)ConfigUtils.isIntermediateInputCompressed((Configuration)confVertex2));
        Assert.assertEquals((Object)LongWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputKeyClass((Configuration)confVertex2).getName());
        Assert.assertEquals((Object)LongWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputValueClass((Configuration)confVertex2).getName());
        Assert.assertEquals((Object)LongWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputKeyClass((Configuration)confVertex3).getName());
        Assert.assertEquals((Object)LongWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputValueClass((Configuration)confVertex3).getName());
        Assert.assertFalse((boolean)ConfigUtils.shouldCompressIntermediateOutput((Configuration)confVertex2));
        Assert.assertFalse((boolean)ConfigUtils.isIntermediateInputCompressed((Configuration)confVertex3));
        Assert.assertEquals((Object)ByteWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputKeyClass((Configuration)confVertex3).getName());
        Assert.assertEquals((Object)ByteWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputValueClass((Configuration)confVertex3).getName());
        Assert.assertEquals((Object)ByteWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputKeyClass((Configuration)confVertex4).getName());
        Assert.assertEquals((Object)ByteWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputValueClass((Configuration)confVertex4).getName());
        Assert.assertTrue((boolean)ConfigUtils.shouldCompressIntermediateOutput((Configuration)confVertex3));
        Assert.assertTrue((boolean)ConfigUtils.isIntermediateInputCompressed((Configuration)confVertex4));
        Assert.assertFalse((boolean)ConfigUtils.shouldCompressIntermediateOutput((Configuration)confVertex4));
        Configuration edge1OutputConf = MultiStageMRConfToTezTranslator.getOutputConfOnEdge((Configuration)confVertex1, (Configuration)confVertex2);
        Configuration edge1InputConf = MultiStageMRConfToTezTranslator.getInputConfOnEdge((Configuration)confVertex1, (Configuration)confVertex2);
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputKeyClass((Configuration)edge1OutputConf).getName());
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateOutputValueClass((Configuration)edge1OutputConf).getName());
        Assert.assertTrue((boolean)ConfigUtils.shouldCompressIntermediateOutput((Configuration)edge1OutputConf));
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputKeyClass((Configuration)edge1InputConf).getName());
        Assert.assertEquals((Object)IntWritable.class.getName(), (Object)ConfigUtils.getIntermediateInputValueClass((Configuration)edge1InputConf).getName());
        Assert.assertTrue((boolean)ConfigUtils.isIntermediateInputCompressed((Configuration)edge1InputConf));
    }
}

