/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.common;

import com.google.protobuf.ByteString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.mapreduce.common.MRInputSplitDistributor;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.TezRootInputInitializerContext;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.events.RootInputUpdatePayloadEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestMRInputSplitDistributor {
    @Test
    public void testSerializedPayload() throws IOException {
        Configuration conf = new Configuration(false);
        conf.setBoolean("mapreduce.tez.input.initializer.serialize.event.payload", true);
        ByteString confByteString = MRHelpers.createByteStringFromConf((Configuration)conf);
        InputSplitForTest split1 = new InputSplitForTest(1);
        InputSplitForTest split2 = new InputSplitForTest(2);
        MRRuntimeProtos.MRSplitProto proto1 = MRHelpers.createSplitProto((InputSplit)split1);
        MRRuntimeProtos.MRSplitProto proto2 = MRHelpers.createSplitProto((InputSplit)split2);
        MRRuntimeProtos.MRSplitsProto.Builder splitsProtoBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
        splitsProtoBuilder.addSplits(proto1);
        splitsProtoBuilder.addSplits(proto2);
        MRRuntimeProtos.MRInputUserPayloadProto.Builder payloadProto = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        payloadProto.setSplits(splitsProtoBuilder.build());
        payloadProto.setConfigurationBytes(confByteString);
        byte[] userPayload = payloadProto.build().toByteArray();
        TezRootInputInitializerContextForTest context = new TezRootInputInitializerContextForTest(userPayload);
        MRInputSplitDistributor splitDist = new MRInputSplitDistributor();
        List events = splitDist.initialize((TezRootInputInitializerContext)context);
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertTrue((boolean)(events.get(0) instanceof RootInputUpdatePayloadEvent));
        Assert.assertTrue((boolean)(events.get(1) instanceof RootInputDataInformationEvent));
        Assert.assertTrue((boolean)(events.get(2) instanceof RootInputDataInformationEvent));
        RootInputDataInformationEvent diEvent1 = (RootInputDataInformationEvent)events.get(1);
        RootInputDataInformationEvent diEvent2 = (RootInputDataInformationEvent)events.get(2);
        Assert.assertNull((Object)diEvent1.getDeserializedUserPayload());
        Assert.assertNull((Object)diEvent2.getDeserializedUserPayload());
        Assert.assertNotNull((Object)diEvent1.getUserPayload());
        Assert.assertNotNull((Object)diEvent2.getUserPayload());
        MRRuntimeProtos.MRSplitProto event1Proto = MRRuntimeProtos.MRSplitProto.parseFrom((byte[])diEvent1.getUserPayload());
        InputSplit is1 = MRInput.getOldSplitDetailsFromEvent((MRRuntimeProtos.MRSplitProto)event1Proto, (Configuration)new Configuration());
        Assert.assertTrue((boolean)(is1 instanceof InputSplitForTest));
        Assert.assertEquals((long)1L, (long)((InputSplitForTest)is1).identifier);
        MRRuntimeProtos.MRSplitProto event2Proto = MRRuntimeProtos.MRSplitProto.parseFrom((byte[])diEvent2.getUserPayload());
        InputSplit is2 = MRInput.getOldSplitDetailsFromEvent((MRRuntimeProtos.MRSplitProto)event2Proto, (Configuration)new Configuration());
        Assert.assertTrue((boolean)(is2 instanceof InputSplitForTest));
        Assert.assertEquals((long)2L, (long)((InputSplitForTest)is2).identifier);
    }

    @Test
    public void testDeserializedPayload() throws IOException {
        Configuration conf = new Configuration(false);
        conf.setBoolean("mapreduce.tez.input.initializer.serialize.event.payload", false);
        ByteString confByteString = MRHelpers.createByteStringFromConf((Configuration)conf);
        InputSplitForTest split1 = new InputSplitForTest(1);
        InputSplitForTest split2 = new InputSplitForTest(2);
        MRRuntimeProtos.MRSplitProto proto1 = MRHelpers.createSplitProto((InputSplit)split1);
        MRRuntimeProtos.MRSplitProto proto2 = MRHelpers.createSplitProto((InputSplit)split2);
        MRRuntimeProtos.MRSplitsProto.Builder splitsProtoBuilder = MRRuntimeProtos.MRSplitsProto.newBuilder();
        splitsProtoBuilder.addSplits(proto1);
        splitsProtoBuilder.addSplits(proto2);
        MRRuntimeProtos.MRInputUserPayloadProto.Builder payloadProto = MRRuntimeProtos.MRInputUserPayloadProto.newBuilder();
        payloadProto.setSplits(splitsProtoBuilder.build());
        payloadProto.setConfigurationBytes(confByteString);
        byte[] userPayload = payloadProto.build().toByteArray();
        TezRootInputInitializerContextForTest context = new TezRootInputInitializerContextForTest(userPayload);
        MRInputSplitDistributor splitDist = new MRInputSplitDistributor();
        List events = splitDist.initialize((TezRootInputInitializerContext)context);
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertTrue((boolean)(events.get(0) instanceof RootInputUpdatePayloadEvent));
        Assert.assertTrue((boolean)(events.get(1) instanceof RootInputDataInformationEvent));
        Assert.assertTrue((boolean)(events.get(2) instanceof RootInputDataInformationEvent));
        RootInputDataInformationEvent diEvent1 = (RootInputDataInformationEvent)events.get(1);
        RootInputDataInformationEvent diEvent2 = (RootInputDataInformationEvent)events.get(2);
        Assert.assertNull((Object)diEvent1.getUserPayload());
        Assert.assertNull((Object)diEvent2.getUserPayload());
        Assert.assertNotNull((Object)diEvent1.getDeserializedUserPayload());
        Assert.assertNotNull((Object)diEvent2.getDeserializedUserPayload());
        Assert.assertTrue((boolean)(diEvent1.getDeserializedUserPayload() instanceof InputSplitForTest));
        Assert.assertEquals((long)1L, (long)((InputSplitForTest)diEvent1.getDeserializedUserPayload()).identifier);
        Assert.assertTrue((boolean)(diEvent2.getDeserializedUserPayload() instanceof InputSplitForTest));
        Assert.assertEquals((long)2L, (long)((InputSplitForTest)diEvent2.getDeserializedUserPayload()).identifier);
    }

    @InterfaceAudience.Private
    private static class InputSplitForTest
    implements InputSplit {
        private int identifier;

        public InputSplitForTest() {
        }

        public InputSplitForTest(int identifier) {
            this.identifier = identifier;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.identifier);
        }

        public void readFields(DataInput in) throws IOException {
            this.identifier = in.readInt();
        }

        public long getLength() throws IOException {
            return 1000L;
        }

        public String[] getLocations() throws IOException {
            return null;
        }
    }

    private static class TezRootInputInitializerContextForTest
    implements TezRootInputInitializerContext {
        private final ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)200);
        private final byte[] payload;

        TezRootInputInitializerContextForTest(byte[] payload) throws IOException {
            this.payload = payload;
        }

        public ApplicationId getApplicationId() {
            return this.appId;
        }

        public String getDAGName() {
            return "FakeDAG";
        }

        public String getInputName() {
            return "MRInput";
        }

        public byte[] getUserPayload() {
            return this.payload;
        }

        public int getNumTasks() {
            return 100;
        }

        public Resource getVertexTaskResource() {
            return Resource.newInstance((int)1024, (int)1);
        }

        public Resource getTotalAvailableResource() {
            return Resource.newInstance((int)10240, (int)10);
        }

        public int getNumClusterNodes() {
            return 10;
        }
    }
}

