/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.examples.terasort;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.mapreduce.examples.terasort.TeraGen;
import org.apache.tez.mapreduce.examples.terasort.TeraSort;
import org.apache.tez.mapreduce.examples.terasort.TeraValidate;
import org.junit.Ignore;

@Ignore
public class TestTeraSort
extends HadoopTestCase {
    private static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), "terasort").getAbsolutePath();
    private static final Path SORT_INPUT_PATH = new Path(TEST_DIR, "sortin");
    private static final Path SORT_OUTPUT_PATH = new Path(TEST_DIR, "sortout");
    private static final Path TERA_OUTPUT_PATH = new Path(TEST_DIR, "validate");
    private static final String NUM_ROWS = "100";

    public TestTeraSort() throws IOException {
        super(2, 8, 1, 1);
    }

    protected void tearDown() throws Exception {
        this.getFileSystem().delete(new Path(TEST_DIR), true);
        super.tearDown();
    }

    private void runTeraGen(Configuration conf, Path sortInput) throws Exception {
        String[] genArgs = new String[]{NUM_ROWS, sortInput.toString()};
        TestTeraSort.assertEquals((int)ToolRunner.run((Configuration)conf, (Tool)new TeraGen(), (String[])genArgs), (int)0);
    }

    private void runTeraSort(Configuration conf, Path sortInput, Path sortOutput) throws Exception {
        String[] sortArgs = new String[]{sortInput.toString(), sortOutput.toString()};
        TestTeraSort.assertEquals((int)ToolRunner.run((Configuration)conf, (Tool)new TeraSort(), (String[])sortArgs), (int)0);
    }

    private void runTeraValidator(Configuration job, Path sortOutput, Path valOutput) throws Exception {
        String[] svArgs = new String[]{sortOutput.toString(), valOutput.toString()};
        TestTeraSort.assertEquals((int)ToolRunner.run((Configuration)job, (Tool)new TeraValidate(), (String[])svArgs), (int)0);
    }

    public void testTeraSort() throws Exception {
        this.runTeraGen((Configuration)this.createJobConf(), SORT_INPUT_PATH);
        this.runTeraSort((Configuration)this.createJobConf(), SORT_INPUT_PATH, SORT_OUTPUT_PATH);
        this.runTeraValidator((Configuration)this.createJobConf(), SORT_OUTPUT_PATH, TERA_OUTPUT_PATH);
    }
}

