/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tez.dag.api.oldrecords.TaskReport;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.records.TezTaskID;

public class VertexStats {
    long firstTaskStartTime = -1L;
    Set<TezTaskID> firstTasksToStart = new HashSet<TezTaskID>();
    long lastTaskFinishTime = -1L;
    Set<TezTaskID> lastTasksToFinish = new HashSet<TezTaskID>();
    long minTaskDuration = -1L;
    long maxTaskDuration = -1L;
    double avgTaskDuration = -1.0;
    long numSuccessfulTasks = 0L;
    Set<TezTaskID> shortestDurationTasks = new HashSet<TezTaskID>();
    Set<TezTaskID> longestDurationTasks = new HashSet<TezTaskID>();

    public long getFirstTaskStartTime() {
        return this.firstTaskStartTime;
    }

    public Set<TezTaskID> getFirstTasksToStart() {
        return Collections.unmodifiableSet(this.firstTasksToStart);
    }

    public long getLastTaskFinishTime() {
        return this.lastTaskFinishTime;
    }

    public Set<TezTaskID> getLastTasksToFinish() {
        return Collections.unmodifiableSet(this.lastTasksToFinish);
    }

    public long getMinTaskDuration() {
        return this.minTaskDuration;
    }

    public long getMaxTaskDuration() {
        return this.maxTaskDuration;
    }

    public double getAvgTaskDuration() {
        return this.avgTaskDuration;
    }

    public Set<TezTaskID> getShortestDurationTasks() {
        return Collections.unmodifiableSet(this.shortestDurationTasks);
    }

    public Set<TezTaskID> getLongestDurationTasks() {
        return Collections.unmodifiableSet(this.longestDurationTasks);
    }

    void updateStats(TaskReport taskReport) {
        if (this.firstTaskStartTime == -1L || this.firstTaskStartTime >= taskReport.getStartTime()) {
            if (this.firstTaskStartTime != taskReport.getStartTime()) {
                this.firstTasksToStart.clear();
            }
            this.firstTasksToStart.add(taskReport.getTaskId());
            this.firstTaskStartTime = taskReport.getStartTime();
        }
        if (taskReport.getFinishTime() > 0L && (this.lastTaskFinishTime == -1L || this.lastTaskFinishTime <= taskReport.getFinishTime())) {
            if (this.lastTaskFinishTime != taskReport.getFinishTime()) {
                this.lastTasksToFinish.clear();
            }
            this.lastTasksToFinish.add(taskReport.getTaskId());
            this.lastTaskFinishTime = taskReport.getFinishTime();
        }
        if (!taskReport.getTaskState().equals((Object)TaskState.SUCCEEDED)) {
            return;
        }
        long taskDuration = taskReport.getFinishTime() - taskReport.getStartTime();
        if (taskDuration < 0L) {
            return;
        }
        ++this.numSuccessfulTasks;
        if (this.minTaskDuration == -1L || this.minTaskDuration >= taskDuration) {
            if (this.minTaskDuration != taskDuration) {
                this.shortestDurationTasks.clear();
            }
            this.minTaskDuration = taskDuration;
            this.shortestDurationTasks.add(taskReport.getTaskId());
        }
        if (this.maxTaskDuration == -1L || this.maxTaskDuration <= taskDuration) {
            if (this.maxTaskDuration != taskDuration) {
                this.longestDurationTasks.clear();
            }
            this.maxTaskDuration = taskDuration;
            this.longestDurationTasks.add(taskReport.getTaskId());
        }
        this.avgTaskDuration = (this.avgTaskDuration * (double)(this.numSuccessfulTasks - 1L) + (double)taskDuration) / (double)this.numSuccessfulTasks;
    }

    private void appendTaskIdSet(StringBuilder sb, Set<TezTaskID> taskIDs) {
        sb.append("[ ");
        boolean first = true;
        if (taskIDs != null) {
            for (TezTaskID tezTaskID : taskIDs) {
                if (!first) {
                    sb.append(",");
                } else {
                    first = false;
                }
                sb.append(tezTaskID.toString());
            }
        }
        sb.append(" ]");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("firstTaskStartTime=").append(this.firstTaskStartTime).append(", firstTasksToStart=");
        this.appendTaskIdSet(sb, this.firstTasksToStart);
        sb.append(", lastTaskFinishTime=").append(this.lastTaskFinishTime).append(", lastTasksToFinish=");
        this.appendTaskIdSet(sb, this.lastTasksToFinish);
        sb.append(", minTaskDuration=").append(this.minTaskDuration).append(", maxTaskDuration=").append(this.maxTaskDuration).append(", avgTaskDuration=").append(this.avgTaskDuration).append(", numSuccessfulTasks=").append(this.numSuccessfulTasks).append(", shortestDurationTasks=");
        this.appendTaskIdSet(sb, this.shortestDurationTasks);
        sb.append(", longestDurationTasks=");
        this.appendTaskIdSet(sb, this.longestDurationTasks);
        return sb.toString();
    }
}

