/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.ProgressBuilder;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.VertexState;

public class VertexStatusBuilder
extends VertexStatus {
    public VertexStatusBuilder() {
        super((DAGProtos.VertexStatusProtoOrBuilder)DAGProtos.VertexStatusProto.newBuilder());
    }

    public void setState(VertexState state) {
        this.getBuilder().setState(VertexStatusBuilder.getProtoState(state));
    }

    public void setDiagnostics(List<String> diagnostics) {
        DAGProtos.VertexStatusProto.Builder builder = this.getBuilder();
        builder.clearDiagnostics();
        builder.addAllDiagnostics(diagnostics);
    }

    public void setProgress(ProgressBuilder progress) {
        this.getBuilder().setProgress(progress.getProto());
    }

    public void setVertexCounters(TezCounters counters) {
        this.getBuilder().setVertexCounters(DagTypeConverters.convertTezCountersToProto((TezCounters)counters));
    }

    public DAGProtos.VertexStatusProto getProto() {
        return this.getBuilder().build();
    }

    @VisibleForTesting
    static DAGProtos.VertexStatusStateProto getProtoState(VertexState state) {
        switch (state) {
            case NEW: {
                return DAGProtos.VertexStatusStateProto.VERTEX_NEW;
            }
            case INITIALIZING: {
                return DAGProtos.VertexStatusStateProto.VERTEX_INITIALIZING;
            }
            case RECOVERING: {
                return DAGProtos.VertexStatusStateProto.VERTEX_NEW;
            }
            case INITED: {
                return DAGProtos.VertexStatusStateProto.VERTEX_INITED;
            }
            case RUNNING: {
                return DAGProtos.VertexStatusStateProto.VERTEX_RUNNING;
            }
            case SUCCEEDED: {
                return DAGProtos.VertexStatusStateProto.VERTEX_SUCCEEDED;
            }
            case FAILED: {
                return DAGProtos.VertexStatusStateProto.VERTEX_FAILED;
            }
            case KILLED: {
                return DAGProtos.VertexStatusStateProto.VERTEX_KILLED;
            }
            case TERMINATING: {
                return DAGProtos.VertexStatusStateProto.VERTEX_TERMINATING;
            }
            case ERROR: {
                return DAGProtos.VertexStatusStateProto.VERTEX_ERROR;
            }
        }
        throw new TezUncheckedException("Unsupported value for VertexState : " + (Object)((Object)state));
    }

    private DAGProtos.VertexStatusProto.Builder getBuilder() {
        return (DAGProtos.VertexStatusProto.Builder)this.proxy;
    }
}

