/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tez.common.TezTaskUmbilicalProtocol;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezHeartbeatRequest;
import org.apache.tez.runtime.api.impl.TezHeartbeatResponse;
import org.apache.tez.runtime.task.TaskReporter;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskReporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testContinuousHeartbeatsOnMaxEvents() throws Exception {
        final Object lock = new Object();
        final AtomicBoolean hb2Done = new AtomicBoolean(false);
        TezTaskUmbilicalProtocol mockUmbilical = (TezTaskUmbilicalProtocol)Mockito.mock(TezTaskUmbilicalProtocol.class);
        ((TezTaskUmbilicalProtocol)Mockito.doAnswer((Answer)new Answer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                TezHeartbeatRequest request = (TezHeartbeatRequest)args[0];
                if (request.getRequestId() == 1L || request.getRequestId() == 2L) {
                    TezHeartbeatResponse response = new TezHeartbeatResponse(TestTaskReporter.this.createEvents(5));
                    response.setLastRequestId(request.getRequestId());
                    return response;
                }
                if (request.getRequestId() == 3L) {
                    TezHeartbeatResponse response = new TezHeartbeatResponse(TestTaskReporter.this.createEvents(1));
                    response.setLastRequestId(request.getRequestId());
                    Object object = lock;
                    synchronized (object) {
                        hb2Done.set(true);
                        lock.notify();
                    }
                    return response;
                }
                throw new TezUncheckedException("Invalid request id for test: " + request.getRequestId());
            }
        }).when((Object)mockUmbilical)).heartbeat((TezHeartbeatRequest)Matchers.any(TezHeartbeatRequest.class));
        TezTaskAttemptID mockTaskAttemptId = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        LogicalIOProcessorRuntimeTask mockTask = (LogicalIOProcessorRuntimeTask)Mockito.mock(LogicalIOProcessorRuntimeTask.class);
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)"vertexName").when((Object)mockTask)).getVertexName();
        ((LogicalIOProcessorRuntimeTask)Mockito.doReturn((Object)mockTaskAttemptId).when((Object)mockTask)).getTaskAttemptID();
        TaskReporter.HeartbeatCallable heartbeatCallable = new TaskReporter.HeartbeatCallable(mockTask, mockUmbilical, 100000L, 100000L, 5, new AtomicLong(0L), "containerIdStr");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(heartbeatCallable);
        try {
            Object object = lock;
            synchronized (object) {
                if (!hb2Done.get()) {
                    lock.wait();
                }
            }
            ((TezTaskUmbilicalProtocol)Mockito.verify((Object)mockUmbilical, (VerificationMode)Mockito.times((int)3))).heartbeat((TezHeartbeatRequest)Matchers.any(TezHeartbeatRequest.class));
            Thread.sleep(2000L);
            ((TezTaskUmbilicalProtocol)Mockito.verify((Object)mockUmbilical, (VerificationMode)Mockito.times((int)3))).heartbeat((TezHeartbeatRequest)Matchers.any(TezHeartbeatRequest.class));
        }
        finally {
            executor.shutdownNow();
        }
    }

    private List<TezEvent> createEvents(int numEvents) {
        ArrayList list = Lists.newArrayListWithCapacity((int)numEvents);
        for (int i = 0; i < numEvents; ++i) {
            list.add(Mockito.mock(TezEvent.class));
        }
        return list;
    }
}

