/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.utils;

import org.apache.tez.dag.utils.Simple2LevelVersionComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestSimple2LevelVersionComparator {
    private final Simple2LevelVersionComparator comparator = new Simple2LevelVersionComparator();

    @Test
    public void testBasicEqualChecks() {
        Assert.assertEquals((long)0L, (long)this.comparator.compare("1-SNAPSHOT", "1-SNAPSHOT"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("1.1-SNAPSHOT", "1.1-SNAPSHOT"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("1.1.0-SNAPSHOT", "1.1.0-SNAPSHOT"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("0.1.0", "0.1.0"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("0.1", "0.1"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("0.1.2", "0.1.3"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("1.1.2", "1.1.5-RC"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("1", "1"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("1.1.x", "1.1.x"));
        Assert.assertEquals((long)0L, (long)this.comparator.compare("1-SNAP.x", "1-SNAP.x"));
    }

    @Test
    public void testInvalidVersions() {
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("x.1", "x.1"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("x.1", "0.1"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.x", "1.1"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.1", "x.1"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.1", "1.x"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.1", "Unknown"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("Unknown", "1.1"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("Unknown", "Unknown"));
    }

    @Test
    public void testInequalityChecks() {
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.1", "2.1"));
        Assert.assertEquals((long)1L, (long)this.comparator.compare("1.1", "0.1"));
        Assert.assertEquals((long)1L, (long)this.comparator.compare("1.1.2", "0.1.2"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.1.9", "4.1.9"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.1-RC", "2.1.x"));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("1.1", ""));
        Assert.assertEquals((long)-1L, (long)this.comparator.compare("", "1.1"));
    }
}

