/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexManagerPlugin;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.impl.RootInputVertexManager;
import org.apache.tez.dag.app.dag.impl.VertexManager;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestVertexManager {
    @Test
    public void testOnRootVertexInitialized() throws Exception {
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ((Vertex)Mockito.doReturn((Object)"vertex1").when((Object)mockVertex)).getName();
        Mockito.when((Object)mockAppContext.getCurrentDAG().getVertex((String)Matchers.any(String.class)).getTotalTasks()).thenReturn((Object)1);
        VertexManager vm = new VertexManager(VertexManagerPluginDescriptor.create((String)RootInputVertexManager.class.getName()), mockVertex, mockAppContext, (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class));
        vm.initialize();
        InputDescriptor id1 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputDataInformationEvent> events1 = new LinkedList<InputDataInformationEvent>();
        InputDataInformationEvent diEvent1 = InputDataInformationEvent.createWithSerializedPayload((int)0, null);
        events1.add(diEvent1);
        List tezEvents1 = vm.onRootVertexInitialized("input1", id1, events1);
        Assert.assertEquals((long)1L, (long)tezEvents1.size());
        Assert.assertEquals((Object)diEvent1, (Object)((TezEvent)tezEvents1.get(0)).getEvent());
        InputDescriptor id2 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputDataInformationEvent> events2 = new LinkedList<InputDataInformationEvent>();
        InputDataInformationEvent diEvent2 = InputDataInformationEvent.createWithSerializedPayload((int)0, null);
        events2.add(diEvent2);
        List tezEvents2 = vm.onRootVertexInitialized("input1", id2, events2);
        Assert.assertEquals((long)tezEvents2.size(), (long)1L);
        Assert.assertEquals((Object)diEvent2, (Object)((TezEvent)tezEvents2.get(0)).getEvent());
    }

    @Test
    public void testOnRootVertexInitialized2() throws Exception {
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ((Vertex)Mockito.doReturn((Object)"vertex1").when((Object)mockVertex)).getName();
        Mockito.when((Object)mockAppContext.getCurrentDAG().getVertex((String)Matchers.any(String.class)).getTotalTasks()).thenReturn((Object)1);
        VertexManager vm = new VertexManager(VertexManagerPluginDescriptor.create((String)CustomVertexManager.class.getName()), mockVertex, mockAppContext, (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class));
        vm.initialize();
        InputDescriptor id1 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputDataInformationEvent> events1 = new LinkedList<InputDataInformationEvent>();
        InputDataInformationEvent diEvent1 = InputDataInformationEvent.createWithSerializedPayload((int)0, null);
        events1.add(diEvent1);
        List tezEventsAfterInput1 = vm.onRootVertexInitialized("input1", id1, events1);
        Assert.assertEquals((long)0L, (long)tezEventsAfterInput1.size());
        InputDescriptor id2 = (InputDescriptor)Mockito.mock(InputDescriptor.class);
        LinkedList<InputDataInformationEvent> events2 = new LinkedList<InputDataInformationEvent>();
        InputDataInformationEvent diEvent2 = InputDataInformationEvent.createWithSerializedPayload((int)0, null);
        events2.add(diEvent2);
        List tezEventsAfterInput2 = vm.onRootVertexInitialized("input2", id2, events2);
        Assert.assertEquals((long)2L, (long)tezEventsAfterInput2.size());
        HashSet<String> edgeVertexSet = new HashSet<String>();
        for (TezEvent tezEvent : tezEventsAfterInput2) {
            edgeVertexSet.add(tezEvent.getDestinationInfo().getEdgeVertexName());
        }
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"input1", "input2"}), edgeVertexSet);
    }

    public static class CustomVertexManager
    extends VertexManagerPlugin {
        private Map<String, List<Event>> cachedEventMap = new HashMap<String, List<Event>>();

        public CustomVertexManager(VertexManagerPluginContext context) {
            super(context);
        }

        public void initialize() {
        }

        public void onVertexStarted(Map<String, List<Integer>> completions) {
        }

        public void onSourceTaskCompleted(String srcVertexName, Integer taskId) {
        }

        public void onVertexManagerEventReceived(VertexManagerEvent vmEvent) {
        }

        public void onRootVertexInitialized(String inputName, InputDescriptor inputDescriptor, List<Event> events) {
            this.cachedEventMap.put(inputName, events);
            if (inputName.equals("input2")) {
                for (Map.Entry<String, List<Event>> entry : this.cachedEventMap.entrySet()) {
                    LinkedList riEvents = Lists.newLinkedList();
                    for (Event event : events) {
                        riEvents.add((InputDataInformationEvent)event);
                    }
                    this.getContext().addRootInputEvents(entry.getKey(), (Collection)riEvents);
                }
            }
        }
    }
}

