/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.StateChangeNotifier;
import org.apache.tez.dag.app.dag.TaskStateInternal;
import org.apache.tez.dag.app.dag.TaskTerminationCause;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventDiagnosticsUpdate;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.event.TaskEventTermination;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.dag.impl.TaskImpl;
import org.apache.tez.dag.app.rm.container.AMContainer;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTaskImpl {
    private static final Log LOG = LogFactory.getLog(TestTaskImpl.class);
    private int taskCounter = 0;
    private final int partition = 1;
    private Configuration conf;
    private TaskAttemptListener taskAttemptListener;
    private TaskHeartbeatHandler taskHeartbeatHandler;
    private Credentials credentials;
    private Clock clock;
    private TaskLocationHint locationHint;
    private ApplicationId appId;
    private TezDAGID dagId;
    private TezVertexID vertexId;
    private AppContext appContext;
    private Resource taskResource;
    private Map<String, LocalResource> localResources;
    private Map<String, String> environment;
    private String javaOpts;
    private boolean leafVertex;
    private ContainerContext containerContext;
    private ContainerId mockContainerId;
    private Container mockContainer;
    private AMContainer mockAMContainer;
    private NodeId mockNodeId;
    private MockTaskImpl mockTask;
    private TestEventHandler eventHandler;

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.taskAttemptListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        this.taskHeartbeatHandler = (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class);
        this.credentials = new Credentials();
        this.clock = new SystemClock();
        this.locationHint = TaskLocationHint.createTaskLocationHint(null, null);
        this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.dagId = TezDAGID.getInstance((ApplicationId)this.appId, (int)1);
        this.vertexId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)1);
        this.appContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockContainerId = (ContainerId)Mockito.mock(ContainerId.class);
        this.mockContainer = (Container)Mockito.mock(Container.class);
        this.mockAMContainer = (AMContainer)Mockito.mock(AMContainer.class);
        this.mockNodeId = (NodeId)Mockito.mock(NodeId.class);
        Mockito.when((Object)this.mockContainer.getId()).thenReturn((Object)this.mockContainerId);
        Mockito.when((Object)this.mockContainer.getNodeId()).thenReturn((Object)this.mockNodeId);
        Mockito.when((Object)this.mockAMContainer.getContainer()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.appContext.getAllContainers().get(this.mockContainerId)).thenReturn((Object)this.mockAMContainer);
        this.taskResource = Resource.newInstance((int)1024, (int)1);
        this.localResources = new HashMap<String, LocalResource>();
        this.environment = new HashMap<String, String>();
        this.javaOpts = "";
        this.leafVertex = false;
        this.containerContext = new ContainerContext(this.localResources, this.credentials, this.environment, this.javaOpts);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        this.eventHandler = new TestEventHandler();
        this.mockTask = new MockTaskImpl(this.vertexId, 1, this.eventHandler, this.conf, this.taskAttemptListener, this.clock, this.taskHeartbeatHandler, this.appContext, this.leafVertex, this.locationHint, this.taskResource, this.containerContext, vertex);
    }

    private TezTaskID getNewTaskID() {
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)this.vertexId, (int)(++this.taskCounter));
        return taskID;
    }

    private void scheduleTaskAttempt(TezTaskID taskId) {
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_SCHEDULE));
        this.assertTaskScheduledState();
    }

    private void sendTezEventsToTask(TezTaskID taskId, int numTezEvents) {
        EventMetaData eventMetaData = new EventMetaData();
        DataMovementEvent dmEvent = DataMovementEvent.create(null);
        TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)dmEvent, eventMetaData);
        for (int i = 0; i < numTezEvents; ++i) {
            this.mockTask.registerTezEvent(tezEvent);
        }
    }

    private void killTask(TezTaskID taskId) {
        this.mockTask.handle((TaskEvent)new TaskEventTermination(taskId, TaskTerminationCause.DAG_KILL));
        this.assertTaskKillWaitState();
    }

    private void killScheduledTaskAttempt(TezTaskAttemptID attemptId) {
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(attemptId, TaskEventType.T_ATTEMPT_KILLED));
        this.assertTaskScheduledState();
    }

    private void launchTaskAttempt(TezTaskAttemptID attemptId) {
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(attemptId, TaskEventType.T_ATTEMPT_LAUNCHED));
        this.assertTaskRunningState();
    }

    private void updateAttemptProgress(MockTaskAttemptImpl attempt, float p) {
        attempt.setProgress(p);
    }

    private void updateAttemptState(MockTaskAttemptImpl attempt, TaskAttemptState s) {
        attempt.setState(s);
    }

    private void killRunningTaskAttempt(TezTaskAttemptID attemptId) {
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(attemptId, TaskEventType.T_ATTEMPT_KILLED));
        this.assertTaskRunningState();
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)1))).incrementKilledTaskAttemptCount();
    }

    private void failRunningTaskAttempt(TezTaskAttemptID attemptId) {
        int failedAttempts = this.mockTask.failedAttempts;
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(attemptId, TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskRunningState();
        Assert.assertEquals((long)(failedAttempts + 1), (long)this.mockTask.failedAttempts);
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)(failedAttempts + 1)))).incrementFailedTaskAttemptCount();
    }

    private void assertTaskNewState() {
        Assert.assertEquals((Object)TaskState.NEW, (Object)this.mockTask.getState());
    }

    private void assertTaskScheduledState() {
        Assert.assertEquals((Object)TaskState.SCHEDULED, (Object)this.mockTask.getState());
    }

    private void assertTaskRunningState() {
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)this.mockTask.getState());
    }

    private void assertTaskKillWaitState() {
        Assert.assertEquals((Object)TaskStateInternal.KILL_WAIT, (Object)this.mockTask.getInternalState());
    }

    private void assertTaskSucceededState() {
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)this.mockTask.getState());
    }

    @Test
    public void testInit() {
        LOG.info((Object)"--- START: testInit ---");
        this.assertTaskNewState();
        assert (this.mockTask.getAttemptList().size() == 0);
    }

    @Test
    public void testScheduleTask() {
        LOG.info((Object)"--- START: testScheduleTask ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
    }

    @Test
    public void testKillScheduledTask() {
        LOG.info((Object)"--- START: testKillScheduledTask ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.killTask(taskId);
    }

    @Test
    public void testKillRunningTask() {
        LOG.info((Object)"--- START: testKillRunningTask ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_KILLED));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{VertexEventType.V_TASK_COMPLETED});
    }

    @Test(timeout=5000L)
    public void testKillRunningTaskPreviousKilledAttempts() {
        LOG.info((Object)"--- START: testKillRunningTaskPreviousKilledAttempts ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.killRunningTaskAttempt(this.mockTask.getLastAttempt().getID());
        Assert.assertEquals((Object)TaskStateInternal.RUNNING, (Object)this.mockTask.getInternalState());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_KILLED));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
        this.verifyOutgoingEvents(this.eventHandler.events, new Enum[]{VertexEventType.V_TASK_COMPLETED});
    }

    @Test
    public void testKillRunningTaskButAttemptSucceeds() {
        LOG.info((Object)"--- START: testKillRunningTaskButAttemptSucceeds ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
    }

    @Test
    public void testKillRunningTaskButAttemptFails() {
        LOG.info((Object)"--- START: testKillRunningTaskButAttemptFails ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.killTask(taskId);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_FAILED));
        Assert.assertEquals((Object)TaskStateInternal.KILLED, (Object)this.mockTask.getInternalState());
    }

    @Test
    public void testKillScheduledTaskAttempt() {
        LOG.info((Object)"--- START: testKillScheduledTaskAttempt ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.killScheduledTaskAttempt(this.mockTask.getLastAttempt().getID());
    }

    @Test
    public void testLaunchTaskAttempt() {
        LOG.info((Object)"--- START: testLaunchTaskAttempt ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
    }

    @Test
    public void testKillRunningTaskAttempt() {
        LOG.info((Object)"--- START: testKillRunningTaskAttempt ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.killRunningTaskAttempt(this.mockTask.getLastAttempt().getID());
    }

    @Test
    public void testFetchedEventsModifyUnderlyingList() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.sendTezEventsToTask(taskId, 2);
        TezTaskAttemptID attemptID = this.mockTask.getAttemptList().iterator().next().getID();
        List fetchedList = this.mockTask.getTaskAttemptTezEvents(attemptID, 0, 100);
        Assert.assertEquals((long)2L, (long)fetchedList.size());
        this.sendTezEventsToTask(taskId, 4);
        Assert.assertEquals((long)2L, (long)fetchedList.size());
        fetchedList = this.mockTask.getTaskAttemptTezEvents(attemptID, 0, 100);
        Assert.assertEquals((long)6L, (long)fetchedList.size());
    }

    @Test
    public void testTaskProgress() {
        LOG.info((Object)"--- START: testTaskProgress ---");
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        float progress = 0.0f;
        assert (this.mockTask.getProgress() == progress);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        progress = 50.0f;
        this.updateAttemptProgress(this.mockTask.getLastAttempt(), progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 100.0f;
        this.updateAttemptProgress(this.mockTask.getLastAttempt(), progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 0.0f;
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.KILLED);
        assert (this.mockTask.getProgress() == progress);
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getID());
        assert (this.mockTask.getAttemptList().size() == 2);
        Assert.assertEquals((long)1L, (long)this.mockTask.failedAttempts);
        ((Vertex)Mockito.verify((Object)this.mockTask.getVertex(), (VerificationMode)Mockito.times((int)1))).incrementFailedTaskAttemptCount();
        assert (this.mockTask.getProgress() == 0.0f);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        progress = 50.0f;
        this.updateAttemptProgress(this.mockTask.getLastAttempt(), progress);
        assert (this.mockTask.getProgress() == progress);
    }

    @Test
    public void testFailureDuringTaskAttemptCommit() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        Assert.assertTrue((String)"First attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getLastAttempt().getID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.FAILED);
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getID());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        Assert.assertEquals((long)1L, (long)this.mockTask.failedAttempts);
        Assert.assertFalse((String)"First attempt should not commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(0).getID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        Assert.assertTrue((String)"Second attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getLastAttempt().getID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        this.assertTaskSucceededState();
    }

    @Test
    public void testChangeCommitTaskAttempt() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        Assert.assertTrue((String)"Second attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(1).getID()));
        Assert.assertFalse((String)"First attempt should not commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(0).getID()));
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.FAILED);
        this.failRunningTaskAttempt(this.mockTask.getLastAttempt().getID());
        Assert.assertEquals((long)2L, (long)this.mockTask.getAttemptList().size());
        Assert.assertFalse((String)"Second attempt should not commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(1).getID()));
        Assert.assertTrue((String)"First attempt should commit", (boolean)this.mockTask.canCommit(this.mockTask.getAttemptList().get(0).getID()));
        this.updateAttemptState(this.mockTask.getAttemptList().get(0), TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getAttemptList().get(0).getID(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        this.assertTaskSucceededState();
    }

    @Test
    public void testTaskSucceedAndRetroActiveFailure() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.updateAttemptState(this.mockTask.getLastAttempt(), TaskAttemptState.RUNNING);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        this.assertTaskSucceededState();
        ((StateChangeNotifier)Mockito.verify((Object)this.mockTask.stateChangeNotifier)).taskSucceeded((String)Mockito.any(String.class), (TezTaskID)Mockito.eq((Object)taskId), Mockito.eq((int)this.mockTask.getLastAttempt().getID().getId()));
        this.eventHandler.events.clear();
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskScheduledState();
        Event event = this.eventHandler.events.get(0);
        Assert.assertEquals((Object)AMNodeEventType.N_TA_ENDED, (Object)event.getType());
        event = this.eventHandler.events.get(this.eventHandler.events.size() - 1);
        Assert.assertEquals((Object)VertexEventType.V_TASK_RESCHEDULED, (Object)event.getType());
    }

    @Test
    public void testDiagnostics_TAUpdate() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_KILLED));
        Assert.assertEquals((long)1L, (long)this.mockTask.getDiagnostics().size());
        Assert.assertEquals((Object)"TaskAttempt 0 killed", this.mockTask.getDiagnostics().get(0));
        this.launchTaskAttempt(this.mockTask.getLastAttempt().getID());
        this.mockTask.getLastAttempt().handle((TaskAttemptEvent)new TaskAttemptEventDiagnosticsUpdate(this.mockTask.getLastAttempt().getID(), "diagnostics of test"));
        this.mockTask.handle((TaskEvent)new TaskEventTAUpdate(this.mockTask.getLastAttempt().getID(), TaskEventType.T_ATTEMPT_FAILED));
        Assert.assertEquals((long)2L, (long)this.mockTask.getDiagnostics().size());
        Assert.assertEquals((Object)"TaskAttempt 1 failed, info=[diagnostics of test]", this.mockTask.getDiagnostics().get(1));
    }

    @Test
    public void testDiagnostics_KillNew() {
        TezTaskID taskId = this.getNewTaskID();
        this.mockTask.handle((TaskEvent)new TaskEventTermination(taskId, TaskTerminationCause.DAG_KILL));
        Assert.assertEquals((long)1L, (long)this.mockTask.getDiagnostics().size());
        Assert.assertTrue((boolean)((String)this.mockTask.getDiagnostics().get(0)).contains(TaskTerminationCause.DAG_KILL.name()));
    }

    @Test
    public void testDiagnostics_Kill() {
        TezTaskID taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.mockTask.handle((TaskEvent)new TaskEventTermination(taskId, TaskTerminationCause.OTHER_TASK_FAILURE));
        Assert.assertEquals((long)1L, (long)this.mockTask.getDiagnostics().size());
        Assert.assertTrue((boolean)((String)this.mockTask.getDiagnostics().get(0)).contains(TaskTerminationCause.OTHER_TASK_FAILURE.name()));
    }

    private void verifyOutgoingEvents(List<Event> events, Enum<?> ... expectedTypes) {
        LinkedList expectedTypeList = new LinkedList();
        for (Enum<?> enum_ : expectedTypes) {
            expectedTypeList.add(enum_);
        }
        block1: for (Event event : events) {
            Iterator typeIter = expectedTypeList.iterator();
            while (typeIter.hasNext()) {
                Enum enum_ = (Enum)typeIter.next();
                if (event.getType() != enum_) continue;
                typeIter.remove();
                continue block1;
            }
        }
        Assert.assertTrue((String)("Did not find types : " + expectedTypeList + " in outgoing event list"), (boolean)expectedTypeList.isEmpty());
    }

    public class MockTaskAttemptImpl
    extends TaskAttemptImpl {
        private float progress;
        private TaskAttemptState state;
        TaskLocationHint locationHint;

        public MockTaskAttemptImpl(TezTaskID taskId, int attemptNumber, EventHandler eventHandler, TaskAttemptListener tal, Configuration conf, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, TaskLocationHint locationHint, boolean isRescheduled, Resource resource, ContainerContext containerContext) {
            super(taskId, attemptNumber, eventHandler, tal, conf, clock, thh, appContext, isRescheduled, resource, containerContext, false);
            this.progress = 0.0f;
            this.state = TaskAttemptState.NEW;
            this.locationHint = locationHint;
        }

        public TaskLocationHint getTaskLocationHint() {
            return this.locationHint;
        }

        public float getProgress() {
            return this.progress;
        }

        public void setProgress(float progress) {
            this.progress = progress;
        }

        public void setState(TaskAttemptState state) {
            this.state = state;
        }

        public TaskAttemptState getState() {
            return this.state;
        }

        public TaskAttemptState getStateNoLock() {
            return this.state;
        }

        public ContainerId getAssignedContainerID() {
            return TestTaskImpl.this.mockContainerId;
        }
    }

    private class MockTaskImpl
    extends TaskImpl {
        private List<MockTaskAttemptImpl> taskAttempts;
        private Vertex vertex;
        TaskLocationHint locationHint;

        public MockTaskImpl(TezVertexID vertexId, int partition, EventHandler eventHandler, Configuration conf, TaskAttemptListener taskAttemptListener, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, boolean leafVertex, TaskLocationHint locationHint, Resource resource, ContainerContext containerContext, Vertex vertex) {
            super(vertexId, partition, eventHandler, conf, taskAttemptListener, clock, thh, appContext, leafVertex, resource, containerContext, (StateChangeNotifier)Mockito.mock(StateChangeNotifier.class));
            this.taskAttempts = new LinkedList<MockTaskAttemptImpl>();
            this.vertex = vertex;
            this.locationHint = locationHint;
        }

        protected TaskAttemptImpl createAttempt(int attemptNumber) {
            MockTaskAttemptImpl attempt = new MockTaskAttemptImpl(this.getTaskId(), attemptNumber, this.eventHandler, this.taskAttemptListener, this.conf, this.clock, this.taskHeartbeatHandler, this.appContext, this.locationHint, true, TestTaskImpl.this.taskResource, TestTaskImpl.this.containerContext);
            this.taskAttempts.add(attempt);
            return attempt;
        }

        protected void internalError(TaskEventType type) {
            super.internalError(type);
            Assert.fail((String)("Internal error: " + type));
        }

        MockTaskAttemptImpl getLastAttempt() {
            return this.taskAttempts.get(this.taskAttempts.size() - 1);
        }

        List<MockTaskAttemptImpl> getAttemptList() {
            return this.taskAttempts;
        }

        public Vertex getVertex() {
            return this.vertex;
        }

        protected void logJobHistoryTaskStartedEvent() {
        }

        protected void logJobHistoryTaskFinishedEvent() {
        }

        protected void logJobHistoryTaskFailedEvent(TaskState finalState) {
        }
    }

    class TestEventHandler
    implements EventHandler<Event> {
        List<Event> events = new ArrayList<Event>();

        TestEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
        }
    }
}

