/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ClusterInfo;
import org.apache.tez.dag.app.ContainerContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventCounterUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminated;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventContainerTerminating;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventKillRequest;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventNodeFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventOutputFailed;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventStartedRemotely;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEventTAUpdate;
import org.apache.tez.dag.app.dag.impl.TaskAttemptImpl;
import org.apache.tez.dag.app.rm.AMSchedulerEventTAEnded;
import org.apache.tez.dag.app.rm.AMSchedulerEventTALaunchRequest;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskAttempt {
    @Test(timeout=5000L)
    public void testLocalityRequest() {
        TaskAttemptImpl.ScheduleTaskattemptTransition sta = new TaskAttemptImpl.ScheduleTaskattemptTransition();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TreeSet<String> hosts = new TreeSet<String>();
        hosts.add("host1");
        hosts.add("host2");
        hosts.add("host3");
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(hosts, null);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (AppContext)Mockito.mock(AppContext.class), locationHint, false, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        TaskAttemptEventSchedule sEvent = (TaskAttemptEventSchedule)Mockito.mock(TaskAttemptEventSchedule.class);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(0) instanceof AMSchedulerEventTALaunchRequest)) {
            Assert.fail((String)("Second event not of type " + AMSchedulerEventTALaunchRequest.class.getName()));
        }
        Set requestedRacks = taImpl.taskRacks;
        Assert.assertEquals((long)1L, (long)requestedRacks.size());
        Assert.assertEquals((long)3L, (long)taImpl.taskHosts.size());
        for (int i = 0; i < 3; ++i) {
            String host = "host" + (i + 1);
            Assert.assertEquals((String)host, (Object)true, (Object)taImpl.taskHosts.contains(host));
        }
    }

    @Test(timeout=5000L)
    public void testPriority() {
        TaskAttemptImpl.ScheduleTaskattemptTransition sta = new TaskAttemptImpl.ScheduleTaskattemptTransition();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (AppContext)Mockito.mock(AppContext.class), null, false, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        MockTaskAttemptImpl taImplReScheduled = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (AppContext)Mockito.mock(AppContext.class), null, true, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        TaskAttemptEventSchedule sEvent = (TaskAttemptEventSchedule)Mockito.mock(TaskAttemptEventSchedule.class);
        Mockito.when((Object)sEvent.getPriorityLowLimit()).thenReturn((Object)3);
        Mockito.when((Object)sEvent.getPriorityHighLimit()).thenReturn((Object)1);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        AMSchedulerEventTALaunchRequest launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)2L, (long)launchEvent.getPriority());
        sta.transition((TaskAttemptImpl)taImplReScheduled, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)1L, (long)launchEvent.getPriority());
        Mockito.when((Object)sEvent.getPriorityLowLimit()).thenReturn((Object)6);
        Mockito.when((Object)sEvent.getPriorityHighLimit()).thenReturn((Object)4);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)3))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)5L, (long)launchEvent.getPriority());
        sta.transition((TaskAttemptImpl)taImplReScheduled, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)4))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)4L, (long)launchEvent.getPriority());
        Mockito.when((Object)sEvent.getPriorityLowLimit()).thenReturn((Object)5);
        Mockito.when((Object)sEvent.getPriorityHighLimit()).thenReturn((Object)5);
        sta.transition((TaskAttemptImpl)taImpl, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)5))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)5L, (long)launchEvent.getPriority());
        sta.transition((TaskAttemptImpl)taImplReScheduled, (TaskAttemptEvent)sEvent);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)6))).handle((Event)arg.capture());
        launchEvent = (AMSchedulerEventTALaunchRequest)arg.getValue();
        Assert.assertEquals((long)5L, (long)launchEvent.getPriority());
    }

    @Test(timeout=5000L)
    public void testHostResolveAttempt() throws Exception {
        TaskAttemptImpl.ScheduleTaskattemptTransition sta = new TaskAttemptImpl.ScheduleTaskattemptTransition();
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        String[] hosts = new String[]{"127.0.0.1", "host2", "host3"};
        TreeSet<String> resolved = new TreeSet<String>(Arrays.asList("host1", "host2", "host3"));
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new TreeSet<String>(Arrays.asList(hosts)), null);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((String)"1", (int)1, (int)1), (int)1), (int)1);
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), new Configuration(), (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), (AppContext)Mockito.mock(AppContext.class), locationHint, false, Resource.newInstance((int)1024, (int)1), TestTaskAttempt.createFakeContainerContext(), false);
        TaskAttemptImpl spyTa = (TaskAttemptImpl)Mockito.spy((Object)((Object)taImpl));
        Mockito.when((Object)spyTa.resolveHosts(hosts)).thenReturn((Object)resolved.toArray(new String[3]));
        TaskAttemptEventSchedule mockTAEvent = (TaskAttemptEventSchedule)Mockito.mock(TaskAttemptEventSchedule.class);
        sta.transition(spyTa, (TaskAttemptEvent)mockTAEvent);
        ((TaskAttemptImpl)Mockito.verify((Object)spyTa)).resolveHosts(hosts);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)1))).handle((Event)arg.capture());
        if (!(arg.getAllValues().get(0) instanceof AMSchedulerEventTALaunchRequest)) {
            Assert.fail((String)"Second Event not of type ContainerRequestEvent");
        }
        HashMap<String, Boolean> expected = new HashMap<String, Boolean>();
        expected.put("host1", true);
        expected.put("host2", true);
        expected.put("host3", true);
        Set requestedHosts = spyTa.taskHosts;
        for (String h : requestedHosts) {
            expected.remove(h);
        }
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test(timeout=5000L)
    public void testLaunchFailedWhileKilling() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)mockAppContext)).getClusterInfo();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), mockAppContext, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventKillRequest(taskAttemptID, null));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventKillRequest(taskAttemptID, null));
        Assert.assertFalse((boolean)eventHandler.internalError);
    }

    @Test(timeout=5000L)
    public void testContainerTerminationWhileRunning() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appCtx);
        containers.addContainerIfNew(container);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)appCtx)).getAllContainers();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), appCtx, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID, contId, null));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        int expectedEventsAtRunning = 3;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminating(taskAttemptID, "Terminating"));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_CONTAINER_TERMINATING", (boolean)eventHandler.internalError);
        Assert.assertEquals((String)"Task attempt is not in the  FAILED state", (Object)taImpl.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertEquals((long)1L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"Terminating", taImpl.getDiagnostics().get(0));
        int expectedEvenstAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEvenstAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), TaskEventTAUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(taskAttemptID, "Terminated"));
        int expectedEventAfterTerminated = expectedEvenstAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventAfterTerminated))).handle((Event)arg.capture());
        Assert.assertEquals((long)2L, (long)taImpl.getDiagnostics().size());
        Assert.assertEquals((Object)"Terminated", taImpl.getDiagnostics().get(1));
    }

    @Test(timeout=5000L)
    public void testContainerTerminatedWhileRunning() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appCtx);
        containers.addContainerIfNew(container);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)appCtx)).getAllContainers();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), appCtx, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID, contId, null));
        Assert.assertEquals((String)"Task attempt is not in running state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(taskAttemptID, "Terminated"));
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_CONTAINER_TERMINATED", (boolean)eventHandler.internalError);
        Assert.assertEquals((Object)"Terminated", taImpl.getDiagnostics().get(0));
    }

    @Test(timeout=5000L)
    public void testContainerTerminatedAfterSuccess() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appCtx);
        containers.addContainerIfNew(container);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)appCtx)).getAllContainers();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), appCtx, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID, contId, null));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        int expectedEventsAtRunning = 3;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEvenstAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEvenstAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), TaskEventTAUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventContainerTerminated(taskAttemptID, "Terminated"));
        int expectedEventAfterTerminated = expectedEvenstAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventAfterTerminated))).handle((Event)arg.capture());
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
    }

    @Test(timeout=5000L)
    public void testContainerPreemptedAfterSuccess() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appCtx);
        containers.addContainerIfNew(container);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)appCtx)).getAllContainers();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), appCtx, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID, contId, null));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)taImpl.getState(), (Object)TaskAttemptState.RUNNING);
        int expectedEventsAtRunning = 3;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEventsAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), TaskEventTAUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEventsAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_CONTAINER_TERMINATED_BY_SYSTEM));
        int expectedEventAfterTerminated = expectedEventsAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventAfterTerminated))).handle((Event)arg.capture());
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
    }

    @Test(timeout=5000L)
    public void testNodeFailedNonLeafVertex() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appCtx);
        containers.addContainerIfNew(container);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)appCtx)).getAllContainers();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), appCtx, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID, contId, null));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)TaskAttemptState.RUNNING, (Object)taImpl.getState());
        int expectedEventsAtRunning = 3;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState());
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEvenstAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEvenstAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), TaskEventTAUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventNodeFailed(taskAttemptID, "NodeDecomissioned"));
        Assert.assertEquals((String)"Task attempt is not in the  KILLED state", (Object)TaskAttemptState.KILLED, (Object)taImpl.getState());
        Assert.assertEquals((Object)true, (Object)taImpl.inputFailedReported);
        int expectedEventsNodeFailure = expectedEvenstAfterTerminating + 2;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsNodeFailure))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEvenstAfterTerminating, expectedEventsNodeFailure), TaskEventTAUpdate.class, 1);
        Assert.assertEquals((String)"Task attempt is not in the  KILLED state", (Object)TaskAttemptState.KILLED, (Object)taImpl.getState());
    }

    @Test(timeout=5000L)
    public void testNodeFailedLeafVertex() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)new MockEventHandler());
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appCtx);
        containers.addContainerIfNew(container);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)appCtx)).getAllContainers();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), appCtx, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), true);
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID, contId, null));
        Assert.assertEquals((String)"Task attempt is not in the RUNNING state", (Object)TaskAttemptState.RUNNING, (Object)taImpl.getState());
        int expectedEventsAtRunning = 3;
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAtRunning))).handle((Event)arg.capture());
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState());
        Assert.assertEquals((long)0L, (long)taImpl.getDiagnostics().size());
        int expectedEvenstAfterTerminating = expectedEventsAtRunning + 3;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEvenstAfterTerminating))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), TaskEventTAUpdate.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), AMSchedulerEventTAEnded.class, 1);
        this.verifyEventType(arg.getAllValues().subList(expectedEventsAtRunning, expectedEvenstAfterTerminating), DAGEventCounterUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventNodeFailed(taskAttemptID, "NodeDecomissioned"));
        int expectedEventsNodeFailure = expectedEvenstAfterTerminating + 0;
        arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsNodeFailure))).handle((Event)arg.capture());
        Assert.assertEquals((String)"Task attempt is not in the  SUCCEEDED state", (Object)TaskAttemptState.SUCCEEDED, (Object)taImpl.getState());
    }

    @Test(timeout=5000L)
    public void testMultipleOutputFailed() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)2);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        TezDAGID dagID = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)1);
        TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)1);
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)0);
        MockEventHandler mockEh = new MockEventHandler();
        MockEventHandler eventHandler = (MockEventHandler)Mockito.spy((Object)mockEh);
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        Configuration taskConf = new Configuration();
        taskConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        taskConf.setBoolean("fs.file.impl.disable.cache", true);
        TaskLocationHint locationHint = TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList("127.0.0.1")), null);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        NodeId nid = NodeId.newInstance((String)"127.0.0.1", (int)0);
        ContainerId contId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)3);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)contId);
        Mockito.when((Object)container.getNodeId()).thenReturn((Object)nid);
        Mockito.when((Object)container.getNodeHttpAddress()).thenReturn((Object)"localhost:0");
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        AMContainerMap containers = new AMContainerMap((ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class), (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), (ContainerSignatureMatcher)new ContainerContextMatcher(), appCtx);
        containers.addContainerIfNew(container);
        ((AppContext)Mockito.doReturn((Object)new ClusterInfo()).when((Object)appCtx)).getClusterInfo();
        ((AppContext)Mockito.doReturn((Object)containers).when((Object)appCtx)).getAllContainers();
        MockTaskAttemptImpl taImpl = new MockTaskAttemptImpl(taskID, 1, eventHandler, taListener, taskConf, (Clock)new SystemClock(), (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), appCtx, locationHint, false, resource, TestTaskAttempt.createFakeContainerContext(), false);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventSchedule(taskAttemptID, 0, 0));
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventStartedRemotely(taskAttemptID, contId, null));
        taImpl.handle(new TaskAttemptEvent(taskAttemptID, TaskAttemptEventType.TA_DONE));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        int expectedEventsTillSucceeded = 6;
        ArgumentCaptor arg = ArgumentCaptor.forClass(Event.class);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsTillSucceeded))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues(), TaskEventTAUpdate.class, 2);
        InputReadErrorEvent mockReEvent = InputReadErrorEvent.create((String)"", (int)0, (int)1);
        EventMetaData mockMeta = (EventMetaData)Mockito.mock(EventMetaData.class);
        TezTaskAttemptID mockDestId1 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)mockDestId1);
        TezEvent tzEvent = new TezEvent((org.apache.tez.runtime.api.Event)mockReEvent, mockMeta);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 4));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 4));
        Assert.assertEquals((String)"Task attempt is not in succeeded state", (Object)taImpl.getState(), (Object)TaskAttemptState.SUCCEEDED);
        TezTaskAttemptID mockDestId2 = (TezTaskAttemptID)Mockito.mock(TezTaskAttemptID.class);
        Mockito.when((Object)mockMeta.getTaskAttemptID()).thenReturn((Object)mockDestId2);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 4));
        Assert.assertEquals((String)"Task attempt is not in FAILED state", (Object)taImpl.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertEquals((Object)true, (Object)taImpl.inputFailedReported);
        int expectedEventsAfterFetchFailure = expectedEventsTillSucceeded + 2;
        arg.getAllValues().clear();
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterFetchFailure))).handle((Event)arg.capture());
        this.verifyEventType(arg.getAllValues().subList(expectedEventsTillSucceeded, expectedEventsAfterFetchFailure), TaskEventTAUpdate.class, 1);
        taImpl.handle((TaskAttemptEvent)new TaskAttemptEventOutputFailed(taskAttemptID, tzEvent, 1));
        Assert.assertEquals((String)"Task attempt is not in FAILED state, still", (Object)taImpl.getState(), (Object)TaskAttemptState.FAILED);
        Assert.assertFalse((String)"InternalError occurred trying to handle TA_TOO_MANY_FETCH_FAILURES", (boolean)eventHandler.internalError);
        ((MockEventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)expectedEventsAfterFetchFailure))).handle((Event)arg.capture());
    }

    private void verifyEventType(List<Event> events, Class<? extends Event> eventClass, int expectedOccurences) {
        int count = 0;
        for (Event e : events) {
            if (!eventClass.isInstance(e)) continue;
            ++count;
        }
        Assert.assertEquals((String)("Mismatch in num occurences of event: " + eventClass.getCanonicalName()), (long)expectedOccurences, (long)count);
    }

    private static ContainerContext createFakeContainerContext() {
        return new ContainerContext(new HashMap(), new Credentials(), new HashMap(), "");
    }

    private class MockTaskAttemptImpl
    extends TaskAttemptImpl {
        TaskLocationHint locationHint;
        Vertex mockVertex;
        boolean inputFailedReported;

        public MockTaskAttemptImpl(TezTaskID taskId, int attemptNumber, EventHandler eventHandler, TaskAttemptListener tal, Configuration conf, Clock clock, TaskHeartbeatHandler taskHeartbeatHandler, AppContext appContext, TaskLocationHint locationHint, boolean isRescheduled, Resource resource, ContainerContext containerContext, boolean leafVertex) {
            super(taskId, attemptNumber, eventHandler, tal, conf, clock, taskHeartbeatHandler, appContext, isRescheduled, resource, containerContext, leafVertex);
            this.mockVertex = (Vertex)Mockito.mock(Vertex.class);
            this.inputFailedReported = false;
            this.locationHint = locationHint;
        }

        public TaskLocationHint getTaskLocationHint() {
            return this.locationHint;
        }

        protected Vertex getVertex() {
            return this.mockVertex;
        }

        protected TaskSpec createRemoteTaskSpec() {
            return null;
        }

        protected void logJobHistoryAttemptStarted() {
        }

        protected void logJobHistoryAttemptFinishedEvent(TaskAttemptStateInternal state) {
        }

        protected void logJobHistoryAttemptUnsuccesfulCompletion(TaskAttemptState state) {
        }

        protected void sendInputFailedToConsumers() {
            this.inputFailedReported = true;
        }
    }

    public static class MockEventHandler
    implements EventHandler {
        public boolean internalError;

        public void handle(Event event) {
            DAGEvent je;
            if (event instanceof DAGEvent && DAGEventType.INTERNAL_ERROR == (je = (DAGEvent)event).getType()) {
                this.internalError = true;
            }
        }
    }

    public static class StubbedFS
    extends RawLocalFileSystem {
        public FileStatus getFileStatus(Path f) throws IOException {
            return new FileStatus(1L, false, 1, 1L, 1L, f);
        }
    }
}

