/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventDAGFinished;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventRecoverEvent;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventRecoverVertex;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.dag.impl.TestDAGImpl;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestDAGRecovery {
    private DAGImpl dag;
    private EventHandler mockEventHandler;
    private String user = "root";
    private String dagName = "dag1";
    private AppContext mockAppContext;
    private ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
    private TezDAGID dagId = TezDAGID.getInstance((ApplicationId)this.appId, (int)1);
    private long initTime = 100L;
    private long startTime = this.initTime + 200L;
    private long commitStartTime = this.startTime + 200L;
    private long finishTime = this.commitStartTime + 200L;
    private TezCounters tezCounters = new TezCounters();

    @Before
    public void setUp() {
        this.mockAppContext = (AppContext)Mockito.mock(AppContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.mockAppContext.getCurrentDAG().getDagUGI()).thenReturn(null);
        this.mockEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        this.tezCounters.findCounter("grp_1", "counter_1").increment(1L);
        DAGProtos.DAGPlan dagPlan = TestDAGImpl.createTestDAGPlan();
        this.dag = new DAGImpl(this.dagId, new Configuration(), dagPlan, this.mockEventHandler, (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class), new Credentials(), (Clock)new SystemClock(), this.user, (TaskHeartbeatHandler)Mockito.mock(TaskHeartbeatHandler.class), this.mockAppContext);
    }

    private void assertNewState() {
        Assert.assertEquals((long)0L, (long)this.dag.getVertices().size());
        Assert.assertEquals((long)0L, (long)this.dag.edges.size());
        Assert.assertNull((Object)this.dag.dagScheduler);
        Assert.assertFalse((boolean)this.dag.recoveryCommitInProgress);
        Assert.assertEquals((long)0L, (long)this.dag.recoveredGroupCommits.size());
    }

    private void restoreFromDAGInitializedEvent() {
        DAGState recoveredState = this.dag.restoreFromEvent((HistoryEvent)new DAGInitializedEvent(this.dagId, this.initTime, this.user, this.dagName, null));
        Assert.assertEquals((Object)DAGState.INITED, (Object)recoveredState);
        Assert.assertEquals((long)this.initTime, (long)this.dag.initTime);
        Assert.assertEquals((long)6L, (long)this.dag.getVertices().size());
        Assert.assertEquals((long)6L, (long)this.dag.edges.size());
        Assert.assertNotNull((Object)this.dag.dagScheduler);
    }

    private void restoreFromDAGStartedEvent() {
        DAGState recoveredState = this.dag.restoreFromEvent((HistoryEvent)new DAGStartedEvent(this.dagId, this.startTime, this.user, this.dagName));
        Assert.assertEquals((long)this.startTime, (long)this.dag.startTime);
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)recoveredState);
    }

    private void restoreFromDAGCommitStartedEvent() {
        DAGState recoveredState = this.dag.restoreFromEvent((HistoryEvent)new DAGCommitStartedEvent(this.dagId, this.commitStartTime));
        Assert.assertTrue((boolean)this.dag.recoveryCommitInProgress);
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)recoveredState);
    }

    private void restoreFromVertexGroupCommitStartedEvent() {
        DAGState recoveredState = this.dag.restoreFromEvent((HistoryEvent)new VertexGroupCommitStartedEvent(this.dagId, "g1", this.commitStartTime));
        Assert.assertEquals((long)1L, (long)this.dag.recoveredGroupCommits.size());
        Assert.assertFalse((boolean)((Boolean)this.dag.recoveredGroupCommits.get("g1")));
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)recoveredState);
    }

    private void restoreFromVertexGroupCommitFinishedEvent() {
        DAGState recoveredState = this.dag.restoreFromEvent((HistoryEvent)new VertexGroupCommitFinishedEvent(this.dagId, "g1", this.commitStartTime + 100L));
        Assert.assertEquals((long)1L, (long)this.dag.recoveredGroupCommits.size());
        Assert.assertTrue((boolean)((Boolean)this.dag.recoveredGroupCommits.get("g1")));
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)recoveredState);
    }

    private void restoreFromDAGFinishedEvent(DAGState finalState) {
        DAGState recoveredState = this.dag.restoreFromEvent((HistoryEvent)new DAGFinishedEvent(this.dagId, this.startTime, this.finishTime, finalState, "", this.tezCounters, this.user, this.dagName, null));
        Assert.assertEquals((long)this.finishTime, (long)this.dag.finishTime);
        Assert.assertFalse((boolean)this.dag.recoveryCommitInProgress);
        Assert.assertEquals((Object)finalState, (Object)recoveredState);
        Assert.assertEquals((Object)this.tezCounters, (Object)this.dag.fullCounters);
    }

    @Test
    public void testDAGRecovery_FromNew() {
        this.assertNewState();
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(DAGEvent.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)events.size());
        Assert.assertEquals((Object)DAGEventType.DAG_INIT, (Object)((DAGEvent)events.get(0)).getType());
        Assert.assertEquals((Object)DAGEventType.DAG_START, (Object)((DAGEvent)events.get(1)).getType());
    }

    @Test
    public void testDAGRecovery_FromInited() {
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(VertexEvent.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List vertexEvents = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)vertexEvents.size());
        for (VertexEvent vEvent : vertexEvents) {
            Assert.assertTrue((boolean)(vEvent instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)vEvent;
            Assert.assertEquals((Object)VertexState.RUNNING, (Object)recoverEvent.getDesiredState());
        }
    }

    @Test
    public void testDAGRecovery_FromStarted() {
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(VertexEvent.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)eventCaptor.capture());
        List vertexEvents = eventCaptor.getAllValues();
        Assert.assertEquals((long)2L, (long)vertexEvents.size());
        for (VertexEvent vEvent : vertexEvents) {
            Assert.assertTrue((boolean)(vEvent instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)vEvent;
            Assert.assertEquals((Object)VertexState.RUNNING, (Object)recoverEvent.getDesiredState());
        }
    }

    @Test
    public void testDAGRecovery_Finished_SUCCEEDED() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromDAGFinishedEvent(DAGState.SUCCEEDED);
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)this.dag.getState());
        Assert.assertEquals((Object)this.tezCounters, (Object)this.dag.getAllCounters());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)dagFinishedEvent.getDAGState());
    }

    @Test
    public void testDAGRecovery_Finished_FAILED() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromDAGFinishedEvent(DAGState.FAILED);
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.FAILED, (Object)this.dag.getState());
        Assert.assertEquals((Object)this.tezCounters, (Object)this.dag.getAllCounters());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.FAILED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.FAILED, (Object)dagFinishedEvent.getDAGState());
    }

    @Test
    public void testDAGRecovery_Finished_KILLED() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromDAGFinishedEvent(DAGState.KILLED);
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.KILLED, (Object)this.dag.getState());
        Assert.assertEquals((Object)this.tezCounters, (Object)this.dag.getAllCounters());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.KILLED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.KILLED, (Object)dagFinishedEvent.getDAGState());
    }

    @Test
    public void testDAGRecovery_Finished_ERROR() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromDAGFinishedEvent(DAGState.ERROR);
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.ERROR, (Object)this.dag.getState());
        Assert.assertEquals((Object)this.tezCounters, (Object)this.dag.getAllCounters());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.FAILED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.ERROR, (Object)dagFinishedEvent.getDAGState());
    }

    @Test
    public void testDAGRecovery_COMMIT_STARTED() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromDAGCommitStartedEvent();
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.FAILED, (Object)this.dag.getState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.FAILED, (Object)dagFinishedEvent.getDAGState());
    }

    @Test
    public void testDAGRecovery_COMMIT_STARTED_Finished_SUCCEEDED() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromDAGCommitStartedEvent();
        this.restoreFromDAGFinishedEvent(DAGState.SUCCEEDED);
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)this.dag.getState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)dagFinishedEvent.getDAGState());
    }

    @Test
    public void testDAGRecovery_GROUP_COMMIT_STARTED() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromVertexGroupCommitStartedEvent();
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.FAILED, (Object)this.dag.getState());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.FAILED, (Object)dagFinishedEvent.getDAGState());
    }

    @Test
    public void testDAGRecovery_GROUP_COMMIT_STARTED_FINISHED() {
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromVertexGroupCommitStartedEvent();
        this.restoreFromVertexGroupCommitFinishedEvent();
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)Mockito.any(VertexEventRecoverVertex.class));
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
    }

    @Test
    public void testDAGRecovery_GROUP_COMMIT_Finished() {
        int i;
        this.assertNewState();
        this.restoreFromDAGInitializedEvent();
        this.restoreFromDAGStartedEvent();
        this.restoreFromVertexGroupCommitStartedEvent();
        this.restoreFromVertexGroupCommitFinishedEvent();
        this.restoreFromDAGFinishedEvent(DAGState.SUCCEEDED);
        this.dag.handle((DAGEvent)new DAGEventRecoverEvent(this.dagId, new ArrayList()));
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)this.dag.getState());
        Assert.assertEquals((Object)this.tezCounters, (Object)this.dag.getAllCounters());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)this.mockEventHandler, (VerificationMode)Mockito.times((int)7))).handle((Event)eventCaptor.capture());
        List events = eventCaptor.getAllValues();
        for (i = 0; i < 6; ++i) {
            Assert.assertTrue((boolean)(events.get(i) instanceof VertexEventRecoverVertex));
            VertexEventRecoverVertex recoverEvent = (VertexEventRecoverVertex)events.get(i);
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)recoverEvent.getDesiredState());
        }
        Assert.assertTrue((boolean)(events.get(i) instanceof DAGAppMasterEventDAGFinished));
        DAGAppMasterEventDAGFinished dagFinishedEvent = (DAGAppMasterEventDAGFinished)events.get(i);
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)dagFinishedEvent.getDAGState());
    }
}

