/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.DAGClientServer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDAGClientServer {
    @Test
    public void testPortRange() {
        boolean succeedToAllocate = false;
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int nextPort = 1024 + rand.nextInt(64511);
            if (!this.testPortRange(nextPort)) continue;
            succeedToAllocate = true;
        }
        if (!succeedToAllocate) {
            Assert.fail((String)"Can not allocate free port even in 10 iterations for DAGClientServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testPortRange(int port) {
        DAGClientServer clientServer = null;
        boolean succeedToAllocate = true;
        try {
            DAGClientHandler mockDAGClientHander = (DAGClientHandler)Mockito.mock(DAGClientHandler.class);
            ApplicationAttemptId mockAppAttempId = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
            clientServer = new DAGClientServer(mockDAGClientHander, mockAppAttempId);
            Configuration conf = new Configuration();
            conf.set("tez.am.client.am.port-range", port + "-" + port);
            clientServer.init(conf);
            clientServer.start();
            int resultedPort = clientServer.getBindAddress().getPort();
            System.out.println("bind to address: " + clientServer.getBindAddress());
            Assert.assertEquals((long)port, (long)resultedPort);
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Could not find a free port in " + port + "-" + port));
            succeedToAllocate = false;
        }
        finally {
            if (clientServer != null) {
                try {
                    clientServer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail((String)"fail to stop DAGClientServer");
                }
            }
        }
        return succeedToAllocate;
    }
}

