/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import java.util.HashMap;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.DAGStatusBuilder;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.VertexStatusBuilder;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.records.TezDAGID;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;
import org.mockito.verification.VerificationMode;

public class TestDAGClientHandler {
    @Test(timeout=5000L)
    public void testDAGClientHandler() throws TezException {
        TezDAGID mockTezDAGId = (TezDAGID)Mockito.mock(TezDAGID.class);
        Mockito.when((Object)mockTezDAGId.getId()).thenReturn((Object)1);
        Mockito.when((Object)mockTezDAGId.toString()).thenReturn((Object)"dag_9999_0001_1");
        DAG mockDAG = (DAG)Mockito.mock(DAG.class);
        Mockito.when((Object)mockDAG.getID()).thenReturn((Object)mockTezDAGId);
        DAGStatusBuilder mockDagStatusBuilder = (DAGStatusBuilder)Mockito.mock(DAGStatusBuilder.class);
        Mockito.when((Object)mockDAG.getDAGStatus(Mockito.anySetOf(StatusGetOpts.class))).thenReturn((Object)mockDagStatusBuilder);
        VertexStatusBuilder mockVertexStatusBuilder = (VertexStatusBuilder)Mockito.mock(VertexStatusBuilder.class);
        Mockito.when((Object)mockDAG.getVertexStatus(Mockito.anyString(), Mockito.anySetOf(StatusGetOpts.class))).thenReturn((Object)mockVertexStatusBuilder);
        DAGAppMaster mockDagAM = (DAGAppMaster)Mockito.mock(DAGAppMaster.class);
        AppContext mockAppContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)mockDagAM.getContext()).thenReturn((Object)mockAppContext);
        Mockito.when((Object)mockDagAM.getContext().getCurrentDAG()).thenReturn((Object)mockDAG);
        DAGClientHandler dagClientHandler = new DAGClientHandler(mockDagAM);
        Assert.assertEquals((long)1L, (long)dagClientHandler.getAllDAGs().size());
        Assert.assertEquals((Object)"dag_9999_0001_1", dagClientHandler.getAllDAGs().get(0));
        try {
            dagClientHandler.getDAGStatus("dag_9999_0001_2", Sets.newSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
            Assert.fail((String)"should not come here");
        }
        catch (TezException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown dagId"));
        }
        DAGStatus dagStatus = dagClientHandler.getDAGStatus("dag_9999_0001_1", Sets.newSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        Assert.assertEquals((Object)mockDagStatusBuilder, (Object)dagStatus);
        try {
            dagClientHandler.getVertexStatus("dag_9999_0001_2", "v1", Sets.newSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
            Assert.fail((String)"should not come here");
        }
        catch (TezException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown dagId"));
        }
        VertexStatus vertexStatus = dagClientHandler.getVertexStatus("dag_9999_0001_1", "v1", Sets.newSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        Assert.assertEquals((Object)mockVertexStatusBuilder, (Object)vertexStatus);
        Mockito.when((Object)mockDagAM.isSession()).thenReturn((Object)false);
        try {
            dagClientHandler.getSessionStatus();
            Assert.fail((String)"should not come here");
        }
        catch (TezException e) {
            Assert.assertEquals((Object)"Unsupported operation as AM not running in session mode", (Object)e.getMessage());
        }
        Mockito.when((Object)mockDagAM.isSession()).thenReturn((Object)true);
        Mockito.when((Object)mockDagAM.getState()).thenReturn((Object)DAGAppMasterState.INITED);
        Assert.assertEquals((Object)TezAppMasterStatus.INITIALIZING, (Object)dagClientHandler.getSessionStatus());
        Mockito.when((Object)mockDagAM.getState()).thenReturn((Object)DAGAppMasterState.ERROR);
        Assert.assertEquals((Object)TezAppMasterStatus.SHUTDOWN, (Object)dagClientHandler.getSessionStatus());
        try {
            dagClientHandler.tryKillDAG("dag_9999_0001_2");
            Assert.fail((String)"should not come here");
        }
        catch (TezException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown dagId"));
        }
        dagClientHandler.tryKillDAG("dag_9999_0001_1");
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(DAG.class);
        ((DAGAppMaster)Mockito.verify((Object)mockDagAM, (VerificationMode)Mockito.times((int)1))).tryKillDAG((DAG)eventCaptor.capture());
        Assert.assertEquals((long)1L, (long)eventCaptor.getAllValues().size());
        Assert.assertTrue((boolean)(eventCaptor.getAllValues().get(0) instanceof DAG));
        Assert.assertEquals((Object)"dag_9999_0001_1", (Object)((DAG)eventCaptor.getAllValues().get(0)).getID().toString());
        DAGProtos.DAGPlan dagPlan = DAGProtos.DAGPlan.getDefaultInstance();
        HashMap localResources = new HashMap();
        dagClientHandler.submitDAG(dagPlan, localResources);
        ((DAGAppMaster)Mockito.verify((Object)mockDagAM)).submitDAGToAppMaster(dagPlan, localResources);
        dagClientHandler.shutdownAM();
        ((DAGAppMaster)Mockito.verify((Object)mockDagAM)).shutdownTezAM();
    }
}

