/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.RuntimeUtils;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.oldrecords.TaskAttemptState;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.ContainerLaunchedEvent;
import org.apache.tez.dag.history.events.DAGCommitStartedEvent;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.events.TaskAttemptFinishedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexDataMovementEventsGeneratedEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitFinishedEvent;
import org.apache.tez.dag.history.events.VertexGroupCommitStartedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexParallelismUpdatedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestHistoryEventsProtoConversion {
    private static final Log LOG = LogFactory.getLog(TestHistoryEventsProtoConversion.class);

    private HistoryEvent testProtoConversion(HistoryEvent event) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HistoryEvent deserializedEvent = null;
        event.toProtoStream((OutputStream)os);
        os.flush();
        os.close();
        deserializedEvent = (HistoryEvent)RuntimeUtils.createClazzInstance((String)event.getClass().getName());
        LOG.info((Object)("Serialized event to byte array, eventType=" + event.getEventType() + ", bufLen=" + os.toByteArray().length));
        deserializedEvent.fromProtoStream((InputStream)new ByteArrayInputStream(os.toByteArray()));
        return deserializedEvent;
    }

    private HistoryEvent testSummaryProtoConversion(HistoryEvent historyEvent) throws IOException {
        SummaryEvent event = (SummaryEvent)historyEvent;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HistoryEvent deserializedEvent = null;
        event.toSummaryProtoStream((OutputStream)os);
        os.flush();
        os.close();
        LOG.info((Object)("Serialized event to byte array, eventType=" + historyEvent.getEventType() + ", bufLen=" + os.toByteArray().length));
        RecoveryProtos.SummaryEventProto summaryEventProto = RecoveryProtos.SummaryEventProto.parseDelimitedFrom((InputStream)new ByteArrayInputStream(os.toByteArray()));
        deserializedEvent = (HistoryEvent)RuntimeUtils.createClazzInstance((String)event.getClass().getName());
        ((SummaryEvent)deserializedEvent).fromSummaryProtoStream(summaryEventProto);
        return deserializedEvent;
    }

    private void logEvents(HistoryEvent event, HistoryEvent deserializedEvent) {
        LOG.info((Object)("Initial Event toString: " + event.toString()));
        LOG.info((Object)("Deserialized Event toString: " + deserializedEvent.toString()));
    }

    private void testAMLaunchedEvent() throws Exception {
        AMLaunchedEvent event = new AMLaunchedEvent(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100L, 100L);
        AMLaunchedEvent deserializedEvent = (AMLaunchedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        Assert.assertEquals((long)event.getAppSubmitTime(), (long)deserializedEvent.getAppSubmitTime());
        Assert.assertEquals((long)event.getLaunchTime(), (long)deserializedEvent.getLaunchTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testAMStartedEvent() throws Exception {
        AMStartedEvent event = new AMStartedEvent(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100L);
        AMStartedEvent deserializedEvent = (AMStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGSubmittedEvent() throws Exception {
        DAGSubmittedEvent event = new DAGSubmittedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 1001L, DAGProtos.DAGPlan.newBuilder().setName("foo").build(), ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), null);
        DAGSubmittedEvent deserializedEvent = (DAGSubmittedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((Object)event.getDAGName(), (Object)deserializedEvent.getDAGName());
        Assert.assertEquals((long)event.getSubmitTime(), (long)deserializedEvent.getSubmitTime());
        Assert.assertEquals((Object)event.getDAGPlan(), (Object)deserializedEvent.getDAGPlan());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGInitializedEvent() throws Exception {
        DAGInitializedEvent event = new DAGInitializedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100334L);
        DAGInitializedEvent deserializedEvent = (DAGInitializedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((long)event.getInitTime(), (long)deserializedEvent.getInitTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGStartedEvent() throws Exception {
        DAGStartedEvent event = new DAGStartedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100334L);
        DAGStartedEvent deserializedEvent = (DAGStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGFinishedEvent() throws Exception {
        DAGFinishedEvent event = new DAGFinishedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 1000L, 20000L, DAGState.FAILED, null, null);
        DAGFinishedEvent deserializedEvent = (DAGFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertNotEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        Assert.assertEquals((Object)event.getTezCounters(), (Object)deserializedEvent.getTezCounters());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        TezCounters tezCounters = new TezCounters();
        tezCounters.addGroup("foo", "bar");
        ((CounterGroup)tezCounters.getGroup("foo")).addCounter("c1", "c1", 100L);
        ((CounterGroup)tezCounters.getGroup("foo")).findCounter("c1").increment(1L);
        DAGFinishedEvent event2 = new DAGFinishedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 1000L, 20000L, DAGState.FAILED, "bad diagnostics", tezCounters);
        DAGFinishedEvent deserializedEvent2 = (DAGFinishedEvent)this.testProtoConversion((HistoryEvent)event2);
        Assert.assertEquals((Object)event2.getDagID(), (Object)deserializedEvent2.getDagID());
        Assert.assertEquals((Object)event2.getState(), (Object)deserializedEvent2.getState());
        Assert.assertNotEquals((long)event2.getStartTime(), (long)deserializedEvent2.getStartTime());
        Assert.assertEquals((long)event2.getFinishTime(), (long)deserializedEvent2.getFinishTime());
        Assert.assertEquals((Object)event2.getDiagnostics(), (Object)deserializedEvent2.getDiagnostics());
        Assert.assertEquals((Object)event2.getTezCounters(), (Object)deserializedEvent2.getTezCounters());
        Assert.assertEquals((long)101L, (long)((CounterGroup)deserializedEvent2.getTezCounters().getGroup("foo")).findCounter("c1").getValue());
        this.logEvents((HistoryEvent)event2, (HistoryEvent)deserializedEvent2);
    }

    private void testVertexInitializedEvent() throws Exception {
        VertexInitializedEvent event = new VertexInitializedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), "vertex1", 1000L, 15000L, 100, "procName", null);
        VertexInitializedEvent deserializedEvent = (VertexInitializedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getInitRequestedTime(), (long)deserializedEvent.getInitRequestedTime());
        Assert.assertEquals((long)event.getInitedTime(), (long)deserializedEvent.getInitedTime());
        Assert.assertEquals((long)event.getNumTasks(), (long)deserializedEvent.getNumTasks());
        Assert.assertEquals((Object)event.getAdditionalInputs(), (Object)deserializedEvent.getAdditionalInputs());
        Assert.assertNull((Object)deserializedEvent.getProcessorName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexStartedEvent() throws Exception {
        VertexStartedEvent event = new VertexStartedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), 145553L, 12334455L);
        VertexStartedEvent deserializedEvent = (VertexStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getStartRequestedTime(), (long)deserializedEvent.getStartRequestedTime());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexParallelismUpdatedEvent() throws Exception {
        VertexParallelismUpdatedEvent event = new VertexParallelismUpdatedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), 100, null, null);
        VertexParallelismUpdatedEvent deserializedEvent = (VertexParallelismUpdatedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getNumTasks(), (long)deserializedEvent.getNumTasks());
        Assert.assertEquals((Object)event.getSourceEdgeManagers(), (Object)deserializedEvent.getSourceEdgeManagers());
        Assert.assertEquals((Object)event.getVertexLocationHint(), (Object)deserializedEvent.getVertexLocationHint());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        LinkedHashMap<String, EdgeManagerDescriptor> sourceEdgeManagers = new LinkedHashMap<String, EdgeManagerDescriptor>();
        sourceEdgeManagers.put("foo", new EdgeManagerDescriptor("bar"));
        sourceEdgeManagers.put("foo1", new EdgeManagerDescriptor("bar1").setUserPayload(new String("payload").getBytes()));
        VertexParallelismUpdatedEvent event2 = new VertexParallelismUpdatedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), 100, new VertexLocationHint(Arrays.asList(new VertexLocationHint.TaskLocationHint(new HashSet<String>(Arrays.asList("h1")), new HashSet<String>(Arrays.asList("r1"))))), sourceEdgeManagers);
        VertexParallelismUpdatedEvent deserializedEvent2 = (VertexParallelismUpdatedEvent)this.testProtoConversion((HistoryEvent)event2);
        Assert.assertEquals((Object)event2.getVertexID(), (Object)deserializedEvent2.getVertexID());
        Assert.assertEquals((long)event2.getNumTasks(), (long)deserializedEvent2.getNumTasks());
        Assert.assertEquals((long)event2.getSourceEdgeManagers().size(), (long)deserializedEvent2.getSourceEdgeManagers().size());
        Assert.assertEquals((Object)((EdgeManagerDescriptor)event2.getSourceEdgeManagers().get("foo")).getClassName(), (Object)((EdgeManagerDescriptor)deserializedEvent2.getSourceEdgeManagers().get("foo")).getClassName());
        Assert.assertArrayEquals((byte[])((EdgeManagerDescriptor)event2.getSourceEdgeManagers().get("foo")).getUserPayload(), (byte[])((EdgeManagerDescriptor)deserializedEvent2.getSourceEdgeManagers().get("foo")).getUserPayload());
        Assert.assertEquals((Object)((EdgeManagerDescriptor)event2.getSourceEdgeManagers().get("foo1")).getClassName(), (Object)((EdgeManagerDescriptor)deserializedEvent2.getSourceEdgeManagers().get("foo1")).getClassName());
        Assert.assertArrayEquals((byte[])((EdgeManagerDescriptor)event2.getSourceEdgeManagers().get("foo1")).getUserPayload(), (byte[])((EdgeManagerDescriptor)deserializedEvent2.getSourceEdgeManagers().get("foo1")).getUserPayload());
        Assert.assertEquals((Object)event2.getVertexLocationHint(), (Object)deserializedEvent2.getVertexLocationHint());
        this.logEvents((HistoryEvent)event2, (HistoryEvent)deserializedEvent2);
    }

    private void testVertexFinishedEvent() throws Exception {
        VertexFinishedEvent event = new VertexFinishedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), "vertex1", 1000L, 15000L, 16000L, 20000L, 1344400L, VertexState.ERROR, null, null, null);
        VertexFinishedEvent deserializedEvent = (VertexFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        Assert.assertEquals((Object)event.getTezCounters(), (Object)deserializedEvent.getTezCounters());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        event = new VertexFinishedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), "vertex1", 1000L, 15000L, 16000L, 20000L, 1344400L, VertexState.ERROR, "diagnose", new TezCounters(), new VertexStats());
        deserializedEvent = (VertexFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        Assert.assertEquals((Object)event.getTezCounters(), (Object)deserializedEvent.getTezCounters());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskStartedEvent() throws Exception {
        TaskStartedEvent event = new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), "vertex1", 1000L, 100000L);
        TaskStartedEvent deserializedEvent = (TaskStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskID(), (Object)deserializedEvent.getTaskID());
        Assert.assertEquals((long)event.getScheduledTime(), (long)deserializedEvent.getScheduledTime());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskFinishedEvent() throws Exception {
        TaskFinishedEvent event = new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), "vertex1", 11000L, 1000000L, null, TaskState.FAILED, null);
        TaskFinishedEvent deserializedEvent = (TaskFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskID(), (Object)deserializedEvent.getTaskID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getTezCounters(), (Object)deserializedEvent.getTezCounters());
        Assert.assertEquals((Object)event.getSuccessfulAttemptID(), (Object)deserializedEvent.getSuccessfulAttemptID());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        event = new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), "vertex1", 11000L, 1000000L, TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), TaskState.FAILED, new TezCounters());
        deserializedEvent = (TaskFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskID(), (Object)deserializedEvent.getTaskID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getTezCounters(), (Object)deserializedEvent.getTezCounters());
        Assert.assertEquals((Object)event.getSuccessfulAttemptID(), (Object)deserializedEvent.getSuccessfulAttemptID());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskAttemptStartedEvent() throws Exception {
        TaskAttemptStartedEvent event = new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10009L, ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), NodeId.newInstance((String)"host1", (int)19999), "inProgress", "Completed");
        TaskAttemptStartedEvent deserializedEvent = (TaskAttemptStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskAttemptID(), (Object)deserializedEvent.getTaskAttemptID());
        Assert.assertEquals((Object)event.getContainerId(), (Object)deserializedEvent.getContainerId());
        Assert.assertEquals((Object)event.getNodeId(), (Object)deserializedEvent.getNodeId());
        Assert.assertEquals((long)event.getStartTime(), (long)deserializedEvent.getStartTime());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testTaskAttemptFinishedEvent() throws Exception {
        TaskAttemptFinishedEvent event = new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10001L, 1000434444L, TaskAttemptState.FAILED, null, null);
        TaskAttemptFinishedEvent deserializedEvent = (TaskAttemptFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskAttemptID(), (Object)deserializedEvent.getTaskAttemptID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getCounters(), (Object)deserializedEvent.getCounters());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        event = new TaskAttemptFinishedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)111), (int)1), (int)1), "vertex1", 10001L, 1000434444L, TaskAttemptState.FAILED, "diagnose", new TezCounters());
        deserializedEvent = (TaskAttemptFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getTaskAttemptID(), (Object)deserializedEvent.getTaskAttemptID());
        Assert.assertEquals((long)event.getFinishTime(), (long)deserializedEvent.getFinishTime());
        Assert.assertEquals((Object)event.getDiagnostics(), (Object)deserializedEvent.getDiagnostics());
        Assert.assertEquals((Object)event.getState(), (Object)deserializedEvent.getState());
        Assert.assertEquals((Object)event.getCounters(), (Object)deserializedEvent.getCounters());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testContainerLaunchedEvent() throws Exception {
        ContainerLaunchedEvent event = new ContainerLaunchedEvent(ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1001), 100034566L, ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1));
        ContainerLaunchedEvent deserializedEvent = (ContainerLaunchedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getContainerId(), (Object)deserializedEvent.getContainerId());
        Assert.assertEquals((long)event.getLaunchTime(), (long)deserializedEvent.getLaunchTime());
        Assert.assertEquals((Object)event.getApplicationAttemptId(), (Object)deserializedEvent.getApplicationAttemptId());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexDataMovementEventsGeneratedEvent() throws Exception {
        VertexDataMovementEventsGeneratedEvent event;
        try {
            event = new VertexDataMovementEventsGeneratedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1), null);
            Assert.fail((String)"Invalid creation should have errored out");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        List<TezEvent> events = Arrays.asList(new TezEvent((Event)new DataMovementEvent(1, null), new EventMetaData(EventMetaData.EventProducerConsumerType.SYSTEM, "foo", "bar", null)));
        event = new VertexDataMovementEventsGeneratedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1), events);
        VertexDataMovementEventsGeneratedEvent deserializedEvent = (VertexDataMovementEventsGeneratedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        Assert.assertEquals((long)1L, (long)deserializedEvent.getTezEvents().size());
        Assert.assertEquals((Object)((TezEvent)event.getTezEvents().get(0)).getEventType(), (Object)((TezEvent)deserializedEvent.getTezEvents().get(0)).getEventType());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testDAGCommitStartedEvent() throws Exception {
        DAGCommitStartedEvent event = new DAGCommitStartedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), 100L);
        DAGCommitStartedEvent deserializedEvent = (DAGCommitStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexCommitStartedEvent() throws Exception {
        VertexCommitStartedEvent event = new VertexCommitStartedEvent(TezVertexID.getInstance((TezDAGID)TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1), 100L);
        VertexCommitStartedEvent deserializedEvent = (VertexCommitStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexID(), (Object)deserializedEvent.getVertexID());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexGroupCommitStartedEvent() throws Exception {
        VertexGroupCommitStartedEvent event = new VertexGroupCommitStartedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), "fooGroup", 1000344L);
        VertexGroupCommitStartedEvent deserializedEvent = (VertexGroupCommitStartedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        deserializedEvent = (VertexGroupCommitStartedEvent)this.testSummaryProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    private void testVertexGroupCommitFinishedEvent() throws Exception {
        VertexGroupCommitFinishedEvent event = new VertexGroupCommitFinishedEvent(TezDAGID.getInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), "fooGroup", 1000344L);
        VertexGroupCommitFinishedEvent deserializedEvent = (VertexGroupCommitFinishedEvent)this.testProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getDagID(), (Object)deserializedEvent.getDagID());
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
        deserializedEvent = (VertexGroupCommitFinishedEvent)this.testSummaryProtoConversion((HistoryEvent)event);
        Assert.assertEquals((Object)event.getVertexGroupName(), (Object)deserializedEvent.getVertexGroupName());
        this.logEvents((HistoryEvent)event, (HistoryEvent)deserializedEvent);
    }

    @Test
    public void testDefaultProtoConversion() throws Exception {
        block22: for (HistoryEventType eventType : HistoryEventType.values()) {
            switch (eventType) {
                case AM_LAUNCHED: {
                    this.testAMLaunchedEvent();
                    continue block22;
                }
                case AM_STARTED: {
                    this.testAMStartedEvent();
                    continue block22;
                }
                case DAG_SUBMITTED: {
                    this.testDAGSubmittedEvent();
                    continue block22;
                }
                case DAG_INITIALIZED: {
                    this.testDAGInitializedEvent();
                    continue block22;
                }
                case DAG_STARTED: {
                    this.testDAGStartedEvent();
                    continue block22;
                }
                case DAG_FINISHED: {
                    this.testDAGFinishedEvent();
                    continue block22;
                }
                case VERTEX_INITIALIZED: {
                    this.testVertexInitializedEvent();
                    continue block22;
                }
                case VERTEX_STARTED: {
                    this.testVertexStartedEvent();
                    continue block22;
                }
                case VERTEX_PARALLELISM_UPDATED: {
                    this.testVertexParallelismUpdatedEvent();
                    continue block22;
                }
                case VERTEX_FINISHED: {
                    this.testVertexFinishedEvent();
                    continue block22;
                }
                case TASK_STARTED: {
                    this.testTaskStartedEvent();
                    continue block22;
                }
                case TASK_FINISHED: {
                    this.testTaskFinishedEvent();
                    continue block22;
                }
                case TASK_ATTEMPT_STARTED: {
                    this.testTaskAttemptStartedEvent();
                    continue block22;
                }
                case TASK_ATTEMPT_FINISHED: {
                    this.testTaskAttemptFinishedEvent();
                    continue block22;
                }
                case CONTAINER_LAUNCHED: {
                    this.testContainerLaunchedEvent();
                    continue block22;
                }
                case VERTEX_DATA_MOVEMENT_EVENTS_GENERATED: {
                    this.testVertexDataMovementEventsGeneratedEvent();
                    continue block22;
                }
                case DAG_COMMIT_STARTED: {
                    this.testDAGCommitStartedEvent();
                    continue block22;
                }
                case VERTEX_COMMIT_STARTED: {
                    this.testVertexCommitStartedEvent();
                    continue block22;
                }
                case VERTEX_GROUP_COMMIT_STARTED: {
                    this.testVertexGroupCommitStartedEvent();
                    continue block22;
                }
                case VERTEX_GROUP_COMMIT_FINISHED: {
                    this.testVertexGroupCommitFinishedEvent();
                    continue block22;
                }
                default: {
                    throw new Exception("Unhandled Event type in Unit tests: " + eventType);
                }
            }
        }
    }
}

