/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.rm.container.AMContainerImpl;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAMContainerMap {
    @Test
    public void testAMContainerMap() throws IOException {
        ContainerHeartbeatHandler chh = this.mockContainerHeartBeatHandler();
        TaskAttemptListener tal = this.mockTaskAttemptListener();
        AppContext context = this.mockAppContext();
        AMContainerMap amContainerMap = new AMContainerMap(chh, tal, (ContainerSignatureMatcher)new ContainerContextMatcher(), context);
        Configuration conf = new Configuration();
        conf.set("tez.profile.container.list", "2, 4");
        conf.set("tez.profile.jvm.opts", "testJvmOpts");
        amContainerMap.init(conf);
        amContainerMap.start();
        ContainerId cId1 = this.mockContainerId(1);
        ContainerId cId2 = this.mockContainerId(2);
        ContainerId cId3 = this.mockContainerId(3);
        ContainerId cId4 = this.mockContainerId(4);
        amContainerMap.addContainerIfNew(this.mockContainer(cId1));
        amContainerMap.addContainerIfNew(this.mockContainer(cId2));
        amContainerMap.addContainerIfNew(this.mockContainer(cId3));
        amContainerMap.addContainerIfNew(this.mockContainer(cId4));
        AMContainerImpl amContainer = (AMContainerImpl)amContainerMap.get(cId1);
        Assert.assertFalse((boolean)amContainer.shouldProfile);
        Assert.assertNull((Object)amContainer.profileJavaOpts);
        amContainer = (AMContainerImpl)amContainerMap.get(cId2);
        Assert.assertTrue((boolean)amContainer.shouldProfile);
        Assert.assertEquals((Object)"testJvmOpts", (Object)amContainer.profileJavaOpts);
        amContainer = (AMContainerImpl)amContainerMap.get(cId3);
        Assert.assertFalse((boolean)amContainer.shouldProfile);
        Assert.assertNull((Object)amContainer.profileJavaOpts);
        amContainer = (AMContainerImpl)amContainerMap.get(cId4);
        Assert.assertTrue((boolean)amContainer.shouldProfile);
        Assert.assertEquals((Object)"testJvmOpts", (Object)amContainer.profileJavaOpts);
        amContainerMap.close();
    }

    private ContainerHeartbeatHandler mockContainerHeartBeatHandler() {
        return (ContainerHeartbeatHandler)Mockito.mock(ContainerHeartbeatHandler.class);
    }

    private TaskAttemptListener mockTaskAttemptListener() {
        TaskAttemptListener tal = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        InetSocketAddress socketAddr = new InetSocketAddress("localhost", 21000);
        ((TaskAttemptListener)Mockito.doReturn((Object)socketAddr).when((Object)tal)).getAddress();
        return tal;
    }

    private AppContext mockAppContext() {
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        return appContext;
    }

    private ContainerId mockContainerId(int cId) {
        ApplicationId appId = ApplicationId.newInstance((long)1000L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)cId);
        return containerId;
    }

    private Container mockContainer(ContainerId containerId) {
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)43255);
        Container container = Container.newInstance((ContainerId)containerId, (NodeId)nodeId, (String)"localhost:33333", (Resource)Resource.newInstance((int)1024, (int)1), (Priority)Priority.newInstance((int)1), (Token)((Token)Mockito.mock(Token.class)));
        return container;
    }
}

