/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.impl.AMRMClientImpl;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.rm.TaskScheduler;
import org.apache.tez.dag.app.rm.TaskSchedulerAppCallbackWrapper;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.app.rm.TezAMRMClientAsync;
import org.apache.tez.dag.app.rm.container.ContainerSignatureMatcher;
import org.junit.Assert;
import org.mockito.Mockito;

class TestTaskSchedulerHelpers {
    TestTaskSchedulerHelpers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitForDelayedDrainNotify(AtomicBoolean drainNotifier) throws InterruptedException {
        while (!drainNotifier.get()) {
            AtomicBoolean atomicBoolean = drainNotifier;
            synchronized (atomicBoolean) {
                drainNotifier.wait();
            }
        }
    }

    private static class CountingExecutorService
    implements ExecutorService {
        final ExecutorService real;
        final CompletionService completionService;

        CountingExecutorService(ExecutorService real) {
            this.real = real;
            this.completionService = new ExecutorCompletionService(real);
        }

        @Override
        public void execute(Runnable command) {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public void shutdown() {
            this.real.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.real.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.real.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.real.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.real.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.completionService.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.completionService.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException("Not expected to be used");
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("Not expected to be used");
        }
    }

    static class PreemptionMatcher
    implements ContainerSignatureMatcher {
        PreemptionMatcher() {
        }

        public boolean isSuperSet(Object cs1, Object cs2) {
            Preconditions.checkNotNull((Object)cs1, (Object)"Arguments cannot be null");
            Preconditions.checkNotNull((Object)cs2, (Object)"Arguments cannot be null");
            return true;
        }

        public boolean isExactMatch(Object cs1, Object cs2) {
            return cs1 == cs2 && cs1 != null;
        }

        public Map<String, LocalResource> getAdditionalResources(Map<String, LocalResource> lr1, Map<String, LocalResource> lr2) {
            return Maps.newHashMap();
        }
    }

    static class AlwaysMatchesContainerMatcher
    implements ContainerSignatureMatcher {
        AlwaysMatchesContainerMatcher() {
        }

        public boolean isSuperSet(Object cs1, Object cs2) {
            Preconditions.checkNotNull((Object)cs1, (Object)"Arguments cannot be null");
            Preconditions.checkNotNull((Object)cs2, (Object)"Arguments cannot be null");
            return true;
        }

        public boolean isExactMatch(Object cs1, Object cs2) {
            return true;
        }

        public Map<String, LocalResource> getAdditionalResources(Map<String, LocalResource> lr1, Map<String, LocalResource> lr2) {
            return Maps.newHashMap();
        }
    }

    static class TaskSchedulerAppCallbackDrainable
    implements TaskScheduler.TaskSchedulerAppCallback {
        int completedEvents;
        int invocations;
        private TaskScheduler.TaskSchedulerAppCallback real;
        private CountingExecutorService countingExecutorService;
        final AtomicInteger count = new AtomicInteger(0);

        public TaskSchedulerAppCallbackDrainable(TaskSchedulerAppCallbackWrapper real) {
            this.countingExecutorService = (CountingExecutorService)real.executorService;
            this.real = real;
        }

        public void taskAllocated(Object task, Object appCookie, Container container) {
            this.count.incrementAndGet();
            ++this.invocations;
            this.real.taskAllocated(task, appCookie, container);
        }

        public void containerCompleted(Object taskLastAllocated, ContainerStatus containerStatus) {
            ++this.invocations;
            this.real.containerCompleted(taskLastAllocated, containerStatus);
        }

        public void containerBeingReleased(ContainerId containerId) {
            ++this.invocations;
            this.real.containerBeingReleased(containerId);
        }

        public void nodesUpdated(List<NodeReport> updatedNodes) {
            ++this.invocations;
            this.real.nodesUpdated(updatedNodes);
        }

        public void appShutdownRequested() {
            ++this.invocations;
            this.real.appShutdownRequested();
        }

        public void setApplicationRegistrationData(Resource maxContainerCapability, Map<ApplicationAccessType, String> appAcls, ByteBuffer key) {
            ++this.invocations;
            this.real.setApplicationRegistrationData(maxContainerCapability, appAcls, key);
        }

        public void onError(Throwable t) {
            ++this.invocations;
            this.real.onError(t);
        }

        public float getProgress() {
            ++this.invocations;
            return this.real.getProgress();
        }

        public TaskScheduler.TaskSchedulerAppCallback.AppFinalStatus getFinalAppStatus() {
            ++this.invocations;
            return this.real.getFinalAppStatus();
        }

        public void preemptContainer(ContainerId cId) {
            ++this.invocations;
            this.real.preemptContainer(cId);
        }

        public void drain() throws InterruptedException, ExecutionException {
            while (this.completedEvents < this.invocations) {
                Future f = this.countingExecutorService.completionService.poll(5000L, TimeUnit.MILLISECONDS);
                if (f != null) {
                    ++this.completedEvents;
                    continue;
                }
                Assert.fail((String)"Timed out while trying to drain queue");
            }
        }
    }

    static class TaskSchedulerWithDrainableAppCallback
    extends TaskScheduler {
        private TaskSchedulerAppCallbackDrainable drainableAppCallback;

        public TaskSchedulerWithDrainableAppCallback(TaskScheduler.TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, AppContext appContext) {
            super(appClient, containerSignatureMatcher, appHostName, appHostPort, appTrackingUrl, appContext);
            this.shouldUnregister.set(true);
        }

        public TaskSchedulerWithDrainableAppCallback(TaskScheduler.TaskSchedulerAppCallback appClient, ContainerSignatureMatcher containerSignatureMatcher, String appHostName, int appHostPort, String appTrackingUrl, TezAMRMClientAsync<TaskScheduler.CookieContainerRequest> client, AppContext appContext) {
            super(appClient, containerSignatureMatcher, appHostName, appHostPort, appTrackingUrl, client, appContext);
            this.shouldUnregister.set(true);
        }

        TaskScheduler.TaskSchedulerAppCallback createAppCallbackDelegate(TaskScheduler.TaskSchedulerAppCallback realAppClient) {
            this.drainableAppCallback = new TaskSchedulerAppCallbackDrainable(new TaskSchedulerAppCallbackWrapper(realAppClient, this.appCallbackExecutor));
            return this.drainableAppCallback;
        }

        ExecutorService createAppCallbackExecutorService() {
            ExecutorService real = super.createAppCallbackExecutorService();
            return new CountingExecutorService(real);
        }

        public TaskSchedulerAppCallbackDrainable getDrainableAppCallback() {
            return this.drainableAppCallback;
        }
    }

    static class CapturingEventHandler
    implements EventHandler {
        private List<Event> events = new LinkedList<Event>();

        CapturingEventHandler() {
        }

        public void handle(Event event) {
            this.events.add(event);
        }

        public void reset() {
            this.events.clear();
        }

        public void verifyNoInvocations(Class<? extends Event> eventClass) {
            for (Event e : this.events) {
                Assert.assertFalse((boolean)e.getClass().getName().equals(eventClass.getName()));
            }
        }

        public Event verifyInvocation(Class<? extends Event> eventClass) {
            for (Event e : this.events) {
                if (!e.getClass().getName().equals(eventClass.getName())) continue;
                return e;
            }
            Assert.fail((String)("Expected Event: " + eventClass.getName() + " not sent"));
            return null;
        }
    }

    static class TaskSchedulerEventHandlerForTest
    extends TaskSchedulerEventHandler {
        private TezAMRMClientAsync<TaskScheduler.CookieContainerRequest> amrmClientAsync;
        private ContainerSignatureMatcher containerSignatureMatcher;

        public TaskSchedulerEventHandlerForTest(AppContext appContext, EventHandler eventHandler, TezAMRMClientAsync<TaskScheduler.CookieContainerRequest> amrmClientAsync, ContainerSignatureMatcher containerSignatureMatcher) {
            super(appContext, null, eventHandler, containerSignatureMatcher);
            this.amrmClientAsync = amrmClientAsync;
            this.containerSignatureMatcher = containerSignatureMatcher;
        }

        public TaskScheduler createTaskScheduler(String host, int port, String trackingUrl, AppContext appContext) {
            return new TaskSchedulerWithDrainableAppCallback((TaskScheduler.TaskSchedulerAppCallback)this, this.containerSignatureMatcher, host, port, trackingUrl, this.amrmClientAsync, appContext);
        }

        public TaskScheduler getSpyTaskScheduler() {
            return this.taskScheduler;
        }

        public void serviceStart() {
            TaskScheduler taskSchedulerReal = this.createTaskScheduler("host", 0, "", this.appContext);
            taskSchedulerReal.serviceInit(this.getConfig());
            taskSchedulerReal.serviceStart();
            this.taskScheduler = (TaskScheduler)Mockito.spy((Object)taskSchedulerReal);
        }

        public void serviceStop() {
        }
    }

    static class AMRMClientAsyncForTest
    extends TezAMRMClientAsync<TaskScheduler.CookieContainerRequest> {
        public AMRMClientAsyncForTest(AMRMClient<TaskScheduler.CookieContainerRequest> client, int intervalMs) {
            super(client, intervalMs, null);
        }

        public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) {
            RegisterApplicationMasterResponse mockRegResponse = (RegisterApplicationMasterResponse)Mockito.mock(RegisterApplicationMasterResponse.class);
            Resource mockMaxResource = (Resource)Mockito.mock(Resource.class);
            Map mockAcls = (Map)Mockito.mock(Map.class);
            Mockito.when((Object)mockRegResponse.getMaximumResourceCapability()).thenReturn((Object)mockMaxResource);
            Mockito.when((Object)mockRegResponse.getApplicationACLs()).thenReturn((Object)mockAcls);
            return mockRegResponse;
        }

        public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) {
        }

        protected void serviceStart() {
        }

        protected void serviceStop() {
        }
    }

    static class AMRMClientForTest
    extends AMRMClientImpl<TaskScheduler.CookieContainerRequest> {
        AMRMClientForTest() {
        }

        protected void serviceStart() {
        }

        protected void serviceStop() {
        }
    }
}

