/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeManager;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.RootInputInitializerRunner;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttemptStateInternal;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.VertexTerminationCause;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputFailed;
import org.apache.tez.dag.app.dag.event.VertexEventRootInputInitialized;
import org.apache.tez.dag.app.dag.event.VertexEventRouteEvent;
import org.apache.tez.dag.app.dag.event.VertexEventTaskAttemptCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskReschedule;
import org.apache.tez.dag.app.dag.event.VertexEventTermination;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.app.dag.impl.ImmediateStartVertexManager;
import org.apache.tez.dag.app.dag.impl.RootInputLeafOutputDescriptor;
import org.apache.tez.dag.app.dag.impl.RootInputVertexManager;
import org.apache.tez.dag.app.dag.impl.VertexImpl;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.OutputCommitter;
import org.apache.tez.runtime.api.OutputCommitterContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.RootInputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.RootInputDataInformationEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.GroupInputSpec;
import org.apache.tez.runtime.api.impl.InputSpec;
import org.apache.tez.runtime.api.impl.OutputSpec;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.test.EdgeManagerForTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestVertexImpl {
    private static final Log LOG = LogFactory.getLog(TestVertexImpl.class);
    private boolean useCustomInitializer = false;
    private TezDAGID dagId;
    private ApplicationAttemptId appAttemptId;
    private DAGProtos.DAGPlan dagPlan;
    private DAGProtos.DAGPlan invalidDagPlan;
    private Map<String, VertexImpl> vertices;
    private Map<TezVertexID, VertexImpl> vertexIdMap;
    private DrainDispatcher dispatcher;
    private TaskAttemptListener taskAttemptListener;
    private Clock clock = new SystemClock();
    private TaskHeartbeatHandler thh;
    private AppContext appContext;
    private VertexLocationHint vertexLocationHint = null;
    private Configuration conf;
    private Map<String, Edge> edges;
    private Map<String, DAGImpl.VertexGroupInfo> vertexGroups;
    private byte[] edgePayload = "EP".getBytes();
    private TaskAttemptEventDispatcher taskAttemptEventDispatcher;
    private TaskEventDispatcher taskEventDispatcher;
    private VertexEventDispatcher vertexEventDispatcher;
    private DagEventDispatcher dagEventDispatcher;
    private HistoryEventHandler historyEventHandler;

    private DAGProtos.DAGPlan createInvalidDAGPlan() {
        LOG.info((Object)"Setting up invalid dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("testverteximplinvalid").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host1").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(0).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x1.y1").build()).build()).build();
        return dag;
    }

    private DAGProtos.DAGPlan createDAGPlanWithInputInitializer(String initializerClassName) {
        LOG.info((Object)"Setting up invalid dag plan with input initializer");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("testVertexWithInitializer").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addInputs(DAGProtos.RootInputLeafOutputProto.newBuilder().setInitializerClassName(initializerClassName).setName("input1").setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("InputClazz").build()).build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(-1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x1.y1").build()).addOutEdgeId("e1").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex2").setType(DAGProtos.PlanVertexType.NORMAL).addInputs(DAGProtos.RootInputLeafOutputProto.newBuilder().setInitializerClassName(initializerClassName).setName("input2").setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("InputClazz").build()).build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(-1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x2.y2").build()).addInEdgeId("e1").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("v1_v2")).setInputVertexName("vertex1").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex2").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.BROADCAST).setId("e1").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).build();
        return dag;
    }

    private DAGProtos.DAGPlan createDAGPlanForOneToOneSplit(String initializerClassName) {
        LOG.info((Object)"Setting up one to one dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("testVertexOneToOneSplit").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addInputs(DAGProtos.RootInputLeafOutputProto.newBuilder().setInitializerClassName(initializerClassName).setName("input1").setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("InputClazz").build()).build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(-1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x1.y1").build()).addOutEdgeId("e1").addOutEdgeId("e2").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex2").setType(DAGProtos.PlanVertexType.NORMAL).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(-1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x2.y2").build()).addInEdgeId("e1").addOutEdgeId("e3").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex3").setType(DAGProtos.PlanVertexType.NORMAL).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(-1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x3.y3").build()).addInEdgeId("e2").addOutEdgeId("e4").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex4").setType(DAGProtos.PlanVertexType.NORMAL).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(-1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x4.y4").build()).addInEdgeId("e3").addInEdgeId("e4").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("v1_v2")).setInputVertexName("vertex1").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex2").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.ONE_TO_ONE).setId("e1").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("v1_v3")).setInputVertexName("vertex1").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex3").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.ONE_TO_ONE).setId("e2").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("v2_v4")).setInputVertexName("vertex2").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex4").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.ONE_TO_ONE).setId("e3").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("v3_v4")).setInputVertexName("vertex3").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex4").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.ONE_TO_ONE).setId("e4").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).build();
        return dag;
    }

    private DAGProtos.DAGPlan createTestDAGPlan() {
        LOG.info((Object)"Setting up dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("testverteximpl").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host1").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x1.y1").build()).addOutEdgeId("e1").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex2").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host2").addRack("rack2").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x2.y2").build()).addOutEdgeId("e2").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex3").setType(DAGProtos.PlanVertexType.NORMAL).setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("x3.y3")).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host3").addRack("rack3").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("foo").setTaskModule("x3.y3").build()).addInEdgeId("e1").addInEdgeId("e2").addOutEdgeId("e3").addOutEdgeId("e4").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex4").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host4").addRack("rack4").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x4.y4").build()).addInEdgeId("e3").addOutEdgeId("e5").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex5").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host5").addRack("rack5").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x5.y5").build()).addInEdgeId("e4").addOutEdgeId("e6").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex6").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host6").addRack("rack6").build()).addOutputs(DAGProtos.RootInputLeafOutputProto.newBuilder().setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("output").build()).setName("outputx").setInitializerClassName(CountingOutputCommitter.class.getName())).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x6.y6").build()).addInEdgeId("e5").addInEdgeId("e6").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i3_v1")).setInputVertexName("vertex1").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o1")).setOutputVertexName("vertex3").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.CUSTOM).setEdgeManager(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName(EdgeManagerForTest.class.getName()).setUserPayload(ByteString.copyFrom((byte[])this.edgePayload)).build()).setId("e1").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i3_v2")).setInputVertexName("vertex2").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex3").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e2").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i4_v3")).setInputVertexName("vertex3").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o3_v4")).setOutputVertexName("vertex4").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e3").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i5_v3")).setInputVertexName("vertex3").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o3_v5")).setOutputVertexName("vertex5").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e4").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i6_v4")).setInputVertexName("vertex4").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o4")).setOutputVertexName("vertex6").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e5").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i6_v5")).setInputVertexName("vertex5").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o5")).setOutputVertexName("vertex6").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e6").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).build();
        return dag;
    }

    private DAGProtos.DAGPlan createSamplerDAGPlan() {
        LOG.info((Object)"Setting up dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("TestSamplerDAG").addVertex(DAGProtos.VertexPlan.newBuilder().setName("A").setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A.class")).setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host1").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("A.class").build()).addOutEdgeId("A_B").addOutEdgeId("A_C").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("B").setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B.class")).setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host2").addRack("rack2").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("").build()).addInEdgeId("A_B").addOutEdgeId("B_C").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("C").setType(DAGProtos.PlanVertexType.NORMAL).setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("C.class")).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host3").addRack("rack3").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("foo").setTaskModule("x3.y3").build()).addInEdgeId("A_C").addInEdgeId("B_C").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_B.class")).setInputVertexName("A").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_B.class")).setOutputVertexName("B").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("A_B").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_C")).setInputVertexName("A").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_C.class")).setOutputVertexName("C").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("A_C").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B_C.class")).setInputVertexName("B").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B_C.class")).setOutputVertexName("C").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("B_C").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).build();
        return dag;
    }

    private DAGProtos.DAGPlan createVertexGroupDAGPlan() {
        LOG.info((Object)"Setting up group dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("TestGroupDAG").addVertex(DAGProtos.VertexPlan.newBuilder().setName("A").setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A.class")).setType(DAGProtos.PlanVertexType.NORMAL).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("A.class").build()).addOutEdgeId("A_C").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("B").setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B.class")).setType(DAGProtos.PlanVertexType.NORMAL).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("").build()).addOutEdgeId("B_C").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("C").setType(DAGProtos.PlanVertexType.NORMAL).setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("C.class")).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("foo").setTaskModule("x3.y3").build()).addInEdgeId("A_C").addInEdgeId("B_C").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_C")).setInputVertexName("A").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_C.class")).setOutputVertexName("C").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("A_C").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B_C.class")).setInputVertexName("B").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B_C.class")).setOutputVertexName("C").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("B_C").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addVertexGroups(DAGProtos.PlanVertexGroupInfo.newBuilder().setGroupName("Group").addGroupMembers("A").addGroupMembers("B").addEdgeMergedInputs(DAGProtos.PlanGroupInputEdgeInfo.newBuilder().setDestVertexName("C").setMergedInput(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("Group.class").build()).build())).build();
        return dag;
    }

    private DAGProtos.DAGPlan createSamplerDAGPlan2() {
        LOG.info((Object)"Setting up dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("TestSamplerDAG").addVertex(DAGProtos.VertexPlan.newBuilder().setName("A").setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A.class")).setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host1").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("A.class").build()).addOutEdgeId("A_C").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("B").setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B.class")).setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host2").addRack("rack2").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("").build()).addOutEdgeId("B_C").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("C").setType(DAGProtos.PlanVertexType.NORMAL).setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("C.class")).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host3").addRack("rack3").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("foo").setTaskModule("x3.y3").build()).addInEdgeId("A_C").addInEdgeId("B_C").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_C")).setInputVertexName("A").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("A_C.class")).setOutputVertexName("C").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("A_C").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B_C.class")).setInputVertexName("B").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("B_C.class")).setOutputVertexName("C").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("B_C").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).build();
        return dag;
    }

    private void setupVertices() {
        int vCnt = this.dagPlan.getVertexCount();
        LOG.info((Object)("Setting up vertices from dag plan, verticesCnt=" + vCnt));
        this.vertices = new HashMap<String, VertexImpl>();
        this.vertexIdMap = new HashMap<TezVertexID, VertexImpl>();
        for (int i = 0; i < vCnt; ++i) {
            DAGProtos.VertexPlan vPlan = this.dagPlan.getVertex(i);
            String vName = vPlan.getName();
            TezVertexID vertexId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)(i + 1));
            VertexImplWithCustomInitializer v = null;
            VertexLocationHint locationHint = DagTypeConverters.convertFromDAGPlan((List)vPlan.getTaskLocationHintList());
            v = this.useCustomInitializer ? new VertexImplWithCustomInitializer(vertexId, vPlan, vPlan.getName(), this.conf, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.clock, this.thh, this.appContext, locationHint, this.dispatcher) : new VertexImpl(vertexId, vPlan, vPlan.getName(), this.conf, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.clock, this.thh, true, this.appContext, locationHint, this.vertexGroups);
            this.vertices.put(vName, v);
            this.vertexIdMap.put(vertexId, v);
        }
    }

    private void parseVertexEdges() {
        LOG.info((Object)("Parsing edges from dag plan, edgeCount=" + this.dagPlan.getEdgeCount()));
        int vCnt = this.dagPlan.getVertexCount();
        Map edgePlans = DagTypeConverters.createEdgePlanMapFromDAGPlan((List)this.dagPlan.getEdgeList());
        for (int i = 0; i < vCnt; ++i) {
            Edge edge;
            DAGProtos.EdgePlan edgePlan;
            DAGProtos.VertexPlan vertexPlan = this.dagPlan.getVertex(i);
            Vertex vertex = (Vertex)this.vertices.get(vertexPlan.getName());
            HashMap<Vertex, Edge> inVertices = new HashMap<Vertex, Edge>();
            HashMap<Vertex, Edge> outVertices = new HashMap<Vertex, Edge>();
            for (String inEdgeId : vertexPlan.getInEdgeIdList()) {
                edgePlan = (DAGProtos.EdgePlan)edgePlans.get(inEdgeId);
                Vertex inVertex = (Vertex)this.vertices.get(edgePlan.getInputVertexName());
                edge = this.edges.get(inEdgeId);
                edge.setSourceVertex(inVertex);
                edge.setDestinationVertex(vertex);
                inVertices.put(inVertex, edge);
            }
            for (String outEdgeId : vertexPlan.getOutEdgeIdList()) {
                edgePlan = (DAGProtos.EdgePlan)edgePlans.get(outEdgeId);
                Vertex outVertex = (Vertex)this.vertices.get(edgePlan.getOutputVertexName());
                edge = this.edges.get(outEdgeId);
                edge.setSourceVertex(vertex);
                edge.setDestinationVertex(outVertex);
                outVertices.put(outVertex, edge);
            }
            LOG.info((Object)("Setting input vertices for vertex " + vertex.getName() + ", inputVerticesCnt=" + inVertices.size()));
            vertex.setInputVertices(inVertices);
            LOG.info((Object)("Setting output vertices for vertex " + vertex.getName() + ", outputVerticesCnt=" + outVertices.size()));
            vertex.setOutputVertices(outVertices);
        }
    }

    public void setupPreDagCreation() {
        this.conf = new Configuration();
        this.conf.setBoolean("tez.am.container.reuse.enabled", false);
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)100L, (int)1), (int)1);
        this.dagId = TezDAGID.getInstance((ApplicationId)this.appAttemptId.getApplicationId(), (int)1);
    }

    public void setupPostDagCreation() {
        UserGroupInformation ugi;
        String dagName = "dag0";
        this.dispatcher = new DrainDispatcher();
        this.appContext = (AppContext)Mockito.mock(AppContext.class);
        this.historyEventHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
        TaskSchedulerEventHandler taskScheduler = (TaskSchedulerEventHandler)Mockito.mock(TaskSchedulerEventHandler.class);
        try {
            ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DAG dag = (DAG)Mockito.mock(DAG.class);
        ((DAG)Mockito.doReturn((Object)ugi).when((Object)dag)).getDagUGI();
        ((DAG)Mockito.doReturn((Object)dagName).when((Object)dag)).getName();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId).when((Object)this.appContext)).getApplicationAttemptId();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId.getApplicationId()).when((Object)this.appContext)).getApplicationID();
        ((AppContext)Mockito.doReturn((Object)dag).when((Object)this.appContext)).getCurrentDAG();
        ((AppContext)Mockito.doReturn((Object)this.conf).when((Object)this.appContext)).getAMConf();
        ((DAG)Mockito.doReturn((Object)new Credentials()).when((Object)dag)).getCredentials();
        ((DAG)Mockito.doReturn((Object)DAGProtos.DAGPlan.getDefaultInstance()).when((Object)dag)).getJobPlan();
        ((AppContext)Mockito.doReturn((Object)this.dagId).when((Object)this.appContext)).getCurrentDAGID();
        ((DAG)Mockito.doReturn((Object)this.dagId).when((Object)dag)).getID();
        ((AppContext)Mockito.doReturn((Object)taskScheduler).when((Object)this.appContext)).getTaskScheduler();
        ((TaskSchedulerEventHandler)Mockito.doReturn((Object)Resource.newInstance((int)102400, (int)60)).when((Object)taskScheduler)).getTotalResources();
        ((AppContext)Mockito.doReturn((Object)this.historyEventHandler).when((Object)this.appContext)).getHistoryHandler();
        ((AppContext)Mockito.doReturn((Object)this.dispatcher.getEventHandler()).when((Object)this.appContext)).getEventHandler();
        this.vertexGroups = Maps.newHashMap();
        for (DAGProtos.PlanVertexGroupInfo groupInfo : this.dagPlan.getVertexGroupsList()) {
            this.vertexGroups.put(groupInfo.getGroupName(), new DAGImpl.VertexGroupInfo(groupInfo));
        }
        this.setupVertices();
        Mockito.when((Object)dag.getVertex((TezVertexID)Matchers.any(TezVertexID.class))).thenAnswer((Answer)new Answer<Vertex>(){

            public Vertex answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                if (args.length != 1) {
                    return null;
                }
                TezVertexID vId = (TezVertexID)args[0];
                return (Vertex)TestVertexImpl.this.vertexIdMap.get(vId);
            }
        });
        Mockito.when((Object)dag.getVertex((String)Matchers.any(String.class))).thenAnswer((Answer)new Answer<Vertex>(){

            public Vertex answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                if (args.length != 1) {
                    return null;
                }
                String vId = (String)args[0];
                return (Vertex)TestVertexImpl.this.vertices.get(vId);
            }
        });
        this.edges = new HashMap<String, Edge>();
        for (DAGProtos.EdgePlan edgePlan : this.dagPlan.getEdgeList()) {
            EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)edgePlan);
            this.edges.put(edgePlan.getId(), new Edge(edgeProperty, this.dispatcher.getEventHandler()));
        }
        this.parseVertexEdges();
        for (Edge edge : this.edges.values()) {
            edge.initialize();
        }
        this.taskAttemptEventDispatcher = new TaskAttemptEventDispatcher();
        this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)this.taskAttemptEventDispatcher);
        this.taskEventDispatcher = new TaskEventDispatcher();
        this.dispatcher.register(TaskEventType.class, (EventHandler)this.taskEventDispatcher);
        this.vertexEventDispatcher = new VertexEventDispatcher();
        this.dispatcher.register(VertexEventType.class, (EventHandler)this.vertexEventDispatcher);
        this.dagEventDispatcher = new DagEventDispatcher();
        this.dispatcher.register(DAGEventType.class, (EventHandler)this.dagEventDispatcher);
        this.dispatcher.init(this.conf);
        this.dispatcher.start();
    }

    @Before
    public void setup() {
        this.useCustomInitializer = false;
        this.setupPreDagCreation();
        this.dagPlan = this.createTestDAGPlan();
        this.invalidDagPlan = this.createInvalidDAGPlan();
        this.setupPostDagCreation();
    }

    @After
    public void teardown() {
        this.dispatcher.await();
        this.dispatcher.stop();
        this.dispatcher = null;
        this.vertexEventDispatcher = null;
        this.dagEventDispatcher = null;
        this.dagPlan = null;
        this.invalidDagPlan = null;
        this.vertices = null;
        this.edges = null;
        this.vertexIdMap = null;
    }

    private void initAllVertices(VertexState expectedState) {
        VertexImpl v;
        int i;
        for (i = 1; i <= this.vertices.size(); ++i) {
            v = this.vertices.get("vertex" + i);
            if (v.sourceVertices != null && !v.sourceVertices.isEmpty()) continue;
            this.initVertex(v);
        }
        for (i = 1; i <= this.vertices.size(); ++i) {
            v = this.vertices.get("vertex" + i);
            Assert.assertEquals((Object)expectedState, (Object)v.getState());
        }
    }

    private void initVertex(VertexImpl v) {
        Assert.assertEquals((Object)VertexState.NEW, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(v.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.await();
    }

    private void startVertex(VertexImpl v) {
        this.startVertex(v, true);
    }

    private void killVertex(VertexImpl v) {
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTermination(v.getVertexId(), VertexTerminationCause.DAG_KILL));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        Assert.assertEquals((Object)v.getTerminationCause(), (Object)VertexTerminationCause.DAG_KILL);
    }

    private void startVertex(VertexImpl v, boolean checkRunningState) {
        Assert.assertEquals((Object)VertexState.INITED, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(v.getVertexId(), VertexEventType.V_START));
        this.dispatcher.await();
        if (checkRunningState) {
            Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        }
    }

    @Test(timeout=5000L)
    public void testVertexInit() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v3 = this.vertices.get("vertex3");
        Assert.assertEquals((Object)"x3.y3", (Object)v3.getProcessorName());
        Assert.assertEquals((Object)"foo", (Object)v3.getJavaOpts());
        Assert.assertEquals((long)2L, (long)v3.getInputSpecList(0).size());
        Assert.assertEquals((long)2L, (long)v3.getInputVerticesCount());
        Assert.assertEquals((long)2L, (long)v3.getOutputVerticesCount());
        Assert.assertEquals((long)2L, (long)v3.getOutputVerticesCount());
        Assert.assertTrue(("vertex1".equals(((InputSpec)v3.getInputSpecList(0).get(0)).getSourceVertexName()) || "vertex2".equals(((InputSpec)v3.getInputSpecList(0).get(0)).getSourceVertexName()) ? 1 : 0) != 0);
        Assert.assertTrue(("vertex1".equals(((InputSpec)v3.getInputSpecList(0).get(1)).getSourceVertexName()) || "vertex2".equals(((InputSpec)v3.getInputSpecList(0).get(1)).getSourceVertexName()) ? 1 : 0) != 0);
        Assert.assertTrue(("i3_v1".equals(((InputSpec)v3.getInputSpecList(0).get(0)).getInputDescriptor().getClassName()) || "i3_v2".equals(((InputSpec)v3.getInputSpecList(0).get(0)).getInputDescriptor().getClassName()) ? 1 : 0) != 0);
        Assert.assertTrue(("i3_v1".equals(((InputSpec)v3.getInputSpecList(0).get(1)).getInputDescriptor().getClassName()) || "i3_v2".equals(((InputSpec)v3.getInputSpecList(0).get(1)).getInputDescriptor().getClassName()) ? 1 : 0) != 0);
        Assert.assertTrue(("vertex4".equals(((OutputSpec)v3.getOutputSpecList(0).get(0)).getDestinationVertexName()) || "vertex5".equals(((OutputSpec)v3.getOutputSpecList(0).get(0)).getDestinationVertexName()) ? 1 : 0) != 0);
        Assert.assertTrue(("vertex4".equals(((OutputSpec)v3.getOutputSpecList(0).get(1)).getDestinationVertexName()) || "vertex5".equals(((OutputSpec)v3.getOutputSpecList(0).get(1)).getDestinationVertexName()) ? 1 : 0) != 0);
        Assert.assertTrue(("o3_v4".equals(((OutputSpec)v3.getOutputSpecList(0).get(0)).getOutputDescriptor().getClassName()) || "o3_v5".equals(((OutputSpec)v3.getOutputSpecList(0).get(0)).getOutputDescriptor().getClassName()) ? 1 : 0) != 0);
        Assert.assertTrue(("o3_v4".equals(((OutputSpec)v3.getOutputSpecList(0).get(1)).getOutputDescriptor().getClassName()) || "o3_v5".equals(((OutputSpec)v3.getOutputSpecList(0).get(1)).getOutputDescriptor().getClassName()) ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testVertexStart() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
    }

    @Test(timeout=5000L)
    public void testVertexSetParallelism() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v3 = this.vertices.get("vertex3");
        Assert.assertEquals((long)2L, (long)v3.getTotalTasks());
        Map tasks = v3.getTasks();
        Assert.assertEquals((long)2L, (long)tasks.size());
        TezTaskID firstTask = (TezTaskID)tasks.keySet().iterator().next();
        this.startVertex(v3);
        Vertex v1 = (Vertex)this.vertices.get("vertex1");
        EdgeManagerDescriptor mockEdgeManagerDescriptor = new EdgeManagerDescriptor(EdgeManagerForTest.class.getName());
        Map<String, EdgeManagerDescriptor> edgeManagerDescriptors = Collections.singletonMap(v1.getName(), mockEdgeManagerDescriptor);
        Assert.assertTrue((boolean)v3.setParallelism(1, null, edgeManagerDescriptors));
        Assert.assertTrue((boolean)(((Edge)v3.sourceVertices.get(v1)).getEdgeManager() instanceof EdgeManagerForTest));
        Assert.assertEquals((long)1L, (long)v3.getTotalTasks());
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertTrue((boolean)((TezTaskID)tasks.keySet().iterator().next()).equals((Object)firstTask));
    }

    @Test(timeout=5000L)
    public void testVertexPendingTaskEvents() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v3 = this.vertices.get("vertex3");
        VertexImpl v2 = this.vertices.get("vertex2");
        this.startVertex(v2);
        this.startVertex(v3);
        TezTaskID t0_v2 = TezTaskID.getInstance((TezVertexID)v2.getVertexId(), (int)0);
        TezTaskAttemptID ta0_t0_v2 = TezTaskAttemptID.getInstance((TezTaskID)t0_v2, (int)0);
        LinkedList taskEvents = Lists.newLinkedList();
        TezEvent tezEvent1 = new TezEvent((org.apache.tez.runtime.api.Event)new CompositeDataMovementEvent(0, 1, new byte[0]), new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, "vertex2", "vertex3", ta0_t0_v2));
        TezEvent tezEvent2 = new TezEvent((org.apache.tez.runtime.api.Event)new DataMovementEvent(0, new byte[0]), new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, "vertex2", "vertex3", ta0_t0_v2));
        taskEvents.add(tezEvent1);
        taskEvents.add(tezEvent2);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventRouteEvent(v3.getVertexId(), (List)taskEvents));
        this.dispatcher.await();
        Assert.assertEquals((long)2L, (long)v3.pendingTaskEvents.size());
        v3.scheduleTasks(Collections.singletonList(new Integer(0)));
        this.dispatcher.await();
        Assert.assertEquals((long)0L, (long)v3.pendingTaskEvents.size());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventRouteEvent(v3.getVertexId(), (List)taskEvents));
        this.dispatcher.await();
        Assert.assertEquals((long)0L, (long)v3.pendingTaskEvents.size());
    }

    @Test(timeout=5000L)
    public void testSetCustomEdgeManager() throws UnsupportedEncodingException {
        this.initAllVertices(VertexState.INITED);
        Edge edge = this.edges.get("e1");
        EdgeManager em = edge.getEdgeManager();
        EdgeManagerForTest originalEm = (EdgeManagerForTest)em;
        Assert.assertTrue((boolean)Arrays.equals(this.edgePayload, originalEm.getEdgeManagerContext().getUserPayload()));
        byte[] userPayload = new String("foo").getBytes();
        EdgeManagerDescriptor edgeManagerDescriptor = new EdgeManagerDescriptor(EdgeManagerForTest.class.getName());
        edgeManagerDescriptor.setUserPayload(userPayload);
        Vertex v1 = (Vertex)this.vertices.get("vertex1");
        Vertex v3 = (Vertex)this.vertices.get("vertex3");
        Map<String, EdgeManagerDescriptor> edgeManagerDescriptors = Collections.singletonMap(v1.getName(), edgeManagerDescriptor);
        Assert.assertTrue((boolean)v3.setParallelism(v3.getTotalTasks() - 1, null, edgeManagerDescriptors));
        VertexImpl v3Impl = (VertexImpl)v3;
        EdgeManager modifiedEdgeManager = ((Edge)v3Impl.sourceVertices.get(v1)).getEdgeManager();
        Assert.assertNotNull((Object)modifiedEdgeManager);
        Assert.assertTrue((boolean)(modifiedEdgeManager instanceof EdgeManagerForTest));
        Assert.assertTrue((boolean)Arrays.equals(userPayload, ((EdgeManagerForTest)modifiedEdgeManager).getUserPayload()));
    }

    @Test(timeout=5000L)
    public void testBasicVertexCompletion() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)v.getCompletedTasks());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)2L, (long)v.getCompletedTasks());
    }

    @Test(timeout=5000L)
    @Ignore
    public void testDuplicateTaskCompletion() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
    }

    @Test(timeout=5000L)
    public void testVertexFailure() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.FAILED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v.getState());
        Assert.assertEquals((Object)VertexTerminationCause.OWN_TASK_FAILURE, (Object)v.getTerminationCause());
        String diagnostics = StringUtils.join((CharSequence)",", (Iterable)v.getDiagnostics()).toLowerCase();
        Assert.assertTrue((boolean)diagnostics.contains("task failed, taskid=" + t1.toString()));
    }

    @Test(timeout=5000L)
    public void testVertexKillDiagnostics() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v2 = this.vertices.get("vertex2");
        this.killVertex(v2);
        String diagnostics = StringUtils.join((CharSequence)",", (Iterable)v2.getDiagnostics()).toLowerCase();
        LOG.info((Object)("diagnostics v2: " + diagnostics));
        Assert.assertTrue((boolean)diagnostics.contains("vertex received kill in inited state"));
        VertexImpl v3 = this.vertices.get("vertex3");
        this.startVertex(v3);
        this.killVertex(v3);
        diagnostics = StringUtils.join((CharSequence)",", (Iterable)v3.getDiagnostics()).toLowerCase();
        Assert.assertTrue((boolean)diagnostics.contains("vertex received kill while in running state"));
    }

    @Test(timeout=5000L)
    public void testVertexKillPending() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTermination(v.getVertexId(), VertexTerminationCause.DAG_KILL));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1), TaskState.KILLED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
    }

    @Test(timeout=5000L)
    public void testVertexKill() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTermination(v.getVertexId(), VertexTerminationCause.DAG_KILL));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
    }

    @Test(timeout=5000L)
    public void testKilledTasksHandling() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.FAILED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v.getState());
        Assert.assertEquals((Object)VertexTerminationCause.OWN_TASK_FAILURE, (Object)v.getTerminationCause());
        Assert.assertEquals((Object)TaskState.KILLED, (Object)v.getTask(t2).getState());
    }

    @Test(timeout=5000L)
    public void testVertexCommitterInit() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v2 = this.vertices.get("vertex2");
        Assert.assertNull((Object)v2.getOutputCommitter("output"));
        VertexImpl v6 = this.vertices.get("vertex6");
        Assert.assertTrue((boolean)(v6.getOutputCommitter("outputx") instanceof CountingOutputCommitter));
    }

    @Test(timeout=5000L)
    public void testVertexManagerInit() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v2 = this.vertices.get("vertex2");
        Assert.assertTrue((boolean)(v2.getVertexManager().getPlugin() instanceof ImmediateStartVertexManager));
        VertexImpl v6 = this.vertices.get("vertex6");
        Assert.assertTrue((boolean)(v6.getVertexManager().getPlugin() instanceof ShuffleVertexManager));
    }

    @Test(timeout=5000L)
    public void testVertexTaskFailure() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex6");
        this.startVertex(v);
        CountingOutputCommitter committer = (CountingOutputCommitter)v.getOutputCommitter("outputx");
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.FAILED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.FAILED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v.getState());
        Assert.assertEquals((Object)VertexTerminationCause.OWN_TASK_FAILURE, (Object)v.getTerminationCause());
        Assert.assertEquals((long)0L, (long)committer.commitCounter);
        Assert.assertEquals((long)1L, (long)committer.abortCounter);
    }

    @Test(timeout=5000L)
    public void testSourceVertexStartHandling() {
        LOG.info((Object)"Testing testSourceVertexStartHandling");
        this.initAllVertices(VertexState.INITED);
        VertexImpl v4 = this.vertices.get("vertex4");
        VertexImpl v5 = this.vertices.get("vertex5");
        VertexImpl v6 = this.vertices.get("vertex6");
        this.startVertex(v4);
        this.startVertex(v5);
        this.dispatcher.await();
        LOG.info((Object)("Verifying v6 state " + v6.getState()));
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v6.getState());
        Assert.assertEquals((long)1L, (long)v6.getDistanceFromRoot());
    }

    @Test(timeout=5000L)
    public void testCounters() {
    }

    @Test(timeout=5000L)
    public void testDiagnostics() {
    }

    @Test(timeout=5000L)
    public void testTaskAttemptCompletionEvents() {
    }

    @Test(timeout=5000L)
    public void testSourceTaskAttemptCompletionEvents() {
        LOG.info((Object)"Testing testSourceTaskAttemptCompletionEvents");
        this.initAllVertices(VertexState.INITED);
        VertexImpl v4 = this.vertices.get("vertex4");
        VertexImpl v5 = this.vertices.get("vertex5");
        VertexImpl v6 = this.vertices.get("vertex6");
        this.startVertex(v4);
        this.startVertex(v5);
        this.dispatcher.await();
        LOG.info((Object)("Verifying v6 state " + v6.getState()));
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v6.getState());
        TezTaskID t1_v4 = TezTaskID.getInstance((TezVertexID)v4.getVertexId(), (int)0);
        TezTaskID t2_v4 = TezTaskID.getInstance((TezVertexID)v4.getVertexId(), (int)1);
        TezTaskID t1_v5 = TezTaskID.getInstance((TezVertexID)v5.getVertexId(), (int)0);
        TezTaskID t2_v5 = TezTaskID.getInstance((TezVertexID)v5.getVertexId(), (int)1);
        TezTaskAttemptID ta1_t1_v4 = TezTaskAttemptID.getInstance((TezTaskID)t1_v4, (int)0);
        TezTaskAttemptID ta2_t1_v4 = TezTaskAttemptID.getInstance((TezTaskID)t1_v4, (int)0);
        TezTaskAttemptID ta1_t2_v4 = TezTaskAttemptID.getInstance((TezTaskID)t2_v4, (int)0);
        TezTaskAttemptID ta1_t1_v5 = TezTaskAttemptID.getInstance((TezTaskID)t1_v5, (int)0);
        TezTaskAttemptID ta1_t2_v5 = TezTaskAttemptID.getInstance((TezTaskID)t2_v5, (int)0);
        TezTaskAttemptID ta2_t2_v5 = TezTaskAttemptID.getInstance((TezTaskID)t2_v5, (int)0);
        v4.handle((VertexEvent)new VertexEventTaskAttemptCompleted(ta1_t1_v4, TaskAttemptStateInternal.FAILED));
        v4.handle((VertexEvent)new VertexEventTaskAttemptCompleted(ta2_t1_v4, TaskAttemptStateInternal.SUCCEEDED));
        v4.handle((VertexEvent)new VertexEventTaskAttemptCompleted(ta1_t2_v4, TaskAttemptStateInternal.SUCCEEDED));
        v5.handle((VertexEvent)new VertexEventTaskAttemptCompleted(ta1_t1_v5, TaskAttemptStateInternal.SUCCEEDED));
        v5.handle((VertexEvent)new VertexEventTaskAttemptCompleted(ta1_t2_v5, TaskAttemptStateInternal.FAILED));
        v5.handle((VertexEvent)new VertexEventTaskAttemptCompleted(ta2_t2_v5, TaskAttemptStateInternal.SUCCEEDED));
        v4.handle((VertexEvent)new VertexEventTaskCompleted(t1_v4, TaskState.SUCCEEDED));
        v4.handle((VertexEvent)new VertexEventTaskCompleted(t2_v4, TaskState.SUCCEEDED));
        v5.handle((VertexEvent)new VertexEventTaskCompleted(t1_v5, TaskState.SUCCEEDED));
        v5.handle((VertexEvent)new VertexEventTaskCompleted(t2_v5, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v4.getState());
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v5.getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v6.getState());
        Assert.assertEquals((long)4L, (long)v6.numSuccessSourceAttemptCompletions);
    }

    @Test(timeout=5000L)
    public void testDAGEventGeneration() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dagEventDispatcher.eventCount.get(DAGEventType.DAG_VERTEX_COMPLETED).intValue());
    }

    @Test(timeout=5000L)
    public void testTaskReschedule() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskReschedule(t1));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
    }

    @Test(timeout=5000L)
    public void testVertexSuccessToRunningAfterTaskScheduler() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex2");
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dagEventDispatcher.eventCount.get(DAGEventType.DAG_VERTEX_COMPLETED).intValue());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskReschedule(t1));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dagEventDispatcher.eventCount.get(DAGEventType.DAG_VERTEX_RERUNNING).intValue());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)2L, (long)this.dagEventDispatcher.eventCount.get(DAGEventType.DAG_VERTEX_COMPLETED).intValue());
    }

    @Test(timeout=5000L)
    public void testVertexSuccessToFailedAfterTaskScheduler() throws Exception {
        VertexImpl v = this.vertices.get("vertex2");
        ArrayList<DAGProtos.RootInputLeafOutputProto> outputs = new ArrayList<DAGProtos.RootInputLeafOutputProto>();
        outputs.add(DAGProtos.RootInputLeafOutputProto.newBuilder().setInitializerClassName(CountingOutputCommitter.class.getName()).setName("output_v2").setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setUserPayload(ByteString.copyFrom((byte[])new CountingOutputCommitter.CountingOutputCommitterConfig().toUserPayload())).build()).build());
        v.setAdditionalOutputs(outputs);
        this.initAllVertices(VertexState.INITED);
        this.startVertex(v);
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dagEventDispatcher.eventCount.get(DAGEventType.DAG_VERTEX_COMPLETED).intValue());
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskReschedule(t1));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dagEventDispatcher.eventCount.get(DAGEventType.INTERNAL_ERROR).intValue());
    }

    @Test(timeout=5000L)
    public void testVertexCommit() {
        this.initAllVertices(VertexState.INITED);
        VertexImpl v = this.vertices.get("vertex6");
        this.startVertex(v);
        CountingOutputCommitter committer = (CountingOutputCommitter)v.getOutputCommitter("outputx");
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)committer.commitCounter);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)committer.commitCounter);
        Assert.assertEquals((long)0L, (long)committer.abortCounter);
        Assert.assertEquals((long)1L, (long)committer.initCounter);
        Assert.assertEquals((long)1L, (long)committer.setupCounter);
    }

    @Test(timeout=5000L)
    public void testCommitterInitAndSetup() {
    }

    @Test(timeout=5000L)
    public void testBadCommitter() throws Exception {
        VertexImpl v = this.vertices.get("vertex2");
        ArrayList<DAGProtos.RootInputLeafOutputProto> outputs = new ArrayList<DAGProtos.RootInputLeafOutputProto>();
        outputs.add(DAGProtos.RootInputLeafOutputProto.newBuilder().setInitializerClassName(CountingOutputCommitter.class.getName()).setName("output_v2").setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setUserPayload(ByteString.copyFrom((byte[])new CountingOutputCommitter.CountingOutputCommitterConfig(true, true, false).toUserPayload())).build()).build());
        v.setAdditionalOutputs(outputs);
        this.initAllVertices(VertexState.INITED);
        this.startVertex(v);
        CountingOutputCommitter committer = (CountingOutputCommitter)v.getOutputCommitter("output_v2");
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v.getState());
        Assert.assertEquals((Object)VertexTerminationCause.COMMIT_FAILURE, (Object)v.getTerminationCause());
        Assert.assertEquals((long)1L, (long)committer.commitCounter);
        Assert.assertEquals((long)0L, (long)committer.abortCounter);
        Assert.assertEquals((long)1L, (long)committer.initCounter);
        Assert.assertEquals((long)1L, (long)committer.setupCounter);
    }

    @Test(timeout=5000L)
    public void testBadCommitter2() throws Exception {
        VertexImpl v = this.vertices.get("vertex2");
        ArrayList<DAGProtos.RootInputLeafOutputProto> outputs = new ArrayList<DAGProtos.RootInputLeafOutputProto>();
        outputs.add(DAGProtos.RootInputLeafOutputProto.newBuilder().setInitializerClassName(CountingOutputCommitter.class.getName()).setName("output_v2").setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setUserPayload(ByteString.copyFrom((byte[])new CountingOutputCommitter.CountingOutputCommitterConfig(true, true, true).toUserPayload())).build()).build());
        v.setAdditionalOutputs(outputs);
        this.initAllVertices(VertexState.INITED);
        this.startVertex(v);
        CountingOutputCommitter committer = (CountingOutputCommitter)v.getOutputCommitter("output_v2");
        TezTaskID t1 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0);
        TezTaskID t2 = TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)1);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t1, TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(t2, TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v.getState());
        Assert.assertEquals((Object)VertexTerminationCause.COMMIT_FAILURE, (Object)v.getTerminationCause());
        Assert.assertEquals((long)1L, (long)committer.commitCounter);
        Assert.assertEquals((long)0L, (long)committer.abortCounter);
        Assert.assertEquals((long)1L, (long)committer.initCounter);
        Assert.assertEquals((long)1L, (long)committer.setupCounter);
    }

    @Test(timeout=5000L)
    public void testVertexWithOneToOneSplit() {
        this.useCustomInitializer = true;
        this.setupPreDagCreation();
        this.dagPlan = this.createDAGPlanForOneToOneSplit("TestInputInitializer");
        this.setupPostDagCreation();
        this.initAllVertices(VertexState.INITIALIZING);
        int numTasks = 5;
        VertexImplWithCustomInitializer v1 = (VertexImplWithCustomInitializer)this.vertices.get("vertex1");
        Assert.assertEquals((Object)VertexState.INITIALIZING, (Object)v1.getState());
        RootInputInitializerRunnerControlled runner1 = v1.getRootInputInitializerRunner();
        List<VertexLocationHint.TaskLocationHint> v1Hints = this.createTaskLocationHints(numTasks);
        runner1.completeInputInitialization(numTasks, v1Hints);
        Assert.assertEquals((Object)VertexState.INITED, (Object)v1.getState());
        Assert.assertEquals((long)numTasks, (long)v1.getTotalTasks());
        Assert.assertEquals((Object)RootInputVertexManager.class.getName(), (Object)v1.getVertexManager().getPlugin().getClass().getName());
        Assert.assertEquals(v1Hints, (Object)v1.getVertexLocationHint().getTaskLocationHints());
        Assert.assertEquals((Object)true, (Object)runner1.hasShutDown);
        Assert.assertEquals((long)numTasks, (long)this.vertices.get("vertex2").getTotalTasks());
        Assert.assertEquals((Object)VertexState.INITED, (Object)this.vertices.get("vertex2").getState());
        Assert.assertEquals((long)numTasks, (long)this.vertices.get("vertex3").getTotalTasks());
        Assert.assertEquals((Object)VertexState.INITED, (Object)this.vertices.get("vertex3").getState());
        Assert.assertEquals((long)numTasks, (long)this.vertices.get("vertex4").getTotalTasks());
        Assert.assertEquals((Object)VertexState.INITED, (Object)this.vertices.get("vertex4").getState());
        this.startVertex(v1);
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)this.vertices.get("vertex1").getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)this.vertices.get("vertex2").getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)this.vertices.get("vertex3").getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)this.vertices.get("vertex4").getState());
    }

    @Test(timeout=5000L)
    public void testHistoryEventGeneration() {
    }

    @Test(timeout=5000L)
    public void testInvalidEvent() {
        VertexImpl v = this.vertices.get("vertex2");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(v.getVertexId(), VertexEventType.V_START));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.ERROR, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dagEventDispatcher.eventCount.get(DAGEventType.INTERNAL_ERROR).intValue());
    }

    @Test(timeout=5000L)
    public void testVertexWithInitializerFailure() {
        this.useCustomInitializer = true;
        this.setupPreDagCreation();
        this.dagPlan = this.createDAGPlanWithInputInitializer("TestInputInitializer");
        this.setupPostDagCreation();
        VertexImplWithCustomInitializer v1 = (VertexImplWithCustomInitializer)this.vertices.get("vertex1");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(v1.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.INITIALIZING, (Object)v1.getState());
        RootInputInitializerRunnerControlled runner1 = v1.getRootInputInitializerRunner();
        runner1.failInputInitialization();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v1.getState());
        Assert.assertEquals((Object)RootInputVertexManager.class.getName(), (Object)v1.getVertexManager().getPlugin().getClass().getName());
        Assert.assertEquals((Object)true, (Object)runner1.hasShutDown);
        VertexImplWithCustomInitializer v2 = (VertexImplWithCustomInitializer)this.vertices.get("vertex2");
        Assert.assertEquals((Object)VertexState.INITIALIZING, (Object)v2.getState());
        RootInputInitializerRunnerControlled runner2 = v2.getRootInputInitializerRunner();
        runner2.failInputInitialization();
        Assert.assertEquals((Object)VertexState.FAILED, (Object)v2.getState());
        Assert.assertEquals((Object)RootInputVertexManager.class.getName(), (Object)v2.getVertexManager().getPlugin().getClass().getName());
        Assert.assertEquals((Object)true, (Object)runner2.hasShutDown);
    }

    @Test(timeout=5000L)
    public void testVertexWithInitializerSuccess() {
        this.useCustomInitializer = true;
        this.setupPreDagCreation();
        this.dagPlan = this.createDAGPlanWithInputInitializer("TestInputInitializer");
        this.setupPostDagCreation();
        VertexImplWithCustomInitializer v1 = (VertexImplWithCustomInitializer)this.vertices.get("vertex1");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(v1.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.INITIALIZING, (Object)v1.getState());
        RootInputInitializerRunnerControlled runner1 = v1.getRootInputInitializerRunner();
        List<VertexLocationHint.TaskLocationHint> v1Hints = this.createTaskLocationHints(5);
        runner1.completeInputInitialization(5, v1Hints);
        Assert.assertEquals((Object)VertexState.INITED, (Object)v1.getState());
        Assert.assertEquals((long)5L, (long)v1.getTotalTasks());
        Assert.assertEquals((Object)RootInputVertexManager.class.getName(), (Object)v1.getVertexManager().getPlugin().getClass().getName());
        Assert.assertEquals(v1Hints, (Object)v1.getVertexLocationHint().getTaskLocationHints());
        Assert.assertEquals((Object)true, (Object)runner1.hasShutDown);
        VertexImplWithCustomInitializer v2 = (VertexImplWithCustomInitializer)this.vertices.get("vertex2");
        Assert.assertEquals((Object)VertexState.INITIALIZING, (Object)v2.getState());
        RootInputInitializerRunnerControlled runner2 = v2.getRootInputInitializerRunner();
        List<VertexLocationHint.TaskLocationHint> v2Hints = this.createTaskLocationHints(10);
        runner2.completeInputInitialization(10, v2Hints);
        Assert.assertEquals((Object)VertexState.INITED, (Object)v2.getState());
        Assert.assertEquals((long)10L, (long)v2.getTotalTasks());
        Assert.assertEquals((Object)RootInputVertexManager.class.getName(), (Object)v2.getVertexManager().getPlugin().getClass().getName());
        Assert.assertEquals(v2Hints, (Object)v2.getVertexLocationHint().getTaskLocationHints());
        Assert.assertEquals((Object)true, (Object)runner2.hasShutDown);
    }

    private List<VertexLocationHint.TaskLocationHint> createTaskLocationHints(int numTasks) {
        ArrayList locationHints = Lists.newArrayListWithCapacity((int)numTasks);
        for (int i = 0; i < numTasks; ++i) {
            VertexLocationHint.TaskLocationHint taskLocationHint = new VertexLocationHint.TaskLocationHint(Sets.newSet((Object[])new String[]{"host" + i}), null);
            locationHints.add(taskLocationHint);
        }
        return locationHints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testVertexWithNoTasks() {
        block3: {
            TezVertexID vId = null;
            try {
                TezDAGID invalidDagId = TezDAGID.getInstance((ApplicationId)this.dagId.getApplicationId(), (int)1000);
                vId = TezVertexID.getInstance((TezDAGID)invalidDagId, (int)1);
                DAGProtos.VertexPlan vPlan = this.invalidDagPlan.getVertex(0);
                VertexImpl v = new VertexImpl(vId, vPlan, vPlan.getName(), this.conf, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.clock, this.thh, true, this.appContext, this.vertexLocationHint, null);
                this.vertexIdMap.put(vId, v);
                this.vertices.put(v.getName(), v);
                v.handle(new VertexEvent(vId, VertexEventType.V_INIT));
                this.dispatcher.await();
                Assert.assertEquals((Object)VertexState.INITED, (Object)v.getState());
                v.handle(new VertexEvent(vId, VertexEventType.V_START));
                this.dispatcher.await();
                Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
                if (vId == null) break block3;
                this.vertexIdMap.remove(vId);
            }
            catch (Throwable throwable) {
                if (vId != null) {
                    this.vertexIdMap.remove(vId);
                }
                throw throwable;
            }
        }
    }

    @Test(timeout=5000L)
    public void testVertexGroupInput() {
        this.setupPreDagCreation();
        this.dagPlan = this.createVertexGroupDAGPlan();
        this.setupPostDagCreation();
        VertexImpl vA = this.vertices.get("A");
        VertexImpl vB = this.vertices.get("B");
        VertexImpl vC = this.vertices.get("C");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vA.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vB.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.await();
        Assert.assertNull((Object)vA.getGroupInputSpecList(0));
        Assert.assertNull((Object)vB.getGroupInputSpecList(0));
        List groupInSpec = vC.getGroupInputSpecList(0);
        Assert.assertEquals((long)1L, (long)groupInSpec.size());
        Assert.assertEquals((Object)"Group", (Object)((GroupInputSpec)groupInSpec.get(0)).getGroupName());
        Assert.assertTrue((boolean)((GroupInputSpec)groupInSpec.get(0)).getGroupVertices().contains("A"));
        Assert.assertTrue((boolean)((GroupInputSpec)groupInSpec.get(0)).getGroupVertices().contains("B"));
        ((GroupInputSpec)groupInSpec.get(0)).getMergedInputDescriptor().getClassName().equals("Group.class");
    }

    @Test(timeout=5000L)
    public void testInitStartRace() {
        this.setupPreDagCreation();
        this.dagPlan = this.createSamplerDAGPlan();
        this.setupPostDagCreation();
        VertexImpl vA = this.vertices.get("A");
        VertexImpl vB = this.vertices.get("B");
        VertexImpl vC = this.vertices.get("C");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vA.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vA.getVertexId(), VertexEventType.V_START));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)vA.getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)vB.getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)vC.getState());
    }

    @Test(timeout=5000L)
    public void testInitStartRace2() {
        this.setupPreDagCreation();
        this.dagPlan = this.createSamplerDAGPlan2();
        this.setupPostDagCreation();
        VertexImpl vA = this.vertices.get("A");
        VertexImpl vB = this.vertices.get("B");
        VertexImpl vC = this.vertices.get("C");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vA.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vA.getVertexId(), VertexEventType.V_START));
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vB.getVertexId(), VertexEventType.V_INIT));
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(vB.getVertexId(), VertexEventType.V_START));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)vA.getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)vB.getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)vC.getState());
    }

    private static class RootInputInitializerRunnerControlled
    extends RootInputInitializerRunner {
        private List<RootInputLeafOutputDescriptor<InputDescriptor>> inputs;
        private final EventHandler eventHandler;
        private final DrainDispatcher dispatcher;
        private final TezVertexID vertexID;
        private volatile boolean hasShutDown = false;

        public RootInputInitializerRunnerControlled(String dagName, String vertexName, TezVertexID vertexID, EventHandler eventHandler, int numTasks, DrainDispatcher dispatcher, Resource taskResource, Resource totalResource) throws IOException {
            super(dagName, vertexName, vertexID, eventHandler, UserGroupInformation.getCurrentUser(), taskResource, totalResource, numTasks, 1);
            this.eventHandler = eventHandler;
            this.dispatcher = dispatcher;
            this.vertexID = vertexID;
        }

        public void runInputInitializers(List<RootInputLeafOutputDescriptor<InputDescriptor>> inputs) {
            this.inputs = inputs;
        }

        public void shutdown() {
            this.hasShutDown = true;
        }

        public void failInputInitialization() {
            super.runInputInitializers(this.inputs);
            this.eventHandler.handle((Event)new VertexEventRootInputFailed(this.vertexID, this.inputs.get(0).getEntityName(), (Throwable)new RuntimeException("MockInitializerFailed")));
            this.dispatcher.await();
        }

        public void completeInputInitialization(int targetTasks, List<VertexLocationHint.TaskLocationHint> locationHints) {
            ArrayList events = Lists.newArrayListWithCapacity((int)(targetTasks + 1));
            RootInputConfigureVertexTasksEvent configEvent = new RootInputConfigureVertexTasksEvent(targetTasks, locationHints);
            events.add(configEvent);
            for (int i = 0; i < targetTasks; ++i) {
                RootInputDataInformationEvent diEvent = new RootInputDataInformationEvent(i, null);
                events.add(diEvent);
            }
            this.eventHandler.handle((Event)new VertexEventRootInputInitialized(this.vertexID, this.inputs.get(0).getEntityName(), (List)events));
            this.dispatcher.await();
        }
    }

    private static class VertexImplWithCustomInitializer
    extends VertexImpl {
        private final DrainDispatcher dispatcher;
        private RootInputInitializerRunnerControlled rootInputInitializerRunner;

        public VertexImplWithCustomInitializer(TezVertexID vertexId, DAGProtos.VertexPlan vertexPlan, String vertexName, Configuration conf, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Clock clock, TaskHeartbeatHandler thh, AppContext appContext, VertexLocationHint vertexLocationHint, DrainDispatcher dispatcher) {
            super(vertexId, vertexPlan, vertexName, conf, eventHandler, taskAttemptListener, clock, thh, true, appContext, vertexLocationHint, null);
            this.dispatcher = dispatcher;
        }

        protected RootInputInitializerRunner createRootInputInitializerRunner(String dagName, String vertexName, TezVertexID vertexID, EventHandler eventHandler, int numTasks, int numNodes, Resource taskResource, Resource totalResource) {
            try {
                this.rootInputInitializerRunner = new RootInputInitializerRunnerControlled(dagName, vertexName, vertexID, eventHandler, numTasks, this.dispatcher, taskResource, totalResource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.rootInputInitializerRunner;
        }

        RootInputInitializerRunnerControlled getRootInputInitializerRunner() {
            return this.rootInputInitializerRunner;
        }
    }

    private class VertexEventDispatcher
    implements EventHandler<VertexEvent> {
        private VertexEventDispatcher() {
        }

        public void handle(VertexEvent event) {
            VertexImpl vertex = (VertexImpl)TestVertexImpl.this.vertexIdMap.get(event.getVertexId());
            vertex.handle((Event)event);
        }
    }

    private class DagEventDispatcher
    implements EventHandler<DAGEvent> {
        public Map<DAGEventType, Integer> eventCount = new HashMap<DAGEventType, Integer>();

        private DagEventDispatcher() {
        }

        public void handle(DAGEvent event) {
            int count = 1;
            if (this.eventCount.containsKey(event.getType())) {
                count = this.eventCount.get(event.getType()) + 1;
            }
            this.eventCount.put((DAGEventType)event.getType(), count);
        }
    }

    private class TaskEventDispatcher
    implements EventHandler<TaskEvent> {
        private TaskEventDispatcher() {
        }

        public void handle(TaskEvent event) {
            VertexImpl vertex = (VertexImpl)TestVertexImpl.this.vertexIdMap.get(event.getTaskID().getVertexID());
            Task task = vertex.getTask(event.getTaskID());
            ((EventHandler)task).handle((Event)event);
        }
    }

    private class TaskAttemptEventDispatcher
    implements EventHandler<TaskAttemptEvent> {
        private TaskAttemptEventDispatcher() {
        }

        public void handle(TaskAttemptEvent event) {
            VertexImpl vertex = (VertexImpl)TestVertexImpl.this.vertexIdMap.get(event.getTaskAttemptID().getTaskID().getVertexID());
            Task task = vertex.getTask(event.getTaskAttemptID().getTaskID());
            ((EventHandler)task.getAttempt(event.getTaskAttemptID())).handle((Event)event);
        }
    }

    public static class CountingOutputCommitter
    extends OutputCommitter {
        public int initCounter = 0;
        public int setupCounter = 0;
        public int commitCounter = 0;
        public int abortCounter = 0;
        private boolean throwError;
        private boolean throwErrorOnAbort;
        private boolean throwRuntimeException;

        public CountingOutputCommitter(boolean throwError, boolean throwOnAbort, boolean throwRuntimeException) {
            this.throwError = throwError;
            this.throwErrorOnAbort = throwOnAbort;
            this.throwRuntimeException = throwRuntimeException;
        }

        public CountingOutputCommitter() {
            this(false, false, false);
        }

        public void initialize(OutputCommitterContext context) throws IOException {
            if (context.getUserPayload() != null) {
                CountingOutputCommitterConfig conf = new CountingOutputCommitterConfig(context.getUserPayload());
                this.throwError = conf.throwError;
                this.throwErrorOnAbort = conf.throwErrorOnAbort;
                this.throwRuntimeException = conf.throwRuntimeException;
            }
            ++this.initCounter;
        }

        public void setupOutput() throws IOException {
            ++this.setupCounter;
        }

        public void commitOutput() throws IOException {
            ++this.commitCounter;
            if (this.throwError) {
                if (!this.throwRuntimeException) {
                    throw new IOException("I can throwz exceptions in commit");
                }
                throw new RuntimeException("I can throwz exceptions in commit");
            }
        }

        public void abortOutput(VertexStatus.State finalState) throws IOException {
            ++this.abortCounter;
            if (this.throwErrorOnAbort) {
                if (!this.throwRuntimeException) {
                    throw new IOException("I can throwz exceptions in abort");
                }
                throw new RuntimeException("I can throwz exceptions in abort");
            }
        }

        public static class CountingOutputCommitterConfig
        implements Writable {
            boolean throwError = false;
            boolean throwErrorOnAbort = false;
            boolean throwRuntimeException = false;

            public CountingOutputCommitterConfig() {
            }

            public CountingOutputCommitterConfig(boolean throwError, boolean throwErrorOnAbort, boolean throwRuntimeException) {
                this.throwError = throwError;
                this.throwErrorOnAbort = throwErrorOnAbort;
                this.throwRuntimeException = throwRuntimeException;
            }

            public CountingOutputCommitterConfig(byte[] payload) throws IOException {
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(payload));
                this.readFields(in);
            }

            public void write(DataOutput out) throws IOException {
                out.writeBoolean(this.throwError);
                out.writeBoolean(this.throwErrorOnAbort);
                out.writeBoolean(this.throwRuntimeException);
            }

            public void readFields(DataInput in) throws IOException {
                this.throwError = in.readBoolean();
                this.throwErrorOnAbort = in.readBoolean();
                this.throwRuntimeException = in.readBoolean();
            }

            public byte[] toUserPayload() throws IOException {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(bos);
                this.write(out);
                return bos.toByteArray();
            }
        }
    }
}

