/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.TaskEventAddTezEvent;
import org.apache.tez.dag.app.dag.impl.Edge;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestEdge {
    @Test(timeout=5000L)
    public void testCompositeEventHandling() {
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        EdgeProperty edgeProp = new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)Mockito.mock(OutputDescriptor.class), (InputDescriptor)Mockito.mock(InputDescriptor.class));
        Edge edge = new Edge(edgeProp, eventHandler);
        TezVertexID srcVertexID = this.createVertexID(1);
        TezVertexID destVertexID = this.createVertexID(2);
        LinkedHashMap<TezTaskID, Task> srcTasks = this.mockTasks(srcVertexID, 1);
        LinkedHashMap<TezTaskID, Task> destTasks = this.mockTasks(destVertexID, 5);
        TezTaskID srcTaskID = srcTasks.keySet().iterator().next();
        Vertex srcVertex = this.mockVertex("src", srcVertexID, srcTasks);
        Vertex destVertex = this.mockVertex("dest", destVertexID, destTasks);
        edge.setSourceVertex(srcVertex);
        edge.setDestinationVertex(destVertex);
        edge.initialize();
        TezTaskAttemptID srcTAID = this.createTAIDForTest(srcTaskID, 2);
        EventMetaData srcMeta = new EventMetaData(EventMetaData.EventProducerConsumerType.OUTPUT, "consumerVertex", "producerVertex", srcTAID);
        CompositeDataMovementEvent cdmEvent = new CompositeDataMovementEvent(0, destTasks.size(), "bytes".getBytes());
        cdmEvent.setVersion(2);
        TezEvent tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)cdmEvent, srcMeta);
        edge.sendTezEventToDestinationTasks(tezEvent);
        ArgumentCaptor args = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)destTasks.size()))).handle((Event)args.capture());
        this.verifyEvents(args.getAllValues(), srcTAID, destTasks);
        Mockito.reset((Object[])new EventHandler[]{eventHandler});
        for (int i = 0; i < destTasks.size(); ++i) {
            DataMovementEvent dmEvent = new DataMovementEvent(i, "bytes".getBytes());
            dmEvent.setVersion(2);
            tezEvent = new TezEvent((org.apache.tez.runtime.api.Event)dmEvent, srcMeta);
            edge.sendTezEventToDestinationTasks(tezEvent);
        }
        args = ArgumentCaptor.forClass(Event.class);
        ((EventHandler)Mockito.verify((Object)eventHandler, (VerificationMode)Mockito.times((int)destTasks.size()))).handle((Event)args.capture());
        this.verifyEvents(args.getAllValues(), srcTAID, destTasks);
    }

    private void verifyEvents(List<Event> events, TezTaskAttemptID srcTAID, LinkedHashMap<TezTaskID, Task> destTasks) {
        int count = 0;
        Iterator<Map.Entry<TezTaskID, Task>> taskIter = destTasks.entrySet().iterator();
        for (Event event : events) {
            Map.Entry<TezTaskID, Task> expEntry = taskIter.next();
            Assert.assertTrue((boolean)(event instanceof TaskEventAddTezEvent));
            TaskEventAddTezEvent taEvent = (TaskEventAddTezEvent)event;
            Assert.assertEquals((Object)expEntry.getKey(), (Object)taEvent.getTaskID());
            TezEvent tezEvent = taEvent.getTezEvent();
            DataMovementEvent dmEvent = (DataMovementEvent)tezEvent.getEvent();
            Assert.assertEquals((long)srcTAID.getId(), (long)dmEvent.getVersion());
            Assert.assertEquals((long)count, (long)dmEvent.getSourceIndex());
            Assert.assertEquals((long)srcTAID.getTaskID().getId(), (long)dmEvent.getTargetIndex());
            Assert.assertTrue((boolean)Arrays.equals("bytes".getBytes(), dmEvent.getUserPayload()));
            ++count;
        }
    }

    private LinkedHashMap<TezTaskID, Task> mockTasks(TezVertexID vertexID, int numTasks) {
        LinkedHashMap<TezTaskID, Task> tasks = new LinkedHashMap<TezTaskID, Task>();
        for (int i = 0; i < numTasks; ++i) {
            Task task = (Task)Mockito.mock(Task.class);
            TezTaskID taskID = TezTaskID.getInstance((TezVertexID)vertexID, (int)i);
            ((Task)Mockito.doReturn((Object)taskID).when((Object)task)).getTaskId();
            tasks.put(taskID, task);
        }
        return tasks;
    }

    private Vertex mockVertex(String name, TezVertexID vertexID, LinkedHashMap<TezTaskID, Task> tasks) {
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        ((Vertex)Mockito.doReturn((Object)vertexID).when((Object)vertex)).getVertexId();
        ((Vertex)Mockito.doReturn((Object)name).when((Object)vertex)).getName();
        ((Vertex)Mockito.doReturn(tasks).when((Object)vertex)).getTasks();
        ((Vertex)Mockito.doReturn((Object)tasks.size()).when((Object)vertex)).getTotalTasks();
        for (Map.Entry<TezTaskID, Task> entry : tasks.entrySet()) {
            ((Vertex)Mockito.doReturn((Object)entry.getValue()).when((Object)vertex)).getTask((TezTaskID)Matchers.eq((Object)entry.getKey()));
            ((Vertex)Mockito.doReturn((Object)entry.getValue()).when((Object)vertex)).getTask(Matchers.eq((int)entry.getKey().getId()));
        }
        return vertex;
    }

    private TezVertexID createVertexID(int id) {
        TezDAGID dagID = TezDAGID.getInstance((String)"1000", (int)1, (int)1);
        TezVertexID vertexID = TezVertexID.getInstance((TezDAGID)dagID, (int)id);
        return vertexID;
    }

    private TezTaskAttemptID createTAIDForTest(TezTaskID taskID, int taId) {
        TezTaskAttemptID taskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)taskID, (int)taId);
        return taskAttemptID;
    }
}

