/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventSchedule;
import org.apache.tez.dag.app.dag.impl.DAGSchedulerMRR;
import org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrder;
import org.apache.tez.dag.app.rm.TaskSchedulerEventHandler;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDAGScheduler {
    MockEventHandler mockEventHandler = new MockEventHandler();

    @Test(timeout=10000L)
    public void testDAGSchedulerNaturalOrder() {
        DAG mockDag = (DAG)Mockito.mock(DAG.class);
        Vertex mockVertex = (Vertex)Mockito.mock(Vertex.class);
        TaskAttempt mockAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockDag.getVertex((TezVertexID)Mockito.any())).thenReturn((Object)mockVertex);
        Mockito.when((Object)mockVertex.getDistanceFromRoot()).thenReturn((Object)0).thenReturn((Object)1).thenReturn((Object)2);
        Mockito.when((Object)mockAttempt.getIsRescheduled()).thenReturn((Object)false);
        DAGEventSchedulerUpdate event = new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, mockAttempt);
        DAGSchedulerNaturalOrder scheduler = new DAGSchedulerNaturalOrder(mockDag, (EventHandler)this.mockEventHandler);
        scheduler.scheduleTask(event);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 2 ? 1 : 0) != 0);
        scheduler.scheduleTask(event);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 4 ? 1 : 0) != 0);
        scheduler.scheduleTask(event);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 6 ? 1 : 0) != 0);
        Mockito.when((Object)mockAttempt.getIsRescheduled()).thenReturn((Object)true);
        scheduler.scheduleTask(event);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 5 ? 1 : 0) != 0);
    }

    @Ignore
    @Test(timeout=10000L)
    public void testDAGSchedulerMRR() {
        DAG mockDag = (DAG)Mockito.mock(DAG.class);
        TezDAGID dagId = TezDAGID.getInstance((String)"1", (int)1, (int)1);
        TaskSchedulerEventHandler mockTaskScheduler = (TaskSchedulerEventHandler)Mockito.mock(TaskSchedulerEventHandler.class);
        Vertex mockVertex1 = (Vertex)Mockito.mock(Vertex.class);
        TezVertexID mockVertexId1 = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        Mockito.when((Object)mockVertex1.getVertexId()).thenReturn((Object)mockVertexId1);
        Mockito.when((Object)mockVertex1.getDistanceFromRoot()).thenReturn((Object)0);
        TaskAttempt mockAttempt1 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockAttempt1.getVertexID()).thenReturn((Object)mockVertexId1);
        Mockito.when((Object)mockAttempt1.getIsRescheduled()).thenReturn((Object)false);
        Mockito.when((Object)mockDag.getVertex(mockVertexId1)).thenReturn((Object)mockVertex1);
        Vertex mockVertex2 = (Vertex)Mockito.mock(Vertex.class);
        TezVertexID mockVertexId2 = TezVertexID.getInstance((TezDAGID)dagId, (int)2);
        Mockito.when((Object)mockVertex2.getVertexId()).thenReturn((Object)mockVertexId2);
        Mockito.when((Object)mockVertex2.getDistanceFromRoot()).thenReturn((Object)1);
        TaskAttempt mockAttempt2 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockAttempt2.getVertexID()).thenReturn((Object)mockVertexId2);
        Mockito.when((Object)mockAttempt2.getIsRescheduled()).thenReturn((Object)false);
        Mockito.when((Object)mockDag.getVertex(mockVertexId2)).thenReturn((Object)mockVertex2);
        TaskAttempt mockAttempt2f = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockAttempt2f.getVertexID()).thenReturn((Object)mockVertexId2);
        Mockito.when((Object)mockAttempt2f.getIsRescheduled()).thenReturn((Object)true);
        Vertex mockVertex3 = (Vertex)Mockito.mock(Vertex.class);
        TezVertexID mockVertexId3 = TezVertexID.getInstance((TezDAGID)dagId, (int)3);
        Mockito.when((Object)mockVertex3.getVertexId()).thenReturn((Object)mockVertexId3);
        Mockito.when((Object)mockVertex3.getDistanceFromRoot()).thenReturn((Object)2);
        TaskAttempt mockAttempt3 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockAttempt3.getVertexID()).thenReturn((Object)mockVertexId3);
        Mockito.when((Object)mockAttempt3.getIsRescheduled()).thenReturn((Object)false);
        Mockito.when((Object)mockDag.getVertex(mockVertexId3)).thenReturn((Object)mockVertex3);
        DAGEventSchedulerUpdate mockEvent1 = (DAGEventSchedulerUpdate)Mockito.mock(DAGEventSchedulerUpdate.class);
        Mockito.when((Object)mockEvent1.getAttempt()).thenReturn((Object)mockAttempt1);
        DAGEventSchedulerUpdate mockEvent2 = (DAGEventSchedulerUpdate)Mockito.mock(DAGEventSchedulerUpdate.class);
        Mockito.when((Object)mockEvent2.getAttempt()).thenReturn((Object)mockAttempt2);
        DAGEventSchedulerUpdate mockEvent2f = (DAGEventSchedulerUpdate)Mockito.mock(DAGEventSchedulerUpdate.class);
        Mockito.when((Object)mockEvent2f.getAttempt()).thenReturn((Object)mockAttempt2f);
        DAGEventSchedulerUpdate mockEvent3 = (DAGEventSchedulerUpdate)Mockito.mock(DAGEventSchedulerUpdate.class);
        Mockito.when((Object)mockEvent3.getAttempt()).thenReturn((Object)mockAttempt3);
        DAGSchedulerMRR scheduler = new DAGSchedulerMRR(mockDag, (EventHandler)this.mockEventHandler, mockTaskScheduler, 0.5f);
        scheduler.scheduleTask(mockEvent1);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 3 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent1);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 3 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex1);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 6 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 6 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2f);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 4 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex2);
        scheduler.scheduleTask(mockEvent3);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 9 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent3);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 9 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex3);
        scheduler.scheduleTask(mockEvent1);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 3 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 2 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent1);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 3 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 2 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2f);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 2 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex1);
        scheduler.scheduleTask(mockEvent3);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 5 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 6 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2f);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 4 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent3);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 5 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex2);
        scheduler.vertexCompleted(mockVertex3);
        scheduler.scheduleTask(mockEvent1);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 3 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex1);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 6 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent3);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 5 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 6 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex2);
        scheduler.vertexCompleted(mockVertex3);
        scheduler.scheduleTask(mockEvent1);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 3 ? 1 : 0) != 0);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 2 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex1);
        scheduler.scheduleTask(mockEvent2);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 6 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex2);
        scheduler.scheduleTask(mockEvent3);
        Assert.assertTrue((this.mockEventHandler.event.getPriority().getPriority() == 9 ? 1 : 0) != 0);
        scheduler.vertexCompleted(mockVertex3);
    }

    class MockEventHandler
    implements EventHandler<TaskAttemptEventSchedule> {
        TaskAttemptEventSchedule event;

        MockEventHandler() {
        }

        public void handle(TaskAttemptEventSchedule event) {
            this.event = event;
        }
    }
}

