/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.TaskAttemptListener;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.dag.DAGScheduler;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.DAGTerminationCause;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.VertexTerminationCause;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventDAGFinished;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventSchedulerUpdate;
import org.apache.tez.dag.app.dag.event.DAGEventStartDag;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.DAGEventVertexCompleted;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventTaskCompleted;
import org.apache.tez.dag.app.dag.event.VertexEventTaskReschedule;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.dag.impl.DAGSchedulerMRR;
import org.apache.tez.dag.app.dag.impl.TestVertexImpl;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.runtime.api.OutputCommitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDAGImpl {
    private static final Log LOG = LogFactory.getLog(TestDAGImpl.class);
    private DAGProtos.DAGPlan dagPlan;
    private TezDAGID dagId;
    private Configuration conf;
    private DrainDispatcher dispatcher;
    private Credentials fsTokens;
    private AppContext appContext;
    private ApplicationAttemptId appAttemptId;
    private DAGImpl dag;
    private TaskEventDispatcher taskEventDispatcher;
    private VertexEventDispatcher vertexEventDispatcher;
    private DagEventDispatcher dagEventDispatcher;
    private TaskAttemptListener taskAttemptListener;
    private TaskHeartbeatHandler thh;
    private Clock clock = new SystemClock();
    private DAGFinishEventHandler dagFinishEventHandler;
    private AppContext mrrAppContext;
    private DAGProtos.DAGPlan mrrDagPlan;
    private DAGImpl mrrDag;
    private TezDAGID mrrDagId;
    private AppContext groupAppContext;
    private DAGProtos.DAGPlan groupDagPlan;
    private DAGImpl groupDag;
    private TezDAGID groupDagId;
    private HistoryEventHandler historyEventHandler;

    private DAGProtos.DAGPlan createTestMRRDAGPlan() {
        LOG.info((Object)"Setting up MRR dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("testverteximpl").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host1").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x1.y1").build()).addOutputs(DAGProtos.RootInputLeafOutputProto.newBuilder().setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("output1").build()).setName("output1").setInitializerClassName(TestVertexImpl.CountingOutputCommitter.class.getName())).addOutEdgeId("e1").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex2").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host2").addRack("rack2").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x2.y2").build()).addOutputs(DAGProtos.RootInputLeafOutputProto.newBuilder().setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("output2").build()).setName("output2").setInitializerClassName(TestVertexImpl.CountingOutputCommitter.class.getName())).addInEdgeId("e1").addOutEdgeId("e2").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex3").setType(DAGProtos.PlanVertexType.NORMAL).setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("x3.y3")).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host3").addRack("rack3").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("foo").setTaskModule("x3.y3").build()).addOutputs(DAGProtos.RootInputLeafOutputProto.newBuilder().setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("output3").build()).setName("output3").setInitializerClassName(TestVertexImpl.CountingOutputCommitter.class.getName())).addInEdgeId("e2").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i2")).setInputVertexName("vertex1").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o1")).setOutputVertexName("vertex2").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e1").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i3")).setInputVertexName("vertex2").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex3").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e2").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).build();
        return dag;
    }

    private DAGProtos.DAGPlan createGroupDAGPlan() {
        LOG.info((Object)"Setting up group dag plan");
        int dummyTaskCount = 1;
        Resource dummyTaskResource = Resource.newInstance((int)1, (int)1);
        org.apache.tez.dag.api.Vertex v1 = new org.apache.tez.dag.api.Vertex("vertex1", new ProcessorDescriptor("Processor"), dummyTaskCount, dummyTaskResource);
        org.apache.tez.dag.api.Vertex v2 = new org.apache.tez.dag.api.Vertex("vertex2", new ProcessorDescriptor("Processor"), dummyTaskCount, dummyTaskResource);
        org.apache.tez.dag.api.Vertex v3 = new org.apache.tez.dag.api.Vertex("vertex3", new ProcessorDescriptor("Processor"), dummyTaskCount, dummyTaskResource);
        DAG dag = new DAG("testDag");
        String groupName1 = "uv12";
        VertexGroup uv12 = dag.createVertexGroup(groupName1, new org.apache.tez.dag.api.Vertex[]{v1, v2});
        OutputDescriptor outDesc = new OutputDescriptor("output.class");
        uv12.addOutput("uvOut", outDesc, TotalCountingOutputCommitter.class);
        v3.addOutput("uvOut", outDesc, TotalCountingOutputCommitter.class);
        GroupInputEdge e1 = new GroupInputEdge(uv12, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")), new InputDescriptor("merge.class"));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addEdge(e1);
        return dag.createDag(this.conf);
    }

    private DAGProtos.DAGPlan createTestDAGPlan() {
        LOG.info((Object)"Setting up dag plan");
        DAGProtos.DAGPlan dag = DAGProtos.DAGPlan.newBuilder().setName("testverteximpl").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host1").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(1).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x1.y1").build()).addOutEdgeId("e1").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex2").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host2").addRack("rack2").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x2.y2").build()).addOutEdgeId("e2").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex3").setType(DAGProtos.PlanVertexType.NORMAL).setProcessorDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("x3.y3")).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host3").addRack("rack3").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("foo").setTaskModule("x3.y3").build()).addInEdgeId("e1").addInEdgeId("e2").addOutEdgeId("e3").addOutEdgeId("e4").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex4").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host4").addRack("rack4").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x4.y4").build()).addInEdgeId("e3").addOutEdgeId("e5").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex5").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host5").addRack("rack5").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x5.y5").build()).addInEdgeId("e4").addOutEdgeId("e6").build()).addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex6").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("host6").addRack("rack6").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x6.y6").build()).addInEdgeId("e5").addInEdgeId("e6").build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i3_v1")).setInputVertexName("vertex1").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o1")).setOutputVertexName("vertex3").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e1").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i3_v2")).setInputVertexName("vertex2").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o2")).setOutputVertexName("vertex3").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e2").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i4_v3")).setInputVertexName("vertex3").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o3_v4")).setOutputVertexName("vertex4").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e3").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i5_v3")).setInputVertexName("vertex3").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o3_v5")).setOutputVertexName("vertex5").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e4").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i6_v4")).setInputVertexName("vertex4").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o4")).setOutputVertexName("vertex6").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e5").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).addEdge(DAGProtos.EdgePlan.newBuilder().setEdgeDestination(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("i6_v5")).setInputVertexName("vertex5").setEdgeSource(DAGProtos.TezEntityDescriptorProto.newBuilder().setClassName("o5")).setOutputVertexName("vertex6").setDataMovementType(DAGProtos.PlanEdgeDataMovementType.SCATTER_GATHER).setId("e6").setDataSourceType(DAGProtos.PlanEdgeDataSourceType.PERSISTED).setSchedulingType(DAGProtos.PlanEdgeSchedulingType.SEQUENTIAL).build()).build();
        return dag;
    }

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.conf.setBoolean("tez.am.container.reuse.enabled", false);
        this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)100L, (int)1), (int)1);
        this.dagId = TezDAGID.getInstance((ApplicationId)this.appAttemptId.getApplicationId(), (int)1);
        Assert.assertNotNull((Object)this.dagId);
        this.dagPlan = this.createTestDAGPlan();
        this.dispatcher = new DrainDispatcher();
        this.fsTokens = new Credentials();
        this.appContext = (AppContext)Mockito.mock(AppContext.class);
        this.historyEventHandler = (HistoryEventHandler)Mockito.mock(HistoryEventHandler.class);
        ((AppContext)Mockito.doReturn((Object)this.conf).when((Object)this.appContext)).getAMConf();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId).when((Object)this.appContext)).getApplicationAttemptId();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId.getApplicationId()).when((Object)this.appContext)).getApplicationID();
        ((AppContext)Mockito.doReturn((Object)this.dagId).when((Object)this.appContext)).getCurrentDAGID();
        ((AppContext)Mockito.doReturn((Object)this.historyEventHandler).when((Object)this.appContext)).getHistoryHandler();
        this.dag = new DAGImpl(this.dagId, this.conf, this.dagPlan, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.fsTokens, this.clock, "user", this.thh, this.appContext);
        ((AppContext)Mockito.doReturn((Object)this.dag).when((Object)this.appContext)).getCurrentDAG();
        this.mrrAppContext = (AppContext)Mockito.mock(AppContext.class);
        this.mrrDagId = TezDAGID.getInstance((ApplicationId)this.appAttemptId.getApplicationId(), (int)2);
        this.mrrDagPlan = this.createTestMRRDAGPlan();
        this.mrrDag = new DAGImpl(this.mrrDagId, this.conf, this.mrrDagPlan, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.fsTokens, this.clock, "user", this.thh, this.mrrAppContext);
        ((AppContext)Mockito.doReturn((Object)this.conf).when((Object)this.mrrAppContext)).getAMConf();
        ((AppContext)Mockito.doReturn((Object)this.mrrDag).when((Object)this.mrrAppContext)).getCurrentDAG();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId).when((Object)this.mrrAppContext)).getApplicationAttemptId();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId.getApplicationId()).when((Object)this.mrrAppContext)).getApplicationID();
        ((AppContext)Mockito.doReturn((Object)this.historyEventHandler).when((Object)this.mrrAppContext)).getHistoryHandler();
        this.groupAppContext = (AppContext)Mockito.mock(AppContext.class);
        this.groupDagId = TezDAGID.getInstance((ApplicationId)this.appAttemptId.getApplicationId(), (int)3);
        this.groupDagPlan = this.createGroupDAGPlan();
        this.groupDag = new DAGImpl(this.groupDagId, this.conf, this.groupDagPlan, this.dispatcher.getEventHandler(), this.taskAttemptListener, this.fsTokens, this.clock, "user", this.thh, this.groupAppContext);
        ((AppContext)Mockito.doReturn((Object)this.conf).when((Object)this.groupAppContext)).getAMConf();
        ((AppContext)Mockito.doReturn((Object)this.groupDag).when((Object)this.groupAppContext)).getCurrentDAG();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId).when((Object)this.groupAppContext)).getApplicationAttemptId();
        ((AppContext)Mockito.doReturn((Object)this.appAttemptId.getApplicationId()).when((Object)this.groupAppContext)).getApplicationID();
        ((AppContext)Mockito.doReturn((Object)this.historyEventHandler).when((Object)this.groupAppContext)).getHistoryHandler();
        this.taskEventDispatcher = new TaskEventDispatcher();
        this.dispatcher.register(TaskEventType.class, (EventHandler)this.taskEventDispatcher);
        this.vertexEventDispatcher = new VertexEventDispatcher();
        this.dispatcher.register(VertexEventType.class, (EventHandler)this.vertexEventDispatcher);
        this.dagEventDispatcher = new DagEventDispatcher();
        this.dispatcher.register(DAGEventType.class, (EventHandler)this.dagEventDispatcher);
        this.dagFinishEventHandler = new DAGFinishEventHandler();
        this.dispatcher.register(DAGAppMasterEventType.class, (EventHandler)this.dagFinishEventHandler);
        this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventHandler());
        this.dispatcher.init(this.conf);
        this.dispatcher.start();
    }

    @After
    public void teardown() {
        this.dispatcher.await();
        this.dispatcher.stop();
        this.dagPlan = null;
        this.dag = null;
    }

    private void initDAG(DAGImpl impl) {
        impl.handle(new DAGEvent(impl.getID(), DAGEventType.DAG_INIT));
        Assert.assertEquals((Object)DAGState.INITED, (Object)impl.getState());
    }

    private void startDAG(DAGImpl impl) {
        this.dispatcher.getEventHandler().handle((Event)new DAGEventStartDag(impl.getID(), null));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)impl.getState());
    }

    @Test(timeout=5000L)
    public void testDAGInit() {
        this.initDAG(this.dag);
        Assert.assertEquals((long)6L, (long)this.dag.getTotalVertices());
    }

    @Test(timeout=5000L)
    public void testDAGStart() {
        TezVertexID vId;
        int i;
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        for (i = 0; i < 6; ++i) {
            vId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)i);
            Vertex v = this.dag.getVertex(vId);
            Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
            if (i < 2) {
                Assert.assertEquals((long)0L, (long)v.getDistanceFromRoot());
                continue;
            }
            if (i == 2) {
                Assert.assertEquals((long)1L, (long)v.getDistanceFromRoot());
                continue;
            }
            if (i > 2 && i < 5) {
                Assert.assertEquals((long)2L, (long)v.getDistanceFromRoot());
                continue;
            }
            if (i != 5) continue;
            Assert.assertEquals((long)3L, (long)v.getDistanceFromRoot());
        }
        for (i = 0; i < 6; ++i) {
            vId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)i);
            LOG.info((Object)("Distance from root: v" + i + ":" + this.dag.getVertex(vId).getDistanceFromRoot()));
        }
    }

    @Test(timeout=5000L)
    public void testVertexCompletion() {
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)1);
        Vertex v = this.dag.getVertex(vId);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)vId, (int)0), TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)vId, (int)1), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dag.getSuccessfulVertices());
    }

    @Test(timeout=5000L)
    public void testGroupDAGCompletionWithCommitSuccess() {
        this.initDAG(this.groupDag);
        this.startDAG(this.groupDag);
        this.dispatcher.await();
        for (int i = 0; i < 3; ++i) {
            Vertex v = this.groupDag.getVertex("vertex" + (i + 1));
            this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
            this.dispatcher.await();
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
            Assert.assertEquals((long)(i + 1), (long)this.groupDag.getSuccessfulVertices());
        }
        Assert.assertEquals((long)3L, (long)this.groupDag.getSuccessfulVertices());
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)this.groupDag.getState());
        Assert.assertEquals((long)2L, (long)TotalCountingOutputCommitter.totalCommitCounter);
    }

    @Test(timeout=5000L)
    public void testDAGCompletionWithCommitSuccess() {
        this.initDAG(this.mrrDag);
        this.dispatcher.await();
        this.startDAG(this.mrrDag);
        this.dispatcher.await();
        for (int i = 0; i < 2; ++i) {
            Vertex v = this.mrrDag.getVertex("vertex" + (i + 1));
            this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
            this.dispatcher.await();
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
            Assert.assertEquals((long)(i + 1), (long)this.mrrDag.getSuccessfulVertices());
        }
        for (Vertex v : this.mrrDag.vertices.values()) {
            for (OutputCommitter c : v.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                Assert.assertEquals((long)0L, (long)committer.abortCounter);
                Assert.assertEquals((long)0L, (long)committer.commitCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
        Vertex v = this.mrrDag.getVertex("vertex3");
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)3L, (long)this.mrrDag.getSuccessfulVertices());
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)this.mrrDag.getState());
        for (Vertex vertex : this.mrrDag.vertices.values()) {
            for (OutputCommitter c : vertex.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                Assert.assertEquals((long)0L, (long)committer.abortCounter);
                Assert.assertEquals((long)1L, (long)committer.commitCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
    }

    @Test(timeout=5000L)
    public void testDAGCompletionWithCommitFailure() throws IOException {
        this.initDAG(this.mrrDag);
        this.dispatcher.await();
        Vertex badVertex = this.mrrDag.getVertex("vertex3");
        ArrayList<DAGProtos.RootInputLeafOutputProto> outputs = new ArrayList<DAGProtos.RootInputLeafOutputProto>();
        outputs.add(DAGProtos.RootInputLeafOutputProto.newBuilder().setInitializerClassName(TestVertexImpl.CountingOutputCommitter.class.getName()).setName("output3").setEntityDescriptor(DAGProtos.TezEntityDescriptorProto.newBuilder().setUserPayload(ByteString.copyFrom((byte[])new TestVertexImpl.CountingOutputCommitter.CountingOutputCommitterConfig(true, false, false).toUserPayload())).build()).build());
        badVertex.setAdditionalOutputs(outputs);
        this.startDAG(this.mrrDag);
        this.dispatcher.await();
        for (int i = 0; i < 2; ++i) {
            Vertex v = this.mrrDag.getVertex("vertex" + (i + 1));
            this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
            this.dispatcher.await();
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
            Assert.assertEquals((long)(i + 1), (long)this.mrrDag.getSuccessfulVertices());
        }
        for (Vertex v : this.mrrDag.vertices.values()) {
            for (OutputCommitter c : v.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                Assert.assertEquals((long)0L, (long)committer.abortCounter);
                Assert.assertEquals((long)0L, (long)committer.commitCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
        Vertex v = this.mrrDag.getVertex("vertex3");
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)3L, (long)this.mrrDag.getSuccessfulVertices());
        Assert.assertEquals((Object)DAGState.FAILED, (Object)this.mrrDag.getState());
        Assert.assertEquals((Object)DAGTerminationCause.COMMIT_FAILURE, (Object)this.mrrDag.getTerminationCause());
        for (Vertex vertex : this.mrrDag.vertices.values()) {
            for (OutputCommitter c : vertex.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                Assert.assertEquals((long)1L, (long)committer.abortCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
    }

    @Test(timeout=5000L)
    public void testDAGErrorAbortAllOutputs() {
        this.initDAG(this.mrrDag);
        this.dispatcher.await();
        this.startDAG(this.mrrDag);
        this.dispatcher.await();
        for (int i = 0; i < 2; ++i) {
            Vertex v = this.mrrDag.getVertex("vertex" + (i + 1));
            this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
            this.dispatcher.await();
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
            Assert.assertEquals((long)(i + 1), (long)this.mrrDag.getSuccessfulVertices());
        }
        for (Vertex v : this.mrrDag.vertices.values()) {
            for (OutputCommitter c : v.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                Assert.assertEquals((long)0L, (long)committer.abortCounter);
                Assert.assertEquals((long)0L, (long)committer.commitCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
        Vertex v = this.mrrDag.getVertex("vertex3");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(v.getVertexId(), VertexEventType.V_INTERNAL_ERROR));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.ERROR, (Object)v.getState());
        Assert.assertEquals((Object)DAGState.ERROR, (Object)this.mrrDag.getState());
        for (Vertex vertex : this.mrrDag.vertices.values()) {
            for (OutputCommitter c : vertex.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                Assert.assertEquals((long)1L, (long)committer.abortCounter);
                Assert.assertEquals((long)0L, (long)committer.commitCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
    }

    @Test(timeout=5000L)
    public void testDAGErrorAbortNonSuccessfulOutputs() {
        this.conf.setBoolean("tez.am.commit-all-outputs-on-dag-success", false);
        this.initDAG(this.mrrDag);
        this.dispatcher.await();
        this.startDAG(this.mrrDag);
        this.dispatcher.await();
        for (int i = 0; i < 2; ++i) {
            Vertex v = this.mrrDag.getVertex("vertex" + (i + 1));
            this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)v.getVertexId(), (int)0), TaskState.SUCCEEDED));
            this.dispatcher.await();
            Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
            Assert.assertEquals((long)(i + 1), (long)this.mrrDag.getSuccessfulVertices());
            for (OutputCommitter c : v.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                Assert.assertEquals((long)0L, (long)committer.abortCounter);
                Assert.assertEquals((long)1L, (long)committer.commitCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
        Vertex errorVertex = this.mrrDag.getVertex("vertex3");
        this.dispatcher.getEventHandler().handle((Event)new VertexEvent(errorVertex.getVertexId(), VertexEventType.V_INTERNAL_ERROR));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.ERROR, (Object)errorVertex.getState());
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.ERROR, (Object)this.mrrDag.getState());
        for (Vertex vertex : this.mrrDag.vertices.values()) {
            for (OutputCommitter c : vertex.getOutputCommitters().values()) {
                TestVertexImpl.CountingOutputCommitter committer = (TestVertexImpl.CountingOutputCommitter)c;
                if (vertex == errorVertex) {
                    Assert.assertEquals((long)1L, (long)committer.abortCounter);
                    Assert.assertEquals((long)0L, (long)committer.commitCounter);
                    Assert.assertEquals((long)1L, (long)committer.initCounter);
                    Assert.assertEquals((long)1L, (long)committer.setupCounter);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)committer.abortCounter);
                Assert.assertEquals((long)1L, (long)committer.commitCounter);
                Assert.assertEquals((long)1L, (long)committer.initCounter);
                Assert.assertEquals((long)1L, (long)committer.setupCounter);
            }
        }
    }

    @Test(timeout=5000L)
    public void testVertexReRunning() {
        this.initDAG(this.dag);
        this.dag.dagScheduler = (DAGScheduler)Mockito.mock(DAGScheduler.class);
        this.startDAG(this.dag);
        this.dispatcher.await();
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)1);
        Vertex v = this.dag.getVertex(vId);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)vId, (int)0), TaskState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)vId, (int)1), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dag.getSuccessfulVertices());
        Assert.assertEquals((long)1L, (long)this.dag.numCompletedVertices);
        ((DAGScheduler)Mockito.verify((Object)this.dag.dagScheduler, (VerificationMode)Mockito.times((int)1))).vertexCompleted(v);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskReschedule(TezTaskID.getInstance((TezVertexID)vId, (int)0)));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v.getState());
        Assert.assertEquals((long)0L, (long)this.dag.getSuccessfulVertices());
        Assert.assertEquals((long)0L, (long)this.dag.numCompletedVertices);
        this.dispatcher.getEventHandler().handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)vId, (int)0), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v.getState());
        Assert.assertEquals((long)1L, (long)this.dag.getSuccessfulVertices());
        Assert.assertEquals((long)1L, (long)this.dag.numCompletedVertices);
        ((DAGScheduler)Mockito.verify((Object)this.dag.dagScheduler, (VerificationMode)Mockito.times((int)1))).vertexCompleted(v);
    }

    public void testKillStartedDAG() {
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        this.dispatcher.getEventHandler().handle((Event)new DAGEvent(this.dagId, DAGEventType.DAG_KILL));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.KILLED, (Object)this.dag.getState());
        for (int i = 0; i < 6; ++i) {
            TezVertexID vId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)i);
            Vertex v = this.dag.getVertex(vId);
            Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        }
    }

    @Test(timeout=5000L)
    public void testKillRunningDAG() {
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        TezVertexID vId1 = TezVertexID.getInstance((TezDAGID)this.dagId, (int)1);
        Vertex v1 = this.dag.getVertex(vId1);
        ((EventHandler)v1).handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)vId1, (int)0), TaskState.SUCCEEDED));
        TezVertexID vId0 = TezVertexID.getInstance((TezDAGID)this.dagId, (int)0);
        Vertex v0 = this.dag.getVertex(vId0);
        ((EventHandler)v0).handle((Event)new VertexEventTaskCompleted(TezTaskID.getInstance((TezVertexID)vId0, (int)0), TaskState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v0.getState());
        Assert.assertEquals((Object)VertexState.RUNNING, (Object)v1.getState());
        this.dispatcher.getEventHandler().handle((Event)new DAGEvent(this.dagId, DAGEventType.DAG_KILL));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.TERMINATING, (Object)this.dag.getState());
        Assert.assertEquals((Object)VertexState.SUCCEEDED, (Object)v0.getState());
        Assert.assertEquals((Object)VertexState.TERMINATING, (Object)v1.getState());
        for (int i = 2; i < 6; ++i) {
            TezVertexID vId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)i);
            Vertex v = this.dag.getVertex(vId);
            Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        }
        Assert.assertEquals((long)1L, (long)this.dag.getSuccessfulVertices());
    }

    @Test(timeout=5000L)
    public void testInvalidEvent() {
        this.dispatcher.getEventHandler().handle((Event)new DAGEventStartDag(this.dagId, null));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.ERROR, (Object)this.dag.getState());
    }

    @Test(timeout=5000L)
    @Ignore
    public void testVertexSuccessfulCompletionUpdates() {
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        for (int i = 0; i < 6; ++i) {
            this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)0), VertexState.SUCCEEDED));
        }
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
        Assert.assertEquals((long)1L, (long)this.dag.getSuccessfulVertices());
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)1), VertexState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)2), VertexState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)3), VertexState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)4), VertexState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)5), VertexState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.SUCCEEDED, (Object)this.dag.getState());
        Assert.assertEquals((long)6L, (long)this.dag.getSuccessfulVertices());
    }

    @Test(timeout=5000L)
    public void testVertexFailureHandling() {
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)0), VertexState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)1), VertexState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)2), VertexState.FAILED));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.FAILED, (Object)this.dag.getState());
        Assert.assertEquals((long)2L, (long)this.dag.getSuccessfulVertices());
        for (int i = 3; i < 6; ++i) {
            TezVertexID vId = TezVertexID.getInstance((TezDAGID)this.dagId, (int)i);
            Vertex v = this.dag.getVertex(vId);
            Assert.assertEquals((Object)VertexState.KILLED, (Object)v.getState());
        }
    }

    @Test(timeout=5000L)
    public void testDAGKill() {
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)0), VertexState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)1), VertexState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new DAGEvent(this.dagId, DAGEventType.DAG_KILL));
        for (int i = 2; i < 6; ++i) {
            this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)i), VertexState.SUCCEEDED));
        }
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.KILLED, (Object)this.dag.getState());
        Assert.assertEquals((Object)DAGTerminationCause.DAG_KILL, (Object)this.dag.getTerminationCause());
        Assert.assertEquals((long)6L, (long)this.dag.getSuccessfulVertices());
        for (Vertex v : this.dag.getVertices().values()) {
            Assert.assertEquals((Object)VertexTerminationCause.DAG_KILL, (Object)v.getTerminationCause());
        }
        Assert.assertEquals((long)1L, (long)this.dagFinishEventHandler.dagFinishEvents);
    }

    @Test(timeout=5000L)
    public void testDAGKillPending() {
        this.initDAG(this.dag);
        this.startDAG(this.dag);
        this.dispatcher.await();
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)0), VertexState.SUCCEEDED));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.RUNNING, (Object)this.dag.getState());
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)1), VertexState.SUCCEEDED));
        this.dispatcher.getEventHandler().handle((Event)new DAGEvent(this.dagId, DAGEventType.DAG_KILL));
        for (int i = 2; i < 5; ++i) {
            this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)i), VertexState.SUCCEEDED));
        }
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.KILLED, (Object)this.dag.getState());
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(TezVertexID.getInstance((TezDAGID)this.dagId, (int)5), VertexState.KILLED));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.KILLED, (Object)this.dag.getState());
        Assert.assertEquals((long)5L, (long)this.dag.getSuccessfulVertices());
        Assert.assertEquals((Object)this.dag.getVertex(TezVertexID.getInstance((TezDAGID)this.dagId, (int)5)).getTerminationCause(), (Object)VertexTerminationCause.DAG_KILL);
        Assert.assertEquals((long)1L, (long)this.dagFinishEventHandler.dagFinishEvents);
    }

    @Test(timeout=5000L)
    public void testDiagnosticUpdates() {
    }

    @Test(timeout=5000L)
    public void testCounterUpdates() {
    }

    @Ignore
    @Test(timeout=5000L)
    public void testOutofBandFailureForMRRScheduler() {
        this.initDAG(this.mrrDag);
        this.dispatcher.await();
        Assert.assertTrue((boolean)(this.mrrDag.dagScheduler instanceof DAGSchedulerMRR));
        this.startDAG(this.mrrDag);
        this.dispatcher.await();
        TaskAttempt attempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        ((TaskAttempt)Mockito.doReturn((Object)this.mrrDag.getVertex("vertex1").getVertexId()).when((Object)attempt)).getVertexID();
        DAGEventSchedulerUpdate scheduleEvent = new DAGEventSchedulerUpdate(DAGEventSchedulerUpdate.UpdateType.TA_SCHEDULE, attempt);
        this.dispatcher.getEventHandler().handle((Event)scheduleEvent);
        this.dispatcher.await();
        this.dispatcher.getEventHandler().handle((Event)new DAGEventVertexCompleted(this.mrrDag.getVertex("vertex2").getVertexId(), VertexState.FAILED));
        this.dispatcher.await();
        Assert.assertEquals((Object)DAGState.FAILED, (Object)this.mrrDag.getState());
    }

    public static class TotalCountingOutputCommitter
    extends TestVertexImpl.CountingOutputCommitter {
        static int totalCommitCounter = 0;

        @Override
        public void commitOutput() throws IOException {
            ++totalCommitCounter;
            super.commitOutput();
        }
    }

    private class DAGFinishEventHandler
    implements EventHandler<DAGAppMasterEventDAGFinished> {
        public int dagFinishEvents = 0;

        private DAGFinishEventHandler() {
        }

        public void handle(DAGAppMasterEventDAGFinished event) {
            ++this.dagFinishEvents;
        }
    }

    private class VertexEventDispatcher
    implements EventHandler<VertexEvent> {
        private VertexEventDispatcher() {
        }

        public void handle(VertexEvent event) {
            TezDAGID id = event.getVertexId().getDAGId();
            DAGImpl handler = id.equals((Object)TestDAGImpl.this.dagId) ? TestDAGImpl.this.dag : (id.equals((Object)TestDAGImpl.this.mrrDagId) ? TestDAGImpl.this.mrrDag : TestDAGImpl.this.groupDag);
            Vertex vertex = handler.getVertex(event.getVertexId());
            ((EventHandler)vertex).handle((Event)event);
        }
    }

    private class TaskEventDispatcher
    implements EventHandler<TaskEvent> {
        private TaskEventDispatcher() {
        }

        public void handle(TaskEvent event) {
            TezDAGID id = event.getTaskID().getVertexID().getDAGId();
            DAGImpl handler = id.equals((Object)TestDAGImpl.this.dagId) ? TestDAGImpl.this.dag : (id.equals((Object)TestDAGImpl.this.mrrDagId) ? TestDAGImpl.this.mrrDag : TestDAGImpl.this.groupDag);
            Vertex vertex = handler.getVertex(event.getTaskID().getVertexID());
            Task task = vertex.getTask(event.getTaskID());
            ((EventHandler)task).handle((Event)event);
        }
    }

    private class TaskEventHandler
    implements EventHandler<TaskEvent> {
        private TaskEventHandler() {
        }

        public void handle(TaskEvent event) {
        }
    }

    private class DagEventDispatcher
    implements EventHandler<DAGEvent> {
        private DagEventDispatcher() {
        }

        public void handle(DAGEvent event) {
            if (event.getDAGId().equals((Object)TestDAGImpl.this.dagId)) {
                TestDAGImpl.this.dag.handle(event);
            } else if (event.getDAGId().equals((Object)TestDAGImpl.this.mrrDagId)) {
                TestDAGImpl.this.mrrDag.handle(event);
            } else if (event.getDAGId().equals((Object)TestDAGImpl.this.groupDagId)) {
                TestDAGImpl.this.groupDag.handle(event);
            } else {
                throw new RuntimeException("Invalid event, unknown dag, dagId=" + event.getDAGId());
            }
        }
    }
}

