/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.tez.common.EnvironmentUpdateUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestEnvironmentUpdateUtils {
    @Test
    public void testMultipleUpdateEnvironment() {
        EnvironmentUpdateUtils.put((String)"test.environment1", (String)"test.value1");
        EnvironmentUpdateUtils.put((String)"test.environment2", (String)"test.value2");
        Assert.assertEquals((String)"Environment was not set propertly", (Object)"test.value1", (Object)System.getenv("test.environment1"));
        Assert.assertEquals((String)"Environment was not set propertly", (Object)"test.value2", (Object)System.getenv("test.environment2"));
    }

    @Test
    public void testConcurrentRequests() throws InterruptedException {
        int concurThread;
        int timeoutSecond = 5;
        int exceptionCount = 0;
        ArrayList tasks = new ArrayList();
        ArrayList<ListenableFuture> pendingTasks = new ArrayList<ListenableFuture>();
        ExecutorService callbackExecutor = Executors.newFixedThreadPool(concurThread, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("CallbackExecutor").build());
        ListeningExecutorService taskExecutorService = MoreExecutors.listeningDecorator((ExecutorService)callbackExecutor);
        for (concurThread = 10; concurThread > 0; --concurThread) {
            ListenableFuture runningTaskFuture = taskExecutorService.submit((Callable)new EnvironmentRequest());
            pendingTasks.add(runningTaskFuture);
        }
        for (ListenableFuture future : pendingTasks) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                ++exceptionCount;
            }
        }
        taskExecutorService.shutdown();
        try {
            if (!taskExecutorService.awaitTermination((long)timeoutSecond, TimeUnit.SECONDS)) {
                taskExecutorService.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            taskExecutorService.shutdownNow();
        }
        Assert.assertEquals((long)0L, (long)exceptionCount);
    }

    private class EnvironmentRequest
    implements Callable<Object> {
        private EnvironmentRequest() {
        }

        @Override
        public Object call() throws Exception {
            EnvironmentUpdateUtils.put((String)("test.environment.concurrent" + Thread.currentThread().getId()), (String)"test.evironment.concurrent");
            return null;
        }
    }
}

