/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.BitSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestTezUtils {
    @Test
    public void testByteStringToAndFromConf() throws IOException {
        Configuration conf = this.getConf();
        Assert.assertEquals((long)conf.size(), (long)6L);
        ByteString bsConf = TezUtils.createByteStringFromConf((Configuration)conf);
        conf.clear();
        Assert.assertEquals((long)conf.size(), (long)0L);
        conf = TezUtils.createConfFromByteString((ByteString)bsConf);
        Assert.assertEquals((long)conf.size(), (long)6L);
        this.checkConf(conf);
    }

    @Test
    public void testPayloadToAndFromConf() throws IOException {
        Configuration conf = this.getConf();
        Assert.assertEquals((long)conf.size(), (long)6L);
        byte[] bConf = TezUtils.createUserPayloadFromConf((Configuration)conf);
        conf.clear();
        Assert.assertEquals((long)conf.size(), (long)0L);
        conf = TezUtils.createConfFromUserPayload((byte[])bConf);
        Assert.assertEquals((long)conf.size(), (long)6L);
        this.checkConf(conf);
    }

    @Test
    public void testCleanVertexName() {
        String testString = "special characters & spaces and longer than 40 characters";
        Assert.assertTrue((testString.length() > 40 ? 1 : 0) != 0);
        String cleaned = TezUtils.cleanVertexName((String)testString);
        Assert.assertTrue((cleaned.length() <= 40 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)cleaned.contains("\\s+"));
        Assert.assertTrue((boolean)cleaned.matches("\\w+"));
    }

    @Test
    public void testBitSetToByteArray() {
        BitSet bitSet = this.createBitSet(0);
        byte[] bytes = TezUtils.toByteArray((BitSet)bitSet);
        Assert.assertTrue((bytes.length == bitSet.length() / 8 + 1 ? 1 : 0) != 0);
        bitSet = this.createBitSet(1000);
        bytes = TezUtils.toByteArray((BitSet)bitSet);
        Assert.assertTrue((bytes.length == bitSet.length() / 8 + 1 ? 1 : 0) != 0);
    }

    @Test
    public void testBitSetFromByteArray() {
        BitSet bitSet = this.createBitSet(0);
        byte[] bytes = TezUtils.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)TezUtils.fromByteArray((byte[])bytes).cardinality(), (long)bitSet.cardinality());
        Assert.assertTrue((boolean)TezUtils.fromByteArray((byte[])bytes).equals(bitSet));
        bitSet = this.createBitSet(1);
        bytes = TezUtils.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)TezUtils.fromByteArray((byte[])bytes).cardinality(), (long)bitSet.cardinality());
        Assert.assertTrue((boolean)TezUtils.fromByteArray((byte[])bytes).equals(bitSet));
        bitSet = this.createBitSet(1000);
        bytes = TezUtils.toByteArray((BitSet)bitSet);
        Assert.assertEquals((long)TezUtils.fromByteArray((byte[])bytes).cardinality(), (long)bitSet.cardinality());
        Assert.assertTrue((boolean)TezUtils.fromByteArray((byte[])bytes).equals(bitSet));
    }

    @Test
    public void testBitSetConversion() {
        for (int i = 0; i < 16; ++i) {
            BitSet bitSet = this.createBitSetWithSingleEntry(i);
            byte[] bytes = TezUtils.toByteArray((BitSet)bitSet);
            BitSet deseraialized = TezUtils.fromByteArray((byte[])bytes);
            Assert.assertEquals((Object)bitSet, (Object)deseraialized);
            Assert.assertEquals((long)bitSet.cardinality(), (long)deseraialized.cardinality());
            Assert.assertEquals((long)1L, (long)deseraialized.cardinality());
        }
    }

    private BitSet createBitSet(int size) {
        BitSet bitSet = new BitSet();
        int bitsToEnable = (int)((double)size * 0.1);
        Random rnd = new Random();
        for (int i = 0; i < bitsToEnable; ++i) {
            bitSet.set(rnd.nextInt(size));
        }
        return bitSet;
    }

    private BitSet createBitSetWithSingleEntry(int bitToSet) {
        BitSet bitSet = new BitSet();
        bitSet.set(bitToSet);
        return bitSet;
    }

    private Configuration getConf() {
        Configuration conf = new Configuration(false);
        conf.set("test1", "value1");
        conf.setBoolean("test2", true);
        conf.setDouble("test3", 1.2345);
        conf.setInt("test4", 34567);
        conf.setLong("test5", 1234567890L);
        conf.setStrings("test6", new String[]{"S1", "S2", "S3"});
        return conf;
    }

    private void checkConf(Configuration conf) {
        Assert.assertEquals((Object)conf.get("test1"), (Object)"value1");
        Assert.assertTrue((boolean)conf.getBoolean("test2", false));
        Assert.assertEquals((double)conf.getDouble("test3", 0.0), (double)1.2345, (double)1.0E-15);
        Assert.assertEquals((long)conf.getInt("test4", 0), (long)34567L);
        Assert.assertEquals((long)conf.getLong("test5", 0L), (long)1234567890L);
        String[] tmp = conf.getStrings("test6");
        Assert.assertEquals((long)tmp.length, (long)3L);
        Assert.assertEquals((Object)tmp[0], (Object)"S1");
        Assert.assertEquals((Object)tmp[1], (Object)"S2");
        Assert.assertEquals((Object)tmp[2], (Object)"S3");
    }
}

