/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client.rpc;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientImpl;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.client.rpc.DAGClientRPCImpl;
import org.apache.tez.dag.api.records.DAGProtos;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.collections.Sets;
import org.mockito.verification.VerificationMode;

public class TestDAGClient {
    private DAGClient dagClient;
    private ApplicationId mockAppId;
    private ApplicationReport mockAppReport;
    private String dagIdStr;
    private DAGClientAMProtocolBlockingPB mockProxy;
    private DAGProtos.VertexStatusProto vertexStatusProtoWithoutCounters;
    private DAGProtos.VertexStatusProto vertexStatusProtoWithCounters;
    private DAGProtos.DAGStatusProto dagStatusProtoWithoutCounters;
    private DAGProtos.DAGStatusProto dagStatusProtoWithCounters;

    private void setUpData() {
        DAGProtos.ProgressProto dagProgressProto = DAGProtos.ProgressProto.newBuilder().setFailedTaskCount(1).setKilledTaskCount(1).setRunningTaskCount(2).setSucceededTaskCount(2).setTotalTaskCount(6).build();
        DAGProtos.TezCountersProto dagCountersProto = DAGProtos.TezCountersProto.newBuilder().addCounterGroups(DAGProtos.TezCounterGroupProto.newBuilder().setName("DAGGroup").addCounters(DAGProtos.TezCounterProto.newBuilder().setDisplayName("dag_counter_1").setValue(99L))).build();
        this.dagStatusProtoWithoutCounters = DAGProtos.DAGStatusProto.newBuilder().addDiagnostics("Diagnostics_0").setState(DAGProtos.DAGStatusStateProto.DAG_RUNNING).setDAGProgress(dagProgressProto).addVertexProgress(DAGProtos.StringProgressPairProto.newBuilder().setKey("v1").setProgress(DAGProtos.ProgressProto.newBuilder().setFailedTaskCount(0).setSucceededTaskCount(0).setKilledTaskCount(0))).addVertexProgress(DAGProtos.StringProgressPairProto.newBuilder().setKey("v2").setProgress(DAGProtos.ProgressProto.newBuilder().setFailedTaskCount(1).setSucceededTaskCount(1).setKilledTaskCount(1))).build();
        this.dagStatusProtoWithCounters = DAGProtos.DAGStatusProto.newBuilder((DAGProtos.DAGStatusProto)this.dagStatusProtoWithoutCounters).setDagCounters(dagCountersProto).build();
        DAGProtos.ProgressProto vertexProgressProto = DAGProtos.ProgressProto.newBuilder().setFailedTaskCount(1).setKilledTaskCount(0).setRunningTaskCount(0).setSucceededTaskCount(1).build();
        DAGProtos.TezCountersProto vertexCountersProto = DAGProtos.TezCountersProto.newBuilder().addCounterGroups(DAGProtos.TezCounterGroupProto.newBuilder().addCounters(DAGProtos.TezCounterProto.newBuilder().setDisplayName("vertex_counter_1").setValue(99L))).build();
        this.vertexStatusProtoWithoutCounters = DAGProtos.VertexStatusProto.newBuilder().addDiagnostics("V_Diagnostics_0").setProgress(vertexProgressProto).setState(DAGProtos.VertexStatusStateProto.VERTEX_SUCCEEDED).build();
        this.vertexStatusProtoWithCounters = DAGProtos.VertexStatusProto.newBuilder((DAGProtos.VertexStatusProto)this.vertexStatusProtoWithoutCounters).setVertexCounters(vertexCountersProto).build();
    }

    @Before
    public void setUp() throws YarnException, IOException, TezException, ServiceException {
        this.setUpData();
        this.mockAppId = (ApplicationId)Mockito.mock(ApplicationId.class);
        this.mockAppReport = (ApplicationReport)Mockito.mock(ApplicationReport.class);
        this.dagIdStr = "dag_9999_0001_1";
        this.mockProxy = (DAGClientAMProtocolBlockingPB)Mockito.mock(DAGClientAMProtocolBlockingPB.class);
        Mockito.when((Object)this.mockProxy.getDAGStatus((RpcController)Matchers.isNull(RpcController.class), (DAGClientAMProtocolRPC.GetDAGStatusRequestProto)Matchers.any(DAGClientAMProtocolRPC.GetDAGStatusRequestProto.class))).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(this.dagStatusProtoWithoutCounters).build());
        Mockito.when((Object)this.mockProxy.getDAGStatus((RpcController)Matchers.isNull(RpcController.class), (DAGClientAMProtocolRPC.GetDAGStatusRequestProto)Matchers.argThat((Matcher)new DAGCounterRequestMatcher()))).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(this.dagStatusProtoWithCounters).build());
        Mockito.when((Object)this.mockProxy.getVertexStatus((RpcController)Matchers.isNull(RpcController.class), (DAGClientAMProtocolRPC.GetVertexStatusRequestProto)Matchers.any(DAGClientAMProtocolRPC.GetVertexStatusRequestProto.class))).thenReturn((Object)DAGClientAMProtocolRPC.GetVertexStatusResponseProto.newBuilder().setVertexStatus(this.vertexStatusProtoWithoutCounters).build());
        Mockito.when((Object)this.mockProxy.getVertexStatus((RpcController)Matchers.isNull(RpcController.class), (DAGClientAMProtocolRPC.GetVertexStatusRequestProto)Matchers.argThat((Matcher)new VertexCounterRequestMatcher()))).thenReturn((Object)DAGClientAMProtocolRPC.GetVertexStatusResponseProto.newBuilder().setVertexStatus(this.vertexStatusProtoWithCounters).build());
        this.dagClient = new DAGClientImpl(this.mockAppId, this.dagIdStr, new TezConfiguration(), null);
        DAGClientRPCImpl realClient = (DAGClientRPCImpl)((DAGClientImpl)this.dagClient).getRealClient();
        realClient.appReport = this.mockAppReport;
        realClient.proxy = this.mockProxy;
    }

    @Test
    public void testApp() throws IOException, TezException, ServiceException {
        Assert.assertTrue((boolean)this.dagClient.getExecutionContext().contains(this.mockAppId.toString()));
        DAGClientRPCImpl realClient = (DAGClientRPCImpl)((DAGClientImpl)this.dagClient).getRealClient();
        Assert.assertEquals((Object)this.mockAppReport, (Object)realClient.getApplicationReportInternal());
    }

    @Test
    public void testDAGStatus() throws Exception {
        DAGStatus resultDagStatus = this.dagClient.getDAGStatus(null);
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy, (VerificationMode)Mockito.times((int)1))).getDAGStatus(null, DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagIdStr).build());
        Assert.assertEquals((Object)new DAGStatus((DAGProtos.DAGStatusProtoOrBuilder)this.dagStatusProtoWithoutCounters), (Object)resultDagStatus);
        System.out.println("DAGStatusWithoutCounter:" + resultDagStatus);
        resultDagStatus = this.dagClient.getDAGStatus(Sets.newSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy, (VerificationMode)Mockito.times((int)1))).getDAGStatus(null, DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagIdStr).addStatusOptions(DAGProtos.StatusGetOptsProto.GET_COUNTERS).build());
        Assert.assertEquals((Object)new DAGStatus((DAGProtos.DAGStatusProtoOrBuilder)this.dagStatusProtoWithCounters), (Object)resultDagStatus);
        System.out.println("DAGStatusWithCounter:" + resultDagStatus);
    }

    @Test
    public void testVertexStatus() throws Exception {
        VertexStatus resultVertexStatus = this.dagClient.getVertexStatus("v1", null);
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy)).getVertexStatus(null, DAGClientAMProtocolRPC.GetVertexStatusRequestProto.newBuilder().setDagId(this.dagIdStr).setVertexName("v1").build());
        Assert.assertEquals((Object)new VertexStatus((DAGProtos.VertexStatusProtoOrBuilder)this.vertexStatusProtoWithoutCounters), (Object)resultVertexStatus);
        System.out.println("VertexWithoutCounter:" + resultVertexStatus);
        resultVertexStatus = this.dagClient.getVertexStatus("v1", Sets.newSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy)).getVertexStatus(null, DAGClientAMProtocolRPC.GetVertexStatusRequestProto.newBuilder().setDagId(this.dagIdStr).setVertexName("v1").addStatusOptions(DAGProtos.StatusGetOptsProto.GET_COUNTERS).build());
        Assert.assertEquals((Object)new VertexStatus((DAGProtos.VertexStatusProtoOrBuilder)this.vertexStatusProtoWithCounters), (Object)resultVertexStatus);
        System.out.println("VertexWithCounter:" + resultVertexStatus);
    }

    @Test
    public void testTryKillDAG() throws Exception {
        this.dagClient.tryKillDAG();
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy, (VerificationMode)Mockito.times((int)1))).tryKillDAG(null, DAGClientAMProtocolRPC.TryKillDAGRequestProto.newBuilder().setDagId(this.dagIdStr).build());
    }

    @Test
    public void testWaitForCompletion() throws Exception {
        Mockito.when((Object)this.mockProxy.getDAGStatus((RpcController)Matchers.isNull(RpcController.class), (DAGClientAMProtocolRPC.GetDAGStatusRequestProto)Matchers.any(DAGClientAMProtocolRPC.GetDAGStatusRequestProto.class))).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(this.dagStatusProtoWithoutCounters).build()).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(DAGProtos.DAGStatusProto.newBuilder((DAGProtos.DAGStatusProto)this.dagStatusProtoWithoutCounters).setState(DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED).build()).build());
        this.dagClient.waitForCompletion();
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy, (VerificationMode)Mockito.times((int)2))).getDAGStatus(null, DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagIdStr).build());
    }

    @Test
    public void testWaitForCompletionWithStatusUpdates() throws Exception {
        Mockito.when((Object)this.mockProxy.getDAGStatus((RpcController)Matchers.isNull(RpcController.class), (DAGClientAMProtocolRPC.GetDAGStatusRequestProto)Matchers.any(DAGClientAMProtocolRPC.GetDAGStatusRequestProto.class))).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(this.dagStatusProtoWithoutCounters).build()).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(this.dagStatusProtoWithoutCounters).build()).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(DAGProtos.DAGStatusProto.newBuilder((DAGProtos.DAGStatusProto)this.dagStatusProtoWithoutCounters).setState(DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED).build()).build());
        this.dagClient.waitForCompletionWithStatusUpdates(null);
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy, (VerificationMode)Mockito.times((int)3))).getDAGStatus(null, DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagIdStr).build());
        Mockito.when((Object)this.mockProxy.getDAGStatus((RpcController)Matchers.isNull(RpcController.class), (DAGClientAMProtocolRPC.GetDAGStatusRequestProto)Matchers.any(DAGClientAMProtocolRPC.GetDAGStatusRequestProto.class))).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(this.dagStatusProtoWithCounters).build()).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(this.dagStatusProtoWithCounters).build()).thenReturn((Object)DAGClientAMProtocolRPC.GetDAGStatusResponseProto.newBuilder().setDagStatus(DAGProtos.DAGStatusProto.newBuilder((DAGProtos.DAGStatusProto)this.dagStatusProtoWithCounters).setState(DAGProtos.DAGStatusStateProto.DAG_SUCCEEDED).build()).build());
        this.dagClient.waitForCompletionWithStatusUpdates(Sets.newSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)this.mockProxy, (VerificationMode)Mockito.times((int)3))).getDAGStatus(null, DAGClientAMProtocolRPC.GetDAGStatusRequestProto.newBuilder().setDagId(this.dagIdStr).addStatusOptions(DAGProtos.StatusGetOptsProto.GET_COUNTERS).build());
    }

    private static class VertexCounterRequestMatcher
    extends ArgumentMatcher<DAGClientAMProtocolRPC.GetVertexStatusRequestProto> {
        private VertexCounterRequestMatcher() {
        }

        public boolean matches(Object argument) {
            if (argument instanceof DAGClientAMProtocolRPC.GetVertexStatusRequestProto) {
                DAGClientAMProtocolRPC.GetVertexStatusRequestProto requestProto = (DAGClientAMProtocolRPC.GetVertexStatusRequestProto)argument;
                return requestProto.getStatusOptionsCount() != 0 && requestProto.getStatusOptionsList().get(0) == DAGProtos.StatusGetOptsProto.GET_COUNTERS;
            }
            return false;
        }
    }

    private static class DAGCounterRequestMatcher
    extends ArgumentMatcher<DAGClientAMProtocolRPC.GetDAGStatusRequestProto> {
        private DAGCounterRequestMatcher() {
        }

        public boolean matches(Object argument) {
            if (argument instanceof DAGClientAMProtocolRPC.GetDAGStatusRequestProto) {
                DAGClientAMProtocolRPC.GetDAGStatusRequestProto requestProto = (DAGClientAMProtocolRPC.GetDAGStatusRequestProto)argument;
                return requestProto.getStatusOptionsCount() != 0 && requestProto.getStatusOptionsList().get(0) == DAGProtos.StatusGetOptsProto.GET_COUNTERS;
            }
            return false;
        }
    }
}

