/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.security.DAGAccessControls;
import org.junit.Assert;
import org.junit.Test;

public class TestDAGAccessControls {
    @Test
    public void testBasicSerializeToConf() {
        DAGAccessControls dagAccessControls = new DAGAccessControls();
        dagAccessControls.setUsersWithViewACLs(Arrays.asList("u1")).setUsersWithModifyACLs(Arrays.asList("u2")).setGroupsWithViewACLs(Arrays.asList("g1")).setGroupsWithModifyACLs(Arrays.asList("g2"));
        Configuration conf = new Configuration(false);
        dagAccessControls.serializeToConfiguration(conf);
        Assert.assertNotNull((Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertNotNull((Object)conf.get("tez.am.dag.modify-acls"));
        Assert.assertEquals((Object)"u1 g1", (Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertEquals((Object)"u2 g2", (Object)conf.get("tez.am.dag.modify-acls"));
    }

    @Test
    public void testWildCardSerializeToConf() {
        DAGAccessControls dagAccessControls = new DAGAccessControls();
        dagAccessControls.setUsersWithViewACLs(Arrays.asList("*")).setUsersWithModifyACLs(Arrays.asList("*")).setGroupsWithViewACLs(Arrays.asList("g1")).setGroupsWithModifyACLs(Arrays.asList("g2"));
        Configuration conf = new Configuration(false);
        dagAccessControls.serializeToConfiguration(conf);
        Assert.assertNotNull((Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertNotNull((Object)conf.get("tez.am.dag.modify-acls"));
        Assert.assertEquals((Object)"*", (Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertEquals((Object)"*", (Object)conf.get("tez.am.dag.modify-acls"));
    }

    @Test
    public void testGroupsOnlySerializeToConf() {
        DAGAccessControls dagAccessControls = new DAGAccessControls();
        dagAccessControls.setGroupsWithViewACLs(Arrays.asList("g1")).setGroupsWithModifyACLs(Arrays.asList("g2"));
        Configuration conf = new Configuration(false);
        dagAccessControls.serializeToConfiguration(conf);
        Assert.assertNotNull((Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertNotNull((Object)conf.get("tez.am.dag.modify-acls"));
        Assert.assertEquals((Object)" g1", (Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertEquals((Object)" g2", (Object)conf.get("tez.am.dag.modify-acls"));
    }

    @Test
    public void testEmptySerializeToConf() {
        DAGAccessControls dagAccessControls = new DAGAccessControls();
        Configuration conf = new Configuration(false);
        dagAccessControls.serializeToConfiguration(conf);
        Assert.assertNotNull((Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertNotNull((Object)conf.get("tez.am.dag.modify-acls"));
        Assert.assertEquals((Object)" ", (Object)conf.get("tez.am.dag.view-acls"));
        Assert.assertEquals((Object)" ", (Object)conf.get("tez.am.dag.modify-acls"));
    }

    @Test
    public void testStringBasedConstructor() {
        DAGAccessControls dagAccessControls = new DAGAccessControls("u1 g1", "u2 g2");
        Assert.assertEquals((long)1L, (long)dagAccessControls.getUsersWithViewACLs().size());
        Assert.assertEquals((long)1L, (long)dagAccessControls.getUsersWithModifyACLs().size());
        Assert.assertEquals((long)1L, (long)dagAccessControls.getGroupsWithViewACLs().size());
        Assert.assertEquals((long)1L, (long)dagAccessControls.getGroupsWithModifyACLs().size());
        Assert.assertTrue((boolean)dagAccessControls.getUsersWithViewACLs().contains("u1"));
        Assert.assertTrue((boolean)dagAccessControls.getUsersWithModifyACLs().contains("u2"));
        Assert.assertTrue((boolean)dagAccessControls.getGroupsWithViewACLs().contains("g1"));
        Assert.assertTrue((boolean)dagAccessControls.getGroupsWithModifyACLs().contains("g2"));
    }
}

