/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.records.DAGProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestTezClientUtils {
    private static String TEST_ROOT_DIR = "target/" + TestTezClientUtils.class.getName() + "-tmpDir";

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesNotDefined() throws Exception {
        TezConfiguration conf = new TezConfiguration(false);
        Credentials credentials = new Credentials();
        try {
            HashMap resources = new HashMap();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, resources);
            Assert.fail((String)"Expected TezUncheckedException");
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid configuration of tez jars"));
        }
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedButEmpty() throws Exception {
        File emptyDir = new File(TEST_ROOT_DIR, "emptyDir");
        emptyDir.deleteOnExit();
        Assert.assertTrue((boolean)emptyDir.mkdirs());
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", emptyDir.toURI().toURL().toString());
        Credentials credentials = new Credentials();
        try {
            HashMap resources = new HashMap();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, resources);
            Assert.fail((String)"Expected TezUncheckedException");
        }
        catch (TezUncheckedException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No files found in locations"));
        }
    }

    @Test(expected=FileNotFoundException.class, timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedNonExistingDirectory() throws Exception {
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", "file:///foo");
        Credentials credentials = new Credentials();
        HashMap resources = new HashMap();
        TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, resources);
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedExistingDirectory() throws Exception {
        URL[] cp = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        StringBuffer buffer = new StringBuffer();
        for (URL url : cp) {
            buffer.append(url.toExternalForm());
            buffer.append(",");
        }
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", buffer.toString());
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        boolean usingArchive = TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap);
        Assert.assertFalse((boolean)usingArchive);
        Set resourceNames = localizedMap.keySet();
        for (URL url : cp) {
            File file = FileUtils.toFile((URL)url);
            if (file.isDirectory()) {
                String[] firList;
                for (String fileNme : firList = file.list()) {
                    File innerFile = new File(file, fileNme);
                    if (innerFile.isDirectory()) continue;
                    Assert.assertTrue((boolean)resourceNames.contains(innerFile.getName()));
                }
                continue;
            }
            Assert.assertTrue((boolean)resourceNames.contains(file.getName()));
        }
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedExistingDirectoryIgnored() throws Exception {
        URL[] cp = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        StringBuffer buffer = new StringBuffer();
        for (URL url : cp) {
            buffer.append(url.toExternalForm());
            buffer.append(",");
        }
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", buffer.toString());
        conf.setBoolean("tez.ignore.lib.uris", true);
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        Assert.assertFalse((boolean)TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap));
        Assert.assertTrue((boolean)localizedMap.isEmpty());
    }

    @Test(timeout=5000L)
    public void validateSetTezJarLocalResourcesDefinedExistingDirectoryIgnoredSetToFalse() throws Exception {
        URL[] cp = ((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs();
        StringBuffer buffer = new StringBuffer();
        for (URL url : cp) {
            buffer.append(url.toExternalForm());
            buffer.append(",");
        }
        TezConfiguration conf = new TezConfiguration();
        conf.set("tez.lib.uris", buffer.toString());
        conf.setBoolean("tez.ignore.lib.uris", false);
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        Assert.assertFalse((boolean)TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap));
        Assert.assertFalse((boolean)localizedMap.isEmpty());
    }

    @Test(timeout=5000L)
    public void testAMCommandOpts() {
        TezConfiguration tezConf = new TezConfiguration();
        String amCommandOpts = "-Xmx 200m -Dtest.property";
        tezConf.set("tez.am.launch.cmd-opts", amCommandOpts);
        String amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)("-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN " + amCommandOpts), (Object)amOptsConstructed);
        String clusterDefaultCommandOpts = "-server -Djava.net.preferIPv4Stack=true -XX:+PrintGCDetails -verbose:gc ";
        tezConf.set("tez.am.launch.cluster-default.cmd-opts", clusterDefaultCommandOpts);
        amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)(clusterDefaultCommandOpts + " " + amCommandOpts), (Object)amOptsConstructed);
        double factor = 0.8;
        amCommandOpts = "-Dtest.property";
        tezConf.set("tez.am.launch.cmd-opts", amCommandOpts);
        amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)(" -Xmx819m " + clusterDefaultCommandOpts + " " + amCommandOpts), (Object)amOptsConstructed);
        clusterDefaultCommandOpts = "-server -Djava.net.preferIPv4Stack=true -XX:+PrintGCDetails -verbose:gc -Xmx200m";
        tezConf.set("tez.am.launch.cluster-default.cmd-opts", clusterDefaultCommandOpts);
        amOptsConstructed = TezClientUtils.constructAMLaunchOpts((TezConfiguration)tezConf, (Resource)Resource.newInstance((int)1024, (int)1));
        Assert.assertEquals((Object)(clusterDefaultCommandOpts + " " + amCommandOpts), (Object)amOptsConstructed);
    }

    @Test(timeout=5000L)
    public void testTaskCommandOpts() {
        TezConfiguration tezConf = new TezConfiguration();
        String taskCommandOpts = "-Xmx 200m -Dtest.property";
        tezConf.set("tez.task.launch.cmd-opts", taskCommandOpts);
        String expected = null;
        String taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)"", (Configuration)tezConf);
        expected = "-server -Djava.net.preferIPv4Stack=true -Dhadoop.metrics.log.level=WARN " + taskCommandOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
        String taskClusterDefaultCommandOpts = "-server -Djava.net.preferIPv4Stack=true -XX:+PrintGCDetails -verbose:gc ";
        tezConf.set("tez.task.launch.cluster-default.cmd-opts", taskClusterDefaultCommandOpts);
        taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)"", (Configuration)tezConf);
        expected = taskClusterDefaultCommandOpts + " " + taskCommandOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
        taskCommandOpts = "-Dtest.property";
        tezConf.set("tez.task.launch.cmd-opts", taskCommandOpts);
        taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)"", (Configuration)tezConf);
        expected = taskClusterDefaultCommandOpts + " " + taskCommandOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
        String programmaticTaskOpts = "-Dset.programatically=true -Djava.net.preferIPv4Stack=false";
        taskOptsConstructed = TezClientUtils.addDefaultsToTaskLaunchCmdOpts((String)programmaticTaskOpts, (Configuration)tezConf);
        expected = taskClusterDefaultCommandOpts + " " + taskCommandOpts + " " + programmaticTaskOpts;
        Assert.assertTrue((String)("Did not find Expected prefix: [" + expected + "] in string [" + taskOptsConstructed + "]"), (boolean)taskOptsConstructed.startsWith(expected));
    }

    @Test(timeout=5000L)
    public void testDefaultMemoryJavaOpts() {
        double factor = 0.8;
        String origJavaOpts = "-Xmx";
        String javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)1000, (int)1), (double)0.8);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)1000, (int)1), (double)0.8);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx800m"));
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)1, (int)1), (double)0.8);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx1m"));
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)-1, (int)1), (double)0.8);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)0.8);
        Assert.assertTrue((boolean)javaOpts.contains("-Xmx284m"));
        origJavaOpts = " -Xms100m ";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)0.8);
        Assert.assertFalse((boolean)javaOpts.contains("-Xmx284m"));
        Assert.assertTrue((boolean)javaOpts.contains("-Xms100m"));
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)0.0);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
        origJavaOpts = "";
        javaOpts = TezClientUtils.maybeAddDefaultMemoryJavaOpts((String)origJavaOpts, (Resource)Resource.newInstance((int)355, (int)1), (double)100.0);
        Assert.assertEquals((Object)origJavaOpts, (Object)javaOpts);
    }

    @Test(timeout=5000L)
    public void testDefaultLoggingJavaOpts() {
        String origJavaOpts = null;
        String javaOpts = TezClientUtils.maybeAddDefaultLoggingJavaOpts((String)"FOOBAR", origJavaOpts);
        Assert.assertNotNull((Object)javaOpts);
        Assert.assertTrue((javaOpts.contains("-Dtez.root.logger=FOOBAR") && javaOpts.contains("tez-container-log4j.properties") ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void testLocalResourceVisibility(DistributedFileSystem remoteFs, Configuration conf) throws Exception {
        Path topLevelDir = null;
        try {
            FsPermission publicDirPerms = new FsPermission(493);
            FsPermission privateDirPerms = new FsPermission(492);
            FsPermission publicFilePerms = new FsPermission(364);
            FsPermission privateFilePerms = new FsPermission(360);
            String fsURI = remoteFs.getUri().toString();
            topLevelDir = new Path(fsURI, "/testLRVisibility");
            Assert.assertTrue((boolean)remoteFs.mkdirs(topLevelDir, publicDirPerms));
            Path publicSubDir = new Path(topLevelDir, "public_sub_dir");
            Assert.assertTrue((boolean)remoteFs.mkdirs(publicSubDir, publicDirPerms));
            Path privateSubDir = new Path(topLevelDir, "private_sub_dir");
            Assert.assertTrue((boolean)remoteFs.mkdirs(privateSubDir, privateDirPerms));
            Path publicFile = new Path(publicSubDir, "public_file");
            Assert.assertTrue((boolean)remoteFs.createNewFile(publicFile));
            remoteFs.setPermission(publicFile, publicFilePerms);
            Path privateFile = new Path(publicSubDir, "private_file");
            Assert.assertTrue((boolean)remoteFs.createNewFile(privateFile));
            remoteFs.setPermission(privateFile, privateFilePerms);
            Path publicFileInPrivateSubdir = new Path(privateSubDir, "public_file_in_private_subdir");
            Assert.assertTrue((boolean)remoteFs.createNewFile(publicFileInPrivateSubdir));
            remoteFs.setPermission(publicFileInPrivateSubdir, publicFilePerms);
            TezConfiguration tezConf = new TezConfiguration(conf);
            String tmpTezLibUris = String.format("%s,%s,%s,%s", topLevelDir, publicSubDir, privateSubDir, conf.get("tez.lib.uris", ""));
            tezConf.set("tez.lib.uris", tmpTezLibUris);
            HashMap lrMap = new HashMap();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)tezConf, (Credentials)new Credentials(), lrMap);
            Assert.assertEquals((String)publicFile.getName(), (Object)LocalResourceVisibility.PUBLIC, (Object)((LocalResource)lrMap.get(publicFile.getName())).getVisibility());
            Assert.assertEquals((String)privateFile.getName(), (Object)LocalResourceVisibility.PRIVATE, (Object)((LocalResource)lrMap.get(privateFile.getName())).getVisibility());
            Assert.assertEquals((String)publicFileInPrivateSubdir.getName(), (Object)LocalResourceVisibility.PRIVATE, (Object)((LocalResource)lrMap.get(publicFileInPrivateSubdir.getName())).getVisibility());
            tezConf = new TezConfiguration(conf);
            Path tarFile = new Path(topLevelDir, "foo.tar.gz");
            Assert.assertTrue((boolean)remoteFs.createNewFile(tarFile));
            remoteFs.setPermission(tarFile, publicFilePerms);
            tezConf.set("tez.lib.uris", tarFile.toString());
            lrMap.clear();
            Assert.assertTrue((boolean)TezClientUtils.setupTezJarsLocalResources((TezConfiguration)tezConf, (Credentials)new Credentials(), lrMap));
            Assert.assertEquals((Object)LocalResourceVisibility.PUBLIC, (Object)((LocalResource)lrMap.get("tezlib")).getVisibility());
            remoteFs.setPermission(tarFile, privateFilePerms);
            lrMap.clear();
            TezClientUtils.setupTezJarsLocalResources((TezConfiguration)tezConf, (Credentials)new Credentials(), lrMap);
            Assert.assertEquals((Object)LocalResourceVisibility.PRIVATE, (Object)((LocalResource)lrMap.get("tezlib")).getVisibility());
            if (topLevelDir == null) return;
        }
        catch (Throwable throwable) {
            if (topLevelDir == null) throw throwable;
            remoteFs.delete(topLevelDir, true);
            throw throwable;
        }
        remoteFs.delete(topLevelDir, true);
    }

    @Test(timeout=5000L)
    public void testConfigurationAllowAll() {
        Configuration srcConf = new Configuration(false);
        HashMap<String, String> confMap = new HashMap<String, String>();
        confMap.put("ipc.timeout", "2000");
        confMap.put("fs.defaultFS", "testfs:///");
        confMap.put("tez.property", "tezProperty");
        confMap.put("yarn.property", "yarnProperty");
        for (Map.Entry entry : confMap.entrySet()) {
            srcConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        DAGProtos.ConfigurationProto confProto = TezClientUtils.createFinalConfProtoForApp((Configuration)srcConf);
        for (DAGProtos.PlanKeyValuePair kvPair : confProto.getConfKeyValuesList()) {
            String val = (String)confMap.remove(kvPair.getKey());
            Assert.assertNotNull((Object)val);
            Assert.assertEquals((Object)val, (Object)kvPair.getValue());
        }
        Assert.assertTrue((boolean)confMap.isEmpty());
    }

    private Path createFile(FileSystem fs, Path dir, String fileName) throws IOException {
        Path f1 = new Path(dir, fileName);
        FSDataOutputStream outputStream = fs.create(f1, true);
        outputStream.write(1);
        outputStream.close();
        return fs.makeQualified(f1);
    }

    @Test(timeout=5000L)
    public void validateSetTezAuxLocalResourcesWithFilesAndFolders() throws Exception {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        ArrayList<String> resources = new ArrayList<String>();
        StringBuilder auxUriStr = new StringBuilder();
        Path topDir = new Path(TEST_ROOT_DIR, "validateauxwithfiles");
        if (localFs.exists(topDir)) {
            localFs.delete(topDir, true);
        }
        localFs.mkdirs(topDir);
        resources.add(this.createFile((FileSystem)localFs, topDir, "f1.txt").toString());
        auxUriStr.append(localFs.makeQualified(topDir).toString()).append(",");
        Path dir2 = new Path(topDir, "dir2");
        localFs.mkdirs(dir2);
        Path nestedDir = new Path(dir2, "nestedDir");
        localFs.mkdirs(nestedDir);
        this.createFile((FileSystem)localFs, nestedDir, "nested-f.txt");
        resources.add(this.createFile((FileSystem)localFs, dir2, "dir2-f.txt").toString());
        auxUriStr.append(localFs.makeQualified(dir2).toString()).append(",");
        Path dir3 = new Path(topDir, "dir3");
        localFs.mkdirs(dir3);
        auxUriStr.append(localFs.makeQualified(dir3).toString()).append(",");
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.ignore.lib.uris", true);
        conf.set("tez.aux.uris", auxUriStr.toString());
        Credentials credentials = new Credentials();
        HashMap localizedMap = new HashMap();
        TezClientUtils.setupTezJarsLocalResources((TezConfiguration)conf, (Credentials)credentials, localizedMap);
        Set resourceNames = localizedMap.keySet();
        Assert.assertEquals((long)2L, (long)resourceNames.size());
        Assert.assertTrue((boolean)resourceNames.contains("f1.txt"));
        Assert.assertTrue((boolean)resourceNames.contains("dir2-f.txt"));
    }
}

