/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.records.DAGProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestDagTypeConverters {
    @Test
    public void testTezEntityDescriptorSerialization() throws IOException {
        UserPayload payload = UserPayload.create((ByteBuffer)ByteBuffer.wrap(new String("Foobar").getBytes()), (int)100);
        String historytext = "Bar123";
        EntityDescriptor entityDescriptor = ((InputDescriptor)InputDescriptor.create((String)"inputClazz").setUserPayload(payload)).setHistoryText(historytext);
        DAGProtos.TezEntityDescriptorProto proto = DagTypeConverters.convertToDAGPlan((EntityDescriptor)entityDescriptor);
        Assert.assertEquals((long)payload.getVersion(), (long)proto.getTezUserPayload().getVersion());
        Assert.assertArrayEquals((byte[])payload.deepCopyAsArray(), (byte[])proto.getTezUserPayload().getUserPayload().toByteArray());
        Assert.assertTrue((boolean)proto.hasHistoryText());
        Assert.assertNotEquals((Object)historytext, (Object)proto.getHistoryText());
        Assert.assertEquals((Object)historytext, (Object)new String(TezCommonUtils.decompressByteStringToByteArray((ByteString)proto.getHistoryText())));
        InputDescriptor inputDescriptor = DagTypeConverters.convertInputDescriptorFromDAGPlan((DAGProtos.TezEntityDescriptorProto)proto);
        Assert.assertNull((Object)inputDescriptor.getHistoryText());
    }
}

